/*
 * Decompiled with CFR 0.152.
 */
package tables.PSJMOTables;

import gui.PPSDialog;
import hcp.constants.Constants;
import java.text.DecimalFormat;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import objects.FiscallObjects;
import objects.lang.LanguageStrings;

public final class PSTableModel
extends DefaultTableModel
implements TableModel {
    private static final String decFor = "######0.00";
    private static final String NPS = "*.**";
    private static String str;
    private DecimalFormat df;

    public final void addTableModelListener(TableModelListener arg0) {
    }

    public final Class getColumnClass(int col) {
        return String.class;
    }

    public final int getColumnCount() {
        return 2;
    }

    public final String getColumnName(int c) {
        if (c == 0) {
            return LanguageStrings.getInstance().getStringByName("DEPARTMENT_TABLE_COLUMN_0");
        }
        return LanguageStrings.getInstance().getStringByName("DEPARTMENT_TABLE_COLUMN_1");
    }

    public final int getRowCount() {
        return Constants.VATS_MAX_NUMBER;
    }

    public final Object getValueAt(int row, int column) {
        FiscallObjects.porStopa ps = FiscallObjects.poreskeStope[row];
        switch (column) {
            case 0: {
                return ps.opis;
            }
            case 1: {
                if (ps.vrednost == 65535) {
                    return NPS;
                }
                this.df = new DecimalFormat(decFor);
                str = this.df.format(ps.pravaVrednost);
                return str;
            }
        }
        return null;
    }

    public final boolean isCellEditable(int r, int c) {
        return c != 0;
    }

    public final void removeTableModelListener(TableModelListener arg0) {
    }

    public final void setValueAt(Object s, int row, int col) {
        if (s == null) {
            return;
        }
        FiscallObjects.porStopa ps = FiscallObjects.poreskeStope[row];
        str = (String)s;
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                if (str.length() < 1) {
                    PPSDialog pps = new PPSDialog();
                    pps.initialize((byte)row);
                    ps.pravaVrednost = 0.0;
                    ps.vrednost = 65535;
                    return;
                }
                if (str.length() > 2 && str.indexOf(46) < 1 && str.indexOf(44) < 1) {
                    ps.pravaVrednost = 0.0;
                    ps.vrednost = 0;
                    return;
                }
                if (str.indexOf(46) >= 0 || str.indexOf(44) >= 0) {
                    str = String.valueOf(str) + '0';
                }
                try {
                    str = str.replaceAll(",", ".");
                    ps.pravaVrednost = Double.parseDouble(str);
                }
                catch (NumberFormatException e) {
                    ps.pravaVrednost = 0.0;
                    ps.vrednost = 0;
                }
                ps.vrednost = (int)(ps.pravaVrednost * 100.0);
            }
        }
    }
}

