/*
 * Decompiled with CFR 0.152.
 */
package serverRemote;

import cashRegister.Command;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import util.SysUtil;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public class TerminalSocket {
    private Socket socket;
    private int id = ++NEXT_ID;
    public long time;
    private InputStream in;
    private OutputStream out;
    private static int NEXT_ID = 0;
    public static final int STATE_SEND_COMMAND = 1;
    public static final int STATE_RECEIVE_ACK = 2;
    public static final int STATE_WAIT_RESPONCE = 3;
    public static final int TIME_OUT = 30000;
    private static final byte[] buffer = new byte[1024];
    public static TerminalSocket current = null;
    public static TerminalSocket currentSystematik = null;
    private static final Exception exc = new Exception("Socket time out");

    public TerminalSocket(Socket sock, InputStream in, OutputStream out) {
        this.socket = sock;
        this.time = System.currentTimeMillis();
        this.in = in;
        this.out = out;
    }

    public final void setSocket(Socket socket) {
        this.socket = socket;
    }

    public final Socket getSocket() {
        return this.socket;
    }

    public void setId(int id) {
        this.id = id;
    }

    public final int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionString() throws Exception {
        int t = 0;
        t = this.in.available();
        if (t < 6) {
            if (System.currentTimeMillis() - this.time > 30000L) {
                throw exc;
            }
            return null;
        }
        byte[] byArray = buffer;
        synchronized (buffer) {
            t = this.in.read(buffer);
            if (buffer[t - 1] != 13) {
                throw exc;
            }
            String s = new String(buffer, 0, t - 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return s;
        }
    }

    public int readByte() throws Exception {
        long time = System.currentTimeMillis();
        int t;
        while ((t = this.in.available()) <= 0) {
            if (System.currentTimeMillis() - time > 15000L) {
                return -1;
            }
            SysUtil.delay(10);
        }
        return this.in.read();
    }

    public void receiveFrame(Command command) throws Exception {
        command.reset();
        int errors = 0;
        int i = 0;
        if (i < 3) {
            int t;
            block9: {
                do {
                    if ((t = this.readByte()) == -1) {
                        throw exc;
                    }
                    if (t == PortSerial.STX) break block9;
                } while (t == 8 || ++errors <= 3);
                throw exc;
            }
            int len = t = this.readByte();
            if (t < 1) {
                throw exc;
            }
            long time = System.currentTimeMillis();
            int pos = 0;
            while (true) {
                if ((t = this.in.available()) > 0) {
                    t = this.in.read(buffer, pos, len - pos);
                }
                if (t <= 0) {
                    if (System.currentTimeMillis() - time > 30000L) {
                        throw exc;
                    }
                    SysUtil.delay(10);
                    continue;
                }
                if ((pos += t) >= len) break;
            }
            command.setCmd(buffer[0] & 0xFF);
            i = 1;
            while (i < t) {
                int mm = buffer[i] & 0xFF;
                command.addByte(mm);
                ++i;
            }
            return;
        }
        throw PortSerial.excCRC;
    }

    public void sendFrame(Command command) throws Exception {
        int t;
        boolean past = false;
        while (true) {
            try {
                t = this.in.available();
            }
            catch (Exception e) {
                t = 0;
            }
            if (t <= 0) {
                if (past) break;
                past = true;
                SysUtil.delay(10);
                continue;
            }
            try {
                this.in.read(buffer);
            }
            catch (Exception e) {
                // empty catch block
            }
            past = false;
        }
        int pos = 0;
        TerminalSocket.buffer[pos++] = (byte)PortSerial.STX;
        int check = command.getPos() + 1;
        TerminalSocket.buffer[pos++] = (byte)check;
        TerminalSocket.buffer[pos++] = (byte)command.getCmd();
        check += command.getCmd() & 0xFF;
        int i = 0;
        while (i < command.getPos()) {
            t = command.getArray()[i] & 0xFF;
            TerminalSocket.buffer[pos++] = (byte)t;
            check += t;
            ++i;
        }
        TerminalSocket.buffer[pos++] = (byte)(check >> 8);
        TerminalSocket.buffer[pos++] = (byte)check;
        int k = 0;
        if (k < 3) {
            this.out.write(buffer, 0, pos);
            this.out.flush();
            return;
        }
        throw new Exception("Podatak nije poslat");
    }

    public Command receiveFrame() throws Exception {
        int errors = 0;
        int i = 0;
        if (i < 3) {
            try {
                Command command;
                int type;
                block14: {
                    do {
                        if ((type = this.readByte()) == -1) {
                            throw exc;
                        }
                        if (type == PortSerial.STX || type == PortSerial.SOX) break block14;
                    } while (type == 8 || ++errors <= 3);
                    throw exc;
                }
                int t = this.readByte();
                if (t == -1) {
                    throw exc;
                }
                int len = t;
                if (type == PortSerial.SOX) {
                    command = Command.bigInstance;
                    int k = this.readByte();
                    if (k == -1) {
                        throw exc;
                    }
                    len |= k << 8;
                } else {
                    command = Command.instance;
                }
                command.reset();
                command.setLength(len);
                System.out.println("len = " + len);
                if (len < 1) {
                    throw exc;
                }
                long time = System.currentTimeMillis();
                int pos = 0;
                while (true) {
                    if ((t = this.in.read(buffer, pos, 1024 - pos)) <= 0) {
                        if (System.currentTimeMillis() - time > 30000L) {
                            throw exc;
                        }
                        Thread.yield();
                        continue;
                    }
                    if ((pos += t) >= len) break;
                }
                command.setCmd(buffer[0] & 0xFF);
                i = 1;
                while (i < len) {
                    int mm = buffer[i] & 0xFF;
                    command.addByte(mm);
                    ++i;
                }
                return command;
            }
            catch (Exception e) {
                throw new SerialPortException(e.getMessage());
            }
        }
        return null;
    }
}

