/*
 * Decompiled with CFR 0.152.
 */
package serverRemote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import objects.Terminals;
import serverRemote.FifoSocket;
import serverRemote.TerminalSocket;
import util.SysUtil;

public class Server
extends Thread {
    public static int port = 1234;
    public static String socketAddress = "172.30.*.*";
    private static Server instance;
    private static FifoSocket fifoNewComing;
    private static FifoSocket fifoTerminalConnected;
    private ServerSocket serverSocket;
    private static ConnectionServer connServer;
    private static final Exception err;

    static {
        err = new Exception("Terminal not responding, try again or disconect!");
    }

    public static final void changeIp(String ip, int port) {
        socketAddress = ip;
        Server.port = port;
    }

    public static void setInstanceToNull() {
        if (instance == null) {
            return;
        }
        fifoNewComing = null;
        fifoTerminalConnected = null;
        connServer = null;
        instance = null;
    }

    public static final Server getInstance() {
        if (instance == null) {
            fifoNewComing = new FifoSocket();
            fifoTerminalConnected = new FifoSocket();
            instance = new Server();
        }
        return instance;
    }

    protected Server() {
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(socketAddress, port));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        try {
            this.serverSocket.setSoTimeout(0);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        System.out.println(this.serverSocket.getLocalSocketAddress().toString());
        this.setPriority(10);
        connServer = new ConnectionServer();
        connServer.setPriority(9);
        connServer.start();
        this.start();
        System.out.println(String.valueOf(this.serverSocket.getLocalSocketAddress().toString()) + " - started...");
    }

    public void setUsedTerminal(int id) throws Exception {
        if (TerminalSocket.current != null) {
            if (TerminalSocket.current.getId() == id) {
                return;
            }
            fifoTerminalConnected.PUSH(TerminalSocket.current);
        }
        TerminalSocket.current = null;
        TerminalSocket tt = fifoTerminalConnected.getTerminalSocket(id);
        if (tt == null) {
            throw err;
        }
        TerminalSocket.current = tt;
    }

    public void run() {
        while (true) {
            InputStream in;
            OutputStream out;
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                SysUtil.delay(1);
                continue;
            }
            try {
                out = socket.getOutputStream();
                in = socket.getInputStream();
            }
            catch (IOException e) {
                continue;
            }
            TerminalSocket terminalSocket = new TerminalSocket(socket, in, out);
            fifoNewComing.PUSH(terminalSocket);
            SysUtil.delay(1);
        }
    }

    class ConnectionServer
    extends Thread {
        ConnectionServer() {
        }

        public void run() {
            while (true) {
                TerminalSocket terminalSocket = (TerminalSocket)fifoNewComing.POP_Block();
                String s = null;
                try {
                    s = terminalSocket.getConnectionString();
                }
                catch (Exception e) {
                    continue;
                }
                if (s == null) {
                    fifoNewComing.PUSH(terminalSocket);
                    SysUtil.delay(1);
                    continue;
                }
                fifoTerminalConnected.PUSH(terminalSocket);
                Terminals.addTerminal(s, terminalSocket.getId());
            }
        }
    }
}

