/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.math.BigInteger;
import java.util.Random;
import security.GeneratorKeys;
import security.KeyRSA;

public class Main {
    private static final Random rnd = new Random();

    public static void main(String[] args) {
        KeyRSA keys = GeneratorKeys.getInstance().getKeys();
        System.out.println(keys.toString());
        Main main = new Main();
        int i = 0;
        block0: while (i < 10000) {
            byte[] arr = main.generateString();
            System.out.println(" i  " + i + "   " + new String(arr));
            byte[] encrypted = main.encrypt(arr);
            byte[] decrypted = main.decrypt(encrypted);
            if (decrypted.length == arr.length) {
                int j = 0;
                while (j < arr.length) {
                    if (decrypted[j] != arr[j]) {
                        System.out.println("Error");
                        break block0;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public byte[] encrypt(byte[] message) {
        return new BigInteger(message).modPow(KeyRSA.getInstance().getPublicExp(), KeyRSA.getInstance().getModulus()).toByteArray();
    }

    public byte[] decrypt(byte[] message) {
        return new BigInteger(message).modPow(KeyRSA.getInstance().getPrivateExp(), KeyRSA.getInstance().getModulus()).toByteArray();
    }

    private byte[] generateString() {
        byte[] arr = new byte[64];
        int i = 0;
        while (i < 64) {
            int t = rnd.nextInt() & 0x7F;
            if (t >= 48 && t <= 57) {
                arr[i] = (byte)t;
            } else if (t >= 65 && t <= 70) {
                arr[i] = (byte)t;
            } else {
                --i;
            }
            ++i;
        }
        return arr;
    }
}

