/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.math.BigInteger;

public class KeyRSA {
    private BigInteger expPrivate;
    private BigInteger expPublic;
    private BigInteger modulus;
    public static final KeyRSA instance = new KeyRSA();

    public static final KeyRSA getInstance() {
        return instance;
    }

    public final BigInteger getModulus() {
        return this.modulus;
    }

    public final BigInteger getPrivateExp() {
        return this.expPrivate;
    }

    public final BigInteger getPublicExp() {
        return this.expPublic;
    }

    public byte[] getModulusToSendECR() {
        byte[] arr = this.modulus.toByteArray();
        byte[] send = new byte[arr.length + 1];
        send[0] = (byte)arr.length;
        System.arraycopy(arr, 0, send, 1, arr.length);
        return send;
    }

    public byte[] getExpECR(boolean privateE) {
        byte[] arr = privateE ? this.expPrivate.toByteArray() : this.expPublic.toByteArray();
        byte[] send = new byte[arr.length + 1];
        send[0] = (byte)arr.length;
        System.arraycopy(arr, 0, send, 1, arr.length);
        return send;
    }

    public void setExp(BigInteger privateE, BigInteger publicE) {
        this.expPublic = publicE;
        this.expPrivate = privateE;
    }

    public final void setModus(BigInteger m) {
        this.modulus = m;
    }

    public String toString() {
        String s = " KEYS  \nmodulus :    " + this.modulus.toByteArray().length + "    " + this.modulus.toString(16) + "\n" + " exp PR :" + "   " + this.expPrivate.toByteArray().length + "    " + this.expPrivate.toString(16) + "\n" + " exp PA :" + "   " + this.expPublic.toByteArray().length + "    " + this.expPublic.toString(16);
        return s;
    }
}

