/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.math.BigInteger;
import java.util.Random;
import security.KeyRSA;

public class GeneratorKeys {
    private BigInteger p;
    private BigInteger q;
    private BigInteger N;
    private BigInteger phi;
    private BigInteger e;
    private BigInteger d;
    private int bitlength = 256;
    Random r = new Random();
    private static final GeneratorKeys instance = new GeneratorKeys();

    public static final GeneratorKeys getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final KeyRSA getKeys() {
        int i = 0;
        while (i < 100000) {
            this.p = BigInteger.probablePrime(this.bitlength, this.r);
            this.q = BigInteger.probablePrime(this.bitlength, this.r);
            this.N = this.p.multiply(this.q);
            this.phi = this.p.subtract(BigInteger.ONE).multiply(this.q.subtract(BigInteger.ONE));
            this.e = BigInteger.valueOf(3L);
            if (this.phi.gcd(this.e).compareTo(BigInteger.ONE) > 0 && this.e.compareTo(this.phi) < 0) {
                this.e = BigInteger.valueOf(7L);
                if (this.phi.gcd(this.e).compareTo(BigInteger.ONE) > 0 && this.e.compareTo(this.phi) < 0) {
                    this.e = BigInteger.valueOf(17L);
                    if (this.phi.gcd(this.e).compareTo(BigInteger.ONE) > 0 && this.e.compareTo(this.phi) < 0) {
                        this.e = BigInteger.valueOf(81L);
                        if (this.phi.gcd(this.e).compareTo(BigInteger.ONE) > 0 && this.e.compareTo(this.phi) < 0) {
                            --i;
                            ++i;
                            continue;
                        }
                    }
                }
            }
            this.d = this.e.modInverse(this.phi);
            KeyRSA.getInstance().setModus(this.N);
            KeyRSA.getInstance().setExp(this.d, this.e);
            return KeyRSA.getInstance();
        }
        return null;
    }
}

