/*
 * Decompiled with CFR 0.152.
 */
package org.freixas.jcalendar;

import com.lipstikLF.delegate.LipstikComboBoxUI;
import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import org.freixas.jcalendar.DateEvent;
import org.freixas.jcalendar.DateListener;
import org.freixas.jcalendar.JCalendar;

public class JCalendarCombo
extends JComboBox {
    public static final int DISPLAY_DATE = 1;
    public static final int DISPLAY_TIME = 2;
    static JCalendarCombo currentPopup = null;
    private Locale locale;
    private DateFormat dateFormat;
    private DateFormat[] parseFormat;
    private DateFormat timePatternFormat;
    private Window parentWindow;
    private JWindow calendarWindow;
    private JCalendar calendarPanel;
    private boolean isCalendarDisplayed = false;
    private Date originalDate = null;
    private Calendar cacheCalendar = null;
    private static InputMap inputMap = new InputMap();
    private static ActionMap actionMap = new ActionMap();
    private static Action cancel = new AbstractAction("cancel"){

        public void actionPerformed(ActionEvent e) {
            JCalendar cal = (JCalendar)e.getSource();
            JCalendarCombo calCombo = cal.getJCalendarComboParent();
            cal.setDate(calCombo.originalDate);
            calCombo.firePopupMenuCanceled();
            calCombo.hideCalendar();
        }
    };
    private static Action apply = new AbstractAction("apply"){

        public void actionPerformed(ActionEvent e) {
            JCalendar cal = (JCalendar)e.getSource();
            JCalendarCombo calCombo = cal.getJCalendarComboParent();
            calCombo.hideCalendar();
        }
    };

    static {
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
        inputMap.put(KeyStroke.getKeyStroke("UP"), "apply");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "apply");
        inputMap.setParent(JCalendar.inputMap);
        actionMap.put("cancel", cancel);
        actionMap.put("apply", apply);
        actionMap.setParent(JCalendar.actionMap);
    }

    public JCalendarCombo() {
        this(Calendar.getInstance(), Locale.getDefault(), 1, false, null);
    }

    public JCalendarCombo(int selectedComponents, boolean isTodayDisplayed) {
        this(Calendar.getInstance(), Locale.getDefault(), selectedComponents, isTodayDisplayed, null);
    }

    public JCalendarCombo(Calendar calendar, Locale locale, int selectedComponents, boolean isTodayDisplayed) {
        this(calendar, locale, selectedComponents, isTodayDisplayed, null);
    }

    public JCalendarCombo(Calendar calendar, Locale locale, int selectedComponents, boolean isTodayDisplayed, String timePattern) {
        this.calendarPanel = new JCalendar(calendar, locale, selectedComponents, isTodayDisplayed, timePattern);
        this.locale = locale;
        this.parseFormat = new DateFormat[12];
        this.parseFormat[0] = DateFormat.getDateTimeInstance(3, 3, locale);
        this.parseFormat[1] = DateFormat.getDateTimeInstance(2, 2, locale);
        this.parseFormat[2] = DateFormat.getDateTimeInstance(1, 1, locale);
        this.parseFormat[3] = DateFormat.getDateTimeInstance(0, 0, locale);
        this.parseFormat[4] = DateFormat.getDateInstance(3, locale);
        this.parseFormat[5] = DateFormat.getDateInstance(2, locale);
        this.parseFormat[6] = DateFormat.getDateInstance(1, locale);
        this.parseFormat[7] = DateFormat.getDateInstance(0, locale);
        this.parseFormat[8] = DateFormat.getTimeInstance(3, locale);
        this.parseFormat[9] = DateFormat.getTimeInstance(2, locale);
        this.parseFormat[10] = DateFormat.getTimeInstance(1, locale);
        this.parseFormat[11] = DateFormat.getTimeInstance(0, locale);
        if (timePattern != null) {
            this.timePatternFormat = new SimpleDateFormat(timePattern, locale);
        }
        if (selectedComponents == 1) {
            this.setDateFormat(DateFormat.getDateInstance(0, locale));
        } else if (selectedComponents == 2) {
            this.setDateFormat(DateFormat.getTimeInstance(0, locale));
            if (timePattern != null) {
                this.timePatternFormat = new SimpleDateFormat(timePattern, locale);
            }
        } else {
            this.setDateFormat(DateFormat.getDateTimeInstance(0, 0, locale));
        }
        super.setModel(new CalendarComboBoxModel());
        super.setKeySelectionManager(new CalendarKeySelectionManager());
        this.createCalendarComponents();
    }

    public void addDateListener(DateListener listener) {
        this.calendarPanel.addDateListener(listener);
    }

    public void removeDateListener(DateListener listener) {
        this.calendarPanel.removeDateListener(listener);
    }

    public boolean isNullAllowed() {
        return this.calendarPanel.isNullAllowed();
    }

    public void setNullAllowed(boolean isNullAllowed) {
        this.calendarPanel.setNullAllowed(isNullAllowed);
    }

    public Date getDate() {
        return this.calendarPanel.getDate();
    }

    public void setDate(Date date) {
        this.calendarPanel.setDate(date);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) throws NullPointerException {
        if (dateFormat == null) {
            throw new NullPointerException("Date format cannot be null.");
        }
        this.dateFormat = dateFormat;
    }

    public Calendar getCalendar() {
        return this.calendarPanel.getCalendar();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isTodayDisplayed() {
        return this.calendarPanel.isTodayDisplayed();
    }

    public Font getTitleFont() {
        return this.calendarPanel.getTitleFont();
    }

    public void setTitleFont(Font font) {
        this.calendarPanel.setTitleFont(font);
    }

    public Font getDayOfWeekFont() {
        return this.calendarPanel.getDayOfWeekFont();
    }

    public void setDayOfWeekFont(Font font) {
        this.calendarPanel.setDayOfWeekFont(font);
    }

    public Font getDayFont() {
        return this.calendarPanel.getDayFont();
    }

    public void setDayFont(Font font) {
        this.calendarPanel.setDayFont(font);
    }

    public Font getTimeFont() {
        return this.calendarPanel.getTimeFont();
    }

    public void setTimeFont(Font font) {
        this.calendarPanel.setTimeFont(font);
    }

    public Font getTodayFont() {
        return this.calendarPanel.getTodayFont();
    }

    public void setTodayFont(Font font) {
        this.calendarPanel.setTodayFont(font);
    }

    public void setSelectedItem(Object anObject) {
        this.getModel().setSelectedItem(anObject);
    }

    public void setKeySelectionManager(JComboBox.KeySelectionManager aManager) {
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        cui = cui instanceof WindowsComboBoxUI ? new WindowsDateComboBoxUI() : (cui instanceof LipstikComboBoxUI ? new LipstikDateComboBoxUI() : (cui instanceof MetalComboBoxUI ? new MetalDateComboBoxUI() : (cui instanceof MotifComboBoxUI ? new MotifDateComboBoxUI() : new MetalDateComboBoxUI())));
        this.setUI((ComboBoxUI)cui);
    }

    protected String paramString() {
        int selectedComponents = this.calendarPanel.getSelectedComponents();
        String curDate = (selectedComponents & 1) == 1 ? DateFormat.getDateInstance(0, this.locale).format(this.getDate()) : ((selectedComponents & 2) == 2 ? DateFormat.getTimeInstance(0, this.locale).format(this.getDate()) : DateFormat.getDateTimeInstance(0, 0, this.locale).format(this.getDate()));
        return String.valueOf(super.paramString()) + ",selectedDate=" + curDate;
    }

    protected Date stringToDate(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        Date date = null;
        if (this.timePatternFormat != null) {
            try {
                date = this.timePatternFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            date = this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (date == null) {
            int i = 0;
            while (i < this.parseFormat.length) {
                try {
                    date = this.parseFormat[i].parse(string);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (date != null) break;
                ++i;
            }
        }
        return date;
    }

    private void createCalendarComponents() {
        Border border;
        this.calendarPanel.setJCalendarComboParent(this);
        this.calendarPanel.setInputMap(1, inputMap);
        this.calendarPanel.setActionMap(actionMap);
        if ((this.calendarPanel.getSelectedComponents() & 2) > 0) {
            InputMap sim = new InputMap();
            sim.put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
            sim.put(KeyStroke.getKeyStroke("ENTER"), "apply");
            ActionMap sam = new ActionMap();
            sam.put("cancel", new AbstractAction("cancel"){

                public void actionPerformed(ActionEvent e) {
                    JCalendarCombo calCombo = JCalendarCombo.this;
                    JCalendarCombo.this.calendarPanel.setDate(calCombo.originalDate);
                    calCombo.firePopupMenuCanceled();
                    calCombo.hideCalendar();
                }
            });
            sam.put("apply", new AbstractAction("apply"){

                public void actionPerformed(ActionEvent e) {
                    JCalendarCombo calCombo = JCalendarCombo.this;
                    calCombo.hideCalendar();
                }
            });
            this.calendarPanel.addSpinnerMaps(sim, sam);
        }
        if ((border = (Border)UIManager.get("PopupMenu.border")) == null) {
            border = new BevelBorder(0);
        }
        this.calendarPanel.setBorder(border);
        this.calendarPanel.addDateListener(new CalDateListener());
        this.addAncestorListener(new ComboAncestorListener());
    }

    private void hideCalendar() {
        if (this.isCalendarDisplayed) {
            this.firePopupMenuWillBecomeInvisible();
            this.calendarWindow.setVisible(false);
            this.isCalendarDisplayed = false;
            this.requestFocus();
            if (currentPopup == this) {
                currentPopup = null;
            }
        }
    }

    private void showCalendar() {
        if (!this.isCalendarDisplayed) {
            if (currentPopup != null) {
                currentPopup.hideCalendar();
            }
            this.firePopupMenuWillBecomeVisible();
            if (this.isEditable()) {
                this.setSelectedItem(this.getEditor().getItem());
                this.getEditor().selectAll();
            }
            Window oldParentWindow = this.parentWindow;
            this.parentWindow = SwingUtilities.getWindowAncestor(this);
            if (this.parentWindow == null) {
                return;
            }
            if (this.calendarWindow == null || this.parentWindow != oldParentWindow) {
                if (this.calendarWindow != null) {
                    this.calendarWindow.dispose();
                }
                this.calendarWindow = new JWindow(this.parentWindow);
                this.calendarWindow.getContentPane().add(this.calendarPanel);
                this.calendarWindow.pack();
            }
            Point fieldLocation = this.getLocationOnScreen();
            Dimension fieldSize = this.getSize();
            Dimension windowSize = this.calendarWindow.getSize();
            Dimension screenSize = this.getToolkit().getScreenSize();
            int x = fieldLocation.x + (fieldSize.width - windowSize.width);
            int y = fieldLocation.y + fieldSize.height;
            if (x + windowSize.width > screenSize.width) {
                x = screenSize.width - windowSize.width;
            }
            if (x < 0) {
                x = 0;
            }
            if (y + windowSize.height > screenSize.height) {
                y = fieldLocation.y - windowSize.height;
            }
            this.originalDate = this.calendarPanel.getDate();
            this.calendarPanel.setDisplayDate(this.originalDate);
            this.cacheCalendar = this.calendarPanel.getCalendar();
            this.calendarWindow.setLocation(x, y);
            this.calendarWindow.setVisible(true);
            this.isCalendarDisplayed = true;
            currentPopup = this;
        }
    }

    private void toggleCalendar() {
        if (this.isCalendarDisplayed) {
            this.hideCalendar();
        } else {
            this.showCalendar();
        }
    }

    private class CalDateListener
    implements DateListener {
        private CalDateListener() {
        }

        public void dateChanged(DateEvent e) {
            Calendar cal = e.getSelectedDate();
            if (cal == null) {
                JCalendarCombo.this.setSelectedItem(null);
            } else {
                JCalendarCombo.this.setSelectedItem(JCalendarCombo.this.dateFormat.format(e.getSelectedDate().getTime()));
            }
            if (cal == null && JCalendarCombo.this.cacheCalendar == null) {
                return;
            }
            if (cal != null && JCalendarCombo.this.cacheCalendar != null && cal.get(1) == JCalendarCombo.this.cacheCalendar.get(1) && cal.get(2) == JCalendarCombo.this.cacheCalendar.get(2) && cal.get(5) == JCalendarCombo.this.cacheCalendar.get(5)) {
                return;
            }
            JCalendarCombo.this.hideCalendar();
        }
    }

    protected class CalendarComboBoxModel
    implements ComboBoxModel {
        protected EventListenerList listenerList = new EventListenerList();

        protected CalendarComboBoxModel() {
        }

        public void addListDataListener(ListDataListener l) {
            this.listenerList.add(ListDataListener.class, l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.listenerList.remove(ListDataListener.class, l);
        }

        public Object getElementAt(int index) {
            return this.getSelectedItem();
        }

        public int getSize() {
            return 1;
        }

        public Object getSelectedItem() {
            Date date = JCalendarCombo.this.calendarPanel.getDate();
            if (date == null) {
                return "";
            }
            return JCalendarCombo.this.dateFormat.format(date);
        }

        public void setSelectedItem(Object anItem) {
            Date date = null;
            if (anItem != null) {
                date = JCalendarCombo.this.stringToDate(anItem.toString());
            }
            boolean fireEvent = false;
            Date calDate = JCalendarCombo.this.calendarPanel.getDate();
            if (date == null && calDate != null || date != null && !date.equals(calDate)) {
                fireEvent = true;
                JCalendarCombo.this.calendarPanel.setDate(date);
            }
            if (JCalendarCombo.this.isEditable()) {
                Object editorItem = JCalendarCombo.this.getEditor().getItem();
                Date editorDate = null;
                if (editorItem != null) {
                    editorDate = JCalendarCombo.this.stringToDate(editorItem.toString());
                }
                if (date == null && editorDate != null || date != null && !date.equals(editorDate)) {
                    fireEvent = true;
                    if (date == null) {
                        JCalendarCombo.this.getEditor().setItem("");
                    } else {
                        JCalendarCombo.this.getEditor().setItem(JCalendarCombo.this.dateFormat.format(date));
                    }
                }
            }
            if (fireEvent) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        private void fireContentsChanged(Object source, int index0, int index1) {
            Object[] listeners = this.listenerList.getListenerList();
            ListDataEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ListDataListener.class) {
                    if (e == null) {
                        e = new ListDataEvent(source, 0, index0, index1);
                    }
                    ((ListDataListener)listeners[i + 1]).contentsChanged(e);
                }
                i -= 2;
            }
        }
    }

    protected class CalendarComboPopup
    implements ComboPopup {
        private JList list = new JList();
        private MouseListener mouseListener = null;

        protected CalendarComboPopup() {
        }

        public KeyListener getKeyListener() {
            return null;
        }

        public JList getList() {
            return this.list;
        }

        public MouseListener getMouseListener() {
            if (this.mouseListener == null) {
                this.mouseListener = new InvocationMouseListener();
            }
            return this.mouseListener;
        }

        public MouseMotionListener getMouseMotionListener() {
            return null;
        }

        public boolean isVisible() {
            return JCalendarCombo.this.isCalendarDisplayed;
        }

        public void hide() {
            JCalendarCombo.this.hideCalendar();
        }

        public void show() {
            JCalendarCombo.this.showCalendar();
        }

        public void uninstallingUI() {
        }
    }

    private class CalendarKeySelectionManager
    implements JComboBox.KeySelectionManager {
        private CalendarKeySelectionManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            return -1;
        }
    }

    private class ComboAncestorListener
    implements AncestorListener {
        private ComboAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent e) {
            JCalendarCombo.this.hideCalendar();
        }

        public void ancestorRemoved(AncestorEvent e) {
            JCalendarCombo.this.hideCalendar();
        }

        public void ancestorMoved(AncestorEvent e) {
            JCalendarCombo.this.hideCalendar();
        }
    }

    private class InvocationMouseListener
    extends MouseAdapter {
        private InvocationMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !JCalendarCombo.this.isEnabled()) {
                return;
            }
            JCalendarCombo.this.toggleCalendar();
        }
    }

    class LipstikDateComboBoxUI
    extends LipstikComboBoxUI {
        LipstikDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new CalendarComboPopup();
        }
    }

    private class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        private MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new CalendarComboPopup();
        }
    }

    class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new CalendarComboPopup();
        }
    }

    class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new CalendarComboPopup();
        }
    }
}

