/*
 * Decompiled with CFR 0.152.
 */
package objects.wrappers;

import gui.GlavniFrame;
import gui.rightPanels.ReklamaPanel;
import java.io.File;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Header_Advertisement;
import objects.lang.LanguageStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tables.zagRekTable.ZagRekCellEditor;
import tables.zagRekTable.ZagRekTableModel;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;

public final class ReklamaWrapper
implements ComObject,
XmlObject {
    public final void sendToPort() throws Exception {
        Header_Advertisement.getInstance().programToCR();
    }

    public final void readFromPort() throws Exception {
        if (!GlavniFrame.PRINTER) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_CANT_READ_AND_HEADER"));
            return;
        }
        Header_Advertisement.getInstance().readHeaderFromCR();
        ZagRekTableModel.currentRow = 0;
        ReklamaPanel.t.editCellAt(0, 0);
        ((ZagRekCellEditor)ReklamaPanel.t.getCellEditor()).ds.setText(Header_Advertisement.getInstance().getStringValue(0, ReklamaPanel.t.getEditingRow()));
        ReklamaPanel.t.revalidate();
        ReklamaPanel.t.repaint();
    }

    public final void writeToXML(XmlFileWriter writer) throws Exception {
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<REKLAMA_DOC>");
        if (writer == null) {
            return;
        }
        writer.indent();
        int j = 0;
        while (j < Header_Advertisement.NUM_ADW) {
            writer.indent();
            writer.writeLn("<REKLAMA>");
            int i = 0;
            while (i < 11) {
                writer.write("<DATA TEXT='" + XmlFileWriter.compileString(Header_Advertisement.getInstance().getStringValue(j, i)) + "' " + "BOLD = '" + Header_Advertisement.getInstance().getBooleanValue(j, i) + "' ");
                writer.writeLn(" />");
                ++i;
            }
            writer.unintent();
            writer.writeLn("</REKLAMA>");
            ++j;
        }
        writer.unintent();
        writer.writeLn("</REKLAMA_DOC>");
    }

    public final void readFromXML(File file) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element rekEl = doc.getDocumentElement();
        NodeList reklamaNode = rekEl.getElementsByTagName("REKLAMA");
        int reklamaList = reklamaNode.getLength();
        int i = 0;
        while (i < reklamaList) {
            Element elem = (Element)reklamaNode.item(i);
            if (elem == null) {
                return;
            }
            NodeList dataNode = elem.getElementsByTagName("DATA");
            int j = 0;
            while (j < dataNode.getLength()) {
                Element dataElem = (Element)dataNode.item(j);
                boolean bold = Boolean.parseBoolean(dataElem.getAttribute("BOLD"));
                String row = dataElem.getAttribute("TEXT").toString();
                Header_Advertisement.getInstance().setBooleanValue(i, j, bold);
                Header_Advertisement.getInstance().setStringValue(i, j, row);
                ++j;
            }
            ++i;
        }
    }
}

