/*
 * Decompiled with CFR 0.152.
 */
package objects.wrappers;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import java.io.File;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.PLU;
import objects.PLUSorter;
import objects.lang.LanguageStrings;
import objects.wrappers.FiscallObjectsWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.BufferByte;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;
import util.comPort.PortSerial;

public final class PLUWrapper
implements ComObject,
XmlObject {
    private static BufferByte arr = new BufferByte(60, 4);
    public static boolean ERROR = false;

    public final void sendToPort() throws Exception {
        ERROR = false;
        ProcessDialog pd = ProcessDialog.getInstance();
        if (JOptionPane.showConfirmDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("PERFORM_BASE_CHECK"), "CHECK BASE?", 0) == 0) {
            PLU ppp;
            PLU plu;
            pd.setTitle(LanguageStrings.getInstance().getStringByName("BASE_CHECK_START"));
            pd.setMaximum(PLU.vec.size() * 3);
            pd.setVisible(true);
            int i = 0;
            while (i < PLU.vec.size()) {
                pd.increaseBar();
                plu = (PLU)PLU.vec.elementAt(i);
                plu.errorCode = 0;
                if (plu.getDesc().trim().length() <= 0) {
                    plu.errorCode = (byte)(plu.errorCode | 4);
                }
                if (plu.getCena() <= 0) {
                    plu.errorCode = (byte)(plu.errorCode | 8);
                }
                ++i;
            }
            PLUSorter.quicksortByBarcode(0, PLU.vec.size() - 1);
            int j = 0;
            while (j < PLU.vec.size() - 1) {
                pd.increaseBar();
                ppp = (PLU)PLU.vec.elementAt(j);
                plu = (PLU)PLU.vec.elementAt(j + 1);
                if (ppp.getBarCode() != -1L && ppp.getBarCode() == plu.getBarCode()) {
                    ppp.errorCode = (byte)(ppp.errorCode | 2);
                    plu.errorCode = (byte)(plu.errorCode | 2);
                }
                ++j;
            }
            PLUSorter.quicksortByCode(0, PLU.vec.size() - 1);
            j = 0;
            while (j < PLU.vec.size() - 1) {
                pd.increaseBar();
                ppp = (PLU)PLU.vec.elementAt(j);
                plu = (PLU)PLU.vec.elementAt(j + 1);
                if (ppp.errorCode != 0) {
                    ERROR = true;
                }
                if (ppp.getCode() != -1 && ppp.getCode() == plu.getCode()) {
                    ppp.errorCode = (byte)(ppp.errorCode | 1);
                    plu.errorCode = (byte)(plu.errorCode | 1);
                }
                ++j;
            }
        }
        GlavniFrame.getInstance().articlePanel.ta.revalidate();
        GlavniFrame.getInstance().articlePanel.ta.repaint();
        pd.setTitle(LanguageStrings.getInstance().getStringByName("BASE_CHECK_END"));
        PLUWrapper.programAllToCR(0);
        if (ERROR) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("BASE_CHECK_ERROR"));
        }
    }

    public final void readFromPort() throws Exception {
        ProcessingDialog.getInstance().setInstanceVisible(true);
        try {
            if (!GlavniFrame.PRINTER) {
                FiscallObjectsWrapper.readDepartment();
            }
            FiscallObjectsWrapper.readMeasure();
            PLUWrapper.readAllFromCR();
        }
        finally {
            ProcessingDialog.getInstance().setInstanceVisible(false);
            GlavniFrame.getInstance().articlePanel.ta.revalidate();
            GlavniFrame.getInstance().articlePanel.ta.repaint();
        }
    }

    public final void writeToXML(XmlFileWriter writer) throws Exception {
        ProcessDialog pd = ProcessDialog.getInstance();
        try {
            int size = PLU.vec.size();
            writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
            writer.writeLn("<ARTICAL>");
            pd.setMaximum(size);
            pd.setVisible(true);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int pom = size / 100;
            int i = 0;
            while (i < size) {
                PLU art = (PLU)PLU.vec.get(i);
                if (art != null) {
                    if (writer == null) {
                        return;
                    }
                    try {
                        writer.indent();
                        writer.write("<DATA PLU='" + String.valueOf(art.getCode()) + "'");
                        writer.write(" DESC='" + XmlFileWriter.compileString(art.getDesc()) + "'");
                        writer.write(" VAT='" + String.valueOf(art.getPoreskaStopa()) + "'");
                        writer.write(" BCR='" + art.getBarCode() + "'");
                        writer.write(" PRC='" + String.valueOf(art.getCena()) + "'");
                        writer.write(" DEP='" + String.valueOf(art.getOdeljenje()) + "'");
                        writer.write(" MES='" + String.valueOf(art.getJedinicaMere()) + "'");
                        writer.write(" AMN='" + String.valueOf(art.getKolicina()) + "'");
                        writer.write(" FIN='" + String.valueOf(art.getProdato()) + "'");
                        writer.writeLn("/>");
                        writer.unintent();
                    }
                    catch (Exception e1) {
                        pd.setVisible(false);
                        throw e1;
                    }
                    if (pom != 0 && i % pom == 0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    pd.increaseBar();
                }
                ++i;
            }
            writer.writeLn("</ARTICAL>");
        }
        finally {
            pd.setVisible(false);
        }
    }

    public final void readFromXML(File file) throws Exception {
        Document doc = null;
        ProcessDialog pd = ProcessDialog.getInstance();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element artEl = doc.getDocumentElement();
            NodeList dataNode = artEl.getElementsByTagName("DATA");
            int dataList = dataNode.getLength();
            pd.setMaximum(dataList);
            pd.setVisible(true);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PLU.vec.removeAllElements();
            int pom = dataList / 100;
            int i = 0;
            while (i < dataList) {
                Element elem = (Element)dataNode.item(i);
                PLU plu = new PLU();
                if (elem == null) {
                    return;
                }
                plu.setCode(Integer.parseInt(elem.getAttribute("PLU")));
                plu.setDesc(elem.getAttribute("DESC"));
                plu.setPoreskaStopa(Byte.parseByte(elem.getAttribute("VAT")));
                String str = elem.getAttribute("BCR");
                if (str == null || str.length() <= 0) {
                    str = "-1";
                }
                plu.setBarCode(Long.parseLong(str));
                plu.setCena(Integer.parseInt(elem.getAttribute("PRC")));
                plu.setOdeljenje(Byte.parseByte(elem.getAttribute("DEP")));
                plu.setJedinicaMere(Byte.parseByte(elem.getAttribute("MES")));
                try {
                    plu.setKolicina(Long.parseLong(elem.getAttribute("AMN")));
                    plu.setProdato(Long.parseLong(elem.getAttribute("FIN")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PLU.vec.add(plu);
                if (pom != 0 && i % pom == 0) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public static final void programAllToCR(int startCode) throws Exception {
        PLU plu = null;
        int descSize = 0;
        int i = startCode;
        int last = startCode;
        int maxDesc = 34;
        if (GlavniFrame.PRINTER) {
            maxDesc = 32;
        }
        Command instance = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        if (PLU.vec.size() == 1) {
            plu = (PLU)PLU.vec.elementAt(0);
            plu.sendToCR();
            return;
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(PLU.vec.size());
        pd.setVisible(true);
        try {
            try {
                while (i < PLU.vec.size()) {
                    instance.reset();
                    instance.setCmd(12);
                    while (instance.getPos() + 30 < 512) {
                        if (i >= PLU.vec.size()) break;
                        plu = (PLU)PLU.vec.elementAt(i);
                        if (plu.errorCode != 0) {
                            ++i;
                            pd.increaseBar();
                            continue;
                        }
                        descSize = plu.getDesc().length();
                        if (instance.getPos() + 30 + descSize >= 512) break;
                        if (descSize > maxDesc) {
                            plu.setDesc(plu.getDesc().substring(0, maxDesc));
                            descSize = maxDesc;
                        }
                        if (!GlavniFrame.PRINTER) {
                            instance.addByte(18 + descSize);
                        } else {
                            instance.addByte(9 + descSize);
                        }
                        instance.addInt(plu.getCode());
                        if (!GlavniFrame.PRINTER) {
                            instance.addLong(plu.getBarCode());
                        }
                        SysUtil.formatForSend(new String(plu.getDesc()), instance);
                        if (!GlavniFrame.PRINTER) {
                            instance.addByte(plu.getOdeljenje());
                        }
                        descSize = 0;
                        descSize = plu.getJedinicaMere();
                        descSize &= 0xF;
                        descSize <<= 4;
                        instance.addByte(descSize |= plu.getPoreskaStopa() & 0xF);
                        instance.addInt(plu.getCena());
                        ++i;
                        pd.increaseBar();
                    }
                    port.sendFrame(instance);
                    Command ccc = port.receiveFrame();
                    int e = ccc.getArray()[0] & 0xFF;
                    if (12 != ccc.getCmd() && e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                    last = i;
                }
            }
            catch (CommandsErrors c) {
                try {
                    int ll = 0;
                    while (true) {
                        plu = (PLU)PLU.vec.elementAt(last++);
                        plu.sendToCR();
                        if (++ll <= 50) continue;
                        PLUWrapper.programAllToCR(last);
                    }
                }
                catch (Exception ex) {
                    plu.errorCode = (byte)(plu.errorCode | 0x10);
                    ERROR = true;
                    PLUWrapper.programAllToCR(last);
                    pd.setVisible(false);
                }
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public static final void programSelected(int[] kk, int startCode) throws Exception {
        int nn = kk.length;
        int descSize = 0;
        int i = startCode;
        int last = startCode;
        PLU plu = null;
        Command instance = Command.bigInstance;
        int maxDesc = 34;
        if (GlavniFrame.PRINTER) {
            maxDesc = 32;
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            try {
                while (i < nn) {
                    instance.reset();
                    instance.setCmd(12);
                    while (instance.getPos() + 30 < 512) {
                        if (i >= nn) break;
                        if (kk[i] < 0 || kk[i] >= PLU.vec.size()) {
                            ++i;
                            break;
                        }
                        plu = (PLU)PLU.vec.elementAt(kk[i]);
                        if (plu.errorCode != 0) {
                            ++i;
                            pd.increaseBar();
                            continue;
                        }
                        descSize = plu.getDesc().length();
                        if (instance.getPos() + 30 + descSize >= 512) break;
                        descSize = plu.getDesc().length();
                        if (descSize > maxDesc) {
                            plu.setDesc(plu.getDesc().substring(0, maxDesc));
                            descSize = maxDesc;
                        }
                        if (!GlavniFrame.PRINTER) {
                            instance.addByte(18 + descSize);
                        } else {
                            instance.addByte(9 + descSize);
                        }
                        instance.addInt(plu.getCode());
                        if (!GlavniFrame.PRINTER) {
                            instance.addLong(plu.getBarCode());
                        }
                        SysUtil.formatForSend(new String(plu.getDesc()), instance);
                        if (!GlavniFrame.PRINTER) {
                            instance.addByte(plu.getOdeljenje());
                        }
                        descSize = 0;
                        descSize = plu.getJedinicaMere();
                        descSize &= 0xF;
                        descSize <<= 4;
                        instance.addByte(descSize |= plu.getPoreskaStopa() & 0xF);
                        instance.addInt(plu.getCena());
                        ++i;
                        pd.increaseBar();
                    }
                    PortSerial port = PortSerial.getInstance();
                    port.sendFrame(instance);
                    Command ccc = port.receiveFrame();
                    int e = ccc.getArray()[0] & 0xFF;
                    if (12 != ccc.getCmd() && e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                    last = i;
                }
            }
            catch (CommandsErrors c) {
                try {
                    int ll = 0;
                    while (true) {
                        plu = (PLU)PLU.vec.elementAt(kk[last++]);
                        plu.sendToCR();
                        if (++ll <= 50) continue;
                        PLUWrapper.programAllToCR(last);
                    }
                }
                catch (Exception ex) {
                    plu.errorCode = (byte)(plu.errorCode | 0x10);
                    ERROR = true;
                    PLUWrapper.programSelected(kk, last);
                    pd.setVisible(false);
                }
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public static final void readAllFromCR() throws Exception {
        int minSize = 18;
        int descSize = 34;
        int descStart = 12;
        if (GlavniFrame.PRINTER) {
            minSize = 10;
            descStart = 10;
        }
        int i = 0;
        Command instance = Command.bigInstance;
        PLU.vec.removeAllElements();
        block0: while (true) {
            instance.reset();
            instance.setCmd(19);
            instance.addInt(++i);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command command = port.receiveFrame();
            int e = command.getArray()[0] & 0xFF;
            int cmd = command.getCmd();
            if (cmd != 19 && cmd != 128) {
                if (e == 18) {
                    return;
                }
                if (e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            int len = command.getLength();
            int pos = 0;
            while (true) {
                if (pos + minSize > len) continue block0;
                arr.reset();
                int size = command.getByte(pos++);
                arr.add(command.getArray(), pos, size);
                pos += size;
                if (arr.getInt(0) == 0) {
                    return;
                }
                PLU plu = new PLU();
                i = arr.getInt(0) & 0xFFFFF;
                plu.setCode(i & 0xFFFFF);
                if (GlavniFrame.PRINTER) {
                    plu.setBarCode(-1L);
                } else {
                    plu.setBarCode(arr.getLong(4));
                }
                if (GlavniFrame.PRINTER) {
                    plu.setCena(arr.getInt(size - 4));
                    byte poreskaStopa = 0;
                    int jedinicaMere = 0;
                    int jj = arr.getValueAt(size - 5);
                    jedinicaMere |= (jj & 0xF0) >> 4;
                    poreskaStopa = (byte)(poreskaStopa | jj & 0xF);
                    byte[] bb = new byte[size - 9];
                    System.arraycopy(arr.getBuffer(), 4, bb, 0, bb.length);
                    plu.setDesc(SysUtil.formatForReceive(bb));
                    plu.setPoreskaStopa(poreskaStopa);
                    plu.setJedinicaMere(jedinicaMere);
                    PLU.vec.add(plu);
                    GlavniFrame.getInstance().articlePanel.ta.revalidate();
                    GlavniFrame.getInstance().articlePanel.ta.repaint();
                    continue;
                }
                int offset = descSize + minSize - size;
                byte[] bb = new byte[descSize];
                System.arraycopy(arr.getBuffer(), descStart, bb, 0, bb.length - offset);
                plu.setDesc(SysUtil.formatForReceive(bb));
                plu.setLager(arr.getInt(42 - offset));
                byte poreskaStopa = 0;
                int jedinicaMere = 0;
                byte odeljenje2 = 0;
                poreskaStopa = (byte)(poreskaStopa | (byte)arr.getValueAt(47 - offset) & 0xF);
                odeljenje2 = (byte)(odeljenje2 | (byte)arr.getValueAt(46 - offset));
                plu.setPoreskaStopa(poreskaStopa);
                plu.setJedinicaMere(jedinicaMere |= ((byte)arr.getValueAt(47 - offset) & 0xF0) >> 4);
                plu.setOdeljenje(odeljenje2);
                plu.setCena(arr.getInt(48 - offset));
                PLU.vec.add(plu);
                GlavniFrame.getInstance().articlePanel.ta.revalidate();
                GlavniFrame.getInstance().articlePanel.ta.repaint();
            }
            break;
        }
    }

    public static final void readSold() throws Exception {
        int code = 0;
        Command instance = Command.bigInstance;
        do {
            instance.reset();
            instance.setCmd(27);
            instance.addInt(++code);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command command = port.receiveFrame();
            int e = command.getArray()[0] & 0xFF;
            int cmd = command.getCmd();
            if (cmd != 27 && cmd != 128) {
                if (e == 18) {
                    return;
                }
                if (e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            int len = command.getLength();
            int pos = 0;
            long lll = 0L;
            while (pos + 16 <= len) {
                arr.reset();
                code = command.getInt(pos);
                pos += 4;
                PLU plu = null;
                int j = 0;
                while (j < PLU.vec.size()) {
                    plu = (PLU)PLU.vec.elementAt(j);
                    if (plu.getCode() == code) break;
                    if (j == PLU.vec.size() - 1) {
                        // empty if block
                    }
                    ++j;
                }
                if (((lll = command.getLong(pos, 6)) & 0x800000000000L) > 0L) {
                    lll |= 0xFFFF000000000000L;
                }
                plu.setProdato(lll);
                lll = command.getLong(pos += 6, 6);
                if ((lll & 0x800000000000L) > 0L) {
                    lll |= 0xFFFF000000000000L;
                }
                plu.setKolicina(lll);
                pos += 6;
            }
        } while (code != 32000);
    }

    public static void printAllArticles() throws Exception {
        int i = 1;
        Command instance = Command.instance;
        do {
            instance.reset();
            instance.setCmd(21);
            instance.addInt(i);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = instance.getArray()[0] & 0xFF;
            int cmd = instance.getCmd();
            if (cmd == 21 || cmd == 128) continue;
            if (e == 18) {
                return;
            }
            if (e == 0) continue;
            CommandsErrors.instanceMain.setError(e);
        } while ((i = instance.getInt(0)) > 0);
    }

    public static void printArticle(int kk) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(21);
        instance.addInt(kk);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (21 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }
}

