/*
 * Decompiled with CFR 0.152.
 */
package objects.wrappers;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.ProcessingDialog;
import java.io.File;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Kasiri;
import objects.lang.LanguageStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;
import util.comPort.PortSerial;

public final class KasiriWrapper
implements ComObject,
XmlObject {
    public final void sendToPort() throws Exception {
        Command instance = Command.instance;
        int l = Kasiri.vec.length;
        PortSerial port = PortSerial.getInstance();
        int i = 0;
        while (i < l) {
            try {
                Kasiri kas = Kasiri.vec[i];
                if (kas.getCode() != 0L) {
                    Command.instance.reset();
                    Command.instance.setCmd(40);
                    instance.addByte(i);
                    instance.addByte(kas.getLevel());
                    SysUtil.formatForSend(kas.getIme(), Command.instance);
                    int k = kas.getIme().length();
                    while (k++ < 22) {
                        instance.addByte(32);
                    }
                    instance.addLong(kas.getCode());
                    port.sendFrame(Command.instance);
                    port.receiveFrame(Command.instance);
                    int e = Command.instance.getArray()[0] & 0xFF;
                    int command = Command.instance.getCmd();
                    if (command != 40 && command != 128 && e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("KASIR: " + (i + 1) + ' ' + e.getMessage());
            }
            ++i;
        }
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
    }

    public final void readFromPort() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            Command instance = Command.instance;
            PortSerial port = PortSerial.getInstance();
            int i = 0;
            while (i < 16) {
                Command.instance.reset();
                Command.instance.setCmd(38);
                instance.addByte(i);
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                int e = Command.instance.getArray()[0] & 0xFF;
                int command = Command.instance.getCmd();
                if (command != 38 && command != 128) {
                    if (e == 21) {
                        break;
                    }
                    if (e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                }
                Kasiri kas = new Kasiri();
                kas.setLevel(Command.instance.getArray()[1]);
                byte[] bb = new byte[22];
                System.arraycopy(Command.instance.getArray(), 2, bb, 0, 22);
                kas.setIme(SysUtil.formatForReceive(bb));
                long v = Command.instance.getLong(24);
                kas.setCode(v);
                v = Command.instance.getLong(32);
                kas.setFinance(v);
                Kasiri.vec[i] = kas;
                ++i;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public final void writeToXML(XmlFileWriter writer) throws Exception {
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<KASIRI>");
        int i = 0;
        while (i < Kasiri.vec.length) {
            Kasiri kas = Kasiri.vec[i];
            if (kas != null) {
                if (writer == null) {
                    return;
                }
                writer.indent();
                writer.write("<DATA IME='" + XmlFileWriter.compileString(kas.getIme().trim()) + "'");
                writer.write(" CODE='" + kas.getCode() + "'");
                writer.write(" LEVEL='" + kas.getLevel() + "'");
                writer.writeLn("/>");
                writer.unintent();
            }
            ++i;
        }
        writer.writeLn("</KASIRI>");
    }

    public final void readFromXML(File file) throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element docEl = doc.getDocumentElement();
            NodeList dataNode = docEl.getElementsByTagName("DATA");
            int dataList = dataNode.getLength();
            int i = 0;
            while (i < dataList) {
                Element elem = (Element)dataNode.item(i);
                Kasiri kas = new Kasiri();
                if (elem == null) {
                    return;
                }
                kas.setCode(Long.parseLong(elem.getAttribute("CODE")));
                kas.setIme(elem.getAttribute("IME"));
                kas.setLevel(Byte.parseByte(elem.getAttribute("LEVEL")));
                Kasiri.vec[i] = kas;
                ++i;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }
}

