/*
 * Decompiled with CFR 0.152.
 */
package objects.wrappers;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.ProcessingDialog;
import gui.rightPanels.RightPanel;
import gui.rightPanels.RightPanelListener;
import gui.search.SearchPluDialog;
import hcp.constants.Constants;
import java.io.File;
import java.util.Calendar;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.FiscallObjects;
import objects.lang.LanguageStrings;
import org.w3c.dom.Element;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;
import util.comPort.PortSerial;

public final class FiscallObjectsWrapper
implements ComObject,
XmlObject {
    public static void readMeasure() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(61);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 61 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int i = 10;
        while (i < FiscallObjects.jediniceMere.length) {
            String s = new String(instance.getArray(), i << 1, 2);
            FiscallObjects.jediniceMere[i] = s = SysUtil.formatForReceive(s.getBytes());
            ++i;
        }
    }

    public static void readDepartment() throws Exception {
        Command instance = Command.instance;
        int l = FiscallObjects.odeljenja.length;
        PortSerial port = PortSerial.getInstance();
        int i = 0;
        while (i < l) {
            Command inst = Command.instance;
            inst.reset();
            inst.setCmd(37);
            instance.addByte(i);
            port.sendFrame(inst);
            port.receiveFrame(inst);
            int e = inst.getArray()[0] & 0xFF;
            int command = inst.getCmd();
            if (command != 37 && command != 128) {
                if (e == 21) break;
                if (e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            byte[] b = new byte[16];
            System.arraycopy(instance.getArray(), 1, b, 0, 16);
            long prod = instance.getLong(17);
            FiscallObjects.odeljenja[i] = new FiscallObjects.odeljenje(SysUtil.formatForReceive(b), prod);
            ++i;
        }
    }

    public static int getADDER(long timeE) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeE);
        int mon = cal.get(2);
        if (mon > 2 && mon < 9) {
            return 2;
        }
        if (mon > 9 || mon < 2) {
            return 1;
        }
        cal.set(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        long time = cal.getTimeInMillis();
        int i = 31;
        while (i > 0) {
            cal.set(5, i);
            time = cal.getTimeInMillis();
            if (cal.get(7) == 1) break;
            --i;
        }
        if (mon == 2) {
            if (timeE < time) {
                return 1;
            }
            return 2;
        }
        if (timeE < time) {
            return 2;
        }
        return 1;
    }

    public final void sendToPort() throws Exception {
        int c = 88;
        int j = 0;
        while (j < RightPanelListener.vec.size()) {
            if (((RightPanel)RightPanelListener.vec.elementAt(j)).isVisible()) {
                c = (char)((RightPanel)RightPanelListener.vec.elementAt((int)j)).button.getMnemonic();
            }
            ++j;
        }
        if (c == 80) {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(31);
            byte[] b = new byte[Constants.VATS_MAX_NUMBER * 2];
            int i = 0;
            while (i < Constants.VATS_MAX_NUMBER) {
                int pomi = FiscallObjects.poreskeStope[i].vrednost;
                b[i * 2] = (byte)pomi;
                b[i * 2 + 1] = (byte)(pomi >>= 8);
                ++i;
            }
            instance.addToArray(b, 0, Constants.VATS_MAX_NUMBER * 2);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 31 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        } else if (c == 74) {
            String ps = "";
            int i = 10;
            while (i < FiscallObjects.jediniceMere.length) {
                ps = String.valueOf(ps) + FiscallObjects.jediniceMere[i];
                ++i;
            }
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(62);
            SysUtil.formatForSend(ps, Command.instance);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 62 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        } else if (c == 79) {
            int l = FiscallObjects.odeljenja.length;
            PortSerial port = PortSerial.getInstance();
            int i = 0;
            while (i < l) {
                try {
                    Command.instance.reset();
                    Command.instance.setCmd(36);
                    Command.instance.addByte(i);
                    SysUtil.formatForSend(FiscallObjects.odeljenja[i].opis, Command.instance);
                    int j2 = FiscallObjects.odeljenja[i].opis.length();
                    while (j2 < 16) {
                        Command.instance.addByte(32);
                        ++j2;
                    }
                    port.sendFrame(Command.instance);
                    port.receiveFrame(Command.instance);
                    int e = Command.instance.getArray()[0] & 0xFF;
                    int command = Command.instance.getCmd();
                    if (command != 36 && command != 128) {
                        if (e == 21) {
                            FiscallObjects.odeljenja[i].opis = "";
                        } else if (e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                    }
                }
                catch (Exception e) {
                    throw new Exception("ODELJENJE: " + (i + 1) + ' ' + e.getMessage());
                }
                ++i;
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }
    }

    public final void readFromPort() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            int c = 88;
            int j = 0;
            while (j < RightPanelListener.vec.size()) {
                if (((RightPanel)RightPanelListener.vec.elementAt(j)).isVisible()) {
                    c = (char)((RightPanel)RightPanelListener.vec.elementAt((int)j)).button.getMnemonic();
                }
                ++j;
            }
            if (c == 80) {
                Command instance = Command.instance;
                instance.reset();
                instance.setCmd(32);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                port.receiveFrame(instance);
                int e = Command.instance.getArray()[0] & 0xFF;
                int command = Command.instance.getCmd();
                if (command != 32 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                byte[] b = new byte[Constants.VATS_MAX_NUMBER * 2];
                System.arraycopy(instance.getArray(), 0, b, 0, b.length);
                int i = 0;
                while (i < Constants.VATS_MAX_NUMBER) {
                    int pomi = 0;
                    pomi = b[i * 2] & 0xFF;
                    FiscallObjects.poreskeStope[i].vrednost = pomi |= (b[i * 2 + 1] & 0xFF) << 8;
                    FiscallObjects.poreskeStope[i].pravaVrednost = (double)pomi / 100.0;
                    ++i;
                }
            } else if (c == 74) {
                FiscallObjectsWrapper.readMeasure();
            } else if (c == 79) {
                FiscallObjectsWrapper.readDepartment();
            }
            GlavniFrame.getInstance().articlePanel.ta.revalitadeCombos();
            SearchPluDialog.getInstance().tablePanel.table.revalitadeCombos();
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public final void writeToXML(XmlFileWriter xmlWriter) throws Exception {
        int i;
        int c = 88;
        int j = 0;
        while (j < RightPanelListener.vec.size()) {
            if (((RightPanel)RightPanelListener.vec.elementAt(j)).isVisible()) {
                c = (char)((RightPanel)RightPanelListener.vec.elementAt((int)j)).button.getMnemonic();
            }
            ++j;
        }
        if (c == 80) {
            xmlWriter.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
            xmlWriter.writeLn("<PORESKESTOPE>");
            if (xmlWriter == null) {
                return;
            }
            xmlWriter.indent();
            xmlWriter.write("<DATA ");
            i = 0;
            while (i < FiscallObjects.poreskeStope.length) {
                xmlWriter.write(String.valueOf(FiscallObjects.poreskeStope[i].opis) + " = '" + FiscallObjects.poreskeStope[i].vrednost + "' ");
                ++i;
            }
            xmlWriter.writeLn("/>");
            xmlWriter.unintent();
            xmlWriter.writeLn("</PORESKESTOPE>");
        } else if (c == 74) {
            xmlWriter.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
            xmlWriter.writeLn("<JEDINICEMERE>");
            if (xmlWriter == null) {
                return;
            }
            xmlWriter.indent();
            xmlWriter.write("<DATA ");
            xmlWriter.write("jm1 = '" + XmlFileWriter.compileString(FiscallObjects.jediniceMere[10]) + "' ");
            xmlWriter.write("jm2 = '" + XmlFileWriter.compileString(FiscallObjects.jediniceMere[11]) + "' ");
            xmlWriter.write("jm3 = '" + XmlFileWriter.compileString(FiscallObjects.jediniceMere[12]) + "' ");
            xmlWriter.write("jm4 = '" + XmlFileWriter.compileString(FiscallObjects.jediniceMere[13]) + "' ");
            xmlWriter.write("jm5 = '" + XmlFileWriter.compileString(FiscallObjects.jediniceMere[14]) + "' ");
            xmlWriter.writeLn("/>");
            xmlWriter.unintent();
            xmlWriter.writeLn("</JEDINICEMERE>");
        } else if (c == 79) {
            xmlWriter.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
            xmlWriter.writeLn("<ODELJENJA>");
            if (xmlWriter == null) {
                return;
            }
            xmlWriter.indent();
            xmlWriter.write("<DATA ");
            i = 0;
            while (i < FiscallObjects.odeljenja.length) {
                xmlWriter.write("ODELJENJE" + i + " = '" + XmlFileWriter.compileString(FiscallObjects.odeljenja[i].opis) + "' ");
                ++i;
            }
            xmlWriter.writeLn("/>");
            xmlWriter.unintent();
            xmlWriter.writeLn("</ODELJENJA>");
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void readFromXML(File file) throws Exception {
        pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            block16: {
                block17: {
                    block15: {
                        doc = null;
                        dbf = DocumentBuilderFactory.newInstance();
                        db = dbf.newDocumentBuilder();
                        doc = db.parse(file);
                        artEl = doc.getDocumentElement();
                        dataNode = artEl.getElementsByTagName("DATA");
                        dataList = dataNode.getLength();
                        c = 88;
                        j = 0;
                        while (j < RightPanelListener.vec.size()) {
                            if (((RightPanel)RightPanelListener.vec.elementAt(j)).isVisible()) {
                                c = (char)((RightPanel)RightPanelListener.vec.elementAt((int)j)).button.getMnemonic();
                            }
                            ++j;
                        }
                        if (c != 80) break block15;
                        i = 0;
                        while (i < dataList) {
                            elem = (Element)dataNode.item(i);
                            if (elem == null) lbl-1000:
                            // 3 sources

                            {
                                return;
                            }
                            j = 0;
                            while (j < 9) {
                                FiscallObjects.poreskeStope[j].vrednost = Integer.parseInt(elem.getAttribute(FiscallObjects.poreskeStope[j].opis));
                                FiscallObjects.poreskeStope[j].pravaVrednost = (double)FiscallObjects.poreskeStope[j].vrednost / 100.0;
                                ++j;
                            }
                            ++i;
                        }
                        break block16;
                    }
                    if (c != 74) break block17;
                    i = 0;
                    while (i < dataList) {
                        elem = (Element)dataNode.item(i);
                        if (elem == null) ** GOTO lbl-1000
                        FiscallObjects.jediniceMere[10] = elem.getAttribute("jm1");
                        FiscallObjects.jediniceMere[11] = elem.getAttribute("jm2");
                        FiscallObjects.jediniceMere[12] = elem.getAttribute("jm3");
                        FiscallObjects.jediniceMere[13] = elem.getAttribute("jm4");
                        FiscallObjects.jediniceMere[14] = elem.getAttribute("jm5");
                        ++i;
                    }
                    break block16;
                }
                if (c == 79) {
                    i = 0;
                    while (i < dataList) {
                        elem = (Element)dataNode.item(i);
                        if (elem != null) ** break;
                        ** continue;
                        j = 0;
                        while (j < FiscallObjects.odeljenja.length) {
                            FiscallObjects.odeljenja[j].opis = elem.getAttribute("ODELJENJE" + j);
                            FiscallObjects.odeljenja[j].prodato = 0L;
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            GlavniFrame.getInstance().articlePanel.ta.revalitadeCombos();
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }
}

