/*
 * Decompiled with CFR 0.152.
 */
package objects;

import gui.GlavniFrame;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.PortSerial;

public class Settings
implements XmlObject {
    private int posx;
    private int posy;
    private int sizex;
    private int sizey;
    private int state;
    private String language;
    private String cash;
    private static Settings instance = new Settings();

    public static Settings getInstance() {
        return instance;
    }

    private Settings() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.posx = d.width / 2 - 512;
        this.posy = d.height / 2 - 264;
        this.sizex = 1024;
        this.sizey = 527;
        this.state = 0;
        this.language = "";
        this.cash = "";
    }

    public void reset() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.posx = d.width / 2 - 512;
        this.posy = d.height / 2 - 264;
        this.sizex = 1024;
        this.sizey = 527;
        this.state = 0;
        GlavniFrame.getInstance().setLocation(this.posx, this.posy);
        GlavniFrame.getInstance().setPreferredSize(new Dimension(this.sizex, this.sizey));
        GlavniFrame.getInstance().setExtendedState(GlavniFrame.getInstance().getExtendedState());
        GlavniFrame.getInstance().pack();
        this.language = "";
        this.cash = "";
        File file = new File("properties", "settings.xml");
        if (file.exists()) {
            file.delete();
        }
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<SETTINGS>");
        if (writer == null) {
            return;
        }
        writer.indent();
        writer.write("<DATA POSX='" + this.posx + "'");
        writer.write(" POSY='" + this.posy + "'");
        writer.write(" SIZEX='" + this.getSizex() + "'");
        writer.write(" SIZEY='" + this.getSizey() + "'");
        writer.write(" STATE='" + this.state + "'");
        writer.write(" PORT='" + XmlFileWriter.compileString(String.valueOf(PortSerial.sPort) + "'"));
        writer.write(" SPEED='" + PortSerial.speed + "'");
        writer.write(" LANG='" + this.language + "'");
        writer.write(" CASH='" + this.cash + "'");
        writer.writeLn(">");
        writer.writeLn("</DATA>");
        writer.unintent();
        writer.writeLn("</SETTINGS>");
    }

    public void readFromXML(File file) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element artEl = doc.getDocumentElement();
        NodeList dataNode = artEl.getElementsByTagName("DATA");
        Element elem = (Element)dataNode.item(0);
        if (elem == null) {
            return;
        }
        this.setPosx(Integer.parseInt(elem.getAttribute("POSX")));
        this.setPosy(Integer.parseInt(elem.getAttribute("POSY")));
        this.setSizex(Integer.parseInt(elem.getAttribute("SIZEX")));
        this.setSizey(Integer.parseInt(elem.getAttribute("SIZEY")));
        this.setState(Integer.parseInt(elem.getAttribute("STATE")));
        PortSerial.sPort = elem.getAttribute("PORT");
        PortSerial.speed = Integer.parseInt(elem.getAttribute("SPEED"));
        this.language = elem.getAttribute("LANG");
        this.cash = elem.getAttribute("CASH");
    }

    public int getPosx() {
        return this.posx;
    }

    public int getPosy() {
        return this.posy;
    }

    public void setPosx(int posx) {
        this.posx = posx;
    }

    public void setPosy(int posy) {
        this.posy = posy;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public final int getSizey() {
        return this.sizey;
    }

    public final void setSizey(int sizey) {
        this.sizey = sizey;
    }

    public final int getSizex() {
        return this.sizex;
    }

    public final void setSizex(int sizex) {
        this.sizex = sizex;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final void setLanguage(String language) {
        this.language = language;
    }

    public final String getCash() {
        return this.cash;
    }

    public final void setCash(String cash) {
        this.cash = cash;
    }
}

