/*
 * Decompiled with CFR 0.152.
 */
package objects;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import hcp.constants.Constants;
import java.sql.ResultSet;
import java.util.Vector;
import objects.DBManager;
import util.BufferByte;
import util.SysUtil;
import util.comPort.PortSerial;

public class PLU {
    private static final String empStr = "";
    private String desc = "";
    private long barCode;
    private int code;
    private int cena;
    private byte poreskaStopa;
    private byte jedinicaMere;
    private byte odeljenje;
    private long prodato;
    private long kolicina;
    private int lager;
    public byte errorCode = 0;
    public static final byte ERROR_CODE_NO_ERROR = 0;
    public static final byte ERROR_CODE_PLU = 1;
    public static final byte ERROR_CODE_BARCODE = 2;
    public static final byte ERROR_CODE_DESCRIPTION = 4;
    public static final byte ERROR_CODE_PRICE = 8;
    public static final byte ERROR_CODE_UNKNOWN = 16;
    public static Vector vec = new Vector();
    public static Vector vecView = new Vector();
    public static final int EMPTY_CODE = -1;
    public static final long EMPTY_BAR_CODE = -1L;
    public static final String sqlTableExists = "show tables like 'articles';";
    public static final String sqlDropTable = "DROP TABLE IF EXISTS `articles`;";
    public static final String sqlGetAll = "SELECT * FROM articles;";
    public static final String sqlCreateTable = " CREATE TABLE `articles` (  `code` smallint(6) NOT NULL default '0',  `barcode` bigint(19) NOT NULL default '0',  `description` text NOT NULL,  `price` int(11) unsigned NOT NULL default '0',  `vat` tinyint(1) unsigned NOT NULL default '0',  `measure` tinyint(1) unsigned NOT NULL default '0',  `department` tinyint(2) unsigned NOT NULL default '0') ENGINE=MyISAM DEFAULT CHARSET=utf8;";
    private static final String sqlQuery = "INSERT INTO `articles` (`code`,`barcode`,`description`,`price`,`vat`,`measure`,`department`) VALUES ";

    public final long getBarCode() {
        return this.barCode;
    }

    public final void setBarCode(long barCode) {
        this.barCode = barCode;
    }

    public final int getCena() {
        return this.cena;
    }

    public final void setCena(int cena) {
        this.cena = cena;
    }

    public final int getCode() {
        return this.code;
    }

    public final void setCode(int code) {
        this.code = code;
    }

    public final byte getJedinicaMere() {
        return this.jedinicaMere;
    }

    public final void setJedinicaMere(int jedinicaMere) {
        this.jedinicaMere = (byte)jedinicaMere;
    }

    public final long getKolicina() {
        return this.kolicina;
    }

    public final void setKolicina(long kolicina) {
        this.kolicina = kolicina;
    }

    public final byte getOdeljenje() {
        return this.odeljenje;
    }

    public final void setOdeljenje(byte odeljenje2) {
        this.odeljenje = odeljenje2;
    }

    public final byte getPoreskaStopa() {
        return this.poreskaStopa;
    }

    public final void setPoreskaStopa(byte poreskaStopa) {
        this.poreskaStopa = (byte)(poreskaStopa % Constants.VATS_MAX_NUMBER);
    }

    public final long getProdato() {
        return this.prodato;
    }

    public final void setProdato(long prodato) {
        this.prodato = prodato;
    }

    public final void setDesc(String desc1) {
        this.desc = new String(desc1);
    }

    public final String getDesc() {
        return this.desc.trim();
    }

    public final int getLager() {
        return this.lager;
    }

    public final void setLager(int lager) {
        this.lager = lager;
    }

    public final void sendToCR() throws Exception {
        PLU.programmToCR(this);
    }

    private static final void programmToCR(PLU plu) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(12);
        int maxDesc = 34;
        if (GlavniFrame.PRINTER) {
            maxDesc = 32;
        }
        int descSize = plu.desc.length();
        int t = 0;
        if (descSize > maxDesc) {
            plu.setDesc(plu.getDesc().substring(0, maxDesc));
            descSize = maxDesc;
        }
        instance.addInt(plu.code);
        if (!GlavniFrame.PRINTER) {
            instance.addLong(plu.barCode);
        }
        SysUtil.formatForSend(plu.desc, instance);
        if (!GlavniFrame.PRINTER) {
            instance.addByte(plu.odeljenje);
        }
        t = plu.jedinicaMere;
        t &= 0xF;
        t <<= 4;
        instance.addByte(t |= plu.poreskaStopa & 0xF);
        instance.addInt(plu.cena);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (12 != instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public final void readFromCR_BARCode() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(10);
        Command instance = Command.instance;
        instance.addLong(this.barCode);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (10 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        this.dodeli();
    }

    public void changePriceByCode(int cena) throws Exception {
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(11);
        instance.addInt(this.code);
        instance.addInt(cena);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command ccc = port.receiveFrame();
        int e = ccc.getArray()[0] & 0xFF;
        if (11 != ccc.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public final void readFromCR_codeBAr(int i) throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(243);
        Command instance = Command.instance;
        instance.addInt(i);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (243 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        this.dodeli();
    }

    private final void dodeli() {
        Command cmd = Command.instance;
        byte[] bb = new byte[34];
        this.poreskaStopa = 0;
        this.jedinicaMere = 0;
        this.odeljenje = 0;
        this.code = cmd.getShort(0) & 0xFFFF;
        this.barCode = cmd.getLong(4, 8);
        System.arraycopy(cmd.getArray(), 12, bb, 0, bb.length);
        this.desc = SysUtil.formatForReceive(bb);
        this.prodato = cmd.getLong(46, 6) & 0xFFFFFFFFFFFFL;
        this.kolicina = cmd.getLong(52, 6) & 0xFFFFFFFFFFFFL;
        this.odeljenje = (byte)(this.odeljenje | (byte)cmd.getByte(58));
        this.jedinicaMere = (byte)(this.jedinicaMere | ((byte)cmd.getByte(59) & 0xF0) >> 4);
        this.poreskaStopa = (byte)(this.poreskaStopa | (byte)cmd.getByte(59) & 0xF);
        this.cena = cmd.getInt(60);
    }

    public final void deleteFROMCR_barCode() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(18);
        Command instance = Command.instance;
        instance.addLong(this.barCode);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (18 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private boolean writeToBase() throws Exception {
        DBManager db = DBManager.getInstance();
        String sql = "INSERT INTO `articles` (`code`,`barcode`,`description`,`price`,`vat`,`measure`,`department`) VALUES (" + this.code + "," + this.barCode + ",'" + SysUtil.compileStringForMySQL(this.desc) + "'," + this.cena + "," + this.poreskaStopa + "," + this.jedinicaMere + "," + this.odeljenje + ");";
        return db.executeSQLQuery(sql);
    }

    public static final void writeAllToBase() throws Exception {
        DBManager db = DBManager.getInstance();
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(vec.size() + 2);
        pd.setVisible(true);
        try {
            db.executeSQLQuery(sqlDropTable);
            pd.increaseBar();
            db.executeSQLQuery(sqlCreateTable);
            pd.increaseBar();
            int i = 0;
            while (i < vec.size()) {
                ((PLU)vec.elementAt(i)).writeToBase();
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void fillDataFromDBResaultSet(ResultSet rs) throws Exception {
        this.setDesc(rs.getString("description"));
        this.setCode(rs.getInt("code"));
        this.setBarCode(rs.getLong("barcode"));
        this.setCena(rs.getInt("price"));
        this.setPoreskaStopa(rs.getByte("vat"));
        this.setJedinicaMere(rs.getByte("measure"));
        this.setOdeljenje(rs.getByte("department"));
    }

    public static final void loadFromBase() throws Exception {
        DBManager db = DBManager.getInstance();
        ResultSet rs = db.getQueryResultSet(sqlTableExists);
        vec.removeAllElements();
        rs = db.getQueryResultSet(sqlGetAll);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            while (rs.next()) {
                PLU plu = new PLU();
                plu.fillDataFromDBResaultSet(rs);
                vec.add(plu);
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public static final void loadSaleFromBase() throws Exception {
        DBManager db = DBManager.getInstance();
        ResultSet rs = db.getQueryResultSet(sqlTableExists);
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(vec.size());
        pd.setVisible(true);
        try {
            int i = 0;
            while (i < vec.size()) {
                long kolicina = 0L;
                long prodato = 0L;
                PLU plu = (PLU)vec.get(i);
                rs = db.getQueryResultSet("SELECT * FROM journal_article where `code` = " + plu.getCode() + ';');
                while (rs.next()) {
                    kolicina += rs.getLong("amount");
                    prodato += SysUtil.round(rs.getLong("price") * rs.getLong("amount"), 3);
                }
                plu.setKolicina(kolicina);
                plu.setProdato(prodato);
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void changeLager() throws Exception {
        int comm = 58;
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(comm);
        instance.addShort(this.getCode());
        instance.addInt(this.getLager());
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (comm != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void addLager(int kk) throws Exception {
        int comm = 59;
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(comm);
        instance.addShort(this.getCode());
        instance.addInt(kk);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (comm != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void readFromCR_Code() throws Exception {
        BufferByte arr = new BufferByte(60, 4);
        int minSize = 18;
        int descSize = 34;
        int descStart = 12;
        if (GlavniFrame.PRINTER) {
            minSize = 10;
            descStart = 4;
        }
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(19);
        instance.addInt(this.code);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command command = port.receiveFrame();
        int e = command.getArray()[0] & 0xFF;
        int cmd = command.getCmd();
        if (cmd != 19 && cmd != 128) {
            if (e == 18) {
                return;
            }
            if (e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        arr.reset();
        int size = command.getByte(0);
        arr.add(command.getArray(), 1, size);
        if (arr.getInt(0) == 0) {
            return;
        }
        int i = arr.getInt(0) & 0xFFFFF;
        this.setCode(i & 0xFFFFF);
        if (GlavniFrame.PRINTER) {
            this.setCena(arr.getInt(size - 4));
            byte poreskaStopa = 0;
            int jedinicaMere = 0;
            int jj = arr.getValueAt(size - 5);
            jedinicaMere |= (jj & 0xF0) >> 4;
            poreskaStopa = (byte)(poreskaStopa | jj & 0xF);
            byte[] bb = new byte[size - 1 - 4 - 5];
            System.arraycopy(arr.getBuffer(), 4, bb, 0, bb.length);
            this.setDesc(SysUtil.formatForReceive(bb));
            this.setPoreskaStopa(poreskaStopa);
            this.setJedinicaMere(jedinicaMere);
            GlavniFrame.getInstance().articlePanel.ta.revalidate();
            GlavniFrame.getInstance().articlePanel.ta.repaint();
            return;
        }
        if (GlavniFrame.PRINTER) {
            this.setBarCode(-1L);
        } else {
            this.setBarCode(arr.getLong(4));
        }
        int offset = descSize + minSize - size;
        if (GlavniFrame.PRINTER) {
            --offset;
        }
        byte[] bb = new byte[descSize];
        System.arraycopy(arr.getBuffer(), descStart, bb, 0, bb.length - offset);
        this.setDesc(SysUtil.formatForReceive(bb));
        this.setLager(arr.getInt(42 - offset));
        if (GlavniFrame.PRINTER) {
            offset += 7;
        }
        byte poreskaStopa = 0;
        int jedinicaMere = 0;
        byte odeljenje2 = 0;
        poreskaStopa = (byte)(poreskaStopa | (byte)arr.getValueAt(47 - offset) & 0xF);
        odeljenje2 = (byte)(odeljenje2 | (byte)arr.getValueAt(46 - offset));
        this.setPoreskaStopa(poreskaStopa);
        this.setJedinicaMere(jedinicaMere |= ((byte)arr.getValueAt(47 - offset) & 0xF0) >> 4);
        this.setOdeljenje(odeljenje2);
        this.setCena(arr.getInt(48 - offset));
        GlavniFrame.getInstance().articlePanel.ta.revalidate();
        GlavniFrame.getInstance().articlePanel.ta.repaint();
    }

    public void sell() throws Exception {
        this.sell(1000);
    }

    public void sell(int amount) throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.instance;
        instance.reset();
        if (this.code != -1) {
            instance.setCmd(48);
            instance.addInt(this.code);
            instance.addInt(amount);
        } else {
            instance.setCmd(49);
            instance.addLong(this.barCode);
            instance.addInt(amount);
        }
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 48 && command != 49 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }
}

