/*
 * Decompiled with CFR 0.152.
 */
package objects;

import gui.GlavniFrame;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XML.XmlExecuter;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;

public class MemoryReader
implements XmlObject {
    public static Vector fisVec = new Vector();
    public static Vector flashVec = new Vector();
    public static Vector ramVec = new Vector();
    private static File file = new File("memorija", "settings.xml");
    private static MemoryReader instance;

    static {
        file.getParentFile().mkdirs();
    }

    private MemoryReader() {
    }

    public static MemoryReader getInstance() {
        if (instance == null) {
            instance = new MemoryReader();
        }
        return instance;
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        MemElement me;
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<MEMORY>");
        writer.indent();
        writer.writeLn("<FISCAL>");
        int i = 0;
        while (i < fisVec.size()) {
            me = (MemElement)fisVec.get(i);
            if (me != null) {
                if (writer == null) {
                    return;
                }
                me.writeToXMLNode(writer);
            }
            ++i;
        }
        writer.writeLn("</FISCAL>");
        writer.unintent();
        writer.indent();
        writer.writeLn("<FLASH>");
        i = 0;
        while (i < flashVec.size()) {
            me = (MemElement)flashVec.get(i);
            if (me != null) {
                if (writer == null) {
                    return;
                }
                me.writeToXMLNode(writer);
            }
            ++i;
        }
        writer.writeLn("</FLASH>");
        writer.unintent();
        writer.indent();
        writer.writeLn("<RAM>");
        i = 0;
        while (i < ramVec.size()) {
            me = (MemElement)ramVec.get(i);
            if (me != null) {
                if (writer == null) {
                    return;
                }
                me.writeToXMLNode(writer);
            }
            ++i;
        }
        writer.writeLn("</RAM>");
        writer.unintent();
        writer.writeLn("</MEMORY>");
    }

    public void readFromXML(File file) throws Exception {
        String pom3;
        int pom2;
        int pom1;
        Element elem;
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element docEl = doc.getDocumentElement();
        NodeList fisNode = docEl.getElementsByTagName("FISCAL");
        NodeList dataNode = ((Element)fisNode.item(0)).getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        fisVec.removeAllElements();
        int i = 0;
        while (i < dataList) {
            elem = (Element)dataNode.item(i);
            pom1 = Integer.parseInt(elem.getAttribute("SIZE"));
            pom2 = Integer.parseInt(elem.getAttribute("FROM"));
            pom3 = elem.getAttribute("NAME");
            MemElement me = new MemElement(pom3, pom2, pom1);
            fisVec.add(me);
            ++i;
        }
        NodeList flashNode = docEl.getElementsByTagName("FLASH");
        dataNode = ((Element)flashNode.item(0)).getElementsByTagName("DATA");
        dataList = dataNode.getLength();
        flashVec.removeAllElements();
        int i2 = 0;
        while (i2 < dataList) {
            elem = (Element)dataNode.item(i2);
            pom1 = Integer.parseInt(elem.getAttribute("SIZE"));
            pom2 = Integer.parseInt(elem.getAttribute("FROM"));
            pom3 = elem.getAttribute("NAME");
            MemElement me = new MemElement(pom3, pom2, pom1);
            flashVec.add(me);
            ++i2;
        }
        NodeList ramNode = docEl.getElementsByTagName("RAM");
        dataNode = ((Element)ramNode.item(0)).getElementsByTagName("DATA");
        dataList = dataNode.getLength();
        ramVec.removeAllElements();
        int i3 = 0;
        while (i3 < dataList) {
            elem = (Element)dataNode.item(i3);
            pom1 = Integer.parseInt(elem.getAttribute("SIZE"));
            pom2 = Integer.parseInt(elem.getAttribute("FROM"));
            pom3 = elem.getAttribute("NAME");
            MemElement me = new MemElement(pom3, pom2, pom1);
            ramVec.add(me);
            ++i3;
        }
    }

    public void saveAll() {
        if (file == null) {
            return;
        }
        try {
            XmlExecuter.getInstance().write(this, file.getAbsolutePath());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), " ERROR", 0);
        }
    }

    public void readAll() {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            XmlExecuter.getInstance().read(this, file.getAbsolutePath());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), " ERROR", 0);
        }
    }

    public class MemElement {
        public String name;
        public int from;
        public int size;

        public MemElement(String name, int from, int size) {
            this.name = name;
            this.from = from;
            this.size = size;
        }

        public void writeToXMLNode(XmlFileWriter writer) throws IOException {
            if (writer == null) {
                return;
            }
            writer.indent();
            writer.write("<DATA NAME='" + XmlFileWriter.compileString(this.name.trim()) + "'");
            writer.write(" FROM='" + this.from + "'");
            writer.write(" SIZE='" + this.size + "'");
            writer.writeLn("/>");
            writer.unintent();
        }

        public String toString() {
            return this.name;
        }
    }
}

