/*
 * Decompiled with CFR 0.152.
 */
package objects;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import tables.zagRekPomTable.RekPomTableModel;
import util.SysUtil;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public class Header_Advertisement {
    public static final int NUM_ROWS = 11;
    public static final int USED_ROW = 127;
    public static final int DOUBLE_ROW = 128;
    public static int SIZE_ROW = 22;
    public static int NUM_ADW = 15;
    private static Header_Advertisement instance;
    private CommandsErrors exc = CommandsErrors.instanceMain;
    public Row[][] arrayRows = new Row[NUM_ADW][11];

    static {
        if (GlavniFrame.PRINTER) {
            SIZE_ROW = 32;
            NUM_ADW = 2;
        }
        if (GlavniFrame.BEST_LC) {
            SIZE_ROW = 18;
        }
    }

    public static final Header_Advertisement getInstance() {
        if (instance == null) {
            instance = new Header_Advertisement();
        }
        return instance;
    }

    private Header_Advertisement() {
        int j = 0;
        while (j < NUM_ADW) {
            int i = 0;
            while (i < 11) {
                this.arrayRows[j][i] = new Row(SIZE_ROW);
                ++i;
            }
            ++j;
        }
    }

    public void programToCR() throws CommandsErrors, SerialPortException {
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(RekPomTableModel.arrBool.length);
        pd.setVisible(true);
        try {
            if (RekPomTableModel.arrBool[0]) {
                this.programRaw(0, 20);
                pd.increaseBar();
            }
            int j = 1;
            while (j < RekPomTableModel.arrBool.length) {
                if (RekPomTableModel.arrBool[j]) {
                    this.programRaw(j, 22);
                }
                pd.increaseBar();
                ++j;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void programRaw(int adw, int command) throws CommandsErrors, SerialPortException {
        Row pom;
        Command bigInstance = Command.bigInstance;
        bigInstance.reset();
        bigInstance.setCmd(command);
        int numEmptyRows = 0;
        int i = 11;
        while (--i >= 0) {
            pom = this.arrayRows[adw][i];
            if (pom.text.trim().length() <= 0) continue;
            numEmptyRows = i;
            break;
        }
        i = 0;
        while (i < 11) {
            pom = this.arrayRows[adw][i];
            if (i > numEmptyRows) {
                bigInstance.addByte(255);
            } else if (pom.doubleRow) {
                bigInstance.addByte(63);
            } else {
                bigInstance.addByte(127);
            }
            String sss = pom.text;
            while (sss.length() < 42) {
                sss = String.valueOf(sss) + " ";
            }
            SysUtil.formatForSend(sss, bigInstance);
            ++i;
        }
        if (adw > 0) {
            bigInstance.addByte(adw - 1);
        }
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(bigInstance);
        Command ret = port.receiveFrame();
        int t = ret.getArray()[0] & 0xFF;
        int cm = ret.getCmd();
        if (128 != cm && command != cm && t != 0) {
            this.exc.setError(t);
            throw this.exc;
        }
    }

    public String getStringValue(int adw, int row) {
        String pom = new String(this.arrayRows[adw][row].text);
        if (pom.trim().length() <= 0) {
            return "";
        }
        return pom;
    }

    public boolean getBooleanValue(int adw, int row) {
        return this.arrayRows[adw][row].doubleRow;
    }

    public void setStringValue(int adw, int row, String value) {
        this.arrayRows[adw][row].text = value;
    }

    public void setBooleanValue(int adw, int row, boolean value) {
        this.arrayRows[adw][row].doubleRow = value;
    }

    public void readHeaderFromCR() throws Exception {
        Command bigInstance = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            byte[] arr;
            Row pom;
            int i;
            int pos;
            int cm;
            int t;
            Command ret;
            if (RekPomTableModel.arrBool[0]) {
                bigInstance.reset();
                bigInstance.setCmd(20);
                port.sendFrame(bigInstance);
                ret = port.receiveFrame();
                t = ret.getArray()[0] & 0xFF;
                cm = ret.getCmd();
                if (128 != cm && 20 != cm && t != 0) {
                    this.exc.setError(t);
                    throw this.exc;
                }
                pos = 0;
                i = 0;
                while (i < 11) {
                    pom = this.arrayRows[0][i];
                    if (ret.getByte(pos) == 255) {
                        pom.text = "";
                    } else {
                        if (ret.getByte(pos) == 63) {
                            pom.doubleRow = true;
                        }
                        if (ret.getByte(pos) == 127) {
                            pom.doubleRow = false;
                        }
                        arr = new byte[42];
                        System.arraycopy(ret.getArray(), ++pos, arr, 0, arr.length);
                        pos += arr.length;
                        pom.text = SysUtil.formatForReceive(arr).substring(0, SIZE_ROW);
                    }
                    ++i;
                }
            }
            if (RekPomTableModel.arrBool[1]) {
                bigInstance.reset();
                bigInstance.setCmd(22);
                port.sendFrame(bigInstance);
                ret = port.receiveFrame();
                t = ret.getArray()[0] & 0xFF;
                cm = ret.getCmd();
                if (128 != cm && 22 != cm && t != 0) {
                    this.exc.setError(t);
                    throw this.exc;
                }
                pos = 0;
                i = 0;
                while (i < 11) {
                    pom = this.arrayRows[NUM_ADW - 1][i];
                    if (ret.getByte(pos) == 255) {
                        pom.text = "";
                    } else {
                        if (ret.getByte(pos) == 63) {
                            pom.doubleRow = true;
                        }
                        if (ret.getByte(pos) == 127) {
                            pom.doubleRow = false;
                        }
                        arr = new byte[42];
                        System.arraycopy(ret.getArray(), ++pos, arr, 0, arr.length);
                        pos += arr.length;
                        pom.text = SysUtil.formatForReceive(arr).substring(0, SIZE_ROW);
                    }
                    ++i;
                }
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public class Row {
        public String text = new String();
        public boolean doubleRow;

        public Row(int SIZE) {
            int i = 0;
            while (i < SIZE) {
                this.text = String.valueOf(this.text) + ' ';
                ++i;
            }
            this.doubleRow = false;
        }
    }
}

