/*
 * Decompiled with CFR 0.152.
 */
package objects;

import gui.GlavniFrame;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XML.XmlExecuter;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;

public class GPRSPatterns
implements XmlObject {
    public static Vector vec = new Vector();
    private static File file = new File("memorija", "gprs.xml");
    private static GPRSPatterns instance;

    static {
        file.getParentFile().mkdirs();
    }

    private GPRSPatterns() {
    }

    public static GPRSPatterns getInstance() {
        if (instance == null) {
            instance = new GPRSPatterns();
        }
        return instance;
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<GPRS>");
        writer.indent();
        writer.writeLn("<PATTERNS>");
        int i = 0;
        while (i < vec.size()) {
            PatternGPRS me = (PatternGPRS)vec.get(i);
            if (me != null) {
                if (writer == null) {
                    return;
                }
                me.writeToXMLNode(writer);
            }
            ++i;
        }
        writer.writeLn("</PATTERNS>");
        writer.unintent();
        writer.writeLn("</GPRS>");
    }

    public void readFromXML(File file) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element docEl = doc.getDocumentElement();
        NodeList fisNode = docEl.getElementsByTagName("PATTERNS");
        NodeList dataNode = ((Element)fisNode.item(0)).getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        vec.removeAllElements();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            PatternGPRS me = new PatternGPRS();
            me.name = elem.getAttribute("NAME");
            me.uploadPath = elem.getAttribute("GPRS_UPLOAD");
            me.downPath = elem.getAttribute("GPRS_DOWNLOAD");
            me.APN = elem.getAttribute("APN");
            me.APNUser = elem.getAttribute("APN_USER");
            me.APNPass = elem.getAttribute("APN_PASS");
            me.ftpAdd = elem.getAttribute("FTP");
            me.ftpUser = elem.getAttribute("FTP_USER");
            me.ftpPass = elem.getAttribute("FTP_PASS");
            vec.add(me);
            ++i;
        }
    }

    public void saveAll() {
        if (file == null) {
            return;
        }
        try {
            XmlExecuter.getInstance().write(this, file.getAbsolutePath());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), " ERROR", 0);
        }
    }

    public void readAll() {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            XmlExecuter.getInstance().read(this, file.getAbsolutePath());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), " ERROR", 0);
        }
    }

    public class PatternGPRS {
        public String downPath;
        public String uploadPath;
        public String APN;
        public String APNUser;
        public String APNPass;
        public String ftpAdd;
        public String ftpUser;
        public String ftpPass;
        public String name;

        public void writeToXMLNode(XmlFileWriter writer) throws IOException {
            if (writer == null) {
                return;
            }
            writer.indent();
            writer.write("<DATA NAME = '" + XmlFileWriter.compileString(this.name) + "'");
            writer.write(" GPRS_UPLOAD = '" + XmlFileWriter.compileString(this.uploadPath) + "'");
            writer.write(" GPRS_DOWNLOAD = '" + XmlFileWriter.compileString(this.downPath) + "'");
            writer.write(" APN = '" + XmlFileWriter.compileString(this.APN) + "'");
            writer.write(" APN_USER = '" + XmlFileWriter.compileString(this.APNUser) + "'");
            writer.write(" APN_PASS = '" + XmlFileWriter.compileString(this.APNPass) + "'");
            writer.write(" FTP = '" + XmlFileWriter.compileString(this.ftpAdd) + "'");
            writer.write(" FTP_USER = '" + XmlFileWriter.compileString(this.ftpUser) + "'");
            writer.write(" FTP_PASS = '" + XmlFileWriter.compileString(this.ftpPass) + "'");
            writer.writeLn(" />");
            writer.unintent();
        }

        public String toString() {
            return this.name;
        }
    }
}

