/*
 * Decompiled with CFR 0.152.
 */
package objects;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class DBManager {
    public static String username = null;
    public static String password = null;
    public static String databaseTableName = null;
    public static String databaseAddres = null;
    private Statement statement;
    private Connection connection;
    private static DBManager instance = null;

    static {
        instance = new DBManager();
    }

    public static DBManager getInstance() {
        return instance;
    }

    public void openMySQLConnection() throws Exception {
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (Exception e) {
            System.out.println("Unable to register the MySQL JDBC Driver.\nMake sure the JDBC driver is in the\nclasspath.\n");
            throw e;
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + databaseAddres + "/" + databaseTableName + "?user=" + username + "&password=" + password + "&serverName=" + "&useUnicode=true&characterEncoding=utf8");
            this.statement = this.connection.createStatement();
            System.out.println("CONNECTION SUCCESSFULL");
        }
        catch (Exception e) {
            System.out.println("Unable to make a connection to MySQL the database.\nThe reason: " + e.getMessage());
            throw e;
        }
    }

    public void openODBCConnection(String databaseName, String username, String password) throws Exception {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            System.out.println("Unable to register the ODBC JDBC Driver.\nMake sure the JDBC driver is in the\nclasspath.\n");
            throw e;
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:odbc:" + databaseName, username, password);
            this.statement = this.connection.createStatement();
            System.out.println("CONNECTION SUCCESSFULL: " + this.connection.getMetaData().getURL());
        }
        catch (Exception e) {
            System.out.println("Unable to make a connection to ODBC database.\nThe reason: " + e.getMessage());
            throw e;
        }
    }

    public boolean executeSQLQuery(String sql) throws Exception {
        if (this.statement == null) {
            throw new Exception("No connection!");
        }
        return this.statement.execute(sql);
    }

    public ResultSet getQueryResultSet(String sql) throws Exception {
        if (this.statement == null) {
            throw new Exception("No connection!");
        }
        if (sql == null) {
            return null;
        }
        this.statement.execute(sql);
        ResultSet rs = this.statement.getResultSet();
        return rs;
    }

    public void closeConnection() throws Exception {
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void openAllMySQLDatabaseTables() throws Exception {
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (Exception e) {
            System.out.println("Unable to register the MySQL JDBC Driver.\nMake sure the JDBC driver is in the\nclasspath.\n");
            throw e;
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + databaseAddres + "/?user=" + username + "&password=" + password + "&serverName=" + "&useUnicode=true&characterEncoding=utf8");
            this.statement = this.connection.createStatement();
            System.out.println("CONNECTION SUCCESSFULL");
        }
        catch (Exception e) {
            System.out.println("Unable to make a connection to MySQL the database.\nThe reason: " + e.getMessage());
            throw e;
        }
    }
}

