/*
 * Decompiled with CFR 0.152.
 */
package journal;

import gui.rightPanels.JournalPanel;
import journal.JournalObject;
import objects.DBManager;
import objects.lang.LanguageStrings;
import org.w3c.dom.Element;
import util.SysUtil;
import util.XML.XmlFileWriter;

public class JournalObjPaid
extends JournalObject {
    private int type;
    private int numOfRec;
    private long amount;
    private String time;
    private static final String sqlQuery = "INSERT INTO `journal_paid` (`number_of_receipt`, `id`, `amount`, `time`) VALUES ";
    public static final String sqlCreateTable = "CREATE TABLE IF NOT EXISTS `journal_paid` (  `number_of_receipt` bigint(20) unsigned NOT NULL default '0',  `id` tinyint(1) unsigned NOT NULL default '0',  `amount` bigint(20) unsigned NOT NULL default '0',  `time` datetime NOT NULL default '0000-00-00 00:00:00',  PRIMARY KEY  (`time`),  UNIQUE KEY `time` (`time`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

    public JournalObjPaid() {
        this.setId(2);
    }

    public void writeToXMLWriter(XmlFileWriter writer) throws Exception {
        writer.write("<JOURNAL.ELEMENT ID= '2' ");
        writer.write(" TYPE='" + String.valueOf(this.type) + "'");
        writer.write(" AMN='" + String.valueOf(this.amount) + "'");
        writer.write(" NOR='" + String.valueOf(this.numOfRec) + "'");
        writer.write(" TIME='" + this.time + "'");
        writer.writeLn("/>");
    }

    public void readXMLElement(Element elem) throws Exception {
        this.type = Integer.parseInt(elem.getAttribute("TYPE"));
        this.amount = Long.parseLong(elem.getAttribute("AMN"));
        this.numOfRec = Integer.parseInt(elem.getAttribute("NOR"));
        this.time = elem.getAttribute("TIME");
        this.appendToTextArea();
    }

    public final void appendToTextArea() {
        String pomstr = "" + (JournalPanel.text.getLineCount() - 1);
        while (pomstr.length() < 5) {
            pomstr = String.valueOf('0') + pomstr;
        }
        pomstr = "R.N. " + pomstr + ' ' + ' ';
        JournalPanel.text.append(pomstr);
        switch (this.type) {
            case 0: {
                JournalPanel.text.append(LanguageStrings.getInstance().getStringByName("JOURNAL_PAID_CASH"));
                break;
            }
            case 1: {
                JournalPanel.text.append(LanguageStrings.getInstance().getStringByName("JOURNAL_PAID_CARD"));
                break;
            }
            case 2: {
                JournalPanel.text.append(LanguageStrings.getInstance().getStringByName("JOURNAL_PAID_CHECK"));
                break;
            }
            case 3: {
                JournalPanel.text.append(LanguageStrings.getInstance().getStringByName("JOURNAL_PAID_VIRMAN"));
                break;
            }
            case 4: {
                JournalPanel.text.append(LanguageStrings.getInstance().getStringByName("JOURNAL_PAID_CREDIT"));
            }
        }
        JournalPanel.text.append(String.valueOf(SysUtil.putVisibleNumberFormat(this.amount, 2)) + " din " + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_ACOUNT_NUMBER") + this.numOfRec + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_TIME") + this.time + "\r\n");
    }

    public final int getNumOfRec() {
        return this.numOfRec;
    }

    public final void setNumOfRec(int numOfRec) {
        this.numOfRec = numOfRec;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int type) {
        this.type = type;
    }

    public final long getAmount() {
        return this.amount;
    }

    public final void setAmount(long amount) {
        this.amount = amount;
    }

    public final String getTime() {
        return this.time;
    }

    public final void setTime(String time) {
        this.time = time;
    }

    public boolean writeToBase() throws Exception {
        DBManager db = DBManager.getInstance();
        String sql = "INSERT INTO `journal_paid` (`number_of_receipt`, `id`, `amount`, `time`) VALUES ('" + this.numOfRec + "', " + this.type + ", '" + this.amount + "', '" + this.time + "');";
        return db.executeSQLQuery(sql);
    }
}

