/*
 * Decompiled with CFR 0.152.
 */
package journal;

import gui.rightPanels.JournalPanel;
import journal.JournalObject;
import objects.DBManager;
import objects.lang.LanguageStrings;
import org.w3c.dom.Element;
import util.SysUtil;
import util.XML.XmlFileWriter;

public class JournalObjArticleBarcode
extends JournalObject {
    private int price;
    private int numOfRec;
    private int amount;
    private long barcode;
    private int ordinalNum;
    private int department;
    private int vat;
    private static final String sqlQuery = "INSERT INTO `journal_article` (`barcode`, `price`, `amount`, `ordinalNum`, `number_of_receipt`, `department`, `vat`) VALUES ";
    public static final String sqlCreateTable = "CREATE TABLE IF NOT EXISTS `journal_article` ( `barcode` int(20) NOT NULL default '0',  `price` int(11) unsigned NOT NULL default '0',  `amount` int(11) NOT NULL default '0',  `ordinalNum` int(5) NOT NULL default '0',  `department` int(5) NOT NULL default '0',  `vat` int(5) NOT NULL default '0',  `number_of_receipt` bigint(20) unsigned NOT NULL default '0') ENGINE=MyISAM DEFAULT CHARSET=utf8;";

    public boolean writeToBase() throws Exception {
        DBManager db = DBManager.getInstance();
        String sql = "INSERT INTO `journal_article` (`barcode`, `price`, `amount`, `ordinalNum`, `number_of_receipt`, `department`, `vat`) VALUES (" + this.barcode + ", " + this.price + ", " + this.amount + ", '" + this.ordinalNum + "', '" + this.numOfRec + "', '" + this.department + "', '" + this.vat + "');";
        return db.executeSQLQuery(sql);
    }

    public JournalObjArticleBarcode() {
        this.setId(7);
        this.numOfRec = -1;
        this.amount = -1;
        this.price = -1;
        this.ordinalNum = -1;
        this.barcode = -1L;
    }

    public void writeToXMLWriter(XmlFileWriter writer) throws Exception {
        writer.write("<JOURNAL.ELEMENT ID= '1' ");
        writer.write(" BARCODE='" + String.valueOf(this.barcode) + "'");
        writer.write(" PRC='" + String.valueOf(this.price) + "'");
        writer.write(" AMN='" + String.valueOf(this.amount) + "'");
        writer.write(" NO='" + String.valueOf(this.ordinalNum) + "'");
        writer.write(" NOR='" + String.valueOf(this.numOfRec) + "'");
        writer.write(" DEP='" + String.valueOf(this.department) + "'");
        writer.write(" VAT='" + String.valueOf(this.vat) + "'");
        writer.writeLn("/>");
    }

    public void readXMLElement(Element elem) throws Exception {
        this.barcode = Long.parseLong(elem.getAttribute("BARCODE"));
        this.price = Integer.parseInt(elem.getAttribute("PRC"));
        this.amount = Integer.parseInt(elem.getAttribute("AMN"));
        this.ordinalNum = Integer.parseInt(elem.getAttribute("NO"));
        this.numOfRec = Integer.parseInt(elem.getAttribute("NOR"));
        this.department = Integer.parseInt(elem.getAttribute("DEP"));
        this.vat = Integer.parseInt(elem.getAttribute("VAT"));
        this.appendToTextArea();
    }

    public final void appendToTextArea() {
        String pomstr = "" + (JournalPanel.text.getLineCount() - 1);
        while (pomstr.length() < 5) {
            pomstr = String.valueOf('0') + pomstr;
        }
        pomstr = "R.N. " + pomstr + ' ' + ' ';
        JournalPanel.text.append(pomstr);
        JournalPanel.text.append(String.valueOf(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_3")) + ": " + this.barcode + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_PRICE") + SysUtil.putVisibleNumberFormat(this.price, 2) + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_AMOUNT") + (double)this.amount / 1000.0 + '\t' + "n.o. " + this.ordinalNum + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_ACOUNT_NUMBER") + this.numOfRec + '\t' + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_7") + ' ' + this.department + '\t' + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_5") + ' ' + this.vat + "\r\n");
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int amount) {
        this.amount = amount;
    }

    public final int getPrice() {
        return this.price;
    }

    public final void setPrice(int price) {
        this.price = price;
    }

    public final int getNumOfRec() {
        return this.numOfRec;
    }

    public final void setNumOfRec(int numOfRec) {
        this.numOfRec = numOfRec;
    }

    public int getOrdinalNum() {
        return this.ordinalNum;
    }

    public void setOrdinalNum(int ordinalNum) {
        this.ordinalNum = ordinalNum;
    }

    public final long getBarcode() {
        return this.barcode;
    }

    public final void setBarcode(long barcode) {
        this.barcode = barcode;
    }

    public final int getDepartment() {
        return this.department;
    }

    public final void setDepartment(int department) {
        this.department = department;
    }

    public final int getVat() {
        return this.vat;
    }

    public final void setVat(int vat) {
        this.vat = vat;
    }
}

