/*
 * Decompiled with CFR 0.152.
 */
package journal;

import gui.rightPanels.JournalPanel;
import journal.JournalObject;
import objects.DBManager;
import objects.lang.LanguageStrings;
import org.w3c.dom.Element;
import util.SysUtil;
import util.XML.XmlFileWriter;

public class JournalObjArticle
extends JournalObject {
    private int code;
    private int price;
    private int numOfRec;
    private String time;
    private int amount;
    private static final String sqlQuery = "INSERT INTO `journal_article` (`code`, `price`, `amount`, `time`, `number_of_receipt`) VALUES ";
    public static final String sqlCreateTable = "CREATE TABLE IF NOT EXISTS `journal_article` ( `code` int(5) NOT NULL default '0',  `price` int(11) unsigned NOT NULL default '0',  `amount` int(11) NOT NULL default '0',  `time` datetime NOT NULL default '0000-00-00 00:00:00',  `number_of_receipt` bigint(20) unsigned NOT NULL default '0') ENGINE=MyISAM DEFAULT CHARSET=utf8;";

    public JournalObjArticle() {
        this.setId(1);
        this.numOfRec = -1;
        this.amount = -1;
        this.price = -1;
        this.code = 0;
    }

    public void writeToXMLWriter(XmlFileWriter writer) throws Exception {
        writer.write("<JOURNAL.ELEMENT ID= '1' ");
        writer.write(" CODE='" + String.valueOf(this.code) + "'");
        writer.write(" TIME='" + this.time + "'");
        writer.write(" PRC='" + String.valueOf(this.price) + "'");
        writer.write(" AMN='" + String.valueOf(this.amount) + "'");
        writer.write(" NOR='" + String.valueOf(this.numOfRec) + "'");
        writer.writeLn("/>");
    }

    public void readXMLElement(Element elem) throws Exception {
        this.code = Integer.parseInt(elem.getAttribute("CODE"));
        this.time = elem.getAttribute("TIME");
        this.price = Integer.parseInt(elem.getAttribute("PRC"));
        this.amount = Integer.parseInt(elem.getAttribute("AMN"));
        this.numOfRec = Integer.parseInt(elem.getAttribute("NOR"));
        this.appendToTextArea();
    }

    public final void appendToTextArea() {
        String pomstr = "" + (JournalPanel.text.getLineCount() - 1);
        while (pomstr.length() < 5) {
            pomstr = String.valueOf('0') + pomstr;
        }
        pomstr = "R.N. " + pomstr + ' ' + ' ';
        JournalPanel.text.append(pomstr);
        JournalPanel.text.append(String.valueOf(LanguageStrings.getInstance().getStringByName("JOURNAL_CODE")) + this.code + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_PRICE") + SysUtil.putVisibleNumberFormat(this.price, 2) + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_AMOUNT") + (double)this.amount / 1000.0 + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_TIME") + this.time + '\t' + LanguageStrings.getInstance().getStringByName("JOURNAL_ACOUNT_NUMBER") + this.numOfRec + "\r\n");
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int amount) {
        this.amount = amount;
    }

    public final int getCode() {
        return this.code;
    }

    public final void setCode(int code) {
        this.code = code;
    }

    public final int getPrice() {
        return this.price;
    }

    public final void setPrice(int price) {
        this.price = price;
    }

    public final int getNumOfRec() {
        return this.numOfRec;
    }

    public final void setNumOfRec(int numOfRec) {
        this.numOfRec = numOfRec;
    }

    public boolean writeToBase() throws Exception {
        DBManager db = DBManager.getInstance();
        String sql = "INSERT INTO `journal_article` (`code`, `price`, `amount`, `time`, `number_of_receipt`) VALUES (" + this.code + ", " + this.price + ", " + this.amount + ", '" + this.time + "', '" + this.numOfRec + "');";
        return db.executeSQLQuery(sql);
    }

    public final String getTime() {
        return this.time;
    }

    public final void setTime(String time) {
        this.time = time;
    }
}

