/*
 * Decompiled with CFR 0.152.
 */
package journal;

import cashRegister.Command;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import gui.rightPanels.JournalPanel;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import journal.JournalObjArticle;
import journal.JournalObjArticleBarcode;
import journal.JournalObjBus;
import journal.JournalObjCashear;
import journal.JournalObjPaid;
import journal.JournalObjRabatMarza;
import journal.JournalObject;
import objects.DBManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public class Journal
implements XmlObject {
    public static final long START_TIME = 946684800000L;
    private static final SimpleDateFormat dataf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int rnCount = 0;
    private static final int MAX_NUMBER_OF_JOURFNAL_RECORDS = 19659;
    public static final byte PAYING = 2;
    public static final byte ARTICLE_SOLD = 1;
    public static final byte CASHIER = 3;
    public static final Vector vec = new Vector();
    private static Journal instance;

    public static Journal getInstance() {
        if (instance == null) {
            instance = new Journal();
        }
        return instance;
    }

    private Journal() {
        dataf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void readJournal() throws Exception {
        JournalPanel.text.setText("");
        vec.removeAllElements();
        this.rnCount = 0;
        int address = -1;
        int startAddress = -1;
        PortSerial port = PortSerial.getInstance();
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            do {
                Command.bigInstance.reset();
                Command.bigInstance.setCmd(75);
                Command.bigInstance.addInt(address);
                port.sendFrame(Command.bigInstance);
                Command cmd = port.receiveFrame();
                if (cmd.getCmd() != 75) {
                    throw new SerialPortException("ERROR " + cmd.getArray()[0]);
                }
                address = this.regulateJournalRecord(cmd);
                if (address > 0) continue;
                break;
            } while (address != startAddress);
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private int regulateJournalRecord(Command cmd) throws Exception {
        int newAddres = 0;
        int pos = 0;
        int type = 0;
        long bar = 0L;
        int t = 0;
        newAddres = cmd.getInt(pos);
        pos += 4;
        block12: while (this.rnCount < 19658) {
            type = cmd.getArray()[pos++] & 0xFF;
            switch (type) {
                default: {
                    try {
                        int i = 0;
                        while (i < 20) {
                            if (cmd.getArray()[pos + i] != -1) {
                                return newAddres;
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        return newAddres;
                    }
                    return -1;
                }
                case 7: {
                    JournalObjArticleBarcode obj7 = new JournalObjArticleBarcode();
                    t = cmd.getInt(pos);
                    obj7.setNumOfRec(t &= 0xFFFFFF);
                    bar = cmd.getLong(pos += 3) & 0xFFFFFFFFFFFFL;
                    pos += 6;
                    obj7.setBarcode(bar);
                    t = cmd.getByte(pos++) & 0xFF;
                    obj7.setOrdinalNum(t);
                    t = cmd.getByte(pos++) & 0xFF;
                    int poreskaStopa = 0;
                    int odeljenje2 = 0;
                    obj7.setDepartment(odeljenje2 |= (t & 0xF0) >> 4);
                    obj7.setVat(poreskaStopa |= t & 0xF);
                    t = cmd.getInt(pos);
                    obj7.setPrice(t);
                    t = cmd.getInt(pos += 4);
                    pos += 4;
                    obj7.setAmount(t);
                    vec.add(obj7);
                    obj7.appendToTextArea();
                    continue block12;
                }
                case 4: {
                    JournalObjRabatMarza obj4 = new JournalObjRabatMarza();
                    bar = (long)cmd.getInt(++pos) & 0xFFFFFFFFL;
                    bar *= 1000L;
                    obj4.setTime(dataf.format(new Date(bar += 946684800000L)));
                    t = cmd.getShort(pos += 4);
                    obj4.setRabat(t);
                    t = cmd.getShort(pos += 2);
                    pos += 2;
                    obj4.setMarza(t);
                    pos += 10;
                    vec.add(obj4);
                    obj4.appendToTextArea();
                    continue block12;
                }
                case 3: {
                    JournalObjCashear obj = new JournalObjCashear();
                    pos += 5;
                    t = cmd.getArray()[pos++] & 0xFF;
                    obj.setCashearId(t);
                    t = cmd.getArray()[pos++] & 0xFF;
                    obj.setLevel(t);
                    bar = cmd.getLong(pos);
                    obj.setAmount(bar);
                    bar = (long)cmd.getInt(pos += 8) & 0xFFFFFFFFL;
                    pos += 4;
                    bar *= 1000L;
                    obj.setTime(dataf.format(new Date(bar += 946684800000L)));
                    vec.add(obj);
                    obj.appendToTextArea();
                    continue block12;
                }
                case 1: {
                    JournalObjArticle obj1 = new JournalObjArticle();
                    t = cmd.getShort(++pos);
                    obj1.setCode(t);
                    bar = (long)cmd.getInt(pos += 2) & 0xFFFFFFFFL;
                    bar *= 1000L;
                    obj1.setTime(dataf.format(new Date(bar += 946684800000L)));
                    t = cmd.getInt(pos += 4);
                    obj1.setNumOfRec(t);
                    t = cmd.getInt(pos += 4);
                    obj1.setPrice(t);
                    t = cmd.getInt(pos += 4);
                    pos += 4;
                    obj1.setAmount(t);
                    vec.add(obj1);
                    obj1.appendToTextArea();
                    continue block12;
                }
                case 2: {
                    JournalObjPaid obj2 = new JournalObjPaid();
                    pos += 2;
                    t = cmd.getArray()[pos++] & 0xFF;
                    obj2.setType(t);
                    bar = cmd.getLong(pos);
                    obj2.setAmount(bar);
                    t = cmd.getInt(pos += 8);
                    obj2.setNumOfRec(t);
                    bar = (long)cmd.getInt(pos += 4) & 0xFFFFFFFFL;
                    pos += 4;
                    bar *= 1000L;
                    obj2.setTime(dataf.format(new Date(bar += 946684800000L)));
                    vec.add(obj2);
                    obj2.appendToTextArea();
                    continue block12;
                }
                case 5: 
            }
            JournalObjBus obj3 = new JournalObjBus();
            --pos;
            try {
                if ((long)cmd.getInt(pos) == 0xFFFFFFFFL) {
                    return -1;
                }
            }
            catch (Exception e) {
                return newAddres;
            }
            bar = (long)cmd.getInt(pos) & 0xFFFFFFFFL;
            pos += 4;
            bar *= 1000L;
            obj3.setTime(dataf.format(new Date(bar += 946684800000L)));
            int value = 0;
            int i = 0;
            while (i < 3) {
                value |= cmd.getByte(pos++) << i * 8;
                ++i;
            }
            obj3.setTicketNumber(value);
            if (value != 0) {
                value = 0;
                i = 0;
                while (i < 3) {
                    value |= cmd.getByte(pos++) << i * 8;
                    ++i;
                }
                obj3.setPrice(value);
                byte b = cmd.getArray()[pos++];
                obj3.setTarif(b & 0xF);
                obj3.setVat(b >>> 4 & 0xF);
                bar = 0L;
                bar = cmd.getLong(pos);
                pos += 8;
                obj3.setLineNumber((int)(bar & 0xFFFFL));
                obj3.setStart((int)((bar >>>= 16) & 0xFFL));
                obj3.setEnd((int)((bar >>>= 8) & 0xFFL));
                obj3.setReturn(((bar >>>= 8) & 0x80L) > 0L);
                obj3.setLineVer((int)(bar & 0x7FL));
                obj3.setStationVat((int)((bar >>>= 8) & 0xFFL));
                obj3.setStationCharge((int)((bar >>>= 8) & 0xFFFFL));
            } else {
                i = 0;
                while (i < 3) {
                    value |= cmd.getByte(pos++) << i * 8;
                    ++i;
                }
                obj3.setPrice(value);
                obj3.setLineVer(cmd.getByte(pos++));
                value = 0;
                i = 0;
                while (i < 2) {
                    value |= cmd.getByte(pos++) << i * 8;
                    ++i;
                }
                obj3.setLineNumber(value);
                value = 0;
                i = 0;
                while (i < 3) {
                    value |= cmd.getByte(pos++) << i * 8;
                    ++i;
                }
                obj3.setIdCard(value);
                obj3.setEnd(cmd.getByte(pos++));
                obj3.setStart(cmd.getByte(pos++));
                obj3.setCardType(cmd.getByte(pos++));
            }
            ++pos;
            vec.add(obj3);
            obj3.appendToTextArea();
        }
        return -1;
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        int size = vec.size();
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<JOURNAL>");
        writer.indent();
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(size);
        pd.setVisible(true);
        try {
            int i = 0;
            while (i < size) {
                JournalObject obj = (JournalObject)vec.get(i);
                obj.writeToXMLWriter(writer);
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
        writer.unintent();
        writer.writeLn("</JOURNAL>");
    }

    public static void writeToBase() throws Exception {
        int size = vec.size();
        DBManager.getInstance().executeSQLQuery("CREATE TABLE IF NOT EXISTS `journal_article` ( `code` int(5) NOT NULL default '0',  `price` int(11) unsigned NOT NULL default '0',  `amount` int(11) NOT NULL default '0',  `time` datetime NOT NULL default '0000-00-00 00:00:00',  `number_of_receipt` bigint(20) unsigned NOT NULL default '0') ENGINE=MyISAM DEFAULT CHARSET=utf8;");
        DBManager.getInstance().executeSQLQuery("CREATE TABLE IF NOT EXISTS `journal_casheer` (  `id` tinyint(4) unsigned NOT NULL default '0',  `level` tinyint(1) unsigned NOT NULL default '0',  `amount` bigint(20) unsigned NOT NULL default '0',  `time` datetime NOT NULL default '0000-00-00 00:00:00',  PRIMARY KEY  (`time`),  UNIQUE KEY `time` (`time`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
        DBManager.getInstance().executeSQLQuery("CREATE TABLE IF NOT EXISTS `journal_paid` (  `number_of_receipt` bigint(20) unsigned NOT NULL default '0',  `id` tinyint(1) unsigned NOT NULL default '0',  `amount` bigint(20) unsigned NOT NULL default '0',  `time` datetime NOT NULL default '0000-00-00 00:00:00',  PRIMARY KEY  (`time`),  UNIQUE KEY `time` (`time`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(size);
        pd.setVisible(true);
        int curentRecNum = 0;
        try {
            int i = 0;
            while (i < size) {
                JournalObject obj = (JournalObject)vec.get(i);
                if (obj.getId() == 2) {
                    curentRecNum = ((JournalObjPaid)obj).getNumOfRec();
                }
                if (obj.getId() != 1 || ((JournalObjArticle)obj).getNumOfRec() == curentRecNum) {
                    block9: {
                        try {
                            obj.writeToBase();
                        }
                        catch (Exception e) {
                            if (e.getMessage().indexOf("Duplicate entry") < 0) {
                                throw e;
                            }
                            if (obj.getId() != 2) break block9;
                            curentRecNum = 0;
                        }
                    }
                    pd.increaseBar();
                }
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void readFromXML(File file) throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            JournalPanel.text.setText("");
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element docEl = doc.getDocumentElement();
            NodeList dataNode = docEl.getElementsByTagName("JOURNAL.ELEMENT");
            int dataList = dataNode.getLength();
            vec.removeAllElements();
            int i = 0;
            while (i < dataList) {
                Element elem = (Element)dataNode.item(i);
                if (elem == null) {
                    return;
                }
                int id = Integer.parseInt(elem.getAttribute("ID"));
                switch (id) {
                    case 1: {
                        JournalObjArticle obj = new JournalObjArticle();
                        obj.readXMLElement(elem);
                        vec.add(obj);
                        break;
                    }
                    case 2: {
                        JournalObjPaid obj1 = new JournalObjPaid();
                        obj1.readXMLElement(elem);
                        vec.add(obj1);
                        break;
                    }
                    case 3: {
                        JournalObjCashear obj2 = new JournalObjCashear();
                        obj2.readXMLElement(elem);
                        vec.add(obj2);
                        break;
                    }
                    case 5: {
                        JournalObjBus obj4 = new JournalObjBus();
                        obj4.readXMLElement(elem);
                        vec.add(obj4);
                        break;
                    }
                }
                ++i;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }
}

