/*
 * Decompiled with CFR 0.152.
 */
package hcp.bmpParser;

public final class BmpImage {
    private int sizex;
    private int sizey;
    private byte[] matrix;

    public BmpImage(int x, int y) {
        this.sizex = x;
        this.sizey = y;
        this.matrix = new byte[this.sizex * this.sizey / 8];
    }

    public final int getSizex() {
        return this.sizex;
    }

    public final void setSizex(byte sizex) {
        this.sizex = sizex;
    }

    public final int getSizey() {
        return this.sizey;
    }

    public final void setSizey(byte sizey) {
        this.sizey = sizey;
    }

    public final byte[] getMatrix() {
        return this.matrix;
    }

    public final void setMatrix(byte[] matrix) {
        this.matrix = matrix;
    }

    public final byte[] getCenteredMatrix() {
        byte[] pom = new byte[256 * this.sizey / 8];
        int i = 0;
        while (i < pom.length) {
            pom[i] = 0;
            ++i;
        }
        byte[] buff = new byte[this.sizex];
        int i2 = 0;
        while (i2 < this.sizey) {
            System.arraycopy(this.matrix, i2 * this.sizex, buff, 0, this.sizex);
            System.arraycopy(buff, 0, pom, i2 * 256 + this.sizey / 2, this.sizex);
            ++i2;
        }
        return pom;
    }
}

