/*
 * Decompiled with CFR 0.152.
 */
package hcp.bmpParser;

import hcp.bmpParser.BmpImage;
import hcp.bmpParser.ImageError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BmpFileToObject {
    private File bmpFile;
    private InputStream in;
    private BmpImage img;
    private static ImageError ie = new ImageError();

    public BmpFileToObject(File file) {
        this.bmpFile = file;
    }

    public BmpImage getImage() throws IOException, ImageError {
        byte[] arr;
        if (this.bmpFile == null || !this.bmpFile.exists() || !this.bmpFile.isFile()) {
            return null;
        }
        this.in = new FileInputStream(this.bmpFile);
        int width = 0;
        int height = 0;
        int dataStart = 0;
        int pos = 0;
        int len = 0;
        try {
            int k;
            arr = new byte[54];
            while ((len = this.in.read(arr, pos, arr.length - pos)) > 0) {
                pos += len;
            }
            if (arr[0] != 66 || arr[1] != 77) {
                ie.setError(1);
                throw ie;
            }
            int i = 10;
            while (i < 14) {
                int k2 = arr[i] & 0xFF;
                dataStart |= (k2 <<= i - 10 << 3);
                ++i;
            }
            if (dataStart < 54) {
                ie.setError(2);
                throw ie;
            }
            int headerSize = 0;
            int i2 = 14;
            while (i2 < 18) {
                k = arr[i2] & 0xFF;
                headerSize |= (k <<= i2 - 14 << 3);
                ++i2;
            }
            if (headerSize != 40) {
                ie.setError(3);
                throw ie;
            }
            i2 = 18;
            while (i2 < 22) {
                k = arr[i2] & 0xFF;
                width |= (k <<= i2 - 18 << 3);
                ++i2;
            }
            if (width > 256) {
                ie.setError(4);
                throw ie;
            }
            if (width <= 0 || width % 8 != 0) {
                ie.setError(4);
                throw ie;
            }
            i2 = 22;
            while (i2 < 26) {
                k = arr[i2] & 0xFF;
                height |= (k <<= i2 - 22 << 3);
                ++i2;
            }
            if (height > 192) {
                ie.setError(4);
                throw ie;
            }
            if (height <= 0) {
                ie.setError(4);
                throw ie;
            }
            if (arr[26] != 1 || arr[27] != 0 || arr[28] != 1 || arr[29] != 0) {
                ie.setError(5);
                throw ie;
            }
            i2 = 30;
            while (i2 < 34) {
                if (arr[i2] != 0) {
                    ie.setError(5);
                    throw ie;
                }
                ++i2;
            }
            int imageData = 0;
            int i3 = 34;
            while (i3 < 38) {
                int k3 = arr[i3] & 0xFF;
                imageData |= (k3 <<= i3 - 34 << 3);
                ++i3;
            }
            int calculatedDataSize = width * height / 8;
            if (imageData != calculatedDataSize) {
                ie.setError(6);
                throw ie;
            }
        }
        finally {
            this.in.close();
        }
        this.img = new BmpImage(width, height);
        this.in.close();
        this.in = new FileInputStream(this.bmpFile);
        pos = 0;
        len = 0;
        while ((len = (int)this.in.skip(dataStart - pos)) > 0) {
            pos += len;
        }
        arr = null;
        arr = new byte[width * height / 8];
        pos = 0;
        len = 0;
        while ((len = this.in.read(arr, pos, arr.length - pos)) > 0) {
            pos += len;
        }
        this.img.setMatrix(arr);
        return this.img;
    }
}

