/*
 * Decompiled with CFR 0.152.
 */
package gui.search;

import java.text.DecimalFormat;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import objects.FiscallObjects;
import objects.PLU;
import objects.lang.LanguageStrings;

public class SearchPluTableModel
implements TableModel {
    private static final String empStr = "";
    private static final String decFor = "######0.00";
    private static final String decForAmount = "######0.000";
    private DecimalFormat df;
    private static final String EMPTY_FF = "FFFF";
    private static final String EMPTY_FFff = "FFFFFFFFFFFFFFFF";
    private static PLU plu;

    public final void addTableModelListener(TableModelListener arg0) {
    }

    public final Class getColumnClass(int col) {
        return String.class;
    }

    public final int getColumnCount() {
        return 10;
    }

    public final String getColumnName(int c) {
        return LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_" + c);
    }

    public final int getRowCount() {
        return PLU.vecView.size();
    }

    public final Object getValueAt(int row, int column) {
        if (PLU.vecView.size() <= row) {
            return empStr;
        }
        if (PLU.vecView.size() == 0) {
            return empStr;
        }
        plu = (PLU)PLU.vecView.get(row);
        switch (column) {
            case 0: {
                return String.valueOf(row + 1);
            }
            case 1: {
                return plu.getDesc();
            }
            case 2: {
                if (plu.getCode() != -1) {
                    return String.valueOf(plu.getCode());
                }
                return EMPTY_FF;
            }
            case 3: {
                if (plu.getBarCode() != -1L) {
                    return String.valueOf(plu.getBarCode());
                }
                return EMPTY_FFff;
            }
            case 4: {
                int pom = plu.getCena();
                double dpom = pom;
                this.df = new DecimalFormat(decFor);
                return this.df.format(dpom / 100.0);
            }
            case 5: {
                byte pomb = plu.getPoreskaStopa();
                if (FiscallObjects.poreskeStope.length <= pomb || pomb < 0) {
                    pomb = 0;
                }
                return FiscallObjects.poreskeStope[pomb].opis;
            }
            case 6: {
                byte pomb = plu.getJedinicaMere();
                if (FiscallObjects.jediniceMere.length <= pomb || pomb < 0) {
                    pomb = 0;
                }
                return FiscallObjects.jediniceMere[pomb];
            }
            case 7: {
                byte pomb = plu.getOdeljenje();
                if (FiscallObjects.odeljenja.length <= pomb || pomb < 0) {
                    pomb = 0;
                }
                return FiscallObjects.odeljenja[pomb].opis;
            }
            case 8: {
                double d = plu.getKolicina();
                this.df = new DecimalFormat(decForAmount);
                return this.df.format(d / 1000.0);
            }
            case 9: {
                double dd = plu.getProdato();
                this.df = new DecimalFormat(decFor);
                return this.df.format(dd / 100.0);
            }
        }
        return null;
    }

    public final boolean isCellEditable(int r, int c) {
        return c < 8 && c > 0;
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public final void setValueAt(Object s, int row, int col) {
        byte pomb = 0;
        if (s == null) {
            return;
        }
        String str = s.toString();
        if (str.length() == 0 && col != 2 && col != 3) {
            return;
        }
        if (PLU.vecView.size() <= row) {
            return;
        }
        plu = (PLU)PLU.vecView.get(row);
        switch (col) {
            case 1: {
                plu.setDesc(str.trim());
                break;
            }
            case 2: {
                if (str.length() == 0) {
                    plu.setCode(-1);
                    return;
                }
                int pomi = 0;
                try {
                    pomi = Integer.parseInt("0" + str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pomi > 32000 || pomi <= 0) {
                    return;
                }
                plu.setCode(pomi);
                break;
            }
            case 3: {
                if (str.length() == 0) {
                    plu.setBarCode(-1L);
                    return;
                }
                long poml = 0L;
                String poms = str;
                try {
                    poml = Long.parseLong(poms);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (poml <= 0L) {
                    return;
                }
                plu.setBarCode(poml);
                break;
            }
            case 4: {
                int iop = str.indexOf(46);
                if (iop < 0) {
                    iop = str.indexOf(44);
                }
                String s1 = empStr;
                String s2 = empStr;
                if (iop >= 0) {
                    s1 = str.substring(0, iop);
                } else {
                    str = String.valueOf(str) + "00";
                }
                s2 = str.substring(iop + 1, str.length());
                str = String.valueOf(s1) + s2;
                int pom = 0;
                try {
                    pom = Integer.parseInt(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pom <= 0) {
                    return;
                }
                plu.setCena(pom);
                break;
            }
            case 5: {
                pomb = 0;
                int i = 0;
                while (i < 9) {
                    if (FiscallObjects.poreskeStope[i].opis.equalsIgnoreCase(str)) {
                        pomb = (byte)(i & 0xF);
                        break;
                    }
                    ++i;
                }
                plu.setPoreskaStopa(pomb);
                break;
            }
            case 6: {
                pomb = 0;
                int i = 0;
                while (i < FiscallObjects.jediniceMere.length) {
                    if (FiscallObjects.jediniceMere[i].equalsIgnoreCase(str)) {
                        pomb = (byte)(i & 0xF);
                        break;
                    }
                    ++i;
                }
                plu.setJedinicaMere(pomb);
                break;
            }
            case 7: {
                pomb = 0;
                int i = 0;
                while (i < FiscallObjects.odeljenja.length) {
                    if (FiscallObjects.odeljenja[i].opis.equalsIgnoreCase(str)) {
                        pomb = (byte)i;
                        break;
                    }
                    ++i;
                }
                plu.setOdeljenje(pomb);
            }
        }
    }
}

