/*
 * Decompiled with CFR 0.152.
 */
package gui.search;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPRadioButton;
import gui.HCPTextField;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import gui.search.SearchPluTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.PLU;
import objects.lang.LanguageStrings;
import util.SysUtil;
import util.comPort.PortSerial;

public class SearchPluPanel
extends JPanel {
    private JPanel leftPanel;
    private JPanel tablePanel;
    public SearchPluTable table;
    private HCPRadioButton code;
    private HCPRadioButton barcode;
    private HCPRadioButton description;
    private HCPTextField search;
    private HCPGreyButton programm;
    private HCPGreyButton changePrice;

    public SearchPluPanel() {
        ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
        this.setLayout(new BorderLayout(10, 10));
        this.leftPanel = new JPanel();
        this.leftPanel.setPreferredSize(new Dimension(250, GlavniFrame.getInstance().getHeight() - 50));
        this.leftPanel.setLayout(new GridLayout(14, 1, 10, 10));
        this.leftPanel.setBackground(HCPColors.getColorM2st());
        this.leftPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        HCPLabel sl = new HCPLabel("", new ImageIcon("images/search.png"), 2);
        this.leftPanel.add(sl);
        this.search = new HCPTextField();
        this.search.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                new Thread(){

                    public void run() {
                        ProcessingDialog pd = ProcessingDialog.getInstance();
                        pd.setInstanceVisible(true);
                        try {
                            String s = SearchPluPanel.this.search.getText().trim();
                            if (s == null || s.length() <= 0) {
                                PLU.vecView.removeAllElements();
                                int i = 0;
                                while (i < PLU.vec.size()) {
                                    PLU plu = (PLU)PLU.vec.elementAt(i);
                                    PLU.vecView.add(plu);
                                    ++i;
                                }
                                return;
                            }
                            try {
                                s = s.toUpperCase();
                                PLU.vecView.removeAllElements();
                                int i = 0;
                                while (i < PLU.vec.size()) {
                                    try {
                                        PLU plu = (PLU)PLU.vec.elementAt(i);
                                        if (SearchPluPanel.this.description.isSelected()) {
                                            String pom = plu.getDesc();
                                            if (pom.toUpperCase().indexOf(s) >= 0) {
                                                PLU.vecView.add(plu);
                                            }
                                        } else if (SearchPluPanel.this.code.isSelected()) {
                                            if (("" + plu.getCode()).toUpperCase().indexOf(s) >= 0) {
                                                PLU.vecView.add(plu);
                                            }
                                        } else if (SearchPluPanel.this.barcode.isSelected() && ("" + plu.getBarCode()).toUpperCase().indexOf(s) >= 0) {
                                            PLU.vecView.add(plu);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception ee) {
                                pd.setInstanceVisible(false);
                                ee.printStackTrace();
                                JOptionPane.showMessageDialog((this).SearchPluPanel.this.table, ee.getMessage(), "ERROR", 0);
                            }
                        }
                        finally {
                            SearchPluPanel.this.repaintTable();
                            pd.setInstanceVisible(false);
                        }
                    }
                }.start();
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.leftPanel.add(this.search);
        this.description = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_1"));
        this.leftPanel.add(this.description);
        this.code = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_2"));
        this.leftPanel.add(this.code);
        this.barcode = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_3"));
        this.leftPanel.add(this.barcode);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.code);
        bg.add(this.barcode);
        bg.add(this.description);
        this.description.setSelected(true);
        this.leftPanel.add(new Component(){});
        this.programm = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_PROGRAM"));
        this.programm.setIcon(slikaCash);
        this.programm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        try {
                            SearchPluPanel.this.program();
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(SearchPluPanel.this.tablePanel, e1.getMessage(), " ERROR", 0);
                        }
                    }
                }.start();
            }
        });
        this.leftPanel.add(this.programm);
        this.changePrice = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_CHANGE_PRICE"));
        this.changePrice.setIcon(slikaCash);
        this.changePrice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        try {
                            SearchPluPanel.this.changePrice();
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(SearchPluPanel.this.tablePanel, e1.getMessage(), " ERROR", 0);
                        }
                    }
                }.start();
            }
        });
        this.leftPanel.add(this.changePrice);
        this.leftPanel.add(new Component(){});
        this.tablePanel = new JPanel();
        this.tablePanel.setPreferredSize(new Dimension(100, 400));
        this.tablePanel.setLayout(new BorderLayout(10, 10));
        this.tablePanel.setBackground(HCPColors.getColorM2st());
        this.tablePanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        this.table = new SearchPluTable();
        this.tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.tablePanel, "Center");
    }

    public void repaintTable() {
        this.table.revalidate();
        this.table.repaint();
    }

    protected void program() throws Exception {
        int[] kk = this.table.getSelectedRows();
        int nn = kk.length;
        int descSize = 0;
        int i = 0;
        Command instance = Command.bigInstance;
        if (nn <= 0) {
            return;
        }
        if (nn == 1) {
            int sel = this.table.getSelectedRow();
            if (sel < 0 || sel >= PLU.vecView.size()) {
                return;
            }
            PLU plu = (PLU)PLU.vecView.elementAt(sel);
            plu.sendToCR();
            return;
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            while (i < nn) {
                instance.reset();
                instance.setCmd(12);
                while (instance.getPos() + 30 < 512) {
                    if (i >= nn) break;
                    if (kk[i] < 0 || kk[i] >= PLU.vecView.size()) {
                        ++i;
                        break;
                    }
                    PLU plu = (PLU)PLU.vecView.elementAt(kk[i]);
                    descSize = plu.getDesc().length();
                    if (instance.getPos() + 30 + descSize >= 512) break;
                    descSize = plu.getDesc().length();
                    if (descSize > 34) {
                        descSize = 34;
                    }
                    instance.addByte(18 + descSize);
                    instance.addInt(plu.getCode());
                    instance.addLong(plu.getBarCode());
                    SysUtil.formatForSend(new String(plu.getDesc()), instance);
                    instance.addByte(plu.getOdeljenje());
                    descSize = plu.getJedinicaMere();
                    descSize &= 0xF;
                    descSize <<= 4;
                    instance.addByte(descSize |= plu.getPoreskaStopa() & 0xF);
                    instance.addInt(plu.getCena());
                    ++i;
                    pd.increaseBar();
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                port.receiveFrame(instance);
                int e = instance.getArray()[0] & 0xFF;
                if (12 == instance.getCmd() || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void changePrice() throws Exception {
        int[] kk = this.table.getSelectedRows();
        int nn = kk.length;
        if (nn <= 0) {
            return;
        }
        int i = 0;
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            while (i < nn) {
                if (kk[i] < 0) break;
                if (kk[i] >= PLU.vecView.size()) {
                    break;
                }
                instance.reset();
                instance.setCmd(11);
                while (instance.getPos() < 504) {
                    if (i >= nn || kk[i] < 0 || kk[i] >= PLU.vecView.size()) break;
                    PLU plu = (PLU)PLU.vecView.elementAt(kk[i]);
                    instance.addInt(plu.getCode());
                    instance.addInt(plu.getCena());
                    ++i;
                    pd.increaseBar();
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                port.receiveFrame(instance);
                int e = instance.getArray()[0] & 0xFF;
                if (11 == instance.getCmd() || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }
}

