/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gnu.io.CommPortIdentifier;
import gui.BaseDialog;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPComboBox;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPNumTextField;
import gui.HCPfileChooser;
import gui.ProcessingDialog;
import gui.TestDisplayDialog;
import gui.TestPrinterDialog;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.DBManager;
import objects.MemoryReader;
import objects.RemoteBases;
import objects.lang.LanguageStrings;
import util.BufferByte;
import util.SysUtil;
import util.comPort.PortSerial;

public final class ToolsPanel
extends RightPanel
implements ActionListener {
    private JPanel mainPanel;
    private JPanel portPCPanel;
    private JPanel memPanel;
    private JPanel textPanel;
    private JPanel basePanel;
    private JPanel programPanel;
    private JPanel printerPanel;
    private HCPComboBox comboPCSpeeds;
    private HCPComboBox comboPCPort;
    private HCPComboBox baseCombo;
    private HCPGreyButton testPCButton;
    private HCPGreyButton readFlash;
    private HCPGreyButton readRam;
    private HCPGreyButton readFiscal;
    private HCPGreyButton readProgram;
    private HCPGreyButton readAllFiscal;
    private HCPGreyButton readAllRam;
    private HCPGreyButton fiscalToBin;
    private SpringLayout osl;
    private HCPNumTextField odFlash;
    private HCPNumTextField doFlash;
    private HCPNumTextField odRam;
    private HCPNumTextField doRam;
    private HCPNumTextField odFiscal;
    private HCPNumTextField doFiscal;
    private HCPComboBox comboFlash;
    private HCPComboBox comboRam;
    private HCPComboBox comboFiscal;
    private HCPGreyButton addFlash;
    private HCPGreyButton rmvFlash;
    private HCPGreyButton addRam;
    private HCPGreyButton rmvRam;
    private HCPGreyButton addFiscal;
    private HCPGreyButton rmvFiscal;
    private HCPGreyButton addBase;
    private HCPGreyButton rmvBase;
    private HCPGreyButton connectToBase;
    private JTextArea memText;
    private ToolsThread runner = null;
    private BufferByte data;

    public ToolsPanel() {
        super(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON"), 'T', LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_TOOLTIP"));
        MemoryReader.getInstance().readAll();
        this.runner = new ToolsThread();
        this.data = new BufferByte(512, 512);
        this.setLayout(new BorderLayout());
        ImageIcon slikaTest = new ImageIcon("images/Control-Panel_Small.png");
        ImageIcon slikaMem = new ImageIcon("images/mem.png");
        ImageIcon slikaPlus = new ImageIcon("images/plus.png");
        ImageIcon slikaMinus = new ImageIcon("images/minus.png");
        this.mainPanel = new JPanel();
        this.mainPanel.setOpaque(false);
        this.osl = new SpringLayout();
        this.mainPanel.setLayout(this.osl);
        this.mainPanel.setIgnoreRepaint(true);
        this.mainPanel.setBackground(HCPColors.getColorM2st());
        this.programPanel = new JPanel();
        this.programPanel.setLayout(new GridLayout(4, 1, 10, 10));
        this.programPanel.setPreferredSize(new Dimension(151, 170));
        this.programPanel.setIgnoreRepaint(true);
        this.programPanel.setBackground(HCPColors.getColorM2st());
        this.programPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        this.readProgram = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PROGRAM_TO_FILE"));
        this.readProgram.setToolTipText(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PROGRAM_TO_FILE_TOOLTIP"));
        this.readProgram.setIcon(slikaMem);
        this.readProgram.addActionListener(this);
        this.readProgram.setActionCommand("PROGRAM_TO_FILE");
        this.programPanel.add(this.readProgram);
        this.readAllFiscal = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_TO_FILE"));
        this.readAllFiscal.setToolTipText(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_TO_FILE_TOOLTIP"));
        this.readAllFiscal.setIcon(slikaMem);
        this.readAllFiscal.addActionListener(this);
        this.readAllFiscal.setActionCommand("FISCAL_TO_FILE");
        this.programPanel.add(this.readAllFiscal);
        this.readAllRam = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_RAM_TO_FILE"));
        this.readAllRam.setToolTipText(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_RAM_TO_FILE_TOOLTIP"));
        this.readAllRam.setIcon(slikaMem);
        this.readAllRam.addActionListener(this);
        this.readAllRam.setActionCommand("RAM_TO_FILE");
        this.programPanel.add(this.readAllRam);
        this.fiscalToBin = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_DATA_TO_FILE"));
        this.fiscalToBin.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_DATA_TO_FILE_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_DATA_TO_FILE_TOOLTIP_1") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_DATA_TO_FILE_TOOLTIP_2") + "<br>" + "</html>");
        this.fiscalToBin.setIcon(slikaMem);
        this.fiscalToBin.addActionListener(this);
        this.fiscalToBin.setActionCommand("FISCAL_DATA_TO_FILE");
        this.programPanel.add(this.fiscalToBin);
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new GridLayout(5, 1, 10, 10));
        this.basePanel.setPreferredSize(new Dimension(130, 210));
        this.basePanel.setIgnoreRepaint(true);
        this.basePanel.setBackground(HCPColors.getColorM2st());
        this.basePanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        this.basePanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_LABEL_DATABASE"), 0));
        this.baseCombo = new HCPComboBox(RemoteBases.vec);
        this.basePanel.add(this.baseCombo);
        this.addBase = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD"));
        this.addBase.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_TOOLTIP_1") + "<br>" + "</html>");
        this.addBase.setIcon(slikaPlus);
        this.addBase.setHorizontalAlignment(2);
        this.addBase.addActionListener(this);
        this.addBase.setActionCommand("DODAJ_BAZU");
        this.basePanel.add(this.addBase);
        this.rmvBase = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE"));
        this.rmvBase.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_TOOLTIP_1") + "<br>" + "</html>");
        this.rmvBase.setIcon(slikaMinus);
        this.rmvBase.setHorizontalAlignment(2);
        this.rmvBase.addActionListener(this);
        this.rmvBase.setActionCommand("OBRISI_BAZU");
        this.basePanel.add(this.rmvBase);
        this.connectToBase = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_CONNECT"));
        this.connectToBase.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_CONNECT_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_CONNECT_TOOLTIP_1") + "<br>" + "</html>");
        this.connectToBase.setIcon(slikaTest);
        this.connectToBase.setHorizontalAlignment(2);
        this.connectToBase.addActionListener(this);
        this.connectToBase.setActionCommand("CONNECT");
        this.basePanel.add(this.connectToBase);
        this.printerPanel = new JPanel();
        this.printerPanel.setLayout(new GridLayout(2, 1, 10, 10));
        this.printerPanel.setPreferredSize(new Dimension(130, 95));
        this.printerPanel.setIgnoreRepaint(true);
        this.printerPanel.setBackground(HCPColors.getColorM2st());
        this.printerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        HCPGreyButton testPrinter = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PORT"));
        if (!GlavniFrame.PRINTER) {
            this.printerPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PRINTER"), 0));
        } else {
            testPrinter.setText(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PRINTER"));
            HCPGreyButton testDisplay = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_DISPLAY"));
            testDisplay.setIcon(slikaTest);
            testDisplay.setHorizontalAlignment(2);
            testDisplay.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TestDisplayDialog.getInstance().setVisible(true);
                }
            });
            this.printerPanel.add(testDisplay);
        }
        testPrinter.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PRINTER_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PRINTER_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PRINTER_TOOLTIP_2") + "</u><br>" + "</html>");
        testPrinter.setIcon(slikaTest);
        testPrinter.setHorizontalAlignment(2);
        testPrinter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestPrinterDialog tpd = new TestPrinterDialog();
                tpd.setVisible(true);
            }
        });
        this.printerPanel.add(testPrinter);
        this.portPCPanel = new JPanel();
        this.portPCPanel.setLayout(new GridLayout(4, 1, 10, 10));
        this.portPCPanel.setPreferredSize(new Dimension(130, 170));
        this.portPCPanel.setIgnoreRepaint(true);
        this.portPCPanel.setBackground(HCPColors.getColorM2st());
        this.portPCPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        this.portPCPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_LABEL_PC_PORT"), 0));
        this.comboPCPort = new HCPComboBox();
        this.portPCPanel.add(this.comboPCPort);
        this.comboPCSpeeds = new HCPComboBox();
        this.comboPCSpeeds.addItem("9600");
        this.comboPCSpeeds.addItem("19200");
        this.comboPCSpeeds.addItem("38400");
        this.comboPCSpeeds.addItem("57600");
        this.comboPCSpeeds.addItem("115200");
        this.comboPCSpeeds.addItem("230400");
        this.comboPCSpeeds.addItem("460800");
        this.comboPCSpeeds.setSelectedIndex(4);
        this.portPCPanel.add(this.comboPCSpeeds);
        this.testPCButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PORT"));
        this.testPCButton.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PORT_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PORT_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_PORT_TOOLTIP_2") + " </u><br>" + "</html>");
        this.testPCButton.setIcon(slikaTest);
        this.testPCButton.setHorizontalAlignment(2);
        this.testPCButton.addActionListener(this);
        this.testPCButton.setActionCommand("TESTPC");
        this.portPCPanel.add(this.testPCButton);
        Enumeration ep = null;
        try {
            ep = CommPortIdentifier.getPortIdentifiers();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.comboPCPort.removeAllItems();
        while (ep.hasMoreElements()) {
            CommPortIdentifier pom = (CommPortIdentifier)ep.nextElement();
            if (pom.getPortType() != 1) continue;
            this.comboPCPort.addItem(pom.getName());
        }
        try {
            this.comboPCSpeeds.setSelectedItem("" + PortSerial.speed);
            this.comboPCPort.setSelectedItem(PortSerial.sPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.memPanel = new JPanel();
        this.memPanel.setLayout(new GridLayout(4, 6, 10, 10));
        this.memPanel.setPreferredSize(new Dimension(560, 170));
        this.memPanel.setIgnoreRepaint(true);
        this.memPanel.setBackground(HCPColors.getColorM2st());
        this.memPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 5, 10, 5)));
        this.memPanel.add(new JLabel());
        this.memPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_LABEL_FROM"), 0));
        this.memPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_LABEL_BYTES"), 0));
        this.memPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_LABEL_PATERNS"), 0));
        this.memPanel.add(new JLabel());
        this.memPanel.add(new JLabel());
        this.readFlash = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FLASH"));
        this.readFlash.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FLASH_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FLASH_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FLASH_TOOLTIP_2") + "</u><br>" + "</html>");
        this.readFlash.setIcon(slikaMem);
        this.readFlash.addActionListener(this);
        this.readFlash.setActionCommand("READ_FLASH");
        this.memPanel.add(this.readFlash);
        this.odFlash = new HCPNumTextField();
        this.odFlash.setText("0");
        this.odFlash.setHorizontalAlignment(0);
        this.memPanel.add(this.odFlash);
        this.doFlash = new HCPNumTextField();
        this.doFlash.setText("0");
        this.doFlash.setHorizontalAlignment(0);
        this.memPanel.add(this.doFlash);
        this.comboFlash = new HCPComboBox(MemoryReader.flashVec);
        this.comboFlash.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ToolsPanel.this.comboFlash) {
                    int opt = ToolsPanel.this.comboFlash.getSelectedIndex();
                    if (opt < 0 || opt >= MemoryReader.flashVec.size()) {
                        return;
                    }
                    MemoryReader.MemElement me = (MemoryReader.MemElement)MemoryReader.flashVec.elementAt(opt);
                    ToolsPanel.this.odFlash.setText(String.valueOf(me.from));
                    ToolsPanel.this.doFlash.setText(String.valueOf(me.size));
                }
            }
        });
        this.memPanel.add(this.comboFlash);
        this.addFlash = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN"));
        this.addFlash.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN_TOOLTIP_1") + "<br>" + "</html>");
        this.addFlash.setIcon(slikaPlus);
        this.addFlash.addActionListener(this);
        this.addFlash.setActionCommand("ADD_FLASH");
        this.memPanel.add(this.addFlash);
        this.rmvFlash = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN"));
        this.rmvFlash.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN_TOOLTIP_1") + "<br>" + "</html>");
        this.rmvFlash.setIcon(slikaMinus);
        this.rmvFlash.addActionListener(this);
        this.rmvFlash.setActionCommand("RMV_FLASH");
        this.memPanel.add(this.rmvFlash);
        this.readRam = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_RAM"));
        this.readRam.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_RAM_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_RAM_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_RAM_TOOLTIP_2") + "</u><br>" + "</html>");
        this.readRam.setIcon(slikaMem);
        this.readRam.addActionListener(this);
        this.readRam.setActionCommand("READ_RAM");
        this.memPanel.add(this.readRam);
        this.odRam = new HCPNumTextField();
        this.odRam.setText("0");
        this.odRam.setHorizontalAlignment(0);
        this.memPanel.add(this.odRam);
        this.doRam = new HCPNumTextField();
        this.doRam.setText("0");
        this.doRam.setHorizontalAlignment(0);
        this.memPanel.add(this.doRam);
        this.comboRam = new HCPComboBox(MemoryReader.ramVec);
        this.comboRam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ToolsPanel.this.comboRam) {
                    int opt = ToolsPanel.this.comboRam.getSelectedIndex();
                    if (opt < 0 || opt >= MemoryReader.ramVec.size()) {
                        return;
                    }
                    MemoryReader.MemElement me = (MemoryReader.MemElement)MemoryReader.ramVec.elementAt(opt);
                    ToolsPanel.this.odRam.setText(String.valueOf(me.from));
                    ToolsPanel.this.doRam.setText(String.valueOf(me.size));
                }
            }
        });
        this.memPanel.add(this.comboRam);
        this.addRam = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN"));
        this.addRam.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN_TOOLTIP_1") + "<br>" + "</html>");
        this.addRam.setIcon(slikaPlus);
        this.addRam.addActionListener(this);
        this.addRam.setActionCommand("ADD_RAM");
        this.memPanel.add(this.addRam);
        this.rmvRam = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN"));
        this.rmvRam.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN_TOOLTIP_1") + "<br>" + "</html>");
        this.rmvRam.setIcon(slikaMinus);
        this.rmvRam.addActionListener(this);
        this.rmvRam.setActionCommand("RMV_RAM");
        this.memPanel.add(this.rmvRam);
        this.readFiscal = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL"));
        this.readFiscal.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_FISCAL_TOOLTIP_2") + "</u><br>" + "</html>");
        this.readFiscal.setIcon(slikaMem);
        this.readFiscal.addActionListener(this);
        this.readFiscal.setActionCommand("READ_FISCAL");
        this.memPanel.add(this.readFiscal);
        this.odFiscal = new HCPNumTextField();
        this.odFiscal.setText("0");
        this.odFiscal.setHorizontalAlignment(0);
        this.memPanel.add(this.odFiscal);
        this.doFiscal = new HCPNumTextField();
        this.doFiscal.setText("0");
        this.doFiscal.setHorizontalAlignment(0);
        this.memPanel.add(this.doFiscal);
        this.comboFiscal = new HCPComboBox(MemoryReader.fisVec);
        this.comboFiscal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ToolsPanel.this.comboFiscal) {
                    int opt = ToolsPanel.this.comboFiscal.getSelectedIndex();
                    if (opt < 0 || opt >= MemoryReader.fisVec.size()) {
                        return;
                    }
                    MemoryReader.MemElement me = (MemoryReader.MemElement)MemoryReader.fisVec.elementAt(opt);
                    ToolsPanel.this.odFiscal.setText(String.valueOf(me.from));
                    ToolsPanel.this.doFiscal.setText(String.valueOf(me.size));
                }
            }
        });
        this.memPanel.add(this.comboFiscal);
        this.addFiscal = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN"));
        this.addFiscal.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_ADD_PATERN_TOOLTIP_1") + "<br>" + "</html>");
        this.addFiscal.setIcon(slikaPlus);
        this.addFiscal.addActionListener(this);
        this.addFiscal.setActionCommand("ADD_FISCAL");
        this.memPanel.add(this.addFiscal);
        this.rmvFiscal = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN"));
        this.rmvFiscal.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_BUTTON_REMOVE_PATERN_TOOLTIP_1") + "<br>" + "</html>");
        this.rmvFiscal.setIcon(slikaMinus);
        this.rmvFiscal.addActionListener(this);
        this.rmvFiscal.setActionCommand("RMV_FISCAL");
        this.memPanel.add(this.rmvFiscal);
        this.textPanel = new JPanel(new BorderLayout());
        this.textPanel.setPreferredSize(new Dimension(716, 310));
        this.textPanel.setIgnoreRepaint(true);
        this.textPanel.setBackground(HCPColors.getColorM2st());
        this.textPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.memText = new JTextArea();
        this.memText.setFont(new Font("Courier New", 0, 14));
        JScrollPane scr = new JScrollPane(this.memText, 20, 30);
        scr.setBorder(new SoftBevelBorder(1));
        this.textPanel.add((Component)scr, "Center");
        this.osl.putConstraint("North", (Component)this.portPCPanel, 0, "North", (Component)this.mainPanel);
        this.osl.putConstraint("West", (Component)this.portPCPanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.portPCPanel);
        this.osl.putConstraint("North", (Component)this.memPanel, 0, "North", (Component)this.mainPanel);
        this.osl.putConstraint("West", (Component)this.memPanel, 5, "East", (Component)this.portPCPanel);
        this.osl.putConstraint("North", (Component)this.programPanel, 0, "North", (Component)this.mainPanel);
        this.osl.putConstraint("West", (Component)this.programPanel, 5, "East", (Component)this.memPanel);
        this.osl.putConstraint("North", (Component)this.basePanel, 5, "South", (Component)this.portPCPanel);
        this.osl.putConstraint("West", (Component)this.basePanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.basePanel);
        this.osl.putConstraint("North", (Component)this.printerPanel, 5, "South", (Component)this.basePanel);
        this.osl.putConstraint("West", (Component)this.printerPanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.printerPanel);
        this.osl.putConstraint("North", (Component)this.textPanel, 5, "South", (Component)this.memPanel);
        this.osl.putConstraint("West", (Component)this.textPanel, 5, "East", (Component)this.basePanel);
        this.add((Component)this.mainPanel, "Center");
    }

    private final void testPC() throws Exception {
        String pom = (String)this.comboPCPort.getSelectedItem();
        String pom2 = (String)this.comboPCSpeeds.getSelectedItem();
        PortSerial.sPort = pom;
        if (pom != null) {
            PortSerial.speed = Integer.parseInt(pom2);
            ProcessingDialog pd = ProcessingDialog.getInstance();
            pd.setInstanceVisible(true);
            try {
                PortSerial.getInstance().test(PortSerial.speed);
            }
            finally {
                pd.setInstanceVisible(false);
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.indexOf("TESTPC") >= 0) {
            try {
                this.runner.setJob(1);
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("READ") >= 0) {
            try {
                if (s.indexOf("READ_FLASH") >= 0) {
                    this.runner.setJob(2);
                    return;
                }
                if (s.indexOf("READ_RAM") >= 0) {
                    this.runner.setJob(3);
                    return;
                }
                if (s.indexOf("READ_FISCAL") < 0) return;
                this.runner.setJob(4);
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("ADD") >= 0) {
            if (s.indexOf("ADD_FLASH") >= 0) {
                int pom2;
                int pom1;
                try {
                    pom1 = Integer.parseInt(this.doFlash.getText());
                    pom2 = Integer.parseInt(this.odFlash.getText());
                }
                catch (NumberFormatException e1) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_YOU_MUST_ENTER_RANGE"), "ERROR", 0);
                    return;
                }
                String pom3 = JOptionPane.showInputDialog(this, (Object)LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_NAME"));
                if (pom3 == null) {
                    return;
                }
                if (pom3.length() <= 0) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_YOU_MUST_ENTER_NAME"), "ERROR", 0);
                    return;
                }
                MemoryReader memoryReader = MemoryReader.getInstance();
                memoryReader.getClass();
                MemoryReader.MemElement me = new MemoryReader.MemElement(memoryReader, pom3, pom2, pom1);
                MemoryReader.flashVec.add(me);
                this.comboFlash.revalidate();
                this.comboFlash.setSelectedItem(me);
            } else if (s.indexOf("ADD_FISCAL") >= 0) {
                int pom2;
                int pom1;
                try {
                    pom1 = Integer.parseInt(this.doFiscal.getText());
                    pom2 = Integer.parseInt(this.odFiscal.getText());
                }
                catch (NumberFormatException e1) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_YOU_MUST_ENTER_RANGE"), "ERROR", 0);
                    return;
                }
                String pom3 = JOptionPane.showInputDialog(this, (Object)LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_NAME"));
                if (pom3 == null) {
                    return;
                }
                if (pom3.length() <= 0) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_YOU_MUST_ENTER_NAME"), "ERROR", 0);
                    return;
                }
                MemoryReader memoryReader = MemoryReader.getInstance();
                memoryReader.getClass();
                MemoryReader.MemElement me = new MemoryReader.MemElement(memoryReader, pom3, pom2, pom1);
                MemoryReader.fisVec.add(me);
                this.comboFiscal.revalidate();
                this.comboFiscal.setSelectedItem(me);
            } else if (s.indexOf("ADD_RAM") >= 0) {
                int pom2;
                int pom1;
                try {
                    pom1 = Integer.parseInt(this.doRam.getText());
                    pom2 = Integer.parseInt(this.odRam.getText());
                }
                catch (NumberFormatException e1) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_YOU_MUST_ENTER_RANGE"), "ERROR", 0);
                    return;
                }
                String pom3 = JOptionPane.showInputDialog(this, (Object)LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_NAME"));
                if (pom3 == null) {
                    return;
                }
                if (pom3.length() <= 0) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_YOU_MUST_ENTER_NAME"), "ERROR", 0);
                    return;
                }
                MemoryReader memoryReader = MemoryReader.getInstance();
                memoryReader.getClass();
                MemoryReader.MemElement me = new MemoryReader.MemElement(memoryReader, pom3, pom2, pom1);
                MemoryReader.ramVec.add(me);
                this.comboRam.revalidate();
                this.comboRam.setSelectedItem(me);
            }
            MemoryReader.getInstance().saveAll();
            return;
        }
        if (s.indexOf("RMV") >= 0) {
            if (JOptionPane.showConfirmDialog(this, LanguageStrings.getAreYouSure(), "DELETE", 2) != 0) {
                return;
            }
            try {
                if (s.indexOf("RMV_FLASH") >= 0) {
                    MemoryReader.flashVec.remove(this.comboFlash.getSelectedIndex());
                    this.comboFlash.revalidate();
                } else if (s.indexOf("RMV_RAM") >= 0) {
                    MemoryReader.ramVec.remove(this.comboRam.getSelectedIndex());
                    this.comboRam.revalidate();
                } else if (s.indexOf("RMV_FISCAL") >= 0) {
                    MemoryReader.fisVec.remove(this.comboFiscal.getSelectedIndex());
                    this.comboFiscal.revalidate();
                }
                MemoryReader.getInstance().saveAll();
                return;
            }
            catch (Exception pom1) {}
            return;
        }
        if (s.indexOf("DODAJ_BAZU") >= 0) {
            try {
                this.addBase();
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("OBRISI_BAZU") >= 0) {
            if (JOptionPane.showConfirmDialog(this, LanguageStrings.getAreYouSure(), "DELETE", 2) != 0) {
                return;
            }
            try {
                this.removeBase();
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("CONNECT") >= 0) {
            try {
                this.runner.setJob(5);
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("PROGRAM_TO_FILE") >= 0) {
            try {
                this.runner.setJob(6);
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("FISCAL_TO_FILE") >= 0) {
            try {
                this.runner.setJob(8);
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("RAM_TO_FILE") >= 0) {
            try {
                this.runner.setJob(9);
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
        if (s.indexOf("FISCAL_DATA_TO_FILE") < 0) return;
        try {
            this.runner.setJob(7);
            return;
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    private void fillData() {
        if (this.data.getSize() <= 0) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_WOULD_YOU_LIKE_TO_VIEW_DATA"), "hex. view", 2) != 0) {
            this.data.reset();
            return;
        }
        SysUtil.bufferToHexView(this.data, this.memText);
        this.data.reset();
    }

    public void writeToBinFile() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        File file = new File("FISCAL");
        file.mkdirs();
        file = new File("FISCAL/Fiscal.bin");
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        out = new FileOutputStream(file);
        PortSerial port = PortSerial.getInstance();
        try {
            int len;
            Command.instance.reset();
            Command.instance.setCmd(3);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 3 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            int numDaily = Command.instance.getInt(25);
            int numVats = Command.instance.getInt(33);
            int numReset = Command.instance.getInt(29);
            String pib = new String(Command.instance.getArray(), 16, 9);
            String ibfm = new String(Command.instance.getArray(), 8, 8);
            ((OutputStream)out).write(pib.getBytes());
            ((OutputStream)out).write(32);
            ((OutputStream)out).write(ibfm.getBytes());
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
            ++numDaily;
            int i = 1;
            while (i < numDaily) {
                Command.instance.reset();
                Command.instance.setCmd(91);
                Command.instance.addShort(i);
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                e = Command.instance.getArray()[0] & 0xFF;
                command = Command.instance.getCmd();
                if (command != 91 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                len = Command.instance.getLength() - 1;
                ((OutputStream)out).write(Command.instance.getArray(), 0, len);
                ++i;
            }
            file = new File("FISCAL/Vats.bin");
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            ((OutputStream)out).write(pib.getBytes());
            ((OutputStream)out).write(32);
            ((OutputStream)out).write(ibfm.getBytes());
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
            ++numVats;
            i = 1;
            while (i < numVats) {
                Command.instance.reset();
                Command.instance.setCmd(93);
                Command.instance.addShort(i);
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                e = Command.instance.getArray()[0] & 0xFF;
                command = Command.instance.getCmd();
                if (command != 93 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                len = Command.instance.getLength();
                ((OutputStream)out).write(Command.instance.getArray(), 0, len - 1);
                ++i;
            }
            file = new File("FISCAL/Resets.bin");
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            ((OutputStream)out).write(pib.getBytes());
            ((OutputStream)out).write(32);
            ((OutputStream)out).write(ibfm.getBytes());
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
            ++numReset;
            i = 1;
            while (i < numReset) {
                Command.instance.reset();
                Command.instance.setCmd(92);
                Command.instance.addShort(i);
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                e = Command.instance.getArray()[0] & 0xFF;
                command = Command.instance.getCmd();
                if (command != 92 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                len = Command.instance.getLength() - 1;
                ((OutputStream)out).write(Command.instance.getArray(), 0, len);
                ++i;
            }
            pd.setInstanceVisible(false);
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
            pd.setInstanceVisible(false);
        }
    }

    public void readProgram() throws Exception {
        int from = 0;
        int to = 524288;
        File file = new File("memorija", "program.bin");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("bin");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            byte[] arr = new byte[512];
            int end = from + to;
            while (true) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(76);
                instance.addInt(from);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 76 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                System.arraycopy(outComm.getArray(), 4, arr, 0, len -= 5);
                from = outComm.getInt(0);
                if ((from += len) >= end) {
                    ((OutputStream)out).write(arr, 0, len -= from - end);
                    this.data.add(arr, 0, len);
                    break;
                }
                ((OutputStream)out).write(arr, 0, len);
                this.data.add(arr, 0, len);
            }
        }
        finally {
            ((OutputStream)out).close();
            pd.setInstanceVisible(false);
        }
    }

    public void readAllRAM() throws Exception {
        int from = 0;
        int to = 0x100000;
        File file = new File("memorija", "all_ram.mem");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("mem");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        Command instance = Command.bigInstance;
        try {
            byte[] arr = new byte[512];
            int end = from + to;
            while (true) {
                instance.reset();
                instance.setCmd(9);
                instance.addInt(from);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 9 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                System.arraycopy(outComm.getArray(), 4, arr, 0, len -= 5);
                from = outComm.getInt(0);
                if ((from += len) >= end) {
                    ((OutputStream)out).write(arr, 0, len -= from - end);
                    this.data.add(arr, 0, len);
                    break;
                }
                ((OutputStream)out).write(arr, 0, len);
                this.data.add(arr, 0, len);
            }
        }
        finally {
            ((OutputStream)out).close();
            pd.setInstanceVisible(false);
        }
    }

    public void readAllFiscal() throws Exception {
        int from = 0;
        int to = 524288;
        File file = new File("memorija", "all_fiscal.mem");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("mem");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            byte[] arr = new byte[512];
            int end = from + to;
            while (true) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(8);
                instance.addInt(from);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 8 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                System.arraycopy(outComm.getArray(), 4, arr, 0, len -= 5);
                from = outComm.getInt(0);
                if ((from += len) >= end) {
                    ((OutputStream)out).write(arr, 0, len -= from - end);
                    this.data.add(arr, 0, len);
                    break;
                }
                ((OutputStream)out).write(arr, 0, len);
                this.data.add(arr, 0, len);
            }
        }
        finally {
            ((OutputStream)out).close();
            pd.setInstanceVisible(false);
        }
    }

    public void readFlash() throws Exception {
        int from = 0;
        int to = 1;
        try {
            from = Integer.parseInt(this.odFlash.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_VALUE_FROM"), "ERROR", 0);
        }
        try {
            to = Integer.parseInt(this.doFlash.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_LENGHT"), "ERROR", 0);
        }
        File file = new File("memorija", "flash.mem");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("mem");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            byte[] arr = new byte[512];
            int end = from + to;
            while (true) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(76);
                instance.addInt(from);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 76 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                System.arraycopy(outComm.getArray(), 4, arr, 0, len -= 5);
                from = outComm.getInt(0);
                if ((from += len) >= end) {
                    ((OutputStream)out).write(arr, 0, len -= from - end);
                    this.data.add(arr, 0, len);
                    break;
                }
                ((OutputStream)out).write(arr, 0, len);
                this.data.add(arr, 0, len);
            }
        }
        finally {
            ((OutputStream)out).close();
            pd.setInstanceVisible(false);
        }
    }

    public void readFiscal() throws Exception {
        int from = 0;
        int to = 1;
        try {
            from = Integer.parseInt(this.odFiscal.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_VALUE_FROM"), "ERROR", 0);
        }
        try {
            to = Integer.parseInt(this.doFiscal.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_LENGHT"), "ERROR", 0);
        }
        File file = new File("memorija", "fiscal.mem");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("mem");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            byte[] arr = new byte[512];
            int end = from + to;
            while (true) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(8);
                instance.addInt(from);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 8 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                System.arraycopy(outComm.getArray(), 4, arr, 0, len -= 5);
                from = outComm.getInt(0);
                if ((from += len) >= end) {
                    ((OutputStream)out).write(arr, 0, len -= from - end);
                    this.data.add(arr, 0, len);
                    break;
                }
                ((OutputStream)out).write(arr, 0, len);
                this.data.add(arr, 0, len);
            }
        }
        finally {
            ((OutputStream)out).close();
            pd.setInstanceVisible(false);
        }
    }

    public void readRam() throws Exception {
        int from = 0;
        int to = 1;
        try {
            from = Integer.parseInt(this.odRam.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_VALUE_FROM"), "ERROR", 0);
        }
        try {
            to = Integer.parseInt(this.doRam.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_ENTER_LENGHT"), "ERROR", 0);
        }
        File file = new File("memorija", "ram.mem");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("mem");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        Command instance = Command.bigInstance;
        try {
            byte[] arr = new byte[512];
            int end = from + to;
            while (true) {
                instance.reset();
                instance.setCmd(9);
                instance.addInt(from);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 9 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                System.arraycopy(outComm.getArray(), 4, arr, 0, len -= 5);
                from = outComm.getInt(0);
                if ((from += len) >= end) {
                    ((OutputStream)out).write(arr, 0, len -= from - end);
                    this.data.add(arr, 0, len);
                    break;
                }
                ((OutputStream)out).write(arr, 0, len);
                this.data.add(arr, 0, len);
            }
        }
        finally {
            ((OutputStream)out).close();
            pd.setInstanceVisible(false);
        }
    }

    public void connect() throws Exception {
        RemoteBases rb = (RemoteBases)this.baseCombo.getSelectedItem();
        if (rb == null) {
            throw new Exception("Null polinter.");
        }
        DBManager.getInstance().closeConnection();
        DBManager.databaseAddres = rb.databaseAddres;
        DBManager.username = rb.username;
        DBManager.password = rb.password;
        if (rb != RemoteBases.hcpBase) {
            DBManager.databaseTableName = rb.databaseName;
        } else {
            try {
                DBManager.databaseTableName = this.getBaseName();
            }
            catch (Exception e) {
                throw new Exception(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_NO_CASH_REGISTER"));
            }
            DBManager.getInstance().openAllMySQLDatabaseTables();
            String dbCreate = "CREATE DATABASE IF NOT EXISTS `" + DBManager.databaseTableName + "` CHARACTER SET 'utf8'" + "COLLATE 'utf8_general_ci';";
            DBManager.getInstance().executeSQLQuery(dbCreate);
            DBManager.getInstance().closeConnection();
        }
        DBManager.getInstance().openMySQLConnection();
    }

    private String getBaseName() throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(3);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 3 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        byte[] b = new byte[6];
        System.arraycopy(Command.instance.getArray(), 10, b, 0, b.length);
        String spom = SysUtil.formatForReceive(b);
        int i = 16;
        while (i < 25) {
            spom = String.valueOf(spom) + (char)Command.instance.getArray()[i];
            ++i;
        }
        return spom;
    }

    private void removeBase() throws Exception {
        if (this.baseCombo.getSelectedItem() == RemoteBases.hcpBase) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("TOOLS_PANEL_CANT_DELETE_DEFAULT_BASE"));
        }
        RemoteBases.vec.remove(this.baseCombo.getSelectedItem());
        RemoteBases.writeAllToXML();
    }

    private void addBase() throws Exception {
        BaseDialog bd = new BaseDialog();
        bd.setVisible(true);
        RemoteBases.writeAllToXML();
        this.baseCombo.setSelectedItem(bd.base);
    }

    private class ToolsThread
    extends Thread {
        public static final byte TEST_PORT = 1;
        public static final byte READ_FLASH = 2;
        public static final byte READ_RAM = 3;
        public static final byte READ_FISCAL = 4;
        public static final byte CONNECT = 5;
        public static final byte PROGRAM_TO_FILE = 6;
        public static final byte FISCAL_DATA_TO_FILE = 7;
        public static final byte FISCAL_TO_FILE = 8;
        public static final byte RAM_TO_FILE = 9;
        private int job = 0;

        public ToolsThread() {
            this.start();
        }

        public final synchronized void setJob(int j) throws Exception {
            if (this.job != 0) {
                throw new Exception(LanguageStrings.getProgramIsBusy());
            }
            this.job = j;
            this.notify();
        }

        public final synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            ToolsPanel.this.testPC();
                            break;
                        }
                        case 2: {
                            ToolsPanel.this.readFlash();
                            ToolsPanel.this.fillData();
                            break;
                        }
                        case 3: {
                            ToolsPanel.this.readRam();
                            ToolsPanel.this.fillData();
                            break;
                        }
                        case 4: {
                            ToolsPanel.this.readFiscal();
                            ToolsPanel.this.fillData();
                            break;
                        }
                        case 5: {
                            ToolsPanel.this.connect();
                            break;
                        }
                        case 6: {
                            ToolsPanel.this.readProgram();
                            ToolsPanel.this.fillData();
                            break;
                        }
                        case 7: {
                            ToolsPanel.this.writeToBinFile();
                            ToolsPanel.this.fillData();
                            break;
                        }
                        case 8: {
                            ToolsPanel.this.readAllFiscal();
                            ToolsPanel.this.fillData();
                            break;
                        }
                        case 9: {
                            ToolsPanel.this.readAllRAM();
                            ToolsPanel.this.fillData();
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }
    }
}

