/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import cashRegister.FiscalCommands;
import gui.GlavniFrame;
import gui.HCPCheckBox;
import gui.HCPColors;
import gui.HCPComboBox;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPTextField;
import gui.IzvestajiDialog;
import gui.KeysDialog;
import gui.ProcessingDialog;
import gui.RabatMarzaDialog;
import gui.RacuniDialog;
import gui.StateDIDialog;
import gui.StateDialog;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.FiscallObjects;
import objects.PLU;
import tables.articlesTable.ArticleTableTxtCellModel;
import tables.testTable.KolicinaTxtField;
import tables.testTable.PLUtest;
import tables.testTable.TableTest;
import tables.testTable.TestTableModel;
import util.SysUtil;
import util.comPort.BarcodePort;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public class TestProdajePanel
extends RightPanel
implements ActionListener {
    public JPanel tp;
    public JPanel eastPanel;
    public static HCPTextField uTxtField;
    public ArticleTableTxtCellModel bcTxtField;
    public HCPTextField kTxtField;
    private HCPGreyButton addButton;
    private HCPGreyButton payButton;
    private HCPGreyButton izvestaj;
    private HCPGreyButton racun;
    private HCPGreyButton stanje;
    private HCPGreyButton stornoAll;
    private HCPGreyButton stornoLast;
    private HCPGreyButton startTest;
    private HCPGreyButton stopTest;
    private HCPGreyButton displaySubsum;
    private JScrollPane scr;
    public static TableTest tt;
    public HCPComboBox comboBarcodePort;
    public static HCPCheckBox useBarcode;
    public volatile HCPCheckBox useDaily;
    public volatile boolean USEDAILY = true;
    public static long TEST_fullValue;
    public TestingThread runner;
    private static int billNumber;
    private static int itemNumber;

    static {
        TEST_fullValue = 0L;
        billNumber = 5;
        itemNumber = 5;
    }

    public TestProdajePanel() {
        super("Test sale", 'Q', "Test sale");
        this.setLayout(new BorderLayout(10, 10));
        this.setIgnoreRepaint(true);
        this.tp = new JPanel();
        this.eastPanel = new JPanel();
        tt = new TableTest();
        this.bcTxtField = new ArticleTableTxtCellModel(3, 20);
        this.bcTxtField.setBorder(new SoftBevelBorder(1));
        this.bcTxtField.setFont(GlavniFrame.font);
        this.kTxtField = !GlavniFrame.PRINTER ? new KolicinaTxtField(20) : new KolicinaTxtField(11);
        uTxtField = new HCPTextField(20);
        uTxtField.setHorizontalAlignment(4);
        this.eastPanel.setOpaque(false);
        this.eastPanel.setLayout(new GridLayout(18, 2, 5, 5));
        this.eastPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.eastPanel.setPreferredSize(new Dimension(200, 610));
        this.eastPanel.setIgnoreRepaint(true);
        this.eastPanel.setBackground(HCPColors.getColorM2st());
        HCPLabel l1 = new HCPLabel("Code");
        l1.setHorizontalAlignment(4);
        this.eastPanel.add(l1);
        this.eastPanel.add(this.bcTxtField);
        HCPLabel l2 = new HCPLabel("Amount");
        l2.setHorizontalAlignment(4);
        this.eastPanel.add(l2);
        this.addButton = new HCPGreyButton("Sell");
        this.addButton.setToolTipText("KEY: enter");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("ADD");
        this.eastPanel.add(this.kTxtField);
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(this.addButton);
        HCPLabel l3 = new HCPLabel("Fiscal:  ");
        l3.setHorizontalAlignment(4);
        this.payButton = new HCPGreyButton("Pay");
        this.payButton.setToolTipText("KEY: ctrl+space");
        this.payButton.addActionListener(this);
        this.payButton.setActionCommand("PAY");
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(this.payButton);
        this.stornoAll = new HCPGreyButton("void all");
        this.stornoAll.setToolTipText("KEY: shift+backspace");
        this.stornoAll.addActionListener(this);
        this.stornoAll.setActionCommand("STORNO_ALL");
        this.stornoLast = new HCPGreyButton("void last");
        this.stornoLast.setToolTipText("KEY: ctrl+backspace");
        this.stornoLast.addActionListener(this);
        this.stornoLast.setActionCommand("STORNO_LAST");
        this.eastPanel.add(this.stornoAll);
        this.eastPanel.add(this.stornoLast);
        HCPGreyButton stornoSell = new HCPGreyButton("void selected");
        stornoSell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    new KeysDialog().setVisible(true);
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        this.eastPanel.add(stornoSell);
        HCPGreyButton rollPaper = new HCPGreyButton("roll paper");
        if (GlavniFrame.PRINTER) {
            this.eastPanel.add(rollPaper);
        }
        this.stanje = new HCPGreyButton("bill state");
        this.stanje.addActionListener(this);
        this.stanje.setActionCommand("STANJE");
        HCPGreyButton stanjeDI = new HCPGreyButton("Z state");
        stanjeDI.addActionListener(this);
        stanjeDI.setActionCommand("STANJE_D_I");
        this.eastPanel.add(stanjeDI);
        this.eastPanel.add(this.stanje);
        if (GlavniFrame.PRINTER) {
            HCPGreyButton dnevni = new HCPGreyButton("Z report");
            this.eastPanel.add(dnevni);
            HCPGreyButton presek = new HCPGreyButton("state report");
            this.eastPanel.add(presek);
            dnevni.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        FiscalCommands.printDailyReport();
                    }
                    catch (Exception e1) {
                        SysUtil.showError(e1);
                    }
                }
            });
            presek.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        FiscalCommands.printCurrentStateReport();
                    }
                    catch (Exception e1) {
                        SysUtil.showError(e1);
                    }
                }
            });
        }
        rollPaper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (GlavniFrame.PRINTER) {
                        FiscalCommands.execCommand(69);
                        return;
                    }
                    Command instance = Command.instance;
                    instance.reset();
                    int cmd = Command.ROLL_PAPER;
                    instance.setCmd(cmd);
                    PortSerial port = PortSerial.getInstance();
                    String s = TestProdajePanel.this.bcTxtField.getText();
                    if (s == null || s.length() == 0) {
                        instance.addByte(9);
                    } else {
                        switch (s.charAt(0)) {
                            case '1': {
                                instance.addByte(1);
                                break;
                            }
                            case '0': {
                                instance.addByte(0);
                                break;
                            }
                            default: {
                                instance.addByte(9);
                            }
                        }
                    }
                    port.sendFrame(instance);
                    port.receiveFrame(instance);
                    int ee = Command.instance.getArray()[0] & 0xFF;
                    int command = Command.instance.getCmd();
                    if (command != cmd && command != 128 && ee != 0) {
                        CommandsErrors.instanceMain.setError(ee);
                    }
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        HCPGreyButton cutPaper = new HCPGreyButton("cut paper");
        this.eastPanel.add(cutPaper);
        cutPaper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FiscalCommands.cutPaper();
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        if (GlavniFrame.PRINTER) {
            int cmd = 66;
            HCPGreyButton mode0Button = new HCPGreyButton("mode 0");
            mode0Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        Command instance = Command.instance;
                        instance.reset();
                        instance.setCmd(66);
                        instance.addByte(0);
                        PortSerial port = PortSerial.getInstance();
                        port.sendFrame(instance);
                        port.receiveFrame(instance);
                        int ee = Command.instance.getArray()[0] & 0xFF;
                        int command = Command.instance.getCmd();
                        if (command != 66 && command != 128 && ee != 0) {
                            CommandsErrors.instanceMain.setError(ee);
                        }
                    }
                    catch (Exception e1) {
                        SysUtil.showError(e1);
                    }
                }
            });
            this.eastPanel.add(mode0Button);
            HCPGreyButton mode1Button = new HCPGreyButton("mode 1");
            mode1Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        Command instance = Command.instance;
                        instance.reset();
                        instance.setCmd(66);
                        instance.addByte(1);
                        PortSerial port = PortSerial.getInstance();
                        port.sendFrame(instance);
                        port.receiveFrame(instance);
                        int ee = Command.instance.getArray()[0] & 0xFF;
                        int command = Command.instance.getCmd();
                        if (command != 66 && command != 128 && ee != 0) {
                            CommandsErrors.instanceMain.setError(ee);
                        }
                    }
                    catch (Exception e1) {
                        SysUtil.showError(e1);
                    }
                }
            });
            this.eastPanel.add(mode1Button);
        } else {
            this.eastPanel.add(new JComponent(){});
            this.eastPanel.add(new JComponent(){});
        }
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(new JLabel());
        this.eastPanel.add(new JLabel());
        this.add((Component)this.eastPanel, "East");
        this.scr = new JScrollPane(tt, 20, 31);
        this.scr.setBorder(new SoftBevelBorder(0));
        this.add((Component)this.scr, "Center");
        InputMap mapIn = this.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(10, 0), "e");
        mapIn.put(KeyStroke.getKeyStroke(32, 128), "s");
        mapIn.put(KeyStroke.getKeyStroke(112, 128), "1");
        mapIn.put(KeyStroke.getKeyStroke(113, 128), "2");
        mapIn.put(KeyStroke.getKeyStroke(8, 128), "l");
        mapIn.put(KeyStroke.getKeyStroke(8, 64), "a");
        mapIn.put(KeyStroke.getKeyStroke(40, 64), "open");
        mapIn.put(KeyStroke.getKeyStroke(38, 64), "beep");
        mapIn.put(KeyStroke.getKeyStroke(40, 128), "cut");
        mapIn.put(KeyStroke.getKeyStroke(38, 128), "roll");
        ActionMap actMap = this.getActionMap();
        actMap.put("beep", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FiscalCommands.execCommand(34);
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        actMap.put("cut", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FiscalCommands.execCommand(27);
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        actMap.put("open", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FiscalCommands.execCommand(Command.COMMAND_DRAWER_OPEN);
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        actMap.put("roll", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FiscalCommands.execCommand(28);
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        actMap.put("e", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (TestProdajePanel.this.bcTxtField.getText().length() <= 0) {
                    TestProdajePanel.this.bcTxtField.requestFocus();
                    return;
                }
                if (TestProdajePanel.this.kTxtField.getText().length() <= 0) {
                    TestProdajePanel.this.kTxtField.requestFocus();
                } else {
                    try {
                        TestProdajePanel.this.addPLUtest();
                    }
                    catch (Exception e1) {
                        SysUtil.showError(e1);
                    }
                }
            }
        });
        actMap.put("s", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    tt.payBill();
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        actMap.put("1", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TestProdajePanel.this.izvestaj();
            }
        });
        actMap.put("2", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TestProdajePanel.this.racuni();
            }
        });
        actMap.put("l", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    tt.stornoLast(0, 0);
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
        actMap.put("a", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    tt.stornoBILL();
                }
                catch (Exception e1) {
                    SysUtil.showError(e1);
                }
            }
        });
    }

    protected void racuni() {
        RacuniDialog rd = new RacuniDialog();
        rd.initialize();
    }

    protected void izvestaj() {
        IzvestajiDialog id = new IzvestajiDialog();
        id.initialize();
    }

    public void addPLUtest() throws Exception {
        int i;
        String pom1 = this.bcTxtField.getText();
        String pom2 = this.kTxtField.getText();
        if (pom1.length() <= 0 || pom2.length() <= 0) {
            return;
        }
        long p1 = 0L;
        pom2 = pom2.replace(',', '.');
        p1 = Long.parseLong(pom1);
        int p = (int)SysUtil.parseLong(pom2.replace(',', '.'), 3);
        PLU plu = null;
        if (p1 < 32000L) {
            i = 0;
            while (i < PLU.vec.size()) {
                if ((long)((PLU)PLU.vec.elementAt(i)).getCode() == p1) {
                    plu = (PLU)PLU.vec.elementAt(i);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < PLU.vec.size()) {
                if (((PLU)PLU.vec.elementAt(i)).getBarCode() == p1) {
                    plu = (PLU)PLU.vec.elementAt(i);
                }
                ++i;
            }
        }
        if (plu == null) {
            throw new Exception("Artikal is not in the table!");
        }
        PLUtest pt = new PLUtest(plu, p);
        this.bcTxtField.requestFocus(true);
        this.bcTxtField.setText("");
        this.kTxtField.setText("");
        if (!GlavniFrame.PRINTER) {
            pt.prodaj();
        }
        long pom = 0L;
        Enumeration e = PLUtest.vec.elements();
        while (e.hasMoreElements()) {
            pom += ((PLUtest)e.nextElement()).getVrednost();
        }
        pt.saleByCode = true;
        pt.prodaj();
        String str = TestTableModel.dformat.format((double)pom / 100.0);
        uTxtField.setText(str);
        PLUtest.vec.addElement(pt);
        tt.revalidate();
        tt.repaint();
    }

    private String getCenaString(int cena) {
        String old;
        String newPrice = old = "" + cena;
        if (cena < 10) {
            newPrice = "0,0" + newPrice;
            return newPrice;
        }
        if (cena < 100) {
            newPrice = "0," + newPrice;
            return newPrice;
        }
        newPrice = String.valueOf(newPrice.substring(0, newPrice.length() - 2)) + ',' + newPrice.substring(newPrice.length() - 2, newPrice.length());
        if (cena > 100000) {
            newPrice = String.valueOf(newPrice.substring(0, newPrice.length() - 6)) + '.' + newPrice.substring(newPrice.length() - 6, newPrice.length());
        }
        if (cena > 100000000) {
            newPrice = String.valueOf(newPrice.substring(0, newPrice.length() - 10)) + '.' + newPrice.substring(newPrice.length() - 10, newPrice.length());
        }
        return newPrice;
    }

    private String getKolicinaString(int cena) {
        String old;
        String newPrice = old = "" + cena;
        newPrice = cena < 10 ? "0,00" + newPrice : (cena < 100 ? "0,0" + newPrice : (cena < 1000 ? "0," + newPrice : String.valueOf(newPrice.substring(0, newPrice.length() - 3)) + ',' + newPrice.substring(newPrice.length() - 3, newPrice.length())));
        while (newPrice.charAt(newPrice.length() - 1) == '0') {
            newPrice = newPrice.substring(0, newPrice.length() - 1);
        }
        while (newPrice.charAt(newPrice.length() - 1) == ',') {
            newPrice = newPrice.substring(0, newPrice.length() - 1);
        }
        return newPrice;
    }

    public void TEST_addPLUtest(PLU plu, int finance) throws Exception {
        PLUtest pt = new PLUtest(plu, finance);
        if (pt.getVrednost() <= 0L) {
            return;
        }
        pt.TEST_prodaj(plu);
        PLUtest.vec.addElement(pt);
        String str = TestTableModel.dformat.format((double)(TEST_fullValue += pt.getVrednost()) / 100.0);
        uTxtField.setText(str);
        tt.revalidate();
        tt.repaint();
    }

    public void sendDiscount() throws SerialPortException, CommandsErrors {
        String s = uTxtField.getText();
        if (s == null || s.length() < 2) {
            return;
        }
        boolean procent = false;
        boolean pay = false;
        if (s.charAt(0) == 'p') {
            pay = true;
            s = s.substring(1);
        }
        if (s.charAt(0) == '%') {
            procent = true;
            s = s.substring(1);
        }
        boolean negative = false;
        if (s.charAt(0) == '-') {
            negative = true;
            s = s.substring(1);
        }
        if (s.length() == 0) {
            return;
        }
        long value = Long.parseLong(s);
        value &= 0xFFFFFFFFFFFFL;
        value <<= 8;
        Command command = Command.instance;
        command.reset();
        command.setCmd(48);
        if (procent) {
            value |= 1L;
        }
        if (negative) {
            value |= 2L;
        }
        if (pay) {
            value |= 4L;
        }
        command.addLong(value);
        command.setPos(7);
        command.setLength(7);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(command);
        port.receiveFrame(command);
        int e = command.getArray()[0] & 0xFF;
        int cmd = command.getCmd();
        if (cmd != 48 && cmd != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("ADD")) {
                this.addPLUtest();
            } else {
                if (s.equalsIgnoreCase("DISCOUNT")) {
                    this.sendDiscount();
                    return;
                }
                if (s.equalsIgnoreCase("PAY")) {
                    tt.payBill();
                } else if (s.equalsIgnoreCase("I1")) {
                    this.izvestaj();
                } else if (s.equalsIgnoreCase("I2")) {
                    this.racuni();
                } else if (s.equalsIgnoreCase("STORNO_ALL")) {
                    tt.stornoBILL();
                } else if (s.equalsIgnoreCase("STORNO_LAST")) {
                    String pom1 = this.bcTxtField.getText();
                    String pom2 = this.kTxtField.getText();
                    this.bcTxtField.setText("");
                    this.kTxtField.setText("");
                    this.bcTxtField.revalidate();
                    this.kTxtField.revalidate();
                    this.bcTxtField.repaint();
                    this.kTxtField.repaint();
                    if (pom1.length() <= 0 || pom2.length() <= 0) {
                        tt.stornoLast(0, 100);
                    } else {
                        long p1 = 0L;
                        pom2 = pom2.replace(',', '.');
                        p1 = Long.parseLong(pom1);
                        int p = (int)SysUtil.parseLong(pom2.replace(',', '.'), 3);
                        tt.stornoLast((int)p1, p);
                    }
                } else if (s.equalsIgnoreCase("START")) {
                    this.startTesting();
                } else if (s.equalsIgnoreCase("STOP")) {
                    this.stopTesting();
                } else if (s.equalsIgnoreCase("STANJE")) {
                    new StateDialog();
                } else if (s.equalsIgnoreCase("STANJE_D_I")) {
                    new StateDIDialog();
                } else if (s.equalsIgnoreCase("SUBSUM")) {
                    FiscalCommands.execCommand(Command.DISPLAY_SHOW_SUBSUM);
                } else if (s.equalsIgnoreCase("RABAT_MARZA")) {
                    this.rabatMarza();
                }
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
        }
        tt.revalidate();
        tt.repaint();
    }

    private void rabatMarza() throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(65);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 65 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int rabat = instance.getShort(0);
        int marza = instance.getShort(2);
        RabatMarzaDialog rmd = new RabatMarzaDialog(rabat, marza);
        if (rmd.value <= 0 || rmd.option < 0) {
            return;
        }
        if (rmd.value > 10000) {
            CommandsErrors.instanceMain.setError(21);
        }
        instance.reset();
        instance.setCmd(65);
        rabat = rmd.option == 0 ? rmd.value : 0;
        instance.addShort(rabat);
        marza = rmd.option == 1 ? rmd.value : 0;
        instance.addShort(marza);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        e = instance.getArray()[0] & 0xFF;
        command = instance.getCmd();
        if (command != 65 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void display(String row1, String row2) throws Exception {
        Command instance = Command.bigInstance;
        ProcessingDialog pd = ProcessingDialog.getInstance();
        PortSerial port = PortSerial.getInstance();
        if (row1.length() > 20) {
            row1 = row1.substring(0, 20);
        }
        if (row2.length() > 20) {
            row2 = row2.substring(0, 20);
        }
        pd.setInstanceVisible(true);
        try {
            instance.reset();
            instance.setCmd(Command.DISPLAY_PRINT);
            String str = row1;
            while (str.length() < 20) {
                str = String.valueOf(str) + ' ';
            }
            str = String.valueOf(str) + row2;
            while (str.length() < 40) {
                str = String.valueOf(str) + ' ';
            }
            SysUtil.formatForSend(str, instance);
            port.sendFrame(instance);
            instance = port.receiveFrame();
            int e = instance.getArray()[0] & 0xFF;
            if (Command.DISPLAY_PRINT != instance.getCmd() && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private void stopTesting() throws Exception {
        if (this.runner == null) {
            throw new Exception("Testiranje nije u toku");
        }
        this.runner.status = false;
        this.runner = null;
    }

    private void startTesting() throws Exception {
        if (PLU.vec.size() <= 0) {
            throw new Exception("Tabela artikala je prazna!");
        }
        int stope = 0;
        int i = 0;
        while (i < FiscallObjects.poreskeStope.length) {
            stope += FiscallObjects.poreskeStope[i].vrednost;
            ++i;
        }
        if (stope <= 0) {
            throw new Exception("Tabela poreskih stopa je prazna!");
        }
        if (this.runner == null) {
            String sss = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)"Unesi prosecan broj racuna po dn.iz.(5-100)");
            if (sss == null || sss.length() <= 0) {
                return;
            }
            billNumber = Integer.parseInt(sss);
            if (billNumber <= 0 || billNumber > 100) {
                throw new Exception("Wrong input");
            }
            sss = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)"Unesi prosecan broj stavki po racunu.(2-200)");
            if (sss == null || sss.length() <= 0) {
                return;
            }
            itemNumber = Integer.parseInt(sss);
            if (itemNumber <= 1 || itemNumber > 200) {
                throw new Exception("Wrong input");
            }
            if (useBarcode.isSelected()) {
                BarcodePort.barcodePort = (String)this.comboBarcodePort.getSelectedItem();
            }
        } else {
            throw new Exception("Testiranje je u toku");
        }
        this.runner = new TestingThread();
    }

    public static long readBillAmount() throws Exception {
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(56);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (Command.instance.getCmd() != 56 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        return instance.getLong(0);
    }

    private class TestingThread
    extends Thread {
        public boolean status = true;
        private int numDaily = 0;
        private int numBill = 1;

        public TestingThread() {
            this.start();
        }

        private synchronized void waitForNotification(int time) {
            try {
                this.wait(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            int counter = 0;
            while (this.status) {
                try {
                    double d = Math.random();
                    int t = (int)(d * d * d * (double)itemNumber);
                    if (t <= 0 || t > itemNumber) {
                        t = itemNumber;
                    }
                    System.out.print("##### Broj sledeceg racuna je: " + this.numBill++ + '\t');
                    System.out.print("Broj stavki u sledecem racunu je: " + t + '\r' + '\n');
                    int i = 0;
                    while (i < t) {
                        try {
                            this.createArt();
                        }
                        catch (Exception e) {
                            System.out.print("Uhvacena greska na artiklu: " + e.getClass().toString() + " : " + e.getMessage());
                            break;
                        }
                        ++i;
                    }
                    if (TestProdajePanel.readBillAmount() != tt.getBillPrice()) {
                        System.out.println("!!!!!GRESKA.....Ocekivana cena nije ista.......");
                        System.out.println("r1= " + TestProdajePanel.readBillAmount());
                        System.out.println("r2= " + tt.getBillPrice());
                        System.out.println(PLUtest.vec);
                        System.out.println(PLUtest.vec.elements());
                        return;
                    }
                    try {
                        tt.TEST_plati();
                    }
                    catch (Exception e) {
                        System.out.print("Uhvacena greska na placanju: " + e.getClass().toString() + " : " + e.getMessage());
                        try {
                            counter = 0;
                            this.uradiDnevni();
                            continue;
                        }
                        catch (Exception e1) {
                            System.out.print("Uhvacena greska na dnevnom izvestaju: " + e1.getMessage());
                            break;
                        }
                    }
                    if (++counter > 0 && counter < billNumber) continue;
                    try {
                        counter = 0;
                        this.uradiDnevni();
                    }
                    catch (Exception e1) {
                        System.out.print("Uhvacena greska na dnevnom izvestaju1: " + e1.getMessage());
                        break;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            try {
                this.uradiDnevni();
            }
            catch (Exception e1) {
                System.out.print("Uhvacena greska na dnevnom izvestaju2: " + e1.getMessage());
            }
            this.waitForNotification(60000);
            tt.revalidate();
            tt.repaint();
        }

        private synchronized void createArt() throws Exception {
            int code = (int)(Math.random() * (double)PLU.vec.size());
            PLU plu = (PLU)PLU.vec.elementAt(code);
            int finance = 0;
            finance = (int)(Math.random() * 9999.0);
            long ff = (long)finance * (long)plu.getCena();
            if ((ff = SysUtil.round(ff, 5)) == 0L) {
                ff += 10000L;
            }
            int t = plu.getPoreskaStopa();
            t = FiscallObjects.poreskeStope[t].vrednost;
            if (t != 0 && (ff = ff * (long)t / 100L) == 0L) {
                ff += 10000L;
            }
            TestProdajePanel.this.TEST_addPLUtest(plu, finance);
        }

        private synchronized void uradiDnevni() throws Exception {
            if (!TestProdajePanel.this.USEDAILY) {
                return;
            }
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(88);
            PortSerial port = PortSerial.getInstance();
            System.out.println("*****");
            System.out.println("***** Dnevni izvestaj broj: " + ++this.numDaily);
            System.out.println("*****");
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 88 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }
}

