/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPfileChooser;
import gui.HelpLabel;
import gui.ProcessingDialog;
import gui.SavePanel;
import gui.rightPanels.RightPanel;
import hcp.bmpParser.BmpFileToObject;
import hcp.bmpParser.BmpImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.Settings;
import objects.lang.LanguageStrings;
import tables.zagRekPomTable.RekPomTable;
import tables.zagRekTable.TableZagRek;
import util.comPort.PortSerial;

public final class ReklamaPanel
extends RightPanel
implements ActionListener {
    private SavePanel sp;
    private JPanel tp;
    private JPanel bp1;
    private JPanel bp2;
    private HCPGreyButton sZag;
    private HCPGreyButton sRek;
    private HCPGreyButton printPics;
    private HCPGreyButton setPic;
    private HCPGreyButton sendPic;
    private HCPGreyButton resetPic;
    public static TableZagRek t;
    public static RekPomTable rpt;
    private SpringLayout sl;
    private BmpImage bi;
    public ToolsThread runner;

    public ReklamaPanel() {
        super(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON"), 'R', LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(10, 10));
        this.sp = new SavePanel(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_LABEL"));
        this.runner = new ToolsThread();
        this.tp = new JPanel();
        this.tp.setPreferredSize(new Dimension(590, 300));
        this.tp.setBackground(HCPColors.getColorM2st());
        this.tp.setOpaque(false);
        t = new TableZagRek(false);
        t.setPreferredSize(new Dimension(410, 280));
        rpt = new RekPomTable();
        rpt.setPreferredSize(new Dimension(130, 240));
        if (GlavniFrame.PRINTER) {
            rpt.setPreferredSize(new Dimension(130, 32));
        }
        this.sl = new SpringLayout();
        this.bp1 = new JPanel();
        this.bp1.setOpaque(false);
        this.bp1.setLayout(new GridLayout(1, 3, 15, 15));
        this.bp1.setPreferredSize(new Dimension(590, 40));
        this.bp1.setIgnoreRepaint(true);
        this.bp1.setBackground(HCPColors.getColorM2st());
        this.bp1.setBorder(new EmptyBorder(5, 15, 5, 15));
        this.bp2 = new JPanel();
        this.bp2.setOpaque(false);
        this.bp2.setLayout(new GridLayout(1, 3, 15, 15));
        this.bp2.setPreferredSize(new Dimension(590, 40));
        this.bp2.setIgnoreRepaint(true);
        this.bp2.setBackground(HCPColors.getColorM2st());
        this.bp2.setBorder(new EmptyBorder(5, 15, 5, 15));
        ImageIcon slikaComp = new ImageIcon("images/ComputerSmall.png");
        ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
        ImageIcon slikaPrint = new ImageIcon("images/print.png");
        this.setPic = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_SET_PICTURE"));
        this.setPic.setIcon(slikaComp);
        this.setPic.setToolTipText("");
        this.setPic.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_SET_PICTURE_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_SET_PICTURE_TOOLTIP_2") + "<br>" + LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_SET_PICTURE_TOOLTIP_1") + "<br></html>");
        this.setPic.addActionListener(this);
        this.setPic.setActionCommand("SETPIC");
        this.bp1.add(this.setPic);
        this.sendPic = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_SEND_PICTURE"));
        this.sendPic.setToolTipText(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_SEND_PICTURE_TOOLTIP"));
        this.sendPic.setIcon(slikaCash);
        this.sendPic.addActionListener(this);
        this.sendPic.setActionCommand("SENDPIC");
        this.bp1.add(this.sendPic);
        this.resetPic = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_RESET_ALL"));
        this.resetPic.setToolTipText(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_RESET_ALL_TOOLTIP"));
        this.resetPic.setIcon(slikaCash);
        this.resetPic.addActionListener(this);
        this.resetPic.setActionCommand("RESETPIC");
        this.bp1.add(this.resetPic);
        this.printPics = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_PRINT_PICTURES"));
        this.printPics.setToolTipText(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_PRINT_PICTURES_TOOLTIP"));
        this.printPics.setIcon(slikaPrint);
        this.printPics.addActionListener(this);
        this.printPics.setActionCommand("PRINTPIC");
        this.bp2.add(this.printPics);
        this.sZag = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_PRINT_HEADER"));
        this.sZag.setToolTipText(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_PRINT_HEADER_TOOLTIP"));
        this.sZag.setIcon(slikaPrint);
        this.sZag.addActionListener(this);
        this.sZag.setActionCommand("SZAG");
        this.bp2.add(this.sZag);
        this.sRek = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_PRINT_ADVERTISEMENT"));
        this.sRek.setToolTipText(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_BUTTON_PRINT_ADVERTISEMENT_TOOLTIP"));
        this.sRek.setIcon(slikaPrint);
        this.sRek.addActionListener(this);
        this.sRek.setActionCommand("SREK");
        this.bp2.add(this.sRek);
        this.tp.setLayout(this.sl);
        this.sl.putConstraint("North", (Component)this.bp1, 10, "North", (Component)this.tp);
        this.sl.putConstraint("West", (Component)this.bp1, 0, "West", (Component)this.tp);
        this.tp.add(this.bp1);
        this.sl.putConstraint("North", (Component)this.bp2, 380, "North", (Component)this.tp);
        this.sl.putConstraint("West", (Component)this.bp2, 0, "West", (Component)this.tp);
        this.tp.add(this.bp2);
        this.sl.putConstraint("North", (Component)t, 80, "North", (Component)this.tp);
        this.sl.putConstraint("West", (Component)t, 15, "West", (Component)this.tp);
        this.tp.add(t);
        this.sl.putConstraint("North", (Component)rpt, 100, "North", (Component)this.tp);
        this.sl.putConstraint("West", (Component)rpt, 20, "East", (Component)t);
        this.tp.add(rpt);
        this.add((Component)this.tp, "West");
        this.add((Component)this.sp, "North");
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout(10, 10));
        outerPanel.setIgnoreRepaint(true);
        outerPanel.setBackground(HCPColors.getColorM2st());
        outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_HELP_LABEL")), "North");
        this.add((Component)outerPanel, "Center");
        JPanel inPanel = new JPanel();
        inPanel.setLayout(new BorderLayout(10, 10));
        inPanel.setIgnoreRepaint(true);
        inPanel.setBackground(HCPColors.getColorM2st());
        inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea text = new JTextArea();
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        text.setFont(GlavniFrame.font);
        text.setText(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_HELP_TEXT_0"));
        int i = 1;
        try {
            while (true) {
                text.append("\r\n\r\n");
                text.append(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_HELP_TEXT_" + i++));
            }
        }
        catch (Exception exception) {
            JScrollPane scrText = new JScrollPane(text, 20, 31);
            inPanel.add((Component)scrText, "Center");
            outerPanel.add((Component)inPanel, "Center");
            if (GlavniFrame.BEST_LC) {
                this.setPic.setEnabled(false);
                this.sendPic.setEnabled(false);
                this.printPics.setEnabled(false);
            }
            return;
        }
    }

    private void printPic() throws Exception {
        PortSerial serial = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(45);
        serial.sendFrame(Command.instance);
        serial.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 45 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private void resetAll() throws Exception {
        block3: {
            try {
                PortSerial serial = PortSerial.getInstance();
                Command.instance.reset();
                Command.instance.setCmd(46);
                serial.sendFrame(Command.instance);
                serial.receiveFrame(Command.instance);
                int e = Command.instance.getArray()[0] & 0xFF;
                int command = Command.instance.getCmd();
                if (command != 46 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("Time out") >= 0) break block3;
                throw e;
            }
        }
    }

    private void setPic() {
        HCPfileChooser fc = new HCPfileChooser("bmp", this);
        File file = fc.openFile();
        if (file == null) {
            return;
        }
        BmpFileToObject bfto = new BmpFileToObject(file);
        if (bfto == null) {
            return;
        }
        try {
            this.bi = bfto.getImage();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage());
            this.bi = null;
            return;
        }
        if (this.bi != null) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_OK_PICTURE"));
            return;
        }
    }

    private void sendPic() throws Exception {
        if (this.bi == null) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_NO_PICTURE"));
            return;
        }
        int x = this.bi.getSizex();
        int y = this.bi.getSizey();
        byte[] array = this.bi.getMatrix();
        if (x * y == 0 || array == null) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_NO_PICTURE"));
            return;
        }
        boolean center = false;
        if (JOptionPane.showConfirmDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_CENTER"), "CENTER", 0) == 0) {
            center = true;
        }
        ProcessingDialog.getInstance().setInstanceVisible(true);
        try {
            byte t;
            int cash;
            int n = cash = Settings.getInstance().getCash().equalsIgnoreCase("BEST") ? 25 : 32;
            if (GlavniFrame.PRINTER) {
                cash = 48;
            }
            int VEL = cash;
            byte[] ab = new byte[VEL];
            byte[] ab0 = new byte[VEL];
            int i = 0;
            while (i < VEL) {
                ab0[i] = -1;
                ++i;
            }
            int pos = 0;
            int pom = cash - x / 8;
            pom /= 2;
            PortSerial serial = PortSerial.getInstance();
            Command.instance.reset();
            Command.instance.setCmd(47);
            int cmd = 47;
            if (GlavniFrame.PRINTER) {
                Command.instance.setCmd(75);
                cmd = 75;
            }
            serial.sendFrame(Command.instance);
            serial.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != cmd && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            if ((t = Command.instance.getArray()[8]) == 0) {
                throw new Exception(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_CASH_IS_FULL"));
            }
            int yy = 0;
            while (yy < 8) {
                int p = 1 << yy;
                if ((t & p) != 0) break;
                ++yy;
            }
            pos = array.length;
            pos -= x / 8;
            int size = x / 8;
            int i2 = 0;
            while (i2 < y) {
                System.arraycopy(ab0, 0, ab, 0, VEL);
                System.arraycopy(array, pos, ab, center ? pom : 0, x / 8);
                int ii = 0;
                while (ii < VEL) {
                    ab[ii] = ~ab[ii];
                    ++ii;
                }
                pos -= size;
                Command.instance.reset();
                Command.instance.setCmd(43);
                cmd = 43;
                if (GlavniFrame.PRINTER) {
                    Command.instance.setCmd(73);
                    cmd = 73;
                }
                Command.instance.addByte(yy);
                Command.instance.addByte(i2);
                Command.instance.addToArray(ab, 0, VEL);
                serial.sendFrame(Command.instance);
                serial.receiveFrame(Command.instance);
                int e1 = Command.instance.getArray()[0] & 0xFF;
                int command1 = Command.instance.getCmd();
                if (command1 != cmd && command1 != 128 && e1 != 0) {
                    CommandsErrors.instanceMain.setError(e1);
                }
                ++i2;
            }
            Command.instance.reset();
            Command.instance.setCmd(44);
            cmd = 44;
            if (GlavniFrame.PRINTER) {
                Command.instance.setCmd(74);
                cmd = 74;
            }
            Command.instance.addByte(yy);
            Command.instance.addByte(y);
            serial.sendFrame(Command.instance);
            serial.receiveFrame(Command.instance);
            int e2 = Command.instance.getArray()[0] & 0xFF;
            int command2 = Command.instance.getCmd();
            if (command2 != cmd && command2 != 128 && e2 != 0) {
                CommandsErrors.instanceMain.setError(e2);
            }
            this.bi = null;
            ProcessingDialog.getInstance().setInstanceVisible(false);
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }
        finally {
            ProcessingDialog.getInstance().setInstanceVisible(false);
        }
    }

    private void stampajRekl() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(25);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 25 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private void stampajZagl() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(24);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 24 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("SZAG")) {
                this.runner.setJob(1);
            } else if (s.equalsIgnoreCase("SREK")) {
                this.runner.setJob(2);
            } else if (s.equalsIgnoreCase("SETPIC")) {
                this.runner.setJob(4);
            } else if (s.equalsIgnoreCase("SENDPIC")) {
                this.runner.setJob(5);
            } else if (s.equalsIgnoreCase("RESETPIC")) {
                this.runner.setJob(6);
            } else if (s.equalsIgnoreCase("PRINTPIC")) {
                this.runner.setJob(3);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    private class ToolsThread
    extends Thread {
        public static final byte STAMPAJ_ZAGLAVLJE = 1;
        public static final byte STAMPAJ_REKLAME = 2;
        public static final byte STAMPAJ_SLIKE = 3;
        public static final byte ODABERI_SLIKU = 4;
        public static final byte POSALJI_SLIKU = 5;
        public static final byte RESETUJ_SLIKE = 6;
        private int job = 0;

        public ToolsThread() {
            this.start();
        }

        public final synchronized void setJob(int j) throws Exception {
            if (this.job != 0) {
                throw new Exception(LanguageStrings.getProgramIsBusy());
            }
            this.job = j;
            this.notify();
        }

        public final synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            ReklamaPanel.this.stampajZagl();
                            break;
                        }
                        case 2: {
                            ReklamaPanel.this.stampajRekl();
                            break;
                        }
                        case 3: {
                            ReklamaPanel.this.printPic();
                            break;
                        }
                        case 4: {
                            ReklamaPanel.this.setPic();
                            break;
                        }
                        case 5: {
                            ReklamaPanel.this.sendPic();
                            break;
                        }
                        case 6: {
                            ReklamaPanel.this.resetAll();
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }
    }
}

