/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.FiscalCommands;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPfileChooser;
import gui.HelpLabel;
import gui.SavePanel;
import gui.TimeChooserDialog;
import gui.rightPanels.RightPanel;
import hcp.constants.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.FiscallObjects;
import objects.lang.LanguageStrings;
import objects.wrappers.FiscallObjectsWrapper;
import tables.PSJMOTables.TablePS;

public final class PoreskeStopePanel
extends RightPanel
implements ActionListener {
    private JPanel tp;
    private JPanel outerPanel;
    private JPanel inPanel;
    private JPanel buttonPanel;
    private JScrollPane scr;
    private SavePanel sp;
    public static TablePS tps;
    private HCPGreyButton readBinFile;
    private HCPGreyButton writeBinFile;
    public LoginThread runner = new LoginThread();

    public PoreskeStopePanel() {
        super(LanguageStrings.getInstance().getStringByName("VATS_PANEL_BUTTON"), 'P', LanguageStrings.getInstance().getStringByName("VATS_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(10, 10));
        this.sp = new SavePanel(LanguageStrings.getInstance().getStringByName("VATS_PANEL_LABEL"));
        this.tp = new JPanel(new BorderLayout(10, 10));
        tps = new TablePS();
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout(10, 10));
        this.outerPanel.setIgnoreRepaint(true);
        this.outerPanel.setBackground(HCPColors.getColorM2st());
        this.outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("VATS_PANEL_HELP_LABEL")), "North");
        this.add((Component)this.outerPanel, "Center");
        this.inPanel = new JPanel();
        this.inPanel.setLayout(new BorderLayout(10, 10));
        this.inPanel.setIgnoreRepaint(true);
        this.inPanel.setBackground(HCPColors.getColorM2st());
        this.inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea text = new JTextArea();
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        text.setFont(GlavniFrame.font);
        text.setText(LanguageStrings.getInstance().getStringByName("VATS_PANEL_HELP_TEXT_0"));
        int i = 1;
        try {
            while (true) {
                text.append("\r\n\r\n");
                text.append(LanguageStrings.getInstance().getStringByName("VATS_PANEL_HELP_TEXT_" + i++));
            }
        }
        catch (Exception exception) {
            ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
            this.buttonPanel = new JPanel(new GridLayout(1, 2, 30, 30));
            this.buttonPanel.setPreferredSize(new Dimension(507, 60));
            this.buttonPanel.setBackground(HCPColors.getColorM2st());
            this.buttonPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 30, 15, 30)));
            this.readBinFile = new HCPGreyButton("Read binary file");
            this.readBinFile.addActionListener(this);
            this.readBinFile.setActionCommand("READ");
            this.readBinFile.setIcon(slikaCash);
            this.buttonPanel.add(this.readBinFile);
            this.writeBinFile = new HCPGreyButton("Write to binary file");
            this.writeBinFile.addActionListener(this);
            this.writeBinFile.setActionCommand("WRITE");
            this.writeBinFile.setIcon(slikaCash);
            this.buttonPanel.add(this.writeBinFile);
            JPanel printPanel = new JPanel(new GridLayout(1, 2, 30, 30));
            printPanel.setPreferredSize(new Dimension(507, 60));
            printPanel.setBackground(HCPColors.getColorM2st());
            printPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 30, 15, 30)));
            HCPGreyButton printButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_PRINT_SETTINGS"));
            printButton.setToolTipText(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_PRINT_SETTINGS_TOOLTIP"));
            printButton.addActionListener(this);
            printButton.setActionCommand("PRINT");
            printButton.setIcon(slikaCash);
            printPanel.add(printButton);
            printPanel.add(new JLabel());
            JScrollPane scrText = new JScrollPane(text, 20, 31);
            this.inPanel.add((Component)scrText, "Center");
            this.outerPanel.add((Component)this.inPanel, "Center");
            this.scr = new JScrollPane(tps, 20, 31);
            this.scr.setBorder(new SoftBevelBorder(0));
            this.tp.add((Component)this.scr, "Center");
            this.add((Component)this.tp, "West");
            this.add((Component)this.sp, "North");
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("READ")) {
                this.runner.setJob(1);
            } else if (s.equalsIgnoreCase("WRITE")) {
                this.runner.setJob(2);
            } else if (s.equalsIgnoreCase("PRINT")) {
                this.runner.setJob(3);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    private class LoginThread
    extends Thread {
        public static final byte READ = 1;
        public static final byte WRITE = 2;
        public static final byte PRINT = 3;
        private int job = 0;

        public LoginThread() {
            this.start();
        }

        public final synchronized void setJob(int j) throws Exception {
            if (this.job != 0) {
                throw new Exception(LanguageStrings.getProgramIsBusy());
            }
            this.job = j;
            this.notify();
        }

        public final synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            this.readFile();
                            break;
                        }
                        case 2: {
                            this.writeFile();
                            break;
                        }
                        case 3: {
                            FiscalCommands.execCommand(33);
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }

        private void readFile() throws Exception {
            int len;
            HCPfileChooser fc = new HCPfileChooser("bin");
            fc.setAcceptAllFileFilterUsed(true);
            File file = fc.openFile();
            if (file == null) {
                return;
            }
            FileInputStream inStream = new FileInputStream(file);
            byte[] b = new byte[18];
            int pos = 0;
            while ((len = ((InputStream)inStream).read(b, pos, b.length - pos)) > 0) {
                if ((pos += len) == b.length) break;
            }
            int i = 0;
            while (i < Constants.VATS_MAX_NUMBER) {
                int pomi = 0;
                pomi = b[i * 2] & 0xFF;
                FiscallObjects.poreskeStope[i].vrednost = pomi |= (b[i * 2 + 1] & 0xFF) << 8;
                FiscallObjects.poreskeStope[i].pravaVrednost = (double)pomi / 100.0;
                ++i;
            }
            Calendar cal = (Calendar)Calendar.getInstance().clone();
            long time = 0L;
            int pom = 0;
            int i2 = 0;
            while (i2 < 4) {
                pom = ((InputStream)inStream).read();
                time |= (long)(pom <<= i2 * 8);
                ++i2;
            }
            time *= 1000L;
            time += 946684800000L;
            time -= (long)(FiscallObjectsWrapper.getADDER(time) * 3600000);
            cal.setTimeInMillis(time);
            tps.revalidate();
            tps.repaint();
            JOptionPane.showMessageDialog(tps, "Table time: " + cal.getTime().toString());
        }

        private void writeFile() throws Exception {
            HCPfileChooser fc = new HCPfileChooser("bin");
            fc.setAcceptAllFileFilterUsed(true);
            File file = fc.saveFile();
            if (file == null) {
                return;
            }
            byte[] b = new byte[18];
            int t = 0;
            int i = 0;
            while (i < Constants.VATS_MAX_NUMBER) {
                int pomi = FiscallObjects.poreskeStope[i].vrednost;
                b[i * 2] = (byte)pomi;
                b[i * 2 + 1] = (byte)(pomi >>= 8);
                ++i;
            }
            TimeChooserDialog tc = new TimeChooserDialog();
            long time = tc.getTime();
            if (time <= 0L) {
                return;
            }
            time += (long)(FiscallObjectsWrapper.getADDER(time) * 3600000);
            t = (int)((time -= 946684800000L) / 1000L);
            FileOutputStream out = null;
            if (file.exists()) {
                file.delete();
            }
            try {
                out = new FileOutputStream(file);
                out.write(b);
                int i2 = 0;
                while (i2 < 4) {
                    out.write(t >>> i2 * 8);
                    ++i2;
                }
                out.flush();
            }
            finally {
                out.close();
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }
    }
}

