/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HelpLabel;
import gui.SavePanel;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.Kasiri;
import objects.lang.LanguageStrings;
import tables.kasiriTable.TableKasiri;
import util.comPort.PortSerial;

public final class KasiriPanel
extends RightPanel
implements ActionListener {
    private JPanel tp;
    private JPanel outerPanel;
    private JPanel inPanel;
    private JPanel loginPanel;
    private JScrollPane scr;
    private SavePanel sp;
    public static TableKasiri tk;
    private HCPGreyButton loginButton;
    private HCPGreyButton logoutButton;
    private HCPGreyButton resetButton;
    private HCPGreyButton printButton;
    public LoginThread runner = new LoginThread();

    public KasiriPanel() {
        super(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_BUTTON"), 'K', LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(10, 10));
        this.sp = new SavePanel(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LABEL"));
        this.tp = new JPanel(new BorderLayout(5, 5));
        this.tp.setOpaque(false);
        tk = new TableKasiri();
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout(10, 10));
        this.outerPanel.setIgnoreRepaint(true);
        this.outerPanel.setBackground(HCPColors.getColorM2st());
        this.outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_HELP_LABEL")), "North");
        this.add((Component)this.outerPanel, "Center");
        this.inPanel = new JPanel();
        this.inPanel.setIgnoreRepaint(true);
        this.inPanel.setLayout(new BorderLayout(10, 10));
        this.inPanel.setBackground(HCPColors.getColorM2st());
        this.inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea text = new JTextArea();
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        text.setFont(GlavniFrame.font);
        text.setText(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_HELP_TEXT_0"));
        int i = 1;
        try {
            while (true) {
                text.append("\r\n\r\n");
                text.append(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_HELP_TEXT_" + i++));
            }
        }
        catch (Exception exception) {
            ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
            this.loginPanel = new JPanel(new GridLayout(2, 2, 5, 5));
            this.loginPanel.setPreferredSize(new Dimension(507, 66));
            this.loginPanel.setBackground(HCPColors.getColorM2st());
            this.loginPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
            this.loginButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LOGIN"));
            this.loginButton.setToolTipText(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LOGIN_TOOLTIP"));
            this.loginButton.addActionListener(this);
            this.loginButton.setActionCommand("LOGIN");
            this.loginButton.setIcon(slikaCash);
            this.loginPanel.add(this.loginButton);
            this.logoutButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LOGOUT"));
            this.logoutButton.setToolTipText(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LOGOUT_TOOLTIP"));
            this.logoutButton.addActionListener(this);
            this.logoutButton.setActionCommand("LOGOUT");
            this.logoutButton.setIcon(slikaCash);
            this.loginPanel.add(this.logoutButton);
            this.resetButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_RESET"));
            this.resetButton.setToolTipText(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_RESET_TOOLTIP"));
            this.resetButton.addActionListener(this);
            this.resetButton.setActionCommand("RESET");
            this.resetButton.setIcon(slikaCash);
            this.loginPanel.add(this.resetButton);
            this.printButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_PRINT"));
            this.printButton.setToolTipText(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_PRINT_TOOLTIP"));
            this.printButton.addActionListener(this);
            this.printButton.setActionCommand("PRINT");
            this.printButton.setIcon(slikaCash);
            this.loginPanel.add(this.printButton);
            if (!GlavniFrame.PRINTER) {
                this.printButton.setEnabled(false);
                this.resetButton.setEnabled(false);
            }
            this.tp.add((Component)this.loginPanel, "South");
            JScrollPane scrText = new JScrollPane(text, 20, 31);
            this.inPanel.add((Component)scrText, "Center");
            this.outerPanel.add((Component)this.inPanel, "Center");
            this.scr = new JScrollPane(tk, 20, 31);
            this.scr.setBorder(new SoftBevelBorder(0));
            this.tp.add((Component)this.scr, "Center");
            this.add((Component)this.tp, "West");
            this.add((Component)this.sp, "North");
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("LOGIN")) {
                this.runner.setJob(1);
            } else if (s.equalsIgnoreCase("LOGOUT")) {
                this.runner.setJob(2);
            } else if (s.equalsIgnoreCase("RESET")) {
                this.runner.setJob(3);
            } else if (s.equalsIgnoreCase("PRINT")) {
                this.runner.setJob(4);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    public void reset() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(Command.CASHIERS_RESETS);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != Command.CASHIERS_RESETS && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
    }

    public void print() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(Command.CASHIERS_PRINT);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != Command.CASHIERS_PRINT && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
    }

    private class LoginThread
    extends Thread {
        public static final byte LOGIN = 1;
        public static final byte LOGOUT = 2;
        public static final byte RESET = 3;
        public static final byte PRINT = 4;
        private int job = 0;

        public LoginThread() {
            this.start();
        }

        public final synchronized void setJob(int j) throws Exception {
            if (this.job != 0) {
                throw new Exception(LanguageStrings.getProgramIsBusy());
            }
            this.job = j;
            this.notify();
        }

        public final synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            this.login();
                            break;
                        }
                        case 2: {
                            this.logout();
                            break;
                        }
                        case 3: {
                            KasiriPanel.this.reset();
                            break;
                        }
                        case 4: {
                            KasiriPanel.this.print();
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }

        private void login() throws Exception {
            int sel = tk.getSelectedRow();
            if (sel < 0 || sel >= Kasiri.vec.length) {
                return;
            }
            Kasiri kas = Kasiri.vec[sel];
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(42);
            instance.addInt((int)kas.getCode());
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = instance.getArray()[0] & 0xFF;
            int command = instance.getCmd();
            if (command != 42 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }

        private void logout() throws Exception {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(42);
            instance.addInt(0);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = instance.getArray()[0] & 0xFF;
            int command = instance.getCmd();
            if (command != 42 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }
    }
}

