/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPfileChooser;
import gui.HelpLabel;
import gui.PopupListener;
import gui.ProcessingDialog;
import gui.RacuniMySQLDialog;
import gui.SavePanel;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import journal.Journal;
import journal.JournalObjArticle;
import journal.JournalObjArticleBarcode;
import journal.JournalObjBus;
import journal.JournalObjCashear;
import journal.JournalObjPaid;
import journal.JournalObjRabatMarza;
import objects.lang.LanguageStrings;
import util.BufferByte;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public final class JournalPanel
extends RightPanel {
    public static final long START_TIME = 946684800000L;
    private static SimpleDateFormat dataf;
    public static JTextArea text;
    private final JScrollPane scr;
    private final SavePanel sp;
    private JSplitPane splitVerPanel;
    private MainThread runner = new MainThread();
    private final JButton hideAll;
    private JPanel leftPanel;
    private HCPGreyButton read;
    private HCPGreyButton reset;
    private HCPGreyButton write;

    public JournalPanel() {
        super(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_BUTTON"), 'Z', LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_BUTTON_TOOLTIP"));
        dataf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setLayout(new BorderLayout(10, 10));
        this.sp = new SavePanel(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_LABEL"));
        text = new JTextArea(){

            public JToolTip createToolTip() {
                JToolTip tip = new JToolTip(){};
                tip.setBackground(HCPColors.getColorM4st());
                return tip;
            }
        };
        text.setFont(new Font("SansSerif", 0, 10));
        text.setEditable(false);
        text.setTabSize(20);
        this.scr = new JScrollPane(text, 20, 30);
        this.scr.setBorder(new SoftBevelBorder(0));
        this.add((Component)this.sp, "North");
        JPanel outerPanel = new JPanel();
        outerPanel.setMinimumSize(new Dimension(0, 0));
        outerPanel.setLayout(new BorderLayout(10, 10));
        outerPanel.setIgnoreRepaint(true);
        outerPanel.setBackground(HCPColors.getColorM2st());
        outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_HELP_LABEL")), "North");
        JPanel inPanel = new JPanel();
        inPanel.setLayout(new BorderLayout(10, 10));
        inPanel.setIgnoreRepaint(true);
        inPanel.setBackground(HCPColors.getColorM2st());
        inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea textHelp = new JTextArea();
        textHelp.setWrapStyleWord(true);
        textHelp.setLineWrap(true);
        textHelp.setEditable(false);
        textHelp.setFont(GlavniFrame.font);
        textHelp.setText(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_HELP_TEXT_0"));
        int i = 1;
        try {
            while (true) {
                textHelp.append("\r\n\r\n");
                textHelp.append(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_HELP_TEXT_" + i++));
            }
        }
        catch (Exception exception) {
            JScrollPane scrText = new JScrollPane(textHelp, 20, 31);
            inPanel.add((Component)scrText, "Center");
            outerPanel.add((Component)inPanel, "Center");
            this.splitVerPanel = new JSplitPane(1, true, this.scr, outerPanel);
            this.splitVerPanel.setOneTouchExpandable(true);
            this.splitVerPanel.setResizeWeight(1.0);
            this.splitVerPanel.setDividerLocation(2000);
            this.splitVerPanel.setLastDividerLocation(500);
            this.add((Component)this.splitVerPanel, "Center");
            text.setToolTipText("<html><u>" + LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_TOOLTIP_0") + "</u><br><u>" + LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_TOOLTIP_1") + "</u><br><u>" + LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_TOOLTIP_2") + "</u><br></html>");
            JPopupMenu popMenu = new JPopupMenu();
            PopupListener popUp = new PopupListener(popMenu);
            PopListener ppl = new PopListener();
            text.addMouseListener(popUp);
            JMenuItem item1 = new JMenuItem(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_SUBMENU_0"));
            item1.addActionListener(ppl);
            item1.setMnemonic('R');
            popMenu.add(item1);
            popMenu.addSeparator();
            JMenuItem item3 = new JMenuItem(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_SUBMENU_1"));
            item3.addActionListener(ppl);
            item3.setMnemonic('3');
            popMenu.add(item3);
            popMenu.addSeparator();
            JMenuItem item6 = new JMenuItem(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_SUBMENU_2"));
            item6.addActionListener(ppl);
            item6.setMnemonic('B');
            popMenu.add(item6);
            this.leftPanel = new JPanel();
            this.leftPanel.setLayout(new GridLayout(19, 1, 0, 2));
            this.leftPanel.setBackground(HCPColors.getColorM2st());
            this.leftPanel.setPreferredSize(new Dimension(15, 500));
            this.leftPanel.setIgnoreRepaint(true);
            this.leftPanel.setOpaque(false);
            this.hideAll = new JButton(">>");
            this.hideAll.setOpaque(false);
            this.hideAll.setHorizontalAlignment(2);
            this.hideAll.setBackground(HCPColors.getColorM2st());
            this.hideAll.setForeground(HCPColors.getColorM3st());
            this.hideAll.setBorder(new MatteBorder(1, 1, 1, 1, HCPColors.getColorM2st()));
            this.hideAll.setFont(GlavniFrame.font);
            this.setFont(GlavniFrame.font);
            this.hideAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean visible = JournalPanel.this.hideAll.getText().equalsIgnoreCase("<<");
                    if (!visible) {
                        JournalPanel.this.leftPanel.setPreferredSize(new Dimension(200, 500));
                        JournalPanel.this.hideAll.setText("<<");
                        JournalPanel.this.setAllVisible(true);
                    } else {
                        JournalPanel.this.leftPanel.setPreferredSize(new Dimension(15, 500));
                        JournalPanel.this.hideAll.setText(">>");
                        JournalPanel.this.setAllVisible(false);
                    }
                }
            });
            this.leftPanel.add(this.hideAll);
            this.add((Component)this.leftPanel, "West");
            this.leftPanel.add(new JLabel());
            this.reset = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_SUBMENU_0"));
            this.reset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JournalPanel.this.runner.setJob(1);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                    }
                }
            });
            this.reset.setVisible(false);
            this.leftPanel.add(this.reset);
            this.leftPanel.add(new JLabel());
            this.read = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_SUBMENU_1"));
            this.read.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JournalPanel.this.runner.setJob(3);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                    }
                }
            });
            this.read.setVisible(false);
            this.leftPanel.add(this.read);
            this.leftPanel.add(new JLabel());
            this.write = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_SUBMENU_2"));
            this.write.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JournalPanel.this.runner.setJob(6);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                    }
                }
            });
            this.write.setVisible(false);
            this.leftPanel.add(this.write);
            return;
        }
    }

    private void setAllVisible(boolean vis) {
        this.read.setVisible(vis);
        this.reset.setVisible(vis);
        this.write.setVisible(vis);
    }

    public void resetujZurnal() throws SerialPortException, CommandsErrors {
        if (JOptionPane.showConfirmDialog(this, LanguageStrings.getAreYouSure(), "RESET", 2) != 0) {
            return;
        }
        Command.instance.reset();
        Command.instance.setCmd(74);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if ((command != 74 || command != 128) && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void readToFile() throws Exception {
        File file = new File("JOURNAL");
        file.mkdirs();
        HCPfileChooser fc = new HCPfileChooser("bin", this);
        fc.setCurrentDirectory(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(file);
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        int address = -1;
        int startAddress = -1;
        PortSerial port = PortSerial.getInstance();
        try {
            do {
                Command.bigInstance.reset();
                Command.bigInstance.setCmd(75);
                Command.bigInstance.addInt(address);
                port.sendFrame(Command.bigInstance);
                Command cmd = port.receiveFrame();
                if (cmd.getCmd() != 75) {
                    throw new SerialPortException("ERROR " + cmd.getArray()[0]);
                }
                address = this.writeCommandDataToFile(cmd, out);
                if (address > 0) continue;
                break;
            } while (address != startAddress);
        }
        finally {
            ((OutputStream)out).close();
            pd.setInstanceVisible(false);
        }
    }

    private int writeCommandDataToFile(Command cmd, OutputStream o) throws Exception {
        int newAddres = 0;
        int pos = 0;
        newAddres = cmd.getInt(pos);
        pos += 4;
        while (true) {
            try {
                if (cmd.getLong(pos) == -1L) {
                    return -1;
                }
            }
            catch (Exception e) {
                return newAddres;
            }
            o.write(cmd.getArray(), pos, 20);
            pos += 20;
        }
    }

    public void readJournal() throws Exception {
        File file = new File("JOURNAL", "journal.hcp");
        HCPfileChooser fc = new HCPfileChooser("hcp", this);
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.addExtension("bin");
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.openFile();
        if (file == null) {
            return;
        }
        FileInputStream in = new FileInputStream(file);
        BufferByte arr = new BufferByte();
        text.setText("");
        Journal.vec.removeAllElements();
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        byte[] bb = new byte[1024];
        arr.reset();
        int len = 0;
        try {
            while ((len = ((InputStream)in).read(bb, 0, bb.length)) >= 0) {
                arr.add(bb, 0, len);
            }
            int i = 0;
            while (i + 20 <= arr.getSize()) {
                JournalPanel.regulateJournalRecord(arr, i);
                i += 20;
            }
        }
        finally {
            ((InputStream)in).close();
            pd.setInstanceVisible(false);
        }
    }

    public void writeAllToBase() throws Exception {
        Journal.writeToBase();
    }

    public void loadBase() throws Exception {
        RacuniMySQLDialog rd = new RacuniMySQLDialog();
        rd.initialize();
    }

    public void generateRandom() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(73);
        int pom = 0;
        try {
            pom = Integer.parseInt(JOptionPane.showInputDialog(this, (Object)"Enter number of lines."));
            if (pom <= 0 || pom > 20000) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("Wrong  number");
        }
        Command.instance.addInt(pom);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if ((command != 73 || command != 128) && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void regulateJournalRecord(BufferByte bb, int pos) throws Exception {
        int type = bb.getBuffer()[pos++] & 0xFF;
        long bar = 0L;
        int t = 0;
        switch (type) {
            default: {
                throw new Exception("File error.");
            }
            case 7: {
                JournalObjArticleBarcode obj7 = new JournalObjArticleBarcode();
                t = bb.getInt(pos);
                obj7.setNumOfRec(t &= 0xFFFFFF);
                bar = bb.getLong(pos += 3) & 0xFFFFFFFFFFFFL;
                pos += 6;
                obj7.setBarcode(bar);
                t = bb.getBuffer()[pos++] & 0xFF;
                obj7.setOrdinalNum(t);
                t = bb.getBuffer()[pos++] & 0xFF;
                int poreskaStopa = 0;
                int odeljenje2 = 0;
                obj7.setDepartment(odeljenje2 |= (t & 0xF0) >> 4);
                obj7.setVat(poreskaStopa |= t & 0xF);
                t = bb.getInt(pos);
                obj7.setPrice(t);
                t = bb.getInt(pos += 4);
                pos += 4;
                obj7.setAmount(t);
                Journal.vec.add(obj7);
                obj7.appendToTextArea();
                return;
            }
            case 4: {
                JournalObjRabatMarza obj4 = new JournalObjRabatMarza();
                bar = (long)bb.getInt(++pos) & 0xFFFFFFFFL;
                bar *= 1000L;
                obj4.setTime(dataf.format(new Date(bar += 946684800000L)));
                t = bb.getShort(pos += 4);
                obj4.setRabat(t);
                t = bb.getShort(pos += 2);
                pos += 2;
                obj4.setMarza(t);
                pos += 10;
                Journal.vec.add(obj4);
                obj4.appendToTextArea();
                break;
            }
            case 3: {
                JournalObjCashear obj = new JournalObjCashear();
                pos += 5;
                t = bb.getBuffer()[pos++] & 0xFF;
                obj.setCashearId(t);
                t = bb.getBuffer()[pos++] & 0xFF;
                obj.setLevel(t);
                bar = bb.getLong(pos);
                obj.setAmount(bar);
                bar = (long)bb.getInt(pos += 8) & 0xFFFFFFFFL;
                bar *= 1000L;
                obj.setTime(dataf.format(new Date(bar += 946684800000L)));
                Journal.vec.add(obj);
                obj.appendToTextArea();
                return;
            }
            case 1: {
                JournalObjArticle obj1 = new JournalObjArticle();
                t = bb.getShort(++pos);
                obj1.setCode(t);
                bar = (long)bb.getInt(pos += 2) & 0xFFFFFFFFL;
                bar *= 1000L;
                obj1.setTime(dataf.format(new Date(bar += 946684800000L)));
                t = bb.getInt(pos += 4);
                obj1.setNumOfRec(t);
                t = bb.getInt(pos += 4);
                obj1.setPrice(t);
                t = bb.getInt(pos += 4);
                pos += 4;
                obj1.setAmount(t);
                Journal.vec.add(obj1);
                obj1.appendToTextArea();
                return;
            }
            case 2: {
                JournalObjPaid obj2 = new JournalObjPaid();
                pos += 2;
                t = bb.getBuffer()[pos++] & 0xFF;
                obj2.setType(t);
                bar = bb.getLong(pos);
                obj2.setAmount(bar);
                t = bb.getInt(pos += 8);
                obj2.setNumOfRec(t);
                bar = (long)bb.getInt(pos += 4) & 0xFFFFFFFFL;
                bar *= 1000L;
                obj2.setTime(dataf.format(new Date(bar += 946684800000L)));
                Journal.vec.add(obj2);
                obj2.appendToTextArea();
                return;
            }
            case 5: {
                JournalObjBus obj3 = new JournalObjBus();
                bar = (long)bb.getInt(--pos) & 0xFFFFFFFFL;
                pos += 4;
                bar *= 1000L;
                obj3.setTime(dataf.format(new Date(bar += 946684800000L)));
                int value = 0;
                int i = 0;
                while (i < 3) {
                    value |= bb.getValueAt(pos++) << i * 8;
                    ++i;
                }
                obj3.setTicketNumber(value);
                if (value != 0) {
                    value = 0;
                    i = 0;
                    while (i < 3) {
                        value |= bb.getValueAt(pos++) << i * 8;
                        ++i;
                    }
                    obj3.setPrice(value);
                    byte b = (byte)bb.getValueAt(pos++);
                    obj3.setTarif(b & 0xF);
                    obj3.setVat(b >>> 4 & 0xF);
                    bar = 0L;
                    bar = bb.getLong(pos);
                    pos += 8;
                    obj3.setLineNumber((int)(bar & 0xFFFFL));
                    obj3.setStart((int)((bar >>>= 16) & 0xFFL));
                    obj3.setEnd((int)((bar >>>= 8) & 0xFFL));
                    obj3.setReturn(((bar >>>= 8) & 0x80L) > 0L);
                    obj3.setLineVer((int)(bar & 0x7FL));
                    obj3.setStationVat((int)((bar >>>= 8) & 0xFFL));
                    obj3.setStationCharge((int)((bar >>>= 8) & 0xFFFFL));
                } else {
                    i = 0;
                    while (i < 3) {
                        value |= bb.getValueAt(pos++) << i * 8;
                        ++i;
                    }
                    obj3.setPrice(value);
                    obj3.setLineVer(bb.getValueAt(pos++));
                    value = 0;
                    i = 0;
                    while (i < 2) {
                        value |= bb.getValueAt(pos++) << i * 8;
                        ++i;
                    }
                    obj3.setLineNumber(value);
                    value = 0;
                    i = 0;
                    while (i < 3) {
                        value |= bb.getValueAt(pos++) << i * 8;
                        ++i;
                    }
                    obj3.setIdCard(value);
                    obj3.setEnd(bb.getValueAt(pos++));
                    obj3.setStart(bb.getValueAt(pos++));
                    obj3.setCardType(bb.getValueAt(pos++));
                }
                ++pos;
                Journal.vec.add(obj3);
                obj3.appendToTextArea();
                return;
            }
        }
    }

    private class MainThread
    extends Thread {
        public static final byte RESET = 1;
        public static final byte READ_JOURNAL_FROM_BASE = 3;
        public static final byte GENERATE_RANDOM = 5;
        public static final byte WRITE_TO_BASE = 6;
        public static final byte LOAD_FROM_BASE = 7;
        public static final byte READ_TO_FILE = 8;
        private int job = 0;

        public MainThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setJob(int j) throws Exception {
            GlavniFrame glavniFrame = GlavniFrame.getInstance();
            synchronized (glavniFrame) {
                if (this.job != 0) {
                    throw new Exception(LanguageStrings.getProgramIsBusy());
                }
                this.job = j;
                this.notify();
            }
        }

        public synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            JournalPanel.this.resetujZurnal();
                            break;
                        }
                        case 3: {
                            JournalPanel.this.readJournal();
                            break;
                        }
                        case 5: {
                            JournalPanel.this.generateRandom();
                            break;
                        }
                        case 6: {
                            JournalPanel.this.writeAllToBase();
                            break;
                        }
                        case 7: {
                            JournalPanel.this.loadBase();
                            break;
                        }
                        case 8: {
                            JournalPanel.this.readToFile();
                        }
                    }
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }
    }

    protected class PopListener
    implements ActionListener {
        protected PopListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int c = ((JMenuItem)e.getSource()).getMnemonic();
            try {
                switch (c) {
                    case 82: {
                        JournalPanel.this.runner.setJob(1);
                        break;
                    }
                    case 51: {
                        JournalPanel.this.runner.setJob(3);
                        break;
                    }
                    case 71: {
                        JournalPanel.this.runner.setJob(5);
                        break;
                    }
                    case 66: {
                        JournalPanel.this.runner.setJob(6);
                        break;
                    }
                    case 76: {
                        JournalPanel.this.runner.setJob(7);
                        break;
                    }
                    case 55: {
                        JournalPanel.this.runner.setJob(8);
                    }
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
    }
}

