/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import ftp.FtpConfigDialog;
import ftp.HcpFtpClient;
import gui.CommandFileDialog;
import gui.GlavniFrame;
import gui.HCPCheckBox;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPGridBagLayout;
import gui.HCPLabel;
import gui.HCPTextField;
import gui.HCPTextFieldRange;
import gui.HCPTextField_IP_ADDRESS;
import gui.HCPfileChooser;
import gui.NumTextFieldRange;
import gui.PhoneNumTextField;
import gui.ProcessingDialog;
import gui.SavePanel;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Terminals;
import objects.lang.LanguageStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import serverRemote.Server;
import serverRemote.TerminalSocket;
import terminalTable.TerminalTable;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;
import util.comPort.PortSerial;

public class HCPServerPanel
extends RightPanel
implements XmlObject,
ComObject,
ActionListener {
    private JPanel mainPanel;
    private JPanel gprsPanel;
    private JPanel numPanel;
    private JPanel socketPanel;
    private JPanel testPanel;
    private JPanel tablePanel;
    private JPanel passPanel;
    private JPanel filePanel;
    public HCPTextFieldRange gprsUpload;
    public HCPTextFieldRange gprsDownload;
    public HCPTextFieldRange apnAdresa;
    public HCPTextFieldRange apnUser;
    public HCPTextFieldRange serverUser;
    public HCPTextFieldRange passField;
    private HCPTextField apnPass;
    private HCPTextField serverPass;
    public HCPTextField_IP_ADDRESS serverAdresa;
    public PhoneNumTextField socketNumbers;
    public PhoneNumTextField ftpNumbers;
    private NumTextFieldRange addr1;
    private NumTextFieldRange addr2;
    private NumTextFieldRange addr3;
    private NumTextFieldRange addr4;
    private NumTextFieldRange port;
    private HCPGreyButton testSocketButton;
    private HCPGreyButton disconect;
    private HCPGreyButton sendPass;
    private HCPGreyButton resetCommand;
    private HCPGreyButton generateFile;
    private HCPGreyButton buttonSaveFtp;
    private HCPCheckBox useServer;
    public TerminalTable tt;
    private HCPGridBagLayout gl;
    private SavePanel sp;
    public static final int HCP_SOCKET = 3;
    public static final int APN_SETTINGS = 5;
    public static final int FTP_SETTINGS = 2;
    public static final int PASSWORD = 6;
    public SettingsThread runner = new SettingsThread();

    public HCPServerPanel() {
        super(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON"), 'G', LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(7, 10));
        this.sp = new SavePanel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL"));
        this.add((Component)this.sp, "North");
        this.mainPanel = new JPanel();
        this.mainPanel.setOpaque(false);
        SpringLayout osl = new SpringLayout();
        this.mainPanel.setLayout(osl);
        this.mainPanel.setIgnoreRepaint(true);
        this.mainPanel.setBackground(HCPColors.getColorM2st());
        this.add((Component)this.mainPanel, "Center");
        this.gprsPanel = new JPanel();
        this.gprsPanel.setLayout(new GridLayout(6, 1, 0, 0));
        this.gprsPanel.setPreferredSize(new Dimension(330, 429));
        this.gprsPanel.setIgnoreRepaint(true);
        this.gprsPanel.setBackground(HCPColors.getColorM2st());
        this.gprsPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(0, 15, 5, 15)));
        this.gprsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_LABEL"), new ImageIcon("images/globe.png"), 0));
        JPanel gprsPomPanel = new JPanel();
        gprsPomPanel.setLayout(new GridLayout(3, 2, 5, 5));
        gprsPomPanel.setBackground(HCPColors.getColorM2st());
        gprsPomPanel.add(new HCPLabel());
        gprsPomPanel.add(new HCPLabel());
        gprsPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_UPLOAD"), 4));
        this.gprsUpload = new HCPTextFieldRange(46);
        gprsPomPanel.add(this.gprsUpload);
        gprsPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_DOWNLOAD"), 4));
        this.gprsDownload = new HCPTextFieldRange(46);
        gprsPomPanel.add(this.gprsDownload);
        this.gprsPanel.add(gprsPomPanel);
        this.gprsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN_SETTINGS"), 0));
        JPanel apnPomPanel = new JPanel();
        apnPomPanel.setLayout(new GridLayout(3, 2, 5, 5));
        apnPomPanel.setBackground(HCPColors.getColorM2st());
        apnPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN"), 4));
        this.apnAdresa = new HCPTextFieldRange(22);
        apnPomPanel.add(this.apnAdresa);
        apnPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN_USERNAME"), 4));
        this.apnUser = new HCPTextFieldRange(22);
        apnPomPanel.add(this.apnUser);
        apnPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN_PASSWORD"), 4));
        this.apnPass = new HCPTextField();
        apnPomPanel.add(this.apnPass);
        this.gprsPanel.add(apnPomPanel);
        this.gprsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_SETTINGS"), 0));
        JPanel serverPomPanel = new JPanel();
        serverPomPanel.setLayout(new GridLayout(3, 2, 5, 5));
        serverPomPanel.setBackground(HCPColors.getColorM2st());
        serverPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_ADDRESS"), 4));
        this.serverAdresa = new HCPTextField_IP_ADDRESS();
        serverPomPanel.add(this.serverAdresa);
        serverPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_USERNAME"), 4));
        this.serverUser = new HCPTextFieldRange(22);
        serverPomPanel.add(this.serverUser);
        serverPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_PASSWORD"), 4));
        this.serverPass = new HCPTextField();
        serverPomPanel.add(this.serverPass);
        this.gprsPanel.add(serverPomPanel);
        this.numPanel = new JPanel();
        this.numPanel.setLayout(new GridLayout(2, 2, 15, 15));
        this.numPanel.setPreferredSize(new Dimension(300, 90));
        this.numPanel.setIgnoreRepaint(true);
        this.numPanel.setBackground(HCPColors.getColorM2st());
        this.numPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        this.numPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_FTP_NUMBERS"), 4));
        this.ftpNumbers = new PhoneNumTextField(46);
        this.numPanel.add(this.ftpNumbers);
        this.numPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_SOCKET_NUMBERS"), 4));
        this.socketNumbers = new PhoneNumTextField(46);
        this.socketNumbers.setEnabled(false);
        this.numPanel.add(this.socketNumbers);
        this.socketPanel = new JPanel();
        this.socketPanel.setPreferredSize(new Dimension(300, 90));
        this.socketPanel.setBackground(HCPColors.getColorM2st());
        this.socketPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        this.gl = new HCPGridBagLayout(this.socketPanel);
        HCPLabel l4 = new HCPLabel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_SOCKET_IP_ADDRESS"));
        l4.setHorizontalAlignment(2);
        this.gl.newConstraints(l4, 0, 0, 1, 1, 40, 20);
        this.socketPanel.add(l4);
        this.addr1 = new NumTextFieldRange(3, 1, 255L);
        this.addr1.setBorder(new SoftBevelBorder(1));
        this.gl.newConstraints(this.addr1, 1, 0, 1, 1, 15, 0);
        this.addr1.setEnabled(false);
        this.socketPanel.add(this.addr1);
        this.addr2 = new NumTextFieldRange(3, 0, 255L);
        this.addr2.setBorder(new SoftBevelBorder(1));
        this.gl.newConstraints(this.addr2, 2, 0, 1, 1, 15, 0);
        this.addr2.setEnabled(false);
        this.socketPanel.add(this.addr2);
        this.addr3 = new NumTextFieldRange(3, 0, 255L);
        this.addr3.setBorder(new SoftBevelBorder(1));
        this.gl.newConstraints(this.addr3, 3, 0, 1, 1, 15, 0);
        this.addr3.setEnabled(false);
        this.socketPanel.add(this.addr3);
        this.addr4 = new NumTextFieldRange(3, 0, 255L);
        this.addr4.setBorder(new SoftBevelBorder(1));
        this.gl.newConstraints(this.addr4, 4, 0, 1, 1, 15, 0);
        this.addr4.setEnabled(false);
        this.socketPanel.add(this.addr4);
        HCPLabel ll = new HCPLabel();
        this.gl.newConstraints(ll, 0, 1, 5, 1, 0, 60);
        this.socketPanel.add(ll);
        HCPLabel l5 = new HCPLabel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_SOCKET_PORT"));
        l5.setHorizontalAlignment(2);
        this.gl.newConstraints(l5, 0, 2, 1, 1, 0, 20);
        this.socketPanel.add(l5);
        this.port = new NumTextFieldRange(5, 1200, 35000L);
        this.port.setBorder(new SoftBevelBorder(1));
        this.gl.newConstraints(this.port, 1, 2, 2, 1, 0, 0);
        this.port.setEnabled(false);
        this.socketPanel.add(this.port);
        this.testPanel = new JPanel();
        this.testPanel.setLayout(new GridLayout(4, 1, 15, 15));
        this.testPanel.setPreferredSize(new Dimension(206, 187));
        this.testPanel.setIgnoreRepaint(true);
        this.testPanel.setBackground(HCPColors.getColorM2st());
        this.testPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        this.testSocketButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_START"));
        this.testSocketButton.setToolTipText(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_START_TOOLTIP"));
        this.testSocketButton.addActionListener(this);
        this.testSocketButton.setActionCommand("TESTSOCKET");
        this.testPanel.add(this.testSocketButton);
        this.useServer = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_USE"), false);
        this.useServer.setToolTipText(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_USE_TOOLTIP"));
        this.useServer.addActionListener(this);
        this.useServer.setActionCommand("USE");
        this.useServer.setEnabled(false);
        this.testPanel.add(this.useServer);
        this.disconect = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_DISCONECT"));
        this.disconect.setToolTipText(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_DISCONECT_TOOLTIP"));
        this.disconect.addActionListener(this);
        this.disconect.setActionCommand("DISC");
        this.testPanel.add(this.disconect);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setPreferredSize(new Dimension(206, 234));
        this.tablePanel.setIgnoreRepaint(true);
        this.tablePanel.setBackground(HCPColors.getColorM2st());
        this.tablePanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        this.tt = new TerminalTable();
        JScrollPane scroll = new JScrollPane(this.tt, 20, 31);
        scroll.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new SoftBevelBorder(1)));
        this.tablePanel.add((Component)scroll, "Center");
        this.passPanel = new JPanel();
        this.passPanel.setLayout(new GridLayout(2, 2, 15, 15));
        this.passPanel.setPreferredSize(new Dimension(300, 106));
        this.passPanel.setIgnoreRepaint(true);
        this.passPanel.setBackground(HCPColors.getColorM2st());
        this.passPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
        ImageIcon slikaFloppy = new ImageIcon("images/Floppy_Drive_Small.png");
        this.passField = new HCPTextFieldRange(18);
        this.passPanel.add(this.passField);
        this.sendPass = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_UNLOCK"));
        this.sendPass.addActionListener(this);
        this.sendPass.setActionCommand("SEND_PASS");
        this.sendPass.setIcon(slikaCash);
        this.passPanel.add(this.sendPass);
        this.passPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_RESET"), 4));
        this.resetCommand = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL_RESET"));
        this.resetCommand.addActionListener(this);
        this.resetCommand.setActionCommand("RESET_COMMAND");
        this.resetCommand.setIcon(slikaCash);
        this.passPanel.add(this.resetCommand);
        this.filePanel = new JPanel();
        this.filePanel.setLayout(new GridLayout(2, 2, 15, 15));
        this.filePanel.setPreferredSize(new Dimension(300, 122));
        this.filePanel.setIgnoreRepaint(true);
        this.filePanel.setBackground(HCPColors.getColorM2st());
        this.filePanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 32, 15)));
        this.filePanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL_GENERATE"), 4));
        this.generateFile = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_GENERATE"));
        this.generateFile.addActionListener(this);
        this.generateFile.setActionCommand("GENERATE");
        this.generateFile.setIcon(slikaFloppy);
        this.filePanel.add(this.generateFile);
        this.filePanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL_SAVE_TO_FTP"), 4));
        this.buttonSaveFtp = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_BUTTON_SAVE_TO_FTP"));
        this.buttonSaveFtp.addActionListener(this);
        this.buttonSaveFtp.setActionCommand("SAVE_TO_FTP");
        this.buttonSaveFtp.setIcon(slikaFloppy);
        this.filePanel.add(this.buttonSaveFtp);
        osl.putConstraint("North", (Component)this.gprsPanel, 0, "North", (Component)this.mainPanel);
        osl.putConstraint("West", (Component)this.gprsPanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.gprsPanel);
        osl.putConstraint("North", (Component)this.numPanel, 0, "North", (Component)this.mainPanel);
        osl.putConstraint("West", (Component)this.numPanel, 7, "East", (Component)this.gprsPanel);
        this.mainPanel.add(this.numPanel);
        osl.putConstraint("North", (Component)this.socketPanel, 7, "South", (Component)this.numPanel);
        osl.putConstraint("West", (Component)this.socketPanel, 7, "East", (Component)this.gprsPanel);
        this.mainPanel.add(this.socketPanel);
        osl.putConstraint("North", (Component)this.testPanel, 0, "North", (Component)this.mainPanel);
        osl.putConstraint("West", (Component)this.testPanel, 7, "East", (Component)this.numPanel);
        this.mainPanel.add(this.testPanel);
        osl.putConstraint("North", (Component)this.passPanel, 7, "South", (Component)this.testPanel);
        osl.putConstraint("West", (Component)this.passPanel, 7, "East", (Component)this.gprsPanel);
        this.mainPanel.add(this.passPanel);
        osl.putConstraint("North", (Component)this.filePanel, 7, "South", (Component)this.passPanel);
        osl.putConstraint("West", (Component)this.filePanel, 7, "East", (Component)this.gprsPanel);
        this.mainPanel.add(this.filePanel);
        osl.putConstraint("North", (Component)this.tablePanel, 7, "South", (Component)this.testPanel);
        osl.putConstraint("West", (Component)this.tablePanel, 7, "East", (Component)this.passPanel);
        this.mainPanel.add(this.tablePanel);
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<HCP_SERVER_SETTINGS>");
        if (writer == null) {
            return;
        }
        writer.indent();
        writer.write("<DATA GPRS_UPLOAD = '" + XmlFileWriter.compileString(this.gprsUpload.getText()) + "'");
        writer.write(" GPRS_DOWNLOAD = '" + XmlFileWriter.compileString(this.gprsDownload.getText()) + "'");
        writer.write(" APN = '" + XmlFileWriter.compileString(this.apnAdresa.getText()) + "'");
        writer.write(" APN_USER = '" + XmlFileWriter.compileString(this.apnUser.getText()) + "'");
        writer.write(" APN_PASS = '" + XmlFileWriter.compileString(new String(this.apnPass.getText())) + "'");
        writer.write(" FTP = '" + XmlFileWriter.compileString(this.serverAdresa.getText()) + "'");
        writer.write(" FTP_USER = '" + XmlFileWriter.compileString(this.serverUser.getText()) + "'");
        writer.write(" FTP_PASS = '" + XmlFileWriter.compileString(new String(this.serverPass.getText())) + "'");
        writer.write(" ADD1 = '" + XmlFileWriter.compileString(this.addr1.getText()) + "'");
        writer.write(" ADD2= '" + XmlFileWriter.compileString(this.addr2.getText()) + "'");
        writer.write(" ADD3= '" + XmlFileWriter.compileString(this.addr3.getText()) + "'");
        writer.write(" ADD4= '" + XmlFileWriter.compileString(this.addr4.getText()) + "'");
        writer.write(" PORT= '" + XmlFileWriter.compileString(this.port.getText()) + "'");
        writer.write(" SOCKET_NUMBERS='" + XmlFileWriter.compileString(this.socketNumbers.getText()) + "'");
        writer.write(" FTP_NUMBERS='" + XmlFileWriter.compileString(this.ftpNumbers.getText()) + "'");
        writer.writeLn(" />");
        writer.unintent();
        writer.writeLn("</HCP_SERVER_SETTINGS>");
    }

    public void readFromXML(File file) throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element docEl = doc.getDocumentElement();
            NodeList dataNode = docEl.getElementsByTagName("DATA");
            Element elem = (Element)dataNode.item(0);
            if (elem == null) {
                return;
            }
            this.gprsUpload.setText(elem.getAttribute("GPRS_UPLOAD"));
            this.gprsDownload.setText(elem.getAttribute("GPRS_DOWNLOAD"));
            this.apnAdresa.setText(elem.getAttribute("APN"));
            this.apnUser.setText(elem.getAttribute("APN_USER"));
            this.apnPass.setText(elem.getAttribute("APN_PASS"));
            this.serverAdresa.setText(elem.getAttribute("FTP"));
            this.serverUser.setText(elem.getAttribute("FTP_USER"));
            this.serverPass.setText(elem.getAttribute("FTP_PASS"));
            this.addr1.setText(elem.getAttribute("ADD1"));
            this.addr2.setText(elem.getAttribute("ADD2"));
            this.addr3.setText(elem.getAttribute("ADD3"));
            this.addr4.setText(elem.getAttribute("ADD4"));
            this.port.setText(elem.getAttribute("PORT"));
            this.socketNumbers.setText(elem.getAttribute("SOCKET_NUMBERS"));
            this.ftpNumbers.setText(elem.getAttribute("FTP_NUMBERS"));
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public void sendToPort() throws Exception {
        this.sendAPN();
        this.sendFTP();
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
    }

    public void readFromPort() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            this.readApn();
            this.readFTP();
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("TESTSOCKET")) {
                this.runner.setJob(1);
            } else if (s.equalsIgnoreCase("DISC")) {
                this.runner.setJob(2);
            } else if (s.equalsIgnoreCase("USE")) {
                PortSerial.useServer = this.useServer.isSelected();
            } else if (s.equalsIgnoreCase("RESET_COMMAND")) {
                this.runner.setJob(3);
            } else if (s.equalsIgnoreCase("SEND_PASS")) {
                this.runner.setJob(4);
            } else if (s.equalsIgnoreCase("GENERATE")) {
                this.runner.setJob(5);
            } else if (s.equalsIgnoreCase("SAVE_TO_FTP")) {
                this.runner.setJob(6);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
        }
    }

    private void sendPass() throws Exception {
        PortSerial port = PortSerial.getInstance();
        String pass = this.passField.getText();
        try {
            Command instance = Command.bigInstance;
            instance.reset();
            instance.setCmd(103);
            instance.addByte(6);
            instance.addToArray(pass.getBytes(), 0, pass.length());
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = instance.getArray()[0] & 0xFF;
            int cmdRet = instance.getCmd();
            if (cmdRet != 103 && cmdRet != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        catch (Exception e) {
            throw new Exception("PASSWORD error: " + e.getMessage());
        }
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
    }

    public void resetCommand() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(64);
        instance.addByte(1);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 64 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
    }

    public void readFTP() throws Exception {
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(104);
        instance.addByte(2);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command command = port.receiveFrame();
        int e = command.getArray()[0] & 0xFF;
        int cmdRet = command.getCmd();
        if (cmdRet != 104 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        String allNums = "";
        instance = command;
        int pos = 1;
        try {
            int add4 = instance.getByte(pos++) & 0xFF;
            int add3 = instance.getByte(pos++) & 0xFF;
            int add2 = instance.getByte(pos++) & 0xFF;
            int add1 = instance.getByte(pos++) & 0xFF;
            String ftpAdd = "" + add1 + '.' + add2 + '.' + add3 + '.' + add4;
            this.serverAdresa.setText(ftpAdd);
            int len = instance.getShort(pos++);
            byte[] ftpUser = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, ftpUser, 0, len);
            this.serverUser.setText(new String(ftpUser, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] ftpPass = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, ftpPass, 0, len);
            this.serverPass.setText(new String(ftpPass, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] ftpUpload = new byte[46];
            System.arraycopy(instance.getArray(), ++pos, ftpUpload, 0, len);
            this.gprsUpload.setText(new String(ftpUpload, 0, len));
            pos += 46;
            len = instance.getShort(pos++);
            byte[] ftpDownload = new byte[46];
            System.arraycopy(instance.getArray(), ++pos, ftpDownload, 0, len);
            this.gprsDownload.setText(new String(ftpDownload, 0, len));
            pos += 46;
            len = instance.getByte(pos++);
            String[] nums = new String[len];
            int i = 0;
            while (i < len) {
                int pom = instance.getByte(pos++);
                nums[i] = new String(instance.getArray(), pos, pom);
                pos += pom;
                allNums = String.valueOf(allNums) + nums[i];
                allNums = String.valueOf(allNums) + ';';
                ++i;
            }
        }
        catch (Exception e1) {
            throw new Exception("FTP error: " + e1.getMessage());
        }
        this.ftpNumbers.setText(allNums);
    }

    public void sendFTP() throws Exception {
        PortSerial port = PortSerial.getInstance();
        try {
            String ftpAdd = this.serverAdresa.getText();
            byte[] ftpUser = this.serverUser.getText().getBytes();
            byte[] ftpPass = new String(this.serverPass.getText()).getBytes();
            byte[] ftpDownload = this.gprsDownload.getText().getBytes();
            byte[] ftpUpload = this.gprsUpload.getText().getBytes();
            if (ftpUser.length > 22 || ftpPass.length > 22 || ftpDownload.length > 46 || ftpUpload.length > 46) {
                throw new Exception("input string is too long!");
            }
            StringTokenizer st = new StringTokenizer(ftpAdd, ".");
            int add1 = Integer.parseInt(st.nextToken());
            int add2 = Integer.parseInt(st.nextToken());
            int add3 = Integer.parseInt(st.nextToken());
            int add4 = Integer.parseInt(st.nextToken());
            String ftpNum = this.ftpNumbers.getText();
            StringTokenizer stFtp = new StringTokenizer(ftpNum, ";");
            int sn = stFtp.countTokens();
            if (sn > 5) {
                throw new Exception("to many socket numbers");
            }
            Command instance = Command.bigInstance;
            instance.reset();
            instance.setCmd(103);
            instance.addByte(2);
            instance.addByte(add4);
            instance.addByte(add3);
            instance.addByte(add2);
            instance.addByte(add1);
            byte[] bb = new byte[22];
            System.arraycopy(ftpUser, 0, bb, 0, ftpUser.length);
            instance.addShort(ftpUser.length);
            instance.addToArray(bb, 0, bb.length);
            bb = new byte[22];
            System.arraycopy(ftpPass, 0, bb, 0, ftpPass.length);
            instance.addShort(ftpPass.length);
            instance.addToArray(bb, 0, bb.length);
            bb = new byte[46];
            System.arraycopy(ftpUpload, 0, bb, 0, ftpUpload.length);
            instance.addShort(ftpUpload.length);
            instance.addToArray(bb, 0, bb.length);
            bb = new byte[46];
            System.arraycopy(ftpDownload, 0, bb, 0, ftpDownload.length);
            instance.addShort(ftpDownload.length);
            instance.addToArray(bb, 0, bb.length);
            instance.addByte(sn);
            while (stFtp.hasMoreTokens()) {
                String pom = stFtp.nextToken();
                instance.addByte(pom.length());
                instance.addToArray(pom.getBytes(), 0, pom.length());
            }
            port.sendFrame(instance);
            Command command = port.receiveFrame();
            int e = command.getArray()[0] & 0xFF;
            int cmdRet = command.getCmd();
            if (cmdRet != 103 && cmdRet != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        catch (Exception e1) {
            throw new Exception("FTP error: " + e1.getMessage());
        }
    }

    public void sendAPN() throws Exception {
        PortSerial port = PortSerial.getInstance();
        try {
            byte[] aAdd = this.apnAdresa.getText().getBytes();
            byte[] aUser = this.apnUser.getText().getBytes();
            byte[] aPass = new String(this.apnPass.getText()).getBytes();
            if (aUser.length > 22 || aPass.length > 22 || aAdd.length > 22) {
                throw new Exception("input string is too long!");
            }
            Command instance = Command.bigInstance;
            instance.reset();
            instance.setCmd(103);
            instance.addByte(5);
            byte[] bb = new byte[22];
            System.arraycopy(aAdd, 0, bb, 0, aAdd.length);
            instance.addShort(aAdd.length);
            instance.addToArray(bb, 0, bb.length);
            bb = new byte[22];
            System.arraycopy(aUser, 0, bb, 0, aUser.length);
            instance.addShort(aUser.length);
            instance.addToArray(bb, 0, bb.length);
            bb = new byte[22];
            System.arraycopy(aPass, 0, bb, 0, aPass.length);
            instance.addShort(aPass.length);
            instance.addToArray(bb, 0, bb.length);
            port.sendFrame(instance);
            Command command = port.receiveFrame();
            int e = command.getArray()[0] & 0xFF;
            int cmdRet = command.getCmd();
            if (cmdRet != 103 && cmdRet != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        catch (Exception e1) {
            throw new Exception("APN error: " + e1.getMessage());
        }
    }

    public void readApn() throws Exception {
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(104);
        instance.addByte(5);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command command = port.receiveFrame();
        int e = command.getArray()[0] & 0xFF;
        int cmdRet = command.getCmd();
        if (cmdRet != 104 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        instance = command;
        int pos = 1;
        try {
            int len = instance.getShort(pos++);
            byte[] aAdd = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, aAdd, 0, len);
            this.apnAdresa.setText(new String(aAdd, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] aUser = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, aUser, 0, len);
            this.apnUser.setText(new String(aUser, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] aPass = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, aPass, 0, len);
            this.apnPass.setText(new String(aPass, 0, len));
            pos += 22;
        }
        catch (Exception e1) {
            throw new Exception("APN error: " + e1.getMessage());
        }
    }

    public void sendSocket() throws Exception {
        PortSerial port = PortSerial.getInstance();
        try {
            int add1 = Integer.parseInt(this.addr1.getText());
            int add2 = Integer.parseInt(this.addr2.getText());
            int add3 = Integer.parseInt(this.addr3.getText());
            int add4 = Integer.parseInt(this.addr4.getText());
            int socketPort = Integer.parseInt(this.port.getText());
            String socketNum = this.socketNumbers.getText();
            StringTokenizer stSocket = new StringTokenizer(socketNum, ";");
            int sn = stSocket.countTokens();
            if (sn > 5) {
                throw new Exception("to many socket numbers");
            }
            Command instance = Command.bigInstance;
            instance.reset();
            instance.setCmd(103);
            instance.addByte(3);
            instance.addByte(add4);
            instance.addByte(add3);
            instance.addByte(add2);
            instance.addByte(add1);
            instance.addInt(socketPort);
            instance.addByte(sn);
            while (stSocket.hasMoreTokens()) {
                String pom = stSocket.nextToken();
                instance.addByte(pom.length());
                instance.addToArray(pom.getBytes(), 0, pom.length());
            }
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = instance.getArray()[0] & 0xFF;
            int cmdRet = instance.getCmd();
            if (cmdRet != 103 && cmdRet != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        catch (Exception e1) {
            throw new Exception("SOCKET error: " + e1.getMessage());
        }
    }

    public void readSocket() throws Exception {
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(104);
        instance.addByte(3);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int cmdRet = instance.getCmd();
        if (cmdRet != 104 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int pos = 1;
        String allNums = "";
        try {
            int add4 = instance.getByte(pos++);
            int add3 = instance.getByte(pos++);
            int add2 = instance.getByte(pos++);
            int add1 = instance.getByte(pos++);
            int socketPort = instance.getInt(pos);
            pos += 4;
            this.addr1.setText(String.valueOf(add1));
            this.addr2.setText(String.valueOf(add2));
            this.addr3.setText(String.valueOf(add3));
            this.addr4.setText(String.valueOf(add4));
            this.port.setText(String.valueOf(socketPort));
            int len = instance.getByte(pos++);
            String[] nums = new String[len];
            int i = 0;
            while (i < len) {
                int pom = instance.getByte(pos++);
                nums[i] = new String(instance.getArray(), pos, pom);
                pos += pom;
                allNums = String.valueOf(allNums) + nums[i];
                allNums = String.valueOf(allNums) + ';';
                ++i;
            }
        }
        catch (Exception e1) {
            throw new Exception("SOCKET error: " + e1.getMessage());
        }
        this.socketNumbers.setText(allNums);
    }

    public void testSocket() throws Exception {
        int portNum = 0;
        String ip = String.valueOf(this.addr1.getText()) + '.' + this.addr2.getText() + '.' + this.addr3.getText() + '.' + this.addr4.getText();
        String portId = this.port.getText();
        portNum = Integer.parseInt(portId);
        Server.changeIp(ip, portNum);
        Server.getInstance();
    }

    public void disconect() {
        if (TerminalSocket.current != null) {
            Terminals.removeTerminal(TerminalSocket.current.getId());
        }
        TerminalSocket.current = null;
        this.tt.revalidate();
        this.tt.repaint();
    }

    public void generateCommandFile() {
        CommandFileDialog.getInstance().setVisible(true);
    }

    public void saveToFtp() throws Exception {
        HCPfileChooser fc = new HCPfileChooser("hcp");
        File file = fc.openFile();
        if (file == null) {
            return;
        }
        FtpConfigDialog fcd = new FtpConfigDialog();
        fcd.setVisible(true);
        if (!fcd.configured) {
            return;
        }
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            HcpFtpClient.init();
            HcpFtpClient.cdCommands();
            HcpFtpClient.putFile(file, file.getName());
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private class SettingsThread
    extends Thread {
        public static final byte TESTSOCKET = 1;
        public static final byte DISC = 2;
        public static final byte RESET_COMMAND = 3;
        public static final byte SEND_PASS = 4;
        public static final byte GENERATE = 5;
        public static final byte SAVE_TO_FTP = 6;
        private int job = 0;

        public SettingsThread() {
            this.start();
        }

        public final synchronized void setJob(int j) throws Exception {
            if (this.job != 0) {
                throw new Exception(LanguageStrings.getProgramIsBusy());
            }
            this.job = j;
            this.notify();
        }

        public final synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            HCPServerPanel.this.testSocket();
                            break;
                        }
                        case 2: {
                            HCPServerPanel.this.disconect();
                            break;
                        }
                        case 3: {
                            HCPServerPanel.this.resetCommand();
                            break;
                        }
                        case 4: {
                            HCPServerPanel.this.sendPass();
                            break;
                        }
                        case 5: {
                            HCPServerPanel.this.generateCommandFile();
                            break;
                        }
                        case 6: {
                            HCPServerPanel.this.saveToFtp();
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }
    }
}

