/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPComboBox;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPTextField;
import gui.HCPTextFieldRange;
import gui.HCPTextField_IP_ADDRESS;
import gui.HelpLabel;
import gui.ProcessingDialog;
import gui.SavePanel;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.GPRSPatterns;
import objects.lang.LanguageStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;
import util.comPort.PortSerial;

public final class GPRSPanel
extends RightPanel
implements ComObject,
XmlObject,
ActionListener {
    public static final int FTP_SETTINGS = 1;
    public static final int APN_SETTINGS = 4;
    private JPanel mainPanel;
    private JPanel gprsPanel;
    private JPanel resetPanel;
    private HCPGreyButton resetButton;
    private HCPGreyButton unlockButton;
    private HCPGreyButton printSettings;
    private HCPGreyButton addPatern;
    private HCPGreyButton rmvPatern;
    private HCPTextFieldRange gprsUpload;
    private HCPTextFieldRange gprsDownload;
    private HCPTextFieldRange apnAdresa;
    private HCPTextFieldRange apnUser;
    private HCPTextFieldRange serverUser;
    private HCPTextField apnPass;
    private HCPTextField serverPass;
    private HCPTextField_IP_ADDRESS serverAdresa;
    private HCPComboBox template;
    private HCPGreyButton readData;
    private HCPTextField simNumber;
    private HCPTextField timeOfSend;
    private HCPTextField timeSent;
    private HCPLabel signalLabel;
    private SavePanel sp;
    public ToolsThread runner;
    ImageIcon slikaPlus = new ImageIcon("images/plus.png");
    ImageIcon slikaMinus = new ImageIcon("images/minus.png");
    ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
    ImageIcon slikaSignal0 = new ImageIcon("images/signal ico0.png");
    ImageIcon slikaSignal1 = new ImageIcon("images/signal ico1.png");
    ImageIcon slikaSignal2 = new ImageIcon("images/signal ico2.png");
    ImageIcon slikaSignal3 = new ImageIcon("images/signal ico3.png");
    ImageIcon slikaSignal4 = new ImageIcon("images/signal ico4.png");

    public GPRSPanel() {
        super(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON"), 'G', LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_TOOLTIP"));
        this.runner = new ToolsThread();
        this.setLayout(new BorderLayout(7, 10));
        this.sp = new SavePanel(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL"));
        this.add((Component)this.sp, "North");
        this.mainPanel = new JPanel();
        this.mainPanel.setOpaque(false);
        SpringLayout osl = new SpringLayout();
        this.mainPanel.setLayout(osl);
        this.mainPanel.setIgnoreRepaint(true);
        this.mainPanel.setPreferredSize(new Dimension(487, 300));
        this.mainPanel.setBackground(HCPColors.getColorM2st());
        this.add((Component)this.mainPanel, "West");
        this.gprsPanel = new JPanel();
        this.gprsPanel.setLayout(new GridLayout(6, 1, 0, 0));
        this.gprsPanel.setPreferredSize(new Dimension(330, 429));
        this.gprsPanel.setIgnoreRepaint(true);
        this.gprsPanel.setBackground(HCPColors.getColorM2st());
        this.gprsPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(0, 15, 5, 15)));
        this.gprsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_LABEL"), new ImageIcon("images/globe.png"), 0));
        JPanel gprsPomPanel = new JPanel();
        gprsPomPanel.setLayout(new GridLayout(3, 2, 5, 5));
        gprsPomPanel.setBackground(HCPColors.getColorM2st());
        gprsPomPanel.add(new HCPLabel());
        gprsPomPanel.add(new HCPLabel());
        gprsPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_UPLOAD"), 4));
        this.gprsUpload = new HCPTextFieldRange(46);
        gprsPomPanel.add(this.gprsUpload);
        gprsPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_DOWNLOAD"), 4));
        this.gprsDownload = new HCPTextFieldRange(46);
        gprsPomPanel.add(this.gprsDownload);
        this.gprsPanel.add(gprsPomPanel);
        this.gprsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN_SETTINGS"), 0));
        JPanel apnPomPanel = new JPanel();
        apnPomPanel.setLayout(new GridLayout(3, 2, 5, 5));
        apnPomPanel.setBackground(HCPColors.getColorM2st());
        apnPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN"), 4));
        this.apnAdresa = new HCPTextFieldRange(22);
        apnPomPanel.add(this.apnAdresa);
        apnPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN_USERNAME"), 4));
        this.apnUser = new HCPTextFieldRange(22);
        apnPomPanel.add(this.apnUser);
        apnPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_APN_PASSWORD"), 4));
        this.apnPass = new HCPTextField();
        apnPomPanel.add(this.apnPass);
        this.gprsPanel.add(apnPomPanel);
        this.gprsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_SETTINGS"), 0));
        JPanel serverPomPanel = new JPanel();
        serverPomPanel.setLayout(new GridLayout(3, 2, 5, 5));
        serverPomPanel.setBackground(HCPColors.getColorM2st());
        serverPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_ADDRESS"), 4));
        this.serverAdresa = new HCPTextField_IP_ADDRESS();
        serverPomPanel.add(this.serverAdresa);
        serverPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_USERNAME"), 4));
        this.serverUser = new HCPTextFieldRange(22);
        serverPomPanel.add(this.serverUser);
        serverPomPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_FTP_PASSWORD"), 4));
        this.serverPass = new HCPTextField();
        serverPomPanel.add(this.serverPass);
        this.gprsPanel.add(serverPomPanel);
        this.resetPanel = new JPanel(new GridLayout(15, 1, 5, 5));
        this.resetPanel.setPreferredSize(new Dimension(150, 429));
        this.resetPanel.setBackground(HCPColors.getColorM2st());
        this.resetPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.resetButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_RESET"));
        this.resetButton.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_RESET_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_RESET_TOOLTIP_1") + "<br>" + "</html>");
        this.resetButton.addActionListener(this);
        this.resetButton.setActionCommand("RESET_COMMAND");
        this.resetButton.setIcon(this.slikaCash);
        this.resetPanel.add(this.resetButton);
        this.unlockButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_UNLOCK"));
        this.unlockButton.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_UNLOCK_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_UNLOCK_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_UNLOCK_TOOLTIP_2") + "</u><br>" + "</html>");
        this.unlockButton.addActionListener(this);
        this.unlockButton.setActionCommand("UNLOCK");
        this.unlockButton.setIcon(this.slikaCash);
        this.resetPanel.add(this.unlockButton);
        this.resetPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL_PATERNS")));
        GPRSPatterns.getInstance().readAll();
        this.template = new HCPComboBox(GPRSPatterns.vec);
        this.template.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.resetPanel.add(this.template);
        this.template.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GPRSPatterns.PatternGPRS tmp = (GPRSPatterns.PatternGPRS)GPRSPanel.this.template.getSelectedItem();
                if (tmp == null) {
                    return;
                }
                GPRSPanel.this.gprsUpload.setText(tmp.uploadPath);
                GPRSPanel.this.gprsDownload.setText(tmp.downPath);
                GPRSPanel.this.apnAdresa.setText(tmp.APN);
                GPRSPanel.this.apnUser.setText(tmp.APNUser);
                GPRSPanel.this.apnPass.setText(tmp.APNPass);
                GPRSPanel.this.serverAdresa.setText(tmp.ftpAdd);
                GPRSPanel.this.serverUser.setText(tmp.ftpUser);
                GPRSPanel.this.serverPass.setText(tmp.ftpPass);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.addPatern = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_ADD"));
        this.addPatern.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_ADD_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_ADD_TOOLTIP_1") + "<br>" + "</html>");
        this.addPatern.setIcon(this.slikaPlus);
        this.addPatern.addActionListener(this);
        this.addPatern.setActionCommand("ADD");
        this.resetPanel.add(this.addPatern);
        this.rmvPatern = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_REMOVE"));
        this.rmvPatern.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_REMOVE_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_REMOVE_TOOLTIP_1") + "<br>" + "</html>");
        this.rmvPatern.setIcon(this.slikaMinus);
        this.rmvPatern.addActionListener(this);
        this.rmvPatern.setActionCommand("RMV");
        this.resetPanel.add(this.rmvPatern);
        this.resetPanel.add(new HCPLabel());
        this.signalLabel = new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL_SIM_NUMBER"));
        this.signalLabel.setHorizontalTextPosition(2);
        this.signalLabel.setIcon(this.slikaSignal0);
        this.resetPanel.add(this.signalLabel);
        this.simNumber = new HCPTextField();
        this.simNumber.setEditable(false);
        this.resetPanel.add(this.simNumber);
        this.resetPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL_SEND_TIME")));
        this.timeSent = new HCPTextField();
        this.timeSent.setEditable(false);
        this.resetPanel.add(this.timeSent);
        this.resetPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL_NEXT_SEND")));
        this.timeOfSend = new HCPTextField();
        this.timeOfSend.setEditable(false);
        this.resetPanel.add(this.timeOfSend);
        this.readData = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_READ_DATA"));
        this.readData.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_READ_DATA_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_READ_DATA_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("GPRS_PANEL_BUTTON_READ_DATA_TOOLTIP_2") + "</u><br>" + "</html>");
        this.readData.setIcon(this.slikaCash);
        this.readData.addActionListener(this);
        this.readData.setActionCommand("DATA");
        this.resetPanel.add(this.readData);
        this.printSettings = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_PRINT_SETTINGS"));
        this.printSettings.setToolTipText(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_PRINT_GPRS_TOOLTIP"));
        this.printSettings.addActionListener(this);
        this.printSettings.setActionCommand("PRINT_GPRS");
        this.printSettings.setIcon(this.slikaCash);
        this.resetPanel.add(this.printSettings);
        osl.putConstraint("North", (Component)this.gprsPanel, 0, "North", (Component)this.mainPanel);
        osl.putConstraint("West", (Component)this.gprsPanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.gprsPanel);
        osl.putConstraint("North", (Component)this.resetPanel, 0, "North", (Component)this.mainPanel);
        osl.putConstraint("West", (Component)this.resetPanel, 7, "East", (Component)this.gprsPanel);
        this.mainPanel.add(this.resetPanel);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout(10, 10));
        outerPanel.setIgnoreRepaint(true);
        outerPanel.setBackground(HCPColors.getColorM2st());
        outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_HELP_LABEL")), "North");
        this.add((Component)outerPanel, "Center");
        JPanel inPanel = new JPanel();
        inPanel.setLayout(new BorderLayout(10, 10));
        inPanel.setIgnoreRepaint(true);
        inPanel.setBackground(HCPColors.getColorM2st());
        inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea text = new JTextArea();
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        text.setFont(GlavniFrame.font);
        text.setText(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_HELP_TEXT_0"));
        int i = 1;
        try {
            while (true) {
                text.append("\r\n\r\n");
                text.append(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_HELP_TEXT_" + i++));
            }
        }
        catch (Exception exception) {
            JScrollPane scrText = new JScrollPane(text, 20, 31);
            inPanel.add((Component)scrText, "Center");
            outerPanel.add((Component)inPanel, "Center");
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        block12: {
            String s = e.getActionCommand();
            try {
                if (s.equalsIgnoreCase("RESET_COMMAND")) {
                    this.runner.setJob(1);
                    break block12;
                }
                if (s.indexOf("DATA") >= 0) {
                    this.runner.setJob(3);
                    break block12;
                }
                if (s.indexOf("UNLOCK") >= 0) {
                    this.runner.setJob(2);
                    break block12;
                }
                if (s.indexOf("PRINT_GPRS") >= 0) {
                    this.runner.setJob(4);
                    break block12;
                }
                if (s.indexOf("ADD") >= 0) {
                    String newName = JOptionPane.showInputDialog(this, (Object)LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_ENTER_NAME"));
                    if (newName == null) {
                        return;
                    }
                    if (newName.length() <= 0) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_YOU_MUST_ENTER_NAME"), "ERROR", 0);
                        return;
                    }
                    GPRSPatterns.PatternGPRS tmp = new GPRSPatterns.PatternGPRS(GPRSPatterns.getInstance());
                    tmp.name = newName;
                    tmp.uploadPath = this.gprsUpload.getText();
                    tmp.downPath = this.gprsDownload.getText();
                    tmp.APN = this.apnAdresa.getText();
                    tmp.APNUser = this.apnUser.getText();
                    tmp.APNPass = this.apnPass.getText();
                    tmp.ftpAdd = this.serverAdresa.getText();
                    tmp.ftpUser = this.serverUser.getText();
                    tmp.ftpPass = this.serverPass.getText();
                    GPRSPatterns.vec.add(tmp);
                    this.template.revalidate();
                    this.template.setSelectedItem(tmp);
                    GPRSPatterns.getInstance().saveAll();
                    break block12;
                }
                if (s.indexOf("RMV") < 0) break block12;
                if (JOptionPane.showConfirmDialog(this, LanguageStrings.getAreYouSure(), "DELETE", 2) != 0) {
                    return;
                }
                try {
                    GPRSPatterns.vec.remove(this.template.getSelectedIndex());
                    this.template.revalidate();
                }
                catch (Exception newName) {
                    // empty catch block
                }
                GPRSPatterns.getInstance().saveAll();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                return;
            }
        }
    }

    public void sendToPort() throws Exception {
        this.sendFTP();
        this.sendAPN();
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
    }

    public void readFromPort() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            this.readFTP();
            this.readApn();
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<SETTINGS>");
        if (writer == null) {
            return;
        }
        writer.indent();
        writer.write("<DATA GPRS_UPLOAD = '" + XmlFileWriter.compileString(this.gprsUpload.getText()) + "'");
        writer.write(" GPRS_DOWNLOAD = '" + XmlFileWriter.compileString(this.gprsDownload.getText()) + "'");
        writer.write(" APN = '" + XmlFileWriter.compileString(this.apnAdresa.getText()) + "'");
        writer.write(" APN_USER = '" + XmlFileWriter.compileString(this.apnUser.getText()) + "'");
        writer.write(" APN_PASS = '" + XmlFileWriter.compileString(new String(this.apnPass.getText())) + "'");
        writer.write(" FTP = '" + XmlFileWriter.compileString(this.serverAdresa.getText()) + "'");
        writer.write(" FTP_USER = '" + XmlFileWriter.compileString(this.serverUser.getText()) + "'");
        writer.write(" FTP_PASS = '" + XmlFileWriter.compileString(new String(this.serverPass.getText())) + "'");
        writer.writeLn("/>");
        writer.unintent();
        writer.writeLn("</SETTINGS>");
    }

    public void readFromXML(File file) throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element artEl = doc.getDocumentElement();
            NodeList dataNode = artEl.getElementsByTagName("DATA");
            Element elem = (Element)dataNode.item(0);
            if (elem == null) {
                return;
            }
            this.gprsUpload.setText(elem.getAttribute("GPRS_UPLOAD"));
            this.gprsDownload.setText(elem.getAttribute("GPRS_DOWNLOAD"));
            this.apnAdresa.setText(elem.getAttribute("APN"));
            this.apnUser.setText(elem.getAttribute("APN_USER"));
            this.apnPass.setText(elem.getAttribute("APN_PASS"));
            this.serverAdresa.setText(elem.getAttribute("FTP"));
            this.serverUser.setText(elem.getAttribute("FTP_USER"));
            this.serverPass.setText(elem.getAttribute("FTP_PASS"));
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public void readFTP() throws Exception {
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(104);
        instance.addByte(1);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command command = port.receiveFrame();
        int e = command.getArray()[0] & 0xFF;
        int cmdRet = command.getCmd();
        if (cmdRet != 104 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        instance = command;
        int pos = 1;
        try {
            int add4 = instance.getByte(pos++) & 0xFF;
            int add3 = instance.getByte(pos++) & 0xFF;
            int add2 = instance.getByte(pos++) & 0xFF;
            int add1 = instance.getByte(pos++) & 0xFF;
            String ftpAdd = "" + add1 + '.' + add2 + '.' + add3 + '.' + add4;
            this.serverAdresa.setText(ftpAdd);
            int len = instance.getShort(pos++);
            byte[] ftpUser = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, ftpUser, 0, len);
            this.serverUser.setText(new String(ftpUser, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] ftpPass = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, ftpPass, 0, len);
            this.serverPass.setText(new String(ftpPass, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] ftpUpload = new byte[46];
            System.arraycopy(instance.getArray(), ++pos, ftpUpload, 0, len);
            this.gprsUpload.setText(new String(ftpUpload, 0, len));
            pos += 46;
            len = instance.getShort(pos++);
            byte[] ftpDownload = new byte[46];
            System.arraycopy(instance.getArray(), ++pos, ftpDownload, 0, len);
            this.gprsDownload.setText(new String(ftpDownload, 0, len));
            pos += 46;
        }
        catch (Exception e1) {
            throw new Exception("FTP error: " + e1.getMessage());
        }
    }

    public void sendFTP() throws Exception {
        int add4;
        int add3;
        int add2;
        int add1;
        byte[] ftpUpload;
        byte[] ftpDownload;
        byte[] ftpPass;
        byte[] ftpUser;
        PortSerial port = PortSerial.getInstance();
        try {
            String ftpAdd = this.serverAdresa.getText();
            ftpUser = this.serverUser.getText().getBytes();
            ftpPass = new String(this.serverPass.getText()).getBytes();
            ftpDownload = this.gprsDownload.getText().getBytes();
            ftpUpload = this.gprsUpload.getText().getBytes();
            if (ftpUser.length > 22 || ftpPass.length > 22 || ftpDownload.length > 46 || ftpUpload.length > 46) {
                throw new Exception("input string is too long!");
            }
            StringTokenizer st = new StringTokenizer(ftpAdd, ".");
            add1 = Integer.parseInt(st.nextToken());
            add2 = Integer.parseInt(st.nextToken());
            add3 = Integer.parseInt(st.nextToken());
            add4 = Integer.parseInt(st.nextToken());
        }
        catch (Exception e1) {
            throw new Exception("FTP error: " + e1.getMessage());
        }
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(103);
        instance.addByte(1);
        instance.addByte(add4);
        instance.addByte(add3);
        instance.addByte(add2);
        instance.addByte(add1);
        byte[] bb = new byte[22];
        System.arraycopy(ftpUser, 0, bb, 0, ftpUser.length);
        instance.addShort(ftpUser.length);
        instance.addToArray(bb, 0, bb.length);
        bb = new byte[22];
        System.arraycopy(ftpPass, 0, bb, 0, ftpPass.length);
        instance.addShort(ftpPass.length);
        instance.addToArray(bb, 0, bb.length);
        bb = new byte[46];
        System.arraycopy(ftpUpload, 0, bb, 0, ftpUpload.length);
        instance.addShort(ftpUpload.length);
        instance.addToArray(bb, 0, bb.length);
        bb = new byte[46];
        System.arraycopy(ftpDownload, 0, bb, 0, ftpDownload.length);
        instance.addShort(ftpDownload.length);
        instance.addToArray(bb, 0, bb.length);
        port.sendFrame(instance);
        Command command = port.receiveFrame();
        int e = command.getArray()[0] & 0xFF;
        int cmdRet = command.getCmd();
        if (cmdRet != 103 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void sendAPN() throws Exception {
        byte[] aPass;
        byte[] aUser;
        byte[] aAdd;
        PortSerial port = PortSerial.getInstance();
        try {
            aAdd = this.apnAdresa.getText().getBytes();
            aUser = this.apnUser.getText().getBytes();
            aPass = new String(this.apnPass.getText()).getBytes();
            if (aUser.length > 22 || aPass.length > 22 || aAdd.length > 22) {
                throw new Exception("input string is too long!");
            }
        }
        catch (Exception e1) {
            throw new Exception("APN error: " + e1.getMessage());
        }
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(103);
        instance.addByte(4);
        byte[] bb = new byte[22];
        System.arraycopy(aAdd, 0, bb, 0, aAdd.length);
        instance.addShort(aAdd.length);
        instance.addToArray(bb, 0, bb.length);
        bb = new byte[22];
        System.arraycopy(aUser, 0, bb, 0, aUser.length);
        instance.addShort(aUser.length);
        instance.addToArray(bb, 0, bb.length);
        bb = new byte[22];
        System.arraycopy(aPass, 0, bb, 0, aPass.length);
        instance.addShort(aPass.length);
        instance.addToArray(bb, 0, bb.length);
        port.sendFrame(instance);
        Command command = port.receiveFrame();
        int e = command.getArray()[0] & 0xFF;
        int cmdRet = command.getCmd();
        if (cmdRet != 103 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void readApn() throws Exception {
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(104);
        instance.addByte(4);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command command = port.receiveFrame();
        int e = command.getArray()[0] & 0xFF;
        int cmdRet = command.getCmd();
        if (cmdRet != 104 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        instance = command;
        int pos = 1;
        try {
            int len = instance.getShort(pos++);
            byte[] aAdd = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, aAdd, 0, len);
            this.apnAdresa.setText(new String(aAdd, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] aUser = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, aUser, 0, len);
            this.apnUser.setText(new String(aUser, 0, len));
            pos += 22;
            len = instance.getShort(pos++);
            byte[] aPass = new byte[22];
            System.arraycopy(instance.getArray(), ++pos, aPass, 0, len);
            this.apnPass.setText(new String(aPass, 0, len));
            pos += 22;
        }
        catch (Exception e1) {
            throw new Exception("APN error: " + e1.getMessage());
        }
    }

    public void readDATA() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            Command.instance.reset();
            Command.instance.setCmd(96);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 96 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            byte[] b = new byte[24];
            System.arraycopy(Command.instance.getArray(), 9, b, 0, 24);
            if (Command.instance.getByte(9) == 6) {
                this.simNumber.setText(new String(b).trim());
            } else {
                this.simNumber.setText(LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_SIM_NOT_VALID"));
            }
            int bs = Command.instance.getByte(0);
            if (bs < 10) {
                this.signalLabel.setIcon(this.slikaSignal0);
            }
            if (bs >= 10 && bs < 13) {
                this.signalLabel.setIcon(this.slikaSignal1);
            }
            if (bs >= 13 && bs < 17) {
                this.signalLabel.setIcon(this.slikaSignal2);
            }
            if (bs >= 17 && bs < 21) {
                this.signalLabel.setIcon(this.slikaSignal3);
            }
            if (bs >= 21) {
                this.signalLabel.setIcon(this.slikaSignal4);
            }
            long time = Command.instance.getInt(1);
            time *= 1000L;
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy,HH:mm");
            Date d = new Date(time += 946684800000L);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.timeSent.setText(sdf.format(d));
            time = Command.instance.getInt(5);
            time *= 1000L;
            d = new Date(time += 946684800000L);
            this.timeOfSend.setText(sdf.format(d));
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private void stampajGPRS() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(112);
        instance.addByte(1);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 112 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private class ToolsThread
    extends Thread {
        public static final byte RESET_COMMAND = 1;
        public static final byte UNLOCK = 2;
        public static final byte DATA = 3;
        public static final byte PRINT = 4;
        private int job = 0;

        public ToolsThread() {
            this.start();
        }

        public final synchronized void setJob(int j) throws Exception {
            if (this.job != 0) {
                throw new Exception(LanguageStrings.getProgramIsBusy());
            }
            this.job = j;
            this.notify();
        }

        public final synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            this.resetCommand();
                            break;
                        }
                        case 2: {
                            this.unlockSIM();
                            break;
                        }
                        case 3: {
                            GPRSPanel.this.readDATA();
                            break;
                        }
                        case 4: {
                            GPRSPanel.this.stampajGPRS();
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }

        private void resetCommand() throws Exception {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(64);
            instance.addByte(0);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = instance.getArray()[0] & 0xFF;
            int command = instance.getCmd();
            if (command != 64 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }

        public void unlockSIM() throws Exception {
            Command.instance.reset();
            Command.instance.setCmd(95);
            String spib = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)LanguageStrings.getInstance().getStringByName("GPRS_SUBPANEL_ENTER_CODE"));
            if (spib == null) {
                return;
            }
            Command.instance.addToArray(spib.getBytes(), 0, spib.length());
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 95 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
        }
    }
}

