/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import cashRegister.FiscalCommands;
import gui.GlavniFrame;
import gui.HCPClockComboBox;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPSpinner;
import gui.HCPTextField;
import gui.HCPfileChooser;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import gui.StatusDialog;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.lang.LanguageStrings;
import org.freixas.jcalendar.JCalendarCombo;
import util.SysUtil;
import util.comPort.PortSerial;

public class FiskalizacijaPanel
extends RightPanel
implements ActionListener {
    private HCPGreyButton setTimeButton;
    private HCPGreyButton readDataButton;
    private HCPGreyButton fiscButton;
    private HCPGreyButton setCurTimeButton;
    private HCPTextField tfPib;
    private HCPTextField tfIbfm;
    private HCPTextField tfTime;
    private HCPClockComboBox comboTime;
    private JCalendarCombo date;
    private JPanel fiscPanel;
    private JPanel datePanel;
    private JPanel dataPanel;
    private JPanel resetPanel;
    private JPanel izvestajiPanel;
    private JPanel periodicniPanel;
    private HCPGreyButton reset1;
    private HCPGreyButton reset2;
    private HCPGreyButton dnevni;
    private HCPGreyButton presek;
    private HCPGreyButton periodicni;
    private JCalendarCombo cod;
    private JCalendarCombo cdo;
    private HCPSpinner zFrom;
    private HCPSpinner zTo;
    private HCPTextField tfIBFM;
    private HCPTextField tfPass;
    public ToolsThread runner;
    private SpringLayout osl;
    private boolean mode = true;
    private ImageIcon slikaTest = new ImageIcon("images/Control-Panel_Small.png");
    private ImageIcon slikaMem = new ImageIcon("images/mem.png");
    private ImageIcon slikaPrint = new ImageIcon("images/print.png");
    private ImageIcon slikaClock = new ImageIcon("images/clock.png");
    private JTextField ntfDaily;
    private JTextField ntfCommand;

    public FiskalizacijaPanel() {
        super(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON"), 'F', LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_TOOLTIP"));
        this.runner = new ToolsThread();
        this.osl = new SpringLayout();
        this.setLayout(this.osl);
        this.fiscPanel = new JPanel();
        this.fiscPanel.setLayout(new GridLayout(2, 1, 15, 15));
        this.fiscPanel.setPreferredSize(new Dimension(280, 110));
        this.fiscPanel.setIgnoreRepaint(true);
        this.fiscPanel.setBackground(HCPColors.getColorM2st());
        this.fiscPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 55, 15, 55)));
        this.setCurTimeButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_SET_TIME"));
        this.setCurTimeButton.setToolTipText(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_SET_TIME_TOOLTIP"));
        this.setCurTimeButton.setIcon(this.slikaClock);
        this.setCurTimeButton.addActionListener(this);
        this.setCurTimeButton.setActionCommand("SET_CURRENT_TIME");
        this.fiscPanel.add(this.setCurTimeButton);
        this.fiscButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_FISCALISE"));
        this.fiscButton.setToolTipText("<html>" + LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_FISCALISE_TOOLTIP_0") + "<br>" + LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_FISCALISE_TOOLTIP_1") + "<br><u>" + LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_FISCALISE_TOOLTIP_2") + "</u><br></html>");
        this.fiscButton.setIcon(this.slikaTest);
        this.fiscButton.addActionListener(this);
        this.fiscButton.setActionCommand("FISCAL");
        this.fiscPanel.add(this.fiscButton);
        this.datePanel = new JPanel(new BorderLayout());
        this.datePanel.setPreferredSize(new Dimension(280, 200));
        this.datePanel.setIgnoreRepaint(true);
        this.datePanel.setBackground(HCPColors.getColorM2st());
        this.datePanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        JPanel dpp1Panel = new JPanel(new GridLayout(4, 1, 5, 5));
        dpp1Panel.setBackground(HCPColors.getColorM2st());
        dpp1Panel.setBorder(new EmptyBorder(5, 15, 15, 15));
        dpp1Panel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_DATE"), 0));
        this.date = new JCalendarCombo();
        dpp1Panel.add(this.date);
        dpp1Panel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_TIME"), 0));
        this.comboTime = new HCPClockComboBox();
        dpp1Panel.add(this.comboTime);
        this.datePanel.add((Component)dpp1Panel, "Center");
        this.setTimeButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_SELECT_TIME"));
        this.setTimeButton.setToolTipText(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_SELECT_TIME_TOOLTIP"));
        this.setTimeButton.setIcon(this.slikaClock);
        this.setTimeButton.addActionListener(this);
        this.setTimeButton.setActionCommand("SET_TIME");
        JPanel dpp2Panel = new JPanel(new BorderLayout());
        dpp2Panel.setBackground(HCPColors.getColorM2st());
        dpp2Panel.setBorder(new EmptyBorder(0, 35, 0, 35));
        dpp2Panel.add((Component)this.setTimeButton, "Center");
        this.datePanel.add((Component)dpp2Panel, "South");
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.setPreferredSize(new Dimension(280, 200));
        this.dataPanel.setIgnoreRepaint(true);
        this.dataPanel.setBackground(HCPColors.getColorM2st());
        this.dataPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        JPanel dpp11Panel = new JPanel(new GridLayout(3, 2, 15, 15));
        dpp11Panel.setBackground(HCPColors.getColorM2st());
        dpp11Panel.setBorder(new EmptyBorder(15, 5, 15, 5));
        dpp11Panel.add(new HCPLabel("pib", 4));
        this.tfPib = new HCPTextField();
        this.tfPib.setEditable(false);
        dpp11Panel.add(this.tfPib);
        dpp11Panel.add(new HCPLabel("ibfm", 4));
        this.tfIbfm = new HCPTextField();
        this.tfIbfm.setEditable(false);
        dpp11Panel.add(this.tfIbfm);
        dpp11Panel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_FICSALISATION_TIME"), 4));
        this.tfTime = new HCPTextField();
        this.tfTime.setEditable(false);
        dpp11Panel.add(this.tfTime);
        this.dataPanel.add((Component)dpp11Panel, "Center");
        this.readDataButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_READ_DATA"));
        this.readDataButton.setToolTipText(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_READ_DATA_TOOLTIP"));
        this.readDataButton.setIcon(this.slikaPrint);
        this.readDataButton.addActionListener(this);
        this.readDataButton.setActionCommand("READ_DATA");
        JPanel dpp22Panel = new JPanel(new BorderLayout());
        dpp22Panel.setBackground(HCPColors.getColorM2st());
        dpp22Panel.setBorder(new EmptyBorder(0, 35, 0, 35));
        dpp22Panel.add((Component)this.readDataButton, "Center");
        this.dataPanel.add((Component)dpp22Panel, "South");
        this.resetPanel = new JPanel();
        this.resetPanel.setLayout(new GridLayout(2, 1, 15, 15));
        this.resetPanel.setPreferredSize(new Dimension(280, 110));
        this.resetPanel.setIgnoreRepaint(true);
        this.resetPanel.setBackground(HCPColors.getColorM2st());
        this.resetPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 55, 15, 55)));
        this.reset1 = new HCPGreyButton("reset P");
        this.reset1.setIcon(this.slikaMem);
        this.reset1.addActionListener(this);
        this.reset1.setActionCommand("RESET_P");
        this.resetPanel.add(this.reset1);
        this.reset2 = new HCPGreyButton("reset C");
        this.reset2.setIcon(this.slikaMem);
        this.reset2.addActionListener(this);
        this.reset2.setActionCommand("RESET_C");
        this.resetPanel.add(this.reset2);
        this.izvestajiPanel = new JPanel();
        this.izvestajiPanel.setLayout(new GridLayout(2, 1, 15, 15));
        this.izvestajiPanel.setPreferredSize(new Dimension(280, 110));
        this.izvestajiPanel.setIgnoreRepaint(true);
        this.izvestajiPanel.setBackground(HCPColors.getColorM2st());
        this.izvestajiPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 55, 15, 55)));
        this.dnevni = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_DAILY"));
        this.dnevni.setIcon(this.slikaPrint);
        this.dnevni.addActionListener(this);
        this.dnevni.setActionCommand("DNEVNI");
        this.izvestajiPanel.add(this.dnevni);
        this.presek = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_STATE"));
        this.presek.setIcon(this.slikaPrint);
        this.presek.addActionListener(this);
        this.presek.setActionCommand("PRESEK");
        this.izvestajiPanel.add(this.presek);
        this.periodicniPanel = new JPanel(new BorderLayout());
        this.periodicniPanel.setPreferredSize(new Dimension(280, 200));
        this.periodicniPanel.setIgnoreRepaint(true);
        this.periodicniPanel.setBackground(HCPColors.getColorM2st());
        this.periodicniPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        this.cod = new JCalendarCombo();
        this.cdo = new JCalendarCombo();
        JPanel dpp33Panel = new JPanel(new GridLayout(4, 1, 0, 0));
        dpp33Panel.setBackground(HCPColors.getColorM2st());
        dpp33Panel.setBorder(new EmptyBorder(5, 15, 15, 15));
        dpp33Panel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_FROM"), 0));
        dpp33Panel.add(this.cod);
        dpp33Panel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_TO"), 0));
        dpp33Panel.add(this.cdo);
        this.zFrom = new HCPSpinner(new SpinnerNumberModel(1, 1, 2500, 1));
        this.zTo = new HCPSpinner(new SpinnerNumberModel(1, 1, 2500, 1));
        JPanel dpp55Panel = new JPanel(new GridLayout(4, 1, 5, 5));
        dpp55Panel.setBackground(HCPColors.getColorM2st());
        dpp55Panel.setBorder(new EmptyBorder(5, 15, 15, 15));
        dpp55Panel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_FROM"), 0));
        dpp55Panel.add(this.zFrom);
        dpp55Panel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_TO"), 0));
        dpp55Panel.add(this.zTo);
        final JPanel cardPanel = new JPanel();
        final CardLayout cl = new CardLayout();
        cardPanel.setLayout(cl);
        cardPanel.add((Component)dpp33Panel, "date");
        cardPanel.add((Component)dpp55Panel, "z");
        cl.show(cardPanel, "date");
        this.periodicniPanel.add((Component)cardPanel, "Center");
        HCPGreyButton flip = new HCPGreyButton("Change mode");
        flip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                cl.next(cardPanel);
                FiskalizacijaPanel.this.mode = !FiskalizacijaPanel.this.mode;
            }
        });
        this.periodicni = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_BUTTON_PERIODICAL"));
        this.periodicni.setIcon(this.slikaPrint);
        this.periodicni.addActionListener(this);
        this.periodicni.setActionCommand("PERIODICNI");
        JPanel dpp44Panel = new JPanel(new BorderLayout());
        dpp44Panel.setBackground(HCPColors.getColorM2st());
        dpp44Panel.setBorder(new EmptyBorder(0, 35, 0, 35));
        dpp44Panel.add((Component)this.periodicni, "Center");
        this.periodicniPanel.add((Component)dpp44Panel, "South");
        this.osl.putConstraint("North", (Component)this.fiscPanel, 0, "North", (Component)this);
        this.osl.putConstraint("West", (Component)this.fiscPanel, 0, "West", (Component)this);
        this.add(this.fiscPanel);
        this.osl.putConstraint("North", (Component)this.resetPanel, 0, "North", (Component)this);
        this.osl.putConstraint("West", (Component)this.resetPanel, 7, "East", (Component)this.fiscPanel);
        this.add(this.resetPanel);
        this.osl.putConstraint("North", (Component)this.izvestajiPanel, 0, "North", (Component)this);
        this.osl.putConstraint("West", (Component)this.izvestajiPanel, 7, "East", (Component)this.resetPanel);
        this.add(this.izvestajiPanel);
        this.osl.putConstraint("North", (Component)this.datePanel, 7, "South", (Component)this.fiscPanel);
        this.osl.putConstraint("West", (Component)this.datePanel, 0, "West", (Component)this);
        this.add(this.datePanel);
        this.osl.putConstraint("North", (Component)this.dataPanel, 7, "South", (Component)this.fiscPanel);
        this.osl.putConstraint("West", (Component)this.dataPanel, 7, "East", (Component)this.datePanel);
        this.add(this.dataPanel);
        this.osl.putConstraint("North", (Component)this.periodicniPanel, 7, "South", (Component)this.fiscPanel);
        this.osl.putConstraint("West", (Component)this.periodicniPanel, 7, "East", (Component)this.dataPanel);
        this.add(this.periodicniPanel);
        JPanel testDailyPanel = new JPanel();
        testDailyPanel.setLayout(new GridLayout(2, 1, 15, 15));
        testDailyPanel.setPreferredSize(new Dimension(150, 110));
        testDailyPanel.setIgnoreRepaint(true);
        testDailyPanel.setBackground(HCPColors.getColorM2st());
        testDailyPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        HCPGreyButton testDaily = new HCPGreyButton("test dnevni");
        testDaily.setToolTipText("Unesi \"BROJ_IZVESTAJA,SUMA_PO_IZVESTAJU,BROJ_RACUNA_PO_IZVESTAJU\"");
        testDaily.setIcon(this.slikaMem);
        testDaily.addActionListener(this);
        testDaily.setActionCommand("TEST_DAILY");
        testDailyPanel.add(testDaily);
        this.ntfDaily = new HCPTextField();
        testDailyPanel.add(this.ntfDaily);
        this.osl.putConstraint("North", (Component)testDailyPanel, 7, "South", (Component)this.datePanel);
        this.osl.putConstraint("West", (Component)testDailyPanel, 0, "West", (Component)this);
        JPanel testTimePanel = new JPanel();
        testTimePanel.setLayout(new GridLayout(2, 1, 15, 15));
        testTimePanel.setPreferredSize(new Dimension(172, 110));
        testTimePanel.setIgnoreRepaint(true);
        testTimePanel.setBackground(HCPColors.getColorM2st());
        testTimePanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        HCPGreyButton startTest = new HCPGreyButton("send command");
        startTest.setIcon(this.slikaTest);
        startTest.addActionListener(this);
        startTest.setActionCommand("USER_COMMAND");
        testTimePanel.add(startTest);
        this.ntfCommand = new HCPTextField();
        testTimePanel.add(this.ntfCommand);
        this.osl.putConstraint("North", (Component)testTimePanel, 7, "South", (Component)this.datePanel);
        this.osl.putConstraint("West", (Component)testTimePanel, 7, "East", (Component)testDailyPanel);
        JPanel testPrinterPanel = new JPanel();
        testPrinterPanel.setLayout(new GridLayout(2, 1, 15, 15));
        testPrinterPanel.setPreferredSize(new Dimension(150, 110));
        testPrinterPanel.setIgnoreRepaint(true);
        testPrinterPanel.setBackground(HCPColors.getColorM2st());
        testPrinterPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(15, 15, 15, 15)));
        HCPGreyButton testPrinter = new HCPGreyButton("read time");
        testPrinter.setIcon(this.slikaMem);
        testPrinter.addActionListener(this);
        testPrinter.setActionCommand("READ_TIME");
        testPrinterPanel.add(testPrinter);
        HCPGreyButton testStatus = new HCPGreyButton("test status");
        testStatus.setIcon(this.slikaMem);
        testStatus.addActionListener(this);
        testStatus.setActionCommand("STATUS");
        testPrinterPanel.add(testStatus);
        this.osl.putConstraint("North", (Component)testPrinterPanel, 7, "South", (Component)this.datePanel);
        this.osl.putConstraint("West", (Component)testPrinterPanel, 7, "East", (Component)testTimePanel);
        JPanel testIBFMPanel = new JPanel();
        testIBFMPanel.setLayout(new BorderLayout());
        testIBFMPanel.setPreferredSize(new Dimension(356, 110));
        testIBFMPanel.setIgnoreRepaint(true);
        testIBFMPanel.setBackground(HCPColors.getColorM2st());
        testIBFMPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 15, 5, 15)));
        JPanel pomIBFMPanel = new JPanel();
        pomIBFMPanel.setLayout(new GridLayout(2, 2, 5, 5));
        pomIBFMPanel.setBackground(HCPColors.getColorM2st());
        this.tfIBFM = new HCPTextField();
        this.tfPass = new HCPTextField();
        pomIBFMPanel.add(new HCPLabel("IBFM:"));
        pomIBFMPanel.add(new HCPLabel("password:"));
        pomIBFMPanel.add(this.tfIBFM);
        pomIBFMPanel.add(this.tfPass);
        testIBFMPanel.add((Component)pomIBFMPanel, "North");
        JPanel pomIBFMPanel2 = new JPanel();
        pomIBFMPanel2.setLayout(new BorderLayout());
        pomIBFMPanel2.setBorder(new EmptyBorder(0, 75, 0, 75));
        pomIBFMPanel2.setBackground(HCPColors.getColorM2st());
        HCPGreyButton testIBFM = new HCPGreyButton("send");
        testIBFM.setIcon(this.slikaMem);
        testIBFM.addActionListener(this);
        testIBFM.setActionCommand("IBFM_PASS");
        pomIBFMPanel2.add((Component)testIBFM, "Center");
        testIBFMPanel.add((Component)pomIBFMPanel2, "South");
        this.osl.putConstraint("North", (Component)testIBFMPanel, 7, "South", (Component)this.datePanel);
        this.osl.putConstraint("West", (Component)testIBFMPanel, 7, "East", (Component)testPrinterPanel);
    }

    private void fiskalizuj() throws Exception {
        if (!this.saljiPib()) {
            return;
        }
        FiscalCommands.fiscalise();
    }

    private boolean saljiPib() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(7);
        String tt = LanguageStrings.getInstance().getStringByName("FISCALISATION_PANEL_ENTER_PIB");
        String spib = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)tt);
        if (spib == null) {
            return false;
        }
        FiscalCommands.sendPIB(spib);
        return true;
    }

    private void setVreme() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            long time = this.date.getDate().getTime();
            time += (long)(this.comboTime.getDateFormat().getCalendar().get(11) * 3600000);
            time += (long)(this.comboTime.getDateFormat().getCalendar().get(12) * 60000);
            time += (long)(this.comboTime.getDateFormat().getCalendar().get(13) * 1000);
            FiscalCommands.setTime(time -= 946684800000L);
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private void readFisData() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            PortSerial port = PortSerial.getInstance();
            Command.instance.reset();
            Command.instance.setCmd(3);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 3 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            long pom = Command.instance.getLong(0);
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy,HH:mm:ss");
            Date d = new Date(pom);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.tfTime.setText(sdf.format(d));
            byte[] b = new byte[8];
            System.arraycopy(Command.instance.getArray(), 8, b, 0, b.length);
            String spom = SysUtil.formatForReceive(b);
            this.tfIbfm.setText(spom);
            spom = "";
            int i = 16;
            while (i < 25) {
                spom = String.valueOf(spom) + (char)Command.instance.getArray()[i];
                ++i;
            }
            this.tfPib.setText(spom);
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private void periodicni() throws Exception {
        FiscalCommands.printPeriodicalReport(this.cod.getDate().getTime() - 946684800000L + 43200000L, this.cdo.getDate().getTime() - 946684800000L + 43200000L);
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("SET_CURRENT_TIME")) {
                this.runner.setJob(3);
            } else if (s.equalsIgnoreCase("FISCAL")) {
                this.runner.setJob(4);
            } else if (s.equalsIgnoreCase("SET_TIME")) {
                this.runner.setJob(5);
            } else if (s.equalsIgnoreCase("READ_DATA")) {
                this.runner.setJob(6);
            } else if (s.equalsIgnoreCase("RESET_C")) {
                this.runner.setJob(8);
            } else if (s.equalsIgnoreCase("RESET_P")) {
                this.runner.setJob(7);
            } else if (s.equalsIgnoreCase("DNEVNI")) {
                this.runner.setJob(9);
            } else if (s.equalsIgnoreCase("PRESEK")) {
                this.runner.setJob(10);
            } else if (s.equalsIgnoreCase("PERIODICNI")) {
                this.runner.setJob(11);
            } else if (s.equalsIgnoreCase("TEST_DAILY")) {
                this.runner.setJob(12);
            } else if (s.equalsIgnoreCase("STATUS")) {
                this.runner.setJob(2);
            } else if (s.equalsIgnoreCase("IBFM_PASS")) {
                this.runner.setJob(13);
            } else if (s.equalsIgnoreCase("UP__SOFTWARE")) {
                this.runner.setJob(14);
            } else if (s.equalsIgnoreCase("ST__SOFTWARE")) {
                this.runner.setJob(15);
            } else if (s.equalsIgnoreCase("READ_TIME")) {
                this.runner.setJob(1);
            } else if (s.equalsIgnoreCase("USER_COMMAND")) {
                this.runner.setJob(16);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    public void startSoftware() throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(67);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 67 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void sendUserCommand() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            int numTest = 0;
            String s = this.ntfCommand.getText();
            try {
                numTest = Integer.parseInt(s);
            }
            catch (Exception e) {
                throw new Exception("Pogeresan broj komande!");
            }
            Command.instance.reset();
            Command.instance.setCmd(numTest);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int cmd = Command.instance.getCmd();
            if (cmd != numTest && cmd != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public void readTime() throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(2);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 2 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        long time = Command.instance.getLong(0) + 946684800000L;
        SimpleDateFormat dataf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String s = dataf.format(new Date(time));
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), s);
    }

    public void updateSoftware() throws Exception {
        int cc = 66;
        int BLOCK_SIZE = 462;
        Command command = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        ProcessDialog pd = ProcessDialog.getInstance();
        HCPfileChooser fc = new HCPfileChooser("bin");
        fc.setAcceptAllFileFilterUsed(true);
        File file = fc.openFile();
        if (file == null) {
            return;
        }
        FileInputStream in = new FileInputStream(file);
        BufferedInputStream buff = new BufferedInputStream(in, 462);
        int fl = (int)(file.length() / 462L);
        pd.setMaximum(++fl);
        pd.setVisible(true);
        byte[] buffer = new byte[462];
        try {
            int sss = 0;
            int commandOffset = 0;
            int i = 0;
            while (i < fl) {
                int offset = 0;
                while ((sss = buff.read(buffer, offset, buffer.length - offset)) >= 0) {
                    if ((offset += sss) == buffer.length) break;
                }
                command.reset();
                command.setCmd(66);
                command.addInt(commandOffset);
                command.addToArray(buffer, 0, offset);
                port.sendFrame(command);
                port.receiveFrame(command);
                int e = command.getArray()[0] & 0xFF;
                int c = command.getCmd();
                if (c != 66 && c != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                pd.increaseBar();
                commandOffset += offset;
                commandOffset -= 14;
                ++i;
            }
            command.reset();
            command.setCmd(66);
            command.addInt(-1);
            port.sendFrame(command);
            port.receiveFrame(command);
            int e = command.getArray()[0] & 0xFF;
            int c = command.getCmd();
            if (c != 66 && c != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            ((InputStream)in).close();
            pd.setVisible(false);
        }
    }

    public void testDaily() throws Exception {
        int numTest = 10;
        long valueFin = 100000L;
        int numBill = 1;
        String s = this.ntfDaily.getText();
        try {
            int n = s.indexOf(44);
            if (n > 0) {
                numTest = Integer.parseInt(s.substring(0, n));
                if ((n = (s = s.substring(n + 1)).indexOf(44)) > 0) {
                    valueFin = Long.parseLong(s.substring(0, n)) & 0xFFFFFFFFFFFL;
                    numBill = (n = (s = s.substring(n + 1)).indexOf(44)) > 0 ? Integer.parseInt(s.substring(0, n - 1)) & 0xFFFFF : Integer.parseInt(s) & 0xFFFFF;
                } else {
                    valueFin = Long.parseLong(s) & 0xFFFFFFFFFFFL;
                }
            } else {
                numTest = Integer.parseInt(s.substring(0, s.length()));
            }
            if (numTest > 255 || numTest < 0) {
                numTest = 255;
            }
        }
        catch (Exception e) {
            throw new Exception("Pogeresan broj dnevnih izvestaja!");
        }
        Command.instance.reset();
        Command.instance.setCmd(224);
        Command.instance.addByte(numTest);
        if (numTest != 0) {
            Command.instance.addLong(valueFin);
            Command.instance.addInt(numBill);
        }
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int cmd = Command.instance.getCmd();
        if (cmd != 224 && cmd != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void testIbfmAndPass() throws Exception {
        int commandNumber = 113;
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.instance;
        String IBFM = this.tfIBFM.getText();
        String pass = this.tfPass.getText();
        int l1 = IBFM.length();
        int l2 = pass.length();
        if (l1 <= 0 || l2 <= 0) {
            throw new Exception("Unesite  IBFM i pasword!");
        }
        instance.reset();
        instance.setCmd(commandNumber);
        SysUtil.formatForSend(IBFM, instance);
        instance.addToArray(pass.getBytes(), 0, l2);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != commandNumber && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void testStatus() throws Exception {
        int OFFSET_FREE_MEMORY = 0;
        int OFFSET_POWER = 4;
        int COMMAND_FS = 8;
        int COMMAND_FD = 9;
        int COMMAND_FB = 10;
        int COMMAND_FR = 11;
        int COMMAND_DFP = 12;
        int COMMAND_DNM = 16;
        StatusDialog sd = new StatusDialog();
        Command com = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        com.reset();
        com.setCmd(55);
        port.sendFrame(com);
        com = port.receiveFrame();
        int e = com.getArray()[0] & 0xFF;
        int command = com.getCmd();
        if (command != 55 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int value = com.getInt(OFFSET_FREE_MEMORY);
        sd.addEntry("FREE MEMORY", String.valueOf(value));
        value = com.getInt(OFFSET_POWER);
        sd.addEntry("POW:", String.valueOf(value));
        value = com.getByte(COMMAND_FS);
        sd.addEntry("FS:", String.valueOf(value));
        value = com.getByte(COMMAND_FD);
        sd.addEntry("FD:", String.valueOf(value));
        value = com.getByte(COMMAND_FB);
        sd.addEntry("FB:", String.valueOf(value));
        value = com.getByte(COMMAND_FR);
        sd.addEntry("FR:", String.valueOf(value));
        value = com.getInt(COMMAND_DFP);
        sd.addEntry("DFP:", String.valueOf(value));
        value = com.getInt(COMMAND_DNM);
        sd.addEntry("DNM:", String.valueOf(value));
        sd.setVisible(true);
    }

    private class ToolsThread
    extends Thread {
        public static final byte READ_TIME = 1;
        public static final byte STATUS = 2;
        public static final byte SET_CURRENT_TIME = 3;
        public static final byte FISCAL = 4;
        public static final byte SET_TIME = 5;
        public static final byte READ_DATA = 6;
        public static final byte RESET_P = 7;
        public static final byte RESET_C = 8;
        public static final byte DNEVNI = 9;
        public static final byte PRESEK = 10;
        public static final byte PERIODICNI = 11;
        public static final byte TEST_DAILY = 12;
        public static final byte IBFM_PASS = 13;
        public static final byte UP__SOFTWARE = 14;
        public static final byte ST__SOFTWARE = 15;
        public static final byte USER_COMMAND = 16;
        private int job = 0;

        public ToolsThread() {
            this.start();
        }

        public final synchronized void setJob(int j) throws Exception {
            if (this.job != 0) {
                throw new Exception(LanguageStrings.getProgramIsBusy());
            }
            this.job = j;
            this.notify();
        }

        public final synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 3: {
                            ProcessingDialog pd = ProcessingDialog.getInstance();
                            pd.setInstanceVisible(true);
                            try {
                                FiscalCommands.setCurrentTime();
                                pd.setInstanceVisible(false);
                                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
                                break;
                            }
                            finally {
                                pd.setInstanceVisible(false);
                            }
                        }
                        case 4: {
                            FiskalizacijaPanel.this.fiskalizuj();
                            break;
                        }
                        case 5: {
                            FiskalizacijaPanel.this.setVreme();
                            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getSuccess(), "OK", 1);
                            break;
                        }
                        case 6: {
                            FiskalizacijaPanel.this.readFisData();
                            break;
                        }
                        case 7: {
                            FiscalCommands.reset(1);
                            break;
                        }
                        case 8: {
                            FiscalCommands.reset(3);
                            break;
                        }
                        case 9: {
                            FiscalCommands.printDailyReport();
                            break;
                        }
                        case 10: {
                            FiscalCommands.printCurrentStateReport();
                            break;
                        }
                        case 11: {
                            FiskalizacijaPanel.this.periodicni();
                            break;
                        }
                        case 12: {
                            FiskalizacijaPanel.this.testDaily();
                            break;
                        }
                        case 2: {
                            FiskalizacijaPanel.this.testStatus();
                            break;
                        }
                        case 13: {
                            FiskalizacijaPanel.this.testIbfmAndPass();
                            break;
                        }
                        case 14: {
                            FiskalizacijaPanel.this.updateSoftware();
                            break;
                        }
                        case 15: {
                            FiskalizacijaPanel.this.startSoftware();
                            break;
                        }
                        case 1: {
                            FiskalizacijaPanel.this.readTime();
                            break;
                        }
                        case 16: {
                            FiskalizacijaPanel.this.sendUserCommand();
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }
    }
}

