/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPCheckBox;
import gui.HCPColors;
import gui.HCPLabel;
import gui.HCPPopButton;
import gui.PeriodicalDialog;
import gui.ProcessingDialog;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.FiscallObjects;
import org.freixas.jcalendar.JCalendarCombo;
import util.comPort.PortSerial;

public class FiscalDataPanel
extends RightPanel
implements ActionListener {
    private JPanel buttonPanel;
    private HCPPopButton readReset;
    private HCPPopButton readTax;
    private HCPPopButton readDaily;
    private HCPPopButton readDepartureClosure;
    private HCPPopButton readLastDeparture;
    private HCPPopButton readDepartureRange;
    private HCPPopButton readDeparturesFromFile;
    private JTextArea text;
    private HCPCheckBox printCash;
    private JCalendarCombo odTest;
    private JCalendarCombo doTest;
    private HCPPopButton testPeriodical;
    private MainThread runner;
    public static Vector vecDaily = new Vector();
    public static Vector vecReset = new Vector();
    public static Vector vecTax = new Vector();
    public static Vector vecDep = new Vector();
    private static final int DAILY_SIZE = 64;
    private static final int RESET_SIZE = 8;
    private static final int TAX_SIZE = 26;
    private static final int DEP_SIZE = 268;
    public static int dailyStartAddress = 4096;
    public static int taxStartAddress = 2048;
    public static int resetStartAddress = 1024;
    public static int departureStartAddress = 1024;
    private static DecimalFormat df = new DecimalFormat("######0.00");
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy,HH:mm:ss");

    public FiscalDataPanel() {
        super("Fiskalni podaci", 'Y', "Fiskalni podaci u kasi");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.runner = new MainThread();
        this.setLayout(new BorderLayout(10, 10));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setPreferredSize(new Dimension(187, 400));
        this.buttonPanel.setLayout(new GridLayout(11, 1, 10, 10));
        this.buttonPanel.setIgnoreRepaint(true);
        this.buttonPanel.setBackground(HCPColors.getColorM2st());
        this.buttonPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        ImageIcon slikaMem = new ImageIcon("images/mem.png");
        ImageIcon slikaPrint = new ImageIcon("images/print.png");
        ImageIcon slikaComp = new ImageIcon("images/ComputerSmall.png");
        this.readReset = new HCPPopButton("citaj resete");
        this.readReset.setHorizontalAlignment(2);
        this.readReset.addActionListener(this);
        this.readReset.setActionCommand("RESET");
        this.readReset.setIcon(slikaMem);
        this.readTax = new HCPPopButton("citaj porez");
        this.readTax.setHorizontalAlignment(2);
        this.readTax.addActionListener(this);
        this.readTax.setActionCommand("TAX");
        this.readTax.setIcon(slikaMem);
        this.readDaily = new HCPPopButton("citaj dnevne");
        this.readDaily.setHorizontalAlignment(2);
        this.readDaily.addActionListener(this);
        this.readDaily.setActionCommand("DAILY");
        this.readDaily.setIcon(slikaMem);
        this.readDepartureClosure = new HCPPopButton("read all departure closures");
        this.readDepartureClosure.setHorizontalAlignment(2);
        this.readDepartureClosure.addActionListener(this);
        this.readDepartureClosure.setActionCommand("DEPARTURE");
        this.readDepartureClosure.setIcon(slikaMem);
        this.readLastDeparture = new HCPPopButton("read last departure closure");
        this.readLastDeparture.setHorizontalAlignment(2);
        this.readLastDeparture.addActionListener(this);
        this.readLastDeparture.setActionCommand("LDC");
        this.readLastDeparture.setIcon(slikaMem);
        this.readDepartureRange = new HCPPopButton("read departure closure range");
        this.readDepartureRange.setHorizontalAlignment(2);
        this.readDepartureRange.addActionListener(this);
        this.readDepartureRange.setActionCommand("RANGE");
        this.readDepartureRange.setIcon(slikaMem);
        this.readDeparturesFromFile = new HCPPopButton("read departures from file");
        this.readDeparturesFromFile.setHorizontalAlignment(2);
        this.readDeparturesFromFile.addActionListener(this);
        this.readDeparturesFromFile.setActionCommand("RFF");
        this.readDeparturesFromFile.setIcon(slikaComp);
        this.buttonPanel.add(this.readReset);
        this.buttonPanel.add(this.readTax);
        this.buttonPanel.add(this.readDaily);
        this.buttonPanel.add(new JLabel());
        this.odTest = new JCalendarCombo();
        this.buttonPanel.add(new HCPLabel("od datuma"));
        this.buttonPanel.add(this.odTest);
        this.doTest = new JCalendarCombo();
        this.buttonPanel.add(new HCPLabel("do datuma"));
        this.buttonPanel.add(this.doTest);
        this.printCash = new HCPCheckBox("Stampaj na kasi");
        this.buttonPanel.add(this.printCash);
        this.testPeriodical = new HCPPopButton("periodicni izvestaj");
        this.testPeriodical.setIcon(slikaPrint);
        this.testPeriodical.addActionListener(this);
        this.testPeriodical.setActionCommand("TEST_PERIODICNI");
        this.buttonPanel.add(this.testPeriodical);
        this.add((Component)this.buttonPanel, "West");
        this.text = new JTextArea();
        this.text.setFont(GlavniFrame.font);
        this.text.setEditable(false);
        JScrollPane scr = new JScrollPane(this.text, 20, 30);
        scr.setBorder(new SoftBevelBorder(0));
        this.add((Component)scr, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("RESET")) {
                this.runner.setJob(2);
            } else if (s.equalsIgnoreCase("TAX")) {
                this.runner.setJob(3);
            } else if (s.equalsIgnoreCase("DAILY")) {
                this.runner.setJob(1);
            } else if (s.equalsIgnoreCase("TEST_PERIODICNI")) {
                this.runner.setJob(4);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    public void readDepTax() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setTitle("Working...");
        pd.setInstanceVisible(true);
        boolean loop = true;
        int start = 35840;
        vecTax.removeAllElements();
        int ppp = 4;
        try {
            while (loop) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(76);
                instance.addInt(start);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 76 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                int i = 0;
                while (i < len / 26) {
                    TaxObj obj = new TaxObj();
                    System.arraycopy(outComm.getArray(), ppp, obj.dataArrey, 0, 26);
                    if (this.isEmptyArray(obj.dataArrey)) {
                        loop = false;
                        break;
                    }
                    vecTax.addElement(obj);
                    ppp += 26;
                    ++i;
                }
                if ((start += len / 26 * 26) % 4 == 0) continue;
                start -= 2;
                ppp = 6;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
        int i = 0;
        while (i < vecTax.size()) {
            TaxObj pom = (TaxObj)vecTax.elementAt(i);
            Date d = new Date(pom.getTime());
            this.text.append("r.b. " + (i + 1) + "\r\n");
            this.text.append("   " + sdf.format(d) + "\r\n");
            int j = 0;
            while (j < FiscallObjects.poreskeStope.length) {
                this.text.append("          " + FiscallObjects.poreskeStope[j].opis + ":\t");
                this.text.append(pom.getTax(4 + j * 2) != 0L ? df.format((double)pom.getTax(4 + j * 2) / 100.0) : "*.**");
                this.text.append("\r\n");
                ++j;
            }
            ++i;
        }
    }

    public void testPeriodical() throws Exception {
        long dt;
        if (this.odTest.getDate().getTime() > this.doTest.getDate().getTime()) {
            throw new Exception("Nepravilan odabir datuma.");
        }
        this.readAllData();
        Calendar calOd = Calendar.getInstance();
        calOd.setTimeInMillis(this.odTest.getDate().getTime() + 43200000L);
        calOd.set(11, 0);
        calOd.set(12, 1);
        long timeOd = calOd.getTimeInMillis() + 3600000L;
        Calendar calDo = Calendar.getInstance();
        calDo.setTimeInMillis(this.doTest.getDate().getTime() + 43200000L);
        calDo.set(11, 23);
        calDo.set(12, 59);
        long timeDo = calDo.getTimeInMillis() + 3600000L;
        if (this.printCash.isSelected()) {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(90);
            instance.addLong(this.odTest.getDate().getTime() - 946684800000L);
            instance.addLong(this.doTest.getDate().getTime() - 946684800000L);
            PortSerial.getInstance().sendFrame(instance);
            PortSerial.getInstance().receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 90 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        boolean doChanged = false;
        boolean odSeted = false;
        int i = vecDaily.size();
        while (--i >= 0) {
            DailyObj dob = (DailyObj)vecDaily.elementAt(i);
            dt = dob.getTime();
            if (!doChanged) {
                if (dt > timeDo) {
                    vecDaily.removeElementAt(i);
                    continue;
                }
                doChanged = true;
                timeDo = dt;
            }
            if (!odSeted && dt < timeOd) {
                odSeted = true;
                dob = (DailyObj)vecDaily.elementAt(i);
                timeOd = dob.getTime();
            } else if (!odSeted) continue;
            if (!odSeted) continue;
            vecDaily.removeElementAt(i);
        }
        Vector<Integer> tmpVec = new Vector<Integer>();
        boolean mark = true;
        int j = vecTax.size();
        while (--j >= 0) {
            TaxObj tob = (TaxObj)vecTax.elementAt(j);
            dt = tob.getTime();
            if (dt > timeDo) {
                tmpVec.add(j);
            }
            if (dt >= timeOd) continue;
            if (mark) {
                mark = false;
                continue;
            }
            tmpVec.add(j);
        }
        j = 0;
        while (j < tmpVec.size()) {
            vecTax.removeElementAt((Integer)tmpVec.get(j));
            ++j;
        }
        j = vecReset.size();
        while (--j >= 0) {
            ResetObj rob = (ResetObj)vecReset.elementAt(j);
            dt = rob.getTime();
            if (dt >= timeOd && dt <= timeDo) continue;
            vecReset.removeElementAt(j);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        new PeriodicalDialog().calculate(sdf.format(new Date(this.odTest.getDate().getTime())), sdf.format(new Date(this.doTest.getDate().getTime())));
    }

    public void readAllData() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setTitle("Working...");
        pd.setInstanceVisible(true);
        try {
            int len;
            int command;
            int e;
            PortSerial port;
            Command instance;
            Object obj;
            int i;
            int start = dailyStartAddress;
            boolean loop = true;
            vecDaily.removeAllElements();
            int numDaily = 1;
            while (loop) {
                Command instance2 = Command.bigInstance;
                instance2.reset();
                instance2.setCmd(8);
                instance2.addInt(start);
                PortSerial port2 = PortSerial.getInstance();
                port2.sendFrame(instance2);
                Command outComm = port2.receiveFrame();
                int e2 = outComm.getArray()[0] & 0xFF;
                int command2 = outComm.getCmd();
                if (command2 != 8 && command2 != 128 && e2 != 0) {
                    CommandsErrors.instanceMain.setError(e2);
                }
                int len2 = outComm.getLength();
                int ppp = 4;
                i = 0;
                while (i < len2 / 64) {
                    obj = new DailyObj(numDaily);
                    System.arraycopy(outComm.getArray(), ppp, ((DailyObj)obj).dataArrey, 0, 64);
                    if (this.isEmptyArray(((DailyObj)obj).dataArrey)) {
                        loop = false;
                        break;
                    }
                    if (this.isValidDaily(((DailyObj)obj).dataArrey[0])) {
                        vecDaily.addElement(obj);
                        ++numDaily;
                    }
                    ppp += 64;
                    ++i;
                }
                start += len2 / 64 * 64;
            }
            start = taxStartAddress;
            loop = true;
            vecTax.removeAllElements();
            int pppTax = 4;
            while (loop) {
                instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(8);
                instance.addInt(start);
                port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                e = outComm.getArray()[0] & 0xFF;
                command = outComm.getCmd();
                if (command != 8 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                len = outComm.getLength();
                i = 0;
                while (i < len / 26) {
                    obj = new TaxObj();
                    System.arraycopy(outComm.getArray(), pppTax, ((TaxObj)obj).dataArrey, 0, 26);
                    if (this.isEmptyArray(((TaxObj)obj).dataArrey)) {
                        loop = false;
                        break;
                    }
                    vecTax.addElement(obj);
                    pppTax += 26;
                    ++i;
                }
                if ((start += len / 26 * 26) % 4 == 0) continue;
                start -= 2;
                pppTax = 6;
            }
            start = resetStartAddress;
            loop = true;
            vecReset.removeAllElements();
            while (loop) {
                instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(8);
                instance.addInt(start);
                port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                e = outComm.getArray()[0] & 0xFF;
                command = outComm.getCmd();
                if (command != 8 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                len = outComm.getLength();
                int ppp = 4;
                int i2 = 0;
                while (i2 < len / 8) {
                    ResetObj obj2 = new ResetObj();
                    System.arraycopy(outComm.getArray(), ppp, obj2.dataArrey, 0, 8);
                    if (this.isEmptyArray(obj2.dataArrey)) {
                        loop = false;
                        break;
                    }
                    vecReset.addElement(obj2);
                    ppp += 8;
                    ++i2;
                }
                start += len / 8 * 8;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public void citajDnevne() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setTitle("Working...");
        pd.setInstanceVisible(true);
        boolean loop = true;
        int start = dailyStartAddress;
        vecDaily.removeAllElements();
        int numDaily = 1;
        try {
            while (loop) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(8);
                instance.addInt(start);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 8 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                int ppp = 4;
                int i = 0;
                while (i < len / 64) {
                    DailyObj obj = new DailyObj(numDaily);
                    System.arraycopy(outComm.getArray(), ppp, obj.dataArrey, 0, 64);
                    if (this.isEmptyArray(obj.dataArrey)) {
                        loop = false;
                        break;
                    }
                    if (this.isValidDaily(obj.dataArrey[0])) {
                        vecDaily.addElement(obj);
                        ++numDaily;
                    }
                    ppp += 64;
                    ++i;
                }
                start += len / 64 * 64;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
        int i = 0;
        while (i < vecDaily.size()) {
            DailyObj pom = (DailyObj)vecDaily.elementAt(i);
            Date d = new Date(pom.getTime());
            this.text.append("r.b. " + pom.getNum() + " :: " + pom.getBillNum() + "\r\n");
            this.text.append("   " + sdf.format(d) + "\r\n");
            int j = 0;
            while (j < FiscallObjects.poreskeStope.length) {
                this.text.append("          " + FiscallObjects.poreskeStope[j].opis + ":\t" + df.format((double)pom.getSold(6 + j * 6) / 100.0) + "\r\n");
                ++j;
            }
            ++i;
        }
    }

    public void citajPorez() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setTitle("Working...");
        pd.setInstanceVisible(true);
        boolean loop = true;
        int start = taxStartAddress;
        vecTax.removeAllElements();
        int ppp = 4;
        try {
            while (loop) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(8);
                instance.addInt(start);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 8 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                int i = 0;
                while (i < len / 26) {
                    TaxObj obj = new TaxObj();
                    System.arraycopy(outComm.getArray(), ppp, obj.dataArrey, 0, 26);
                    if (this.isEmptyArray(obj.dataArrey)) {
                        loop = false;
                        break;
                    }
                    vecTax.addElement(obj);
                    ppp += 26;
                    ++i;
                }
                if ((start += len / 26 * 26) % 4 == 0) continue;
                start -= 2;
                ppp = 6;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
        int i = 0;
        while (i < vecTax.size()) {
            TaxObj pom = (TaxObj)vecTax.elementAt(i);
            Date d = new Date(pom.getTime());
            this.text.append("r.b. " + (i + 1) + "\r\n");
            this.text.append("   " + sdf.format(d) + "\r\n");
            int j = 0;
            while (j < FiscallObjects.poreskeStope.length) {
                this.text.append("          " + FiscallObjects.poreskeStope[j].opis + ":\t");
                this.text.append(pom.getTax(4 + j * 2) != 0L ? df.format((double)pom.getTax(4 + j * 2) / 100.0) : "*.**");
                this.text.append("\r\n");
                ++j;
            }
            ++i;
        }
    }

    public void citajResete() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setTitle("Working...");
        pd.setInstanceVisible(true);
        boolean loop = true;
        int start = resetStartAddress;
        vecReset.removeAllElements();
        try {
            while (loop) {
                Command instance = Command.bigInstance;
                instance.reset();
                instance.setCmd(8);
                instance.addInt(start);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command outComm = port.receiveFrame();
                int e = outComm.getArray()[0] & 0xFF;
                int command = outComm.getCmd();
                if (command != 8 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len = outComm.getLength();
                int ppp = 4;
                int i = 0;
                while (i < len / 8) {
                    ResetObj obj = new ResetObj();
                    System.arraycopy(outComm.getArray(), ppp, obj.dataArrey, 0, 8);
                    if (this.isEmptyArray(obj.dataArrey)) {
                        loop = false;
                        break;
                    }
                    vecReset.addElement(obj);
                    ppp += 8;
                    ++i;
                }
                start += len / 8 * 8;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
        int i = 0;
        while (i < vecReset.size()) {
            ResetObj pom = (ResetObj)vecReset.elementAt(i);
            char c = pom.getType() == 1 ? (char)'P' : 'C';
            this.text.append("r.b. " + (i + 1) + "\t");
            this.text.append("type " + c);
            Date d = new Date(pom.getTime());
            this.text.append("\t" + sdf.format(d) + "\r\n");
            ++i;
        }
    }

    private boolean isEmptyArray(byte[] b) {
        boolean isEmpty = true;
        int i = 0;
        while (i < b.length) {
            if (b[i] != -1) {
                isEmpty = false;
                break;
            }
            ++i;
        }
        return isEmpty;
    }

    private boolean isValidDaily(byte b) {
        return (b & 3) == 0;
    }

    public class DailyObj {
        int num;
        byte[] dataArrey = new byte[64];

        public DailyObj(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }

        public int getBillNum() {
            int time = 0;
            int i = 60;
            while (i < 62) {
                int t = this.dataArrey[i] & 0xFF;
                time |= t << (i - 60) * 8;
                ++i;
            }
            return time;
        }

        public long getTime() {
            long time = 0L;
            int i = 2;
            while (i < 6) {
                int t = this.dataArrey[i] & 0xFF;
                time |= (long)(t << (i - 2) * 8);
                ++i;
            }
            time *= 1000L;
            return time += 946684800000L;
        }

        public long getSold(int start) {
            long sold = 0L;
            int i = start;
            while (i < start + 6) {
                long t = this.dataArrey[i] & 0xFF;
                sold |= t << (i - start) * 8;
                ++i;
            }
            sold ^= 0xFFFFFFFFFFFFFFFFL;
            return sold &= 0xFFFFFFFFFFFFL;
        }
    }

    public class DepartureObj {
        private int num;
        private byte[] dataArrey = new byte[268];

        public DepartureObj(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }

        public int getInt(int offset, int lenght) {
            int serNum = 0;
            int i = offset;
            while (i < offset + lenght) {
                int t = this.dataArrey[i] & 0xFF;
                serNum |= t << (i - offset) * 8;
                ++i;
            }
            return serNum;
        }

        public int getSerialNumber() {
            return this.getInt(4, 3);
        }

        public int getLastSoldTicket() {
            return this.getInt(0, 4);
        }

        public int getNumOfIdCards() {
            return this.getInt(173, 4);
        }

        public long getRealDepartureTime() {
            long time = this.getInt(177, 4);
            time *= 1000L;
            return time += 946684800000L;
        }

        public String getEnteredDepartureTime() {
            String s = Integer.toHexString(this.getInt(181, 2));
            while (s.length() < 4) {
                s = String.valueOf('0') + s;
            }
            s = String.valueOf(s.substring(0, 2)) + ':' + s.substring(2, 4);
            return s;
        }

        public int getLineNumber() {
            return this.getInt(183, 2);
        }

        public int getDriverId() {
            return this.getInt(185, 3);
        }

        public long getExecTime() {
            long time = this.getInt(188, 4);
            time *= 1000L;
            return time += 946684800000L;
        }

        public long getPriceListTime() {
            long time = this.getInt(258, 4);
            time *= 1000L;
            return time += 946684800000L;
        }

        public long getVatTableTime() {
            long time = this.getInt(262, 4);
            time *= 1000L;
            return time += 946684800000L;
        }

        public int getFlags() {
            return this.getInt(266, 2);
        }

        public void appendVatsToText() {
            int pom = 0;
            int j = 0;
            while (j < FiscallObjects.poreskeStope.length) {
                FiscalDataPanel.this.text.append("          " + FiscallObjects.poreskeStope[j].opis + ":");
                pom = this.getInt(8 + j * 4, 4);
                FiscalDataPanel.this.text.append("\tTF: " + (pom != 0 ? df.format((double)pom / 100.0) : "0,00"));
                FiscalDataPanel.this.text.append("  TN: " + this.getInt(44 + j * 2, 2));
                pom = this.getInt(62 + j * 3, 3);
                FiscalDataPanel.this.text.append("\tSF: " + (pom != 0 ? df.format((double)pom / 100.0) : "0,00"));
                FiscalDataPanel.this.text.append("  SN: " + this.getInt(89 + j * 2, 2));
                FiscalDataPanel.this.text.append("\r\n");
                ++j;
            }
        }

        public void appendTarifsToText() {
            int j = 0;
            while (j < 11) {
                FiscalDataPanel.this.text.append("          T " + j + ":");
                int pom = this.getInt(107 + j * 4, 4);
                FiscalDataPanel.this.text.append("\tTF: " + (pom != 0 ? df.format((double)pom / 100.0) : "0,00"));
                FiscalDataPanel.this.text.append("  TN: " + this.getInt(151 + j * 2, 2));
                pom = this.getInt(192 + j * 4, 4);
                FiscalDataPanel.this.text.append("\tTRF: " + (pom != 0 ? df.format((double)pom / 100.0) : "0,00"));
                FiscalDataPanel.this.text.append("  TRN: " + this.getInt(236 + j * 2, 2));
                FiscalDataPanel.this.text.append("\r\n");
                ++j;
            }
        }
    }

    private class MainThread
    extends Thread {
        public static final byte READ_DAILY = 1;
        public static final byte READ_RESET = 2;
        public static final byte READ_TAX = 3;
        public static final byte TEST_PERIODICNI = 4;
        private int job = 0;

        public MainThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setJob(int j) throws Exception {
            GlavniFrame glavniFrame = GlavniFrame.getInstance();
            synchronized (glavniFrame) {
                if (this.job != 0) {
                    throw new Exception("Program je zauzet!");
                }
                this.job = j;
                this.notify();
            }
        }

        public synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    FiscalDataPanel.this.text.setText("");
                    switch (this.job) {
                        case 1: {
                            FiscalDataPanel.this.citajDnevne();
                            break;
                        }
                        case 2: {
                            FiscalDataPanel.this.citajResete();
                            break;
                        }
                        case 3: {
                            FiscalDataPanel.this.citajPorez();
                            break;
                        }
                        case 4: {
                            FiscalDataPanel.this.testPeriodical();
                        }
                    }
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
                }
                this.job = 0;
            }
        }
    }

    public class ResetObj {
        byte[] dataArrey = new byte[8];

        public byte getType() {
            return this.dataArrey[3];
        }

        public long getTime() {
            long time = 0L;
            int i = 4;
            while (i < 8) {
                int t = this.dataArrey[i] & 0xFF;
                time |= (long)(t << (i - 4) * 8);
                ++i;
            }
            time *= 1000L;
            return time += 946684800000L;
        }
    }

    public class TaxObj {
        byte[] dataArrey = new byte[26];

        public long getTime() {
            long time = 0L;
            int i = 0;
            while (i < 4) {
                int t = this.dataArrey[i] & 0xFF;
                time |= (long)(t << i * 8);
                ++i;
            }
            time *= 1000L;
            return time += 946684800000L;
        }

        public long getTax(int start) {
            long sold = 0L;
            int i = start;
            while (i < start + 2) {
                long t = this.dataArrey[i] & 0xFF;
                sold |= t << (i - start) * 8;
                ++i;
            }
            return (sold &= 0xFFFFL) == 65535L ? 0L : sold;
        }
    }
}

