/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPComboBox;
import gui.HCPGreyButton;
import gui.HCPfileChooser;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tables.displayTable.DisplayData;
import tables.displayTable.TableDisplay;
import tables.displayTable2.DisplayData2;
import tables.displayTable2.TableDisplay2;
import util.XML.XmlExecuter;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;

public class DMPanel
extends RightPanel
implements ActionListener,
ItemListener,
XmlObject {
    private JPanel buttonPanel;
    private HCPComboBox combo;
    private HCPGreyButton read;
    private HCPGreyButton save;
    private HCPGreyButton saveCash;
    private HCPGreyButton readCash;
    private HCPGreyButton readBin;
    private HCPGreyButton saveBin;
    private JSplitPane splitVerPanel;
    private TableDisplay td;
    private TableDisplay2 td2;
    private MainThread runner = new MainThread();

    public DMPanel() {
        super("Display", 'D', "Display");
        this.setLayout(new BorderLayout(10, 10));
        this.td = new TableDisplay();
        this.td2 = new TableDisplay2();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(11, 1, 10, 10));
        this.buttonPanel.setBackground(HCPColors.getColorM2st());
        this.buttonPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.combo = new HCPComboBox(DMData.vec);
        this.combo.addItemListener(this);
        this.buttonPanel.add(this.combo);
        this.buttonPanel.add(new JLabel());
        ImageIcon slikaComp = new ImageIcon("images/ComputerSmall.png");
        ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
        this.read = new HCPGreyButton("read");
        this.read.setHorizontalAlignment(2);
        this.read.addActionListener(this);
        this.read.setIcon(slikaComp);
        this.buttonPanel.add(this.read);
        this.save = new HCPGreyButton("save");
        this.save.setHorizontalAlignment(2);
        this.save.addActionListener(this);
        this.save.setIcon(slikaComp);
        this.buttonPanel.add(this.save);
        this.buttonPanel.add(new JLabel());
        this.readCash = new HCPGreyButton("read");
        this.readCash.setHorizontalAlignment(2);
        this.readCash.addActionListener(this);
        this.readCash.setIcon(slikaCash);
        this.buttonPanel.add(this.readCash);
        this.saveCash = new HCPGreyButton("send");
        this.saveCash.setHorizontalAlignment(2);
        this.saveCash.addActionListener(this);
        this.saveCash.setIcon(slikaCash);
        this.buttonPanel.add(this.saveCash);
        this.buttonPanel.add(new JLabel());
        this.readBin = new HCPGreyButton("read .bin");
        this.readBin.setHorizontalAlignment(2);
        this.readBin.addActionListener(this);
        this.readBin.setIcon(slikaComp);
        this.buttonPanel.add(this.readBin);
        this.saveBin = new HCPGreyButton("save .bin");
        this.saveBin.setHorizontalAlignment(2);
        this.saveBin.addActionListener(this);
        this.saveBin.setIcon(slikaComp);
        this.buttonPanel.add(this.saveBin);
        this.add((Component)this.buttonPanel, "West");
        JScrollPane scr = new JScrollPane(this.td, 20, 31);
        scr.setBorder(new SoftBevelBorder(0));
        this.add((Component)scr, "Center");
        JScrollPane scr2 = new JScrollPane(this.td2, 20, 31);
        scr2.setBorder(new SoftBevelBorder(0));
        this.add((Component)scr2, "Center");
        this.splitVerPanel = new JSplitPane(1, true, scr, scr2);
        this.splitVerPanel.setOneTouchExpandable(true);
        this.splitVerPanel.setResizeWeight(0.5);
        this.add((Component)this.splitVerPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.read) {
                this.runner.setJob(1);
            }
            if (e.getSource() == this.save) {
                this.runner.setJob(2);
            }
            if (e.getSource() == this.readCash) {
                this.runner.setJob(3);
            }
            if (e.getSource() == this.saveCash) {
                this.runner.setJob(4);
            }
            if (e.getSource() == this.readBin) {
                this.runner.setJob(5);
            }
            if (e.getSource() == this.saveBin) {
                this.runner.setJob(6);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.revalidateData();
    }

    private void revalidateData() {
        int sel = this.combo.getSelectedIndex();
        DMData dmd = (DMData)DMData.vec.elementAt(sel);
        TableDisplay.dd = dmd.dd;
        this.td.revalidate();
        this.td.repaint();
        TableDisplay2.dd2 = dmd.dd2;
        this.td2.revalidate();
        this.td2.repaint();
    }

    private void resetSelectionData() {
        this.combo.setSelectedIndex(0);
        DMData dmd = (DMData)DMData.vec.elementAt(0);
        TableDisplay.dd = dmd.dd;
        this.td.revalidate();
        this.td.repaint();
        TableDisplay2.dd2 = dmd.dd2;
        this.td2.revalidate();
        this.td2.repaint();
    }

    private void saveToBin() throws Exception {
        HCPfileChooser fc = new HCPfileChooser("bin");
        File file = fc.saveFile();
        if (file == null) {
            return;
        }
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(2);
            ((OutputStream)out).write("Charade generated memory image".getBytes());
            ((OutputStream)out).write(10);
            ((OutputStream)out).write("  Address 0x3e0000 to 0x400000".getBytes());
            ((OutputStream)out).write(10);
            ((OutputStream)out).write("  File: displays.bin ".getBytes());
            ((OutputStream)out).write(10);
            ((OutputStream)out).write("  Fri Nov 19 2010 00:45:22".getBytes());
            byte[] byArray = new byte[8];
            byArray[1] = 8;
            byArray[3] = 64;
            byArray[6] = 62;
            ((OutputStream)out).write(byArray);
            int i = 0;
            while (i < DMData.vec.size()) {
                DMData dmd = (DMData)DMData.vec.elementAt(i);
                dmd.dd.saveAll(i, out);
                dmd.dd2.saveAll(i, out);
                ++i;
            }
        }
        finally {
            pd.setInstanceVisible(false);
            ((OutputStream)out).close();
        }
    }

    private void readFromBin() throws Exception {
        HCPfileChooser fc = new HCPfileChooser("bin");
        File file = fc.openFile();
        if (file == null) {
            return;
        }
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        FileInputStream in = new FileInputStream(file);
        try {
            while (((InputStream)in).read() != 8) {
            }
            int i = 0;
            while (i < 6) {
                ((InputStream)in).read();
                ++i;
            }
            i = 0;
            while (i < DMData.vec.size()) {
                DMData dmd = (DMData)DMData.vec.elementAt(i);
                dmd.dd.readAll(i, in);
                dmd.dd2.readAll(i, in);
                ++i;
            }
        }
        finally {
            pd.setInstanceVisible(false);
            ((InputStream)in).close();
        }
    }

    private void write() throws Exception {
        HCPfileChooser fc = new HCPfileChooser("xml");
        File file = fc.saveFile();
        if (file == null) {
            return;
        }
        XmlExecuter.getInstance().write(this, file.getAbsolutePath());
    }

    private void read() throws Exception {
        HCPfileChooser fc = new HCPfileChooser("xml");
        File file = fc.openFile();
        if (file == null) {
            return;
        }
        XmlExecuter.getInstance().read(this, file.getAbsolutePath());
    }

    public void writeCash() throws Exception {
        boolean trim = false;
        int i = 0;
        while (i < DMData.vec.size()) {
            DMData dmd = (DMData)DMData.vec.elementAt(i);
            dmd.dd.programAllMessages(i, trim);
            dmd.dd2.programAllKeys(i);
            dmd.dd2.programAllMenies(i, trim);
            ++i;
        }
    }

    public void readCash() throws Exception {
        int i = 0;
        while (i < DMData.vec.size()) {
            DMData dmd = (DMData)DMData.vec.elementAt(i);
            dmd.dd.readAllMessages(i);
            dmd.dd2.readAllKeys(i);
            dmd.dd2.readAllMenies(i);
            ++i;
        }
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        if (writer == null) {
            return;
        }
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<DISPLAY_DOC>");
        writer.indent();
        int size = DMData.vec.size();
        boolean trim = false;
        if (JOptionPane.showConfirmDialog(GlavniFrame.getInstance(), "TRIM DATA", "TRIM?", 0) == 0) {
            trim = true;
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(512 * size);
        pd.setVisible(true);
        try {
            int i = 0;
            while (i < size) {
                DMData dmd = (DMData)DMData.vec.elementAt(i);
                writer.write("<DISPLAY NAME='" + XmlFileWriter.compileString(dmd.name) + "'>");
                writer.indent();
                dmd.dd.writeToXMLElement(writer, trim);
                dmd.dd2.writeToXMLElement(writer, trim);
                writer.unintent();
                writer.writeLn("</DISPLAY>");
                ++i;
            }
            writer.unintent();
            writer.writeLn("</DISPLAY_DOC>");
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void readFromXML(File file) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        ProcessDialog pd = ProcessDialog.getInstance();
        DMData dmd = null;
        try {
            doc = db.parse(file);
            Element docEl = doc.getDocumentElement();
            NodeList displayNode = docEl.getElementsByTagName("DISPLAY");
            int ds = displayNode.getLength();
            int displayList = ds * 512;
            pd.setMaximum(displayList);
            pd.setVisible(true);
            DMData.vec.removeAllElements();
            int i = 0;
            while (i < ds) {
                Element elem = (Element)displayNode.item(i);
                if (elem == null) {
                    return;
                }
                dmd = new DMData(elem.getAttribute("NAME"));
                Element ddEl = (Element)elem.getElementsByTagName("DISPLAY_MESSAGES").item(0);
                Element dd2El = (Element)elem.getElementsByTagName("DISPLAY_MENY").item(0);
                dmd.dd.readFromXMLElement(ddEl);
                dmd.dd2.readFromXMLElement(dd2El);
                DMData.vec.add(dmd);
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
        if (dmd != null) {
            this.combo.revalidate();
            this.combo.setSelectedItem(dmd);
            TableDisplay.dd = dmd.dd;
            this.td.revalidate();
            this.td.repaint();
            TableDisplay2.dd2 = dmd.dd2;
            this.td2.revalidate();
            this.td2.repaint();
        }
    }

    private static class DMData {
        public String name;
        public DisplayData dd;
        public DisplayData2 dd2;
        public static Vector vec = new Vector(5);

        static {
            DMData dmd = new DMData("Srpski");
            vec.add(dmd);
            dmd = new DMData("Engleski");
            vec.add(dmd);
            dmd = new DMData("Madjarski");
            vec.add(dmd);
            dmd = new DMData("Rumunski");
            vec.add(dmd);
            dmd = new DMData("Albanski");
            vec.add(dmd);
        }

        public DMData(String newName) {
            this.name = newName;
            this.dd = new DisplayData();
            this.dd2 = new DisplayData2();
        }

        public String toString() {
            return this.name;
        }
    }

    private class MainThread
    extends Thread {
        public static final byte READ_FROM_BASE = 1;
        public static final byte WRITE_TO_BASE = 2;
        public static final byte READ_FROM_CASH = 3;
        public static final byte WRITE_TO_CASH = 4;
        public static final byte READ_BIN = 5;
        public static final byte SAVE_BIN = 6;
        private int job = 0;

        public MainThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setJob(int j) throws Exception {
            GlavniFrame glavniFrame = GlavniFrame.getInstance();
            synchronized (glavniFrame) {
                if (this.job != 0) {
                    throw new Exception("Program je zauzet!");
                }
                this.job = j;
                this.notify();
            }
        }

        public synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            try {
                                DMPanel.this.read();
                                break;
                            }
                            finally {
                                DMPanel.this.resetSelectionData();
                            }
                        }
                        case 2: {
                            DMPanel.this.write();
                            break;
                        }
                        case 4: {
                            DMPanel.this.writeCash();
                            break;
                        }
                        case 5: {
                            try {
                                DMPanel.this.readFromBin();
                                break;
                            }
                            finally {
                                DMPanel.this.resetSelectionData();
                            }
                        }
                        case 6: {
                            DMPanel.this.saveToBin();
                            break;
                        }
                        case 3: {
                            try {
                                DMPanel.this.readCash();
                            }
                            finally {
                                DMPanel.this.resetSelectionData();
                            }
                        }
                    }
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                }
                this.job = 0;
            }
        }
    }
}

