/*
 * Decompiled with CFR 0.152.
 */
package gui.importXls;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import objects.lang.LanguageStrings;

public class ImportXlsTableModel
implements TableModel {
    private static final String EMPTY_FF = "FFFF";
    private static final String EMPTY_FFff = "FFFFFFFFFFFFFFFF";
    public static final int COLUMN_SIZE = 8;
    public static boolean useCode = true;
    public static boolean useBarcode = true;
    public static boolean useMeasure = true;
    public static boolean useDepartment = true;
    public static String[][] data = null;
    public static int startRow;
    public static int endRow;
    public static int[] columns;

    static {
        columns = new int[8];
        int i = 0;
        while (i < 8) {
            ImportXlsTableModel.columns[i] = i;
            ++i;
        }
    }

    public ImportXlsTableModel(String[][] strings) {
        data = strings;
        startRow = 0;
        endRow = strings[0].length;
    }

    public final int getColumnCount() {
        return 8;
    }

    public final int getRowCount() {
        return endRow - startRow;
    }

    public final Object getValueAt(int r, int c) {
        r += startRow;
        switch (c) {
            case 0: {
                return String.valueOf(r + 1 - startRow);
            }
            case 1: {
                return data[columns[0]][r];
            }
            case 2: {
                if (useCode) {
                    return data[columns[1]][r];
                }
                return EMPTY_FF;
            }
            case 3: {
                if (useBarcode) {
                    return data[columns[2]][r];
                }
                return EMPTY_FFff;
            }
            case 4: {
                return data[columns[3]][r];
            }
            case 5: {
                return data[columns[4]][r];
            }
            case 6: {
                if (useMeasure) {
                    return data[columns[5]][r];
                }
                return "0";
            }
            case 7: {
                if (useDepartment) {
                    return data[columns[6]][r];
                }
                return "0";
            }
        }
        return null;
    }

    public final void setValueAt(Object s, int r, int c) {
        if (s == null) {
            return;
        }
        String str = (String)s;
        ImportXlsTableModel.data[ImportXlsTableModel.columns[c - 1]][r += ImportXlsTableModel.startRow] = str;
    }

    public final String getColumnName(int c) {
        return LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_" + c);
    }

    public final Class getColumnClass(int col) {
        return String.class;
    }

    public final boolean isCellEditable(int r, int c) {
        if (c == 0) {
            return false;
        }
        if (c == 2 && !useCode) {
            return false;
        }
        if (c == 3 && !useBarcode) {
            return false;
        }
        if (c == 6 && !useMeasure) {
            return false;
        }
        return c != 7 || useDepartment;
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public final void addTableModelListener(TableModelListener arg0) {
    }
}

