/*
 * Decompiled with CFR 0.152.
 */
package gui.importXls;

import gui.GlavniFrame;
import gui.HCPfileChooser;
import gui.ProcessingDialog;
import gui.importXls.ImportXlsDialog;
import java.io.File;
import javax.swing.JOptionPane;
import jxl.Sheet;
import jxl.Workbook;

public class ExcelImporer {
    public static void importXls() {
        new Thread(){

            public void run() {
                Workbook workbook = null;
                HCPfileChooser fc = new HCPfileChooser("xls");
                File xlsFile = fc.openFile();
                if (xlsFile == null) {
                    return;
                }
                ProcessingDialog pd = ProcessingDialog.getInstance();
                pd.setInstanceVisible(true);
                try {
                    try {
                        workbook = Workbook.getWorkbook(xlsFile);
                        Sheet sheet = workbook.getSheet(0);
                        int col = sheet.getColumns();
                        int row = sheet.getRows();
                        if (col < 7) {
                            col = 7;
                        }
                        String[][] data = new String[col][row];
                        int i = 0;
                        while (i < row) {
                            int j = 0;
                            while (j < col) {
                                try {
                                    data[j][i] = sheet.getCell(j, i).getContents();
                                    if (data[j][i] == null) {
                                        data[j][i] = "";
                                    }
                                }
                                catch (Exception e) {
                                    data[j][i] = "";
                                }
                                ++j;
                            }
                            ++i;
                        }
                        pd.setInstanceVisible(false);
                        new ImportXlsDialog(data).setVisible(true);
                    }
                    catch (Exception e) {
                        pd.setInstanceVisible(false);
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                        workbook.close();
                        pd.setInstanceVisible(false);
                        return;
                    }
                }
                finally {
                    workbook.close();
                    pd.setInstanceVisible(false);
                }
            }
        }.start();
    }
}

