/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.HCPClockComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.freixas.jcalendar.JCalendarCombo;

public class TimeChooserDialog
extends JDialog
implements ActionListener {
    private JCalendarCombo date;
    private HCPClockComboBox jcbTime;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel mainPane = new JPanel(new BorderLayout());
    private long time = 0L;

    public TimeChooserDialog() {
        this.mainPane.setBorder(new CompoundBorder(BorderFactory.createTitledBorder("Time chooser"), new EmptyBorder(10, 10, 10, 10)));
        JPanel pomPane1 = new JPanel(new GridLayout(4, 1, 10, 10));
        pomPane1.setBorder(new EmptyBorder(0, 0, 15, 0));
        pomPane1.setPreferredSize(new Dimension(200, 150));
        pomPane1.add(new JLabel("choose date", 0));
        this.date = new JCalendarCombo();
        pomPane1.add(this.date);
        this.jcbTime = new HCPClockComboBox();
        pomPane1.add(new JLabel("choose time", 0));
        pomPane1.add(this.jcbTime);
        JPanel pomPane2 = new JPanel(new GridLayout(1, 2, 5, 5));
        pomPane2.setPreferredSize(new Dimension(200, 20));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("OK");
        pomPane2.add(this.okButton);
        this.cancelButton = new JButton("CANCEL");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("CANCEL");
        pomPane2.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.mainPane.add((Component)pomPane1, "Center");
        this.mainPane.add((Component)pomPane2, "South");
        this.setContentPane(this.mainPane);
        this.pack();
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.setModal(true);
        this.setVisible(true);
    }

    public TimeChooserDialog(TimeZone timeZone) {
        this.mainPane.setBorder(new CompoundBorder(BorderFactory.createTitledBorder("Time chooser"), new EmptyBorder(10, 10, 10, 10)));
        JPanel pomPane1 = new JPanel(new GridLayout(4, 1, 10, 10));
        pomPane1.setBorder(new EmptyBorder(0, 0, 15, 0));
        pomPane1.setPreferredSize(new Dimension(200, 150));
        pomPane1.add(new JLabel("choose date", 0));
        this.date = new JCalendarCombo();
        this.date.getDateFormat().setTimeZone(timeZone);
        pomPane1.add(this.date);
        this.jcbTime = new HCPClockComboBox(timeZone);
        pomPane1.add(new JLabel("choose time", 0));
        pomPane1.add(this.jcbTime);
        JPanel pomPane2 = new JPanel(new GridLayout(1, 2, 5, 5));
        pomPane2.setPreferredSize(new Dimension(200, 20));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("OK");
        pomPane2.add(this.okButton);
        this.cancelButton = new JButton("CANCEL");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("CANCEL");
        pomPane2.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.mainPane.add((Component)pomPane1, "Center");
        this.mainPane.add((Component)pomPane2, "South");
        this.setContentPane(this.mainPane);
        this.pack();
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.setModal(true);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equals("OK")) {
            this.time = this.date.getDate().getTime();
            this.time += (long)(this.jcbTime.getDateFormat().getCalendar().get(11) * 3600000);
            this.time += (long)(this.jcbTime.getDateFormat().getCalendar().get(12) * 60000);
            this.time += (long)(this.jcbTime.getDateFormat().getCalendar().get(13) * 1000);
            this.setVisible(false);
        } else if (str.equals("CANCEL")) {
            this.time = -1L;
            this.setVisible(false);
        }
    }

    public final long getTime() {
        return this.time;
    }

    public final Calendar getCalendar() {
        Calendar cal = (Calendar)Calendar.getInstance().clone();
        cal.setTimeInMillis(this.time);
        return cal;
    }
}

