/*
 * Decompiled with CFR 0.152.
 */
package gui;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPCheckBox;
import gui.HCPGreyButton;
import gui.ProcessDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.Header_Advertisement;
import objects.lang.LanguageStrings;
import util.SysUtil;
import util.comPort.PortSerial;

public class TestPrinterDialog
extends JDialog
implements ActionListener {
    private HCPGreyButton stampaj;
    private HCPGreyButton stampajBold;
    private HCPCheckBox cutPaper;
    private JScrollPane scr;
    private JTextArea text;
    private JPanel mainPane;
    private JPanel westPane;
    private ImageIcon slikaPrint = new ImageIcon("images/print.png");
    private MainThread runner = new MainThread();
    private static byte REGULAR = (byte)-1;
    private static byte BOLD = (byte)(REGULAR & 0xFFFFFFEF);

    public TestPrinterDialog() {
        super(GlavniFrame.getInstance(), "PRINTER TEST", false);
        this.mainPane = new JPanel(new BorderLayout(5, 5));
        this.mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.westPane = new JPanel(new GridLayout(12, 1, 5, 5));
        this.stampaj = new HCPGreyButton("PRINT");
        this.stampaj.setIcon(this.slikaPrint);
        this.stampaj.addActionListener(this);
        this.stampaj.setActionCommand("PRINT");
        this.westPane.add(this.stampaj);
        this.stampajBold = new HCPGreyButton("PRINT BOLD");
        this.stampajBold.setIcon(this.slikaPrint);
        this.stampajBold.addActionListener(this);
        this.stampajBold.setActionCommand("PRINT_BOLD");
        this.westPane.add(this.stampajBold);
        this.cutPaper = new HCPCheckBox("CUT PAPER", true);
        this.cutPaper.addActionListener(this);
        this.westPane.add(this.cutPaper);
        this.text = new JTextArea();
        this.text.setBorder(new SoftBevelBorder(1));
        this.text.setLineWrap(true);
        this.text.setRows(10);
        this.text.setFont(new Font("Courier New", 0, 12));
        this.scr = new JScrollPane(this.text, 20, 31);
        this.mainPane.add((Component)this.scr, "Center");
        this.mainPane.add((Component)this.westPane, "West");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPane, "Center");
        int width = 300;
        if (GlavniFrame.PRINTER) {
            width = 370;
        }
        contentPane.setPreferredSize(new Dimension(width, 400));
        this.setResizable(false);
        this.pack();
        InputMap mapIn = this.mainPane.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(10, 0), "e");
        ActionMap actMap = this.mainPane.getActionMap();
        actMap.put("e", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TestPrinterDialog.this.setVisible(false);
            }
        });
        this.setLocationRelativeTo(GlavniFrame.getInstance());
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equalsIgnoreCase("PRINT")) {
                this.runner.setJob(1);
            } else if (s.equalsIgnoreCase("PRINT_BOLD")) {
                this.runner.setJob(2);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    public void print(int FLAG) throws Exception {
        int PRINTER_SIZE = Header_Advertisement.SIZE_ROW;
        String str = this.text.getText();
        String out = "";
        StringTokenizer tock = new StringTokenizer(str, "\n", true);
        while (tock.hasMoreTokens()) {
            String pom = tock.nextToken();
            while (pom.equals("\n") && tock.hasMoreTokens()) {
                pom = tock.nextToken();
                if (!pom.equals("\n")) continue;
                int i = 0;
                while (i < PRINTER_SIZE) {
                    out = String.valueOf(out) + ' ';
                    ++i;
                }
            }
            int ll = pom.length() % PRINTER_SIZE;
            out = String.valueOf(out) + pom;
            while (ll < PRINTER_SIZE) {
                out = String.valueOf(out) + ' ';
                ++ll;
            }
        }
        int len = out.length();
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(len / PRINTER_SIZE);
        pd.setVisible(true);
        int pos = 0;
        try {
            while (pos < len) {
                instance.reset();
                instance.setCmd(26);
                instance.addByte(len - pos < 511 && this.cutPaper.isSelected() ? 1 : 0);
                while (instance.getPos() + PRINTER_SIZE + 1 < 512 && pos < len) {
                    int tt = pos + PRINTER_SIZE < len ? PRINTER_SIZE : len - pos;
                    instance.addByte(FLAG);
                    SysUtil.formatForSend(out.substring(pos, pos + tt), instance);
                    pos += tt;
                    pd.increaseBar();
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command cc = port.receiveFrame();
                int e = cc.getArray()[0] & 0xFF;
                if (26 == cc.getCmd() || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private class MainThread
    extends Thread {
        public static final byte PRINT = 1;
        public static final byte PRINT_BOLD = 2;
        private int job = 0;

        public MainThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setJob(int j) throws Exception {
            GlavniFrame glavniFrame = GlavniFrame.getInstance();
            synchronized (glavniFrame) {
                if (this.job != 0) {
                    throw new Exception(LanguageStrings.getProgramIsBusy());
                }
                this.job = j;
                this.notify();
            }
        }

        public synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 1: {
                            TestPrinterDialog.this.print(REGULAR);
                            break;
                        }
                        case 2: {
                            TestPrinterDialog.this.print(BOLD);
                        }
                    }
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                }
                this.job = 0;
            }
        }
    }
}

