/*
 * Decompiled with CFR 0.152.
 */
package gui;

import cashRegister.Command;
import cashRegister.FiscalCommands;
import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPSpinner;
import gui.HCPTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;

public class TestJournalDialog
extends JDialog
implements ActionListener {
    private HCPGreyButton jbStart;
    private HCPGreyButton jbStop;
    private HCPTextField jtfCurrent;
    private HCPSpinner jsMax;
    private JProgressBar bar;
    private JProgressBar state;
    private JPanel mainPane;
    private JPanel westPane;
    private volatile boolean work = false;
    private volatile int no = 0;
    private static final int max = 59550;
    public static TestJournalDialog instance = new TestJournalDialog();

    private TestJournalDialog() {
        super(GlavniFrame.getInstance(), "JOURNAL TEST", false);
        new MainThread();
        this.mainPane = new JPanel(new BorderLayout(5, 5));
        this.mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.westPane = new JPanel(new GridLayout(8, 1, 5, 5));
        this.jbStart = new HCPGreyButton("Start");
        this.jbStart.addActionListener(this);
        this.westPane.add(this.jbStart);
        this.jbStop = new HCPGreyButton("Stop");
        this.jbStop.addActionListener(this);
        this.westPane.add(this.jbStop);
        this.westPane.add(new HCPLabel("MAX (%): "));
        this.jsMax = new HCPSpinner(new SpinnerNumberModel(90, 1, 100, 1));
        this.westPane.add(this.jsMax);
        this.westPane.add(new HCPLabel("CURRENT: "));
        this.jtfCurrent = new HCPTextField();
        this.jtfCurrent.setEnabled(false);
        this.westPane.add(this.jtfCurrent);
        JPanel barPane = new JPanel(new GridLayout(1, 2, 5, 5));
        this.bar = new JProgressBar();
        this.bar.setMaximum(59550);
        this.bar.setStringPainted(true);
        this.bar.setOrientation(1);
        barPane.add(this.bar);
        this.state = new JProgressBar();
        this.state.setIndeterminate(false);
        this.state.setOrientation(1);
        barPane.add(this.state);
        this.mainPane.add((Component)barPane, "Center");
        this.mainPane.add((Component)this.westPane, "West");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPane, "Center");
        this.westPane.setBorder(new SoftBevelBorder(1));
        this.westPane.setPreferredSize(new Dimension(100, 280));
        contentPane.setPreferredSize(new Dimension(154, 280));
        this.setResizable(false);
        this.pack();
        InputMap mapIn = this.mainPane.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(10, 0), "e");
        ActionMap actMap = this.mainPane.getActionMap();
        actMap.put("e", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TestJournalDialog.this.setVisible(false);
            }
        });
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                TestJournalDialog.this.work = false;
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.jbStart) {
                if (this.work) {
                    throw new Exception("Working...");
                }
                this.work = true;
            } else if (e.getSource() == this.jbStop) {
                if (!this.work) {
                    throw new Exception("Stopped...");
                }
                this.work = false;
            }
            this.state.setIndeterminate(this.work);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage(), "ERROR", 0);
            return;
        }
    }

    public void readNo() throws Exception {
        FiscalCommands.execCommand(77);
        this.no = 59550 - Command.instance.getInt(8);
        if (595 * Integer.valueOf((Integer)this.jsMax.getValue()) - this.no < 0) {
            this.work = false;
        }
    }

    private class MainThread
    extends Thread {
        public MainThread() {
            this.start();
        }

        private synchronized void waitMe() {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            while (true) {
                if (!TestJournalDialog.this.work) {
                    this.waitMe();
                    continue;
                }
                try {
                    TestJournalDialog.this.readNo();
                    TestJournalDialog.this.jtfCurrent.setText("" + TestJournalDialog.this.no);
                    TestJournalDialog.this.bar.setValue(TestJournalDialog.this.no);
                    FiscalCommands.printCurrentStateReport();
                }
                catch (Exception e1) {
                    TestJournalDialog.this.work = false;
                    TestJournalDialog.this.state.setIndeterminate(false);
                    JOptionPane.showMessageDialog(instance, e1.getMessage(), "ERROR", 0);
                }
                this.waitMe();
            }
        }
    }
}

