/*
 * Decompiled with CFR 0.152.
 */
package gui;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPTextFieldRange;
import gui.ProcessingDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import util.SysUtil;
import util.comPort.PortSerial;

public class TestDisplayDialog
extends JDialog {
    private HCPGreyButton stampaj;
    private HCPGreyButton startTest;
    private HCPGreyButton stopTest;
    public HCPTextFieldRange row1;
    public HCPTextFieldRange row2;
    private static final Font bigFont = new Font("Courier New", 0, 40);
    private JPanel mainPane;
    private JPanel textPane;
    private JPanel buttonPane;
    private JPanel rightPanel;
    private ImageIcon slikaPrint = new ImageIcon("images/print.png");
    public TestingThread tester;
    private static TestDisplayDialog instance = null;
    private static int cmd = Command.DISPLAY_PRINT;

    public static TestDisplayDialog getInstance() {
        if (instance == null) {
            instance = new TestDisplayDialog();
        }
        return instance;
    }

    private TestDisplayDialog() {
        super(GlavniFrame.getInstance(), "DISPLAY TEST", false);
        this.mainPane = new JPanel(new BorderLayout(5, 5));
        this.mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.rightPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.rightPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.rightPanel.setBorder(new EmptyBorder(5, 120, 0, 120));
        this.startTest = new HCPGreyButton("START TEST");
        this.startTest.setIcon(this.slikaPrint);
        this.startTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        try {
                            TestDisplayDialog.this.startTestingDisplay();
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(TestDisplayDialog.this.mainPane, e1.getMessage(), "ERROR", 0);
                            return;
                        }
                    }
                }.start();
            }
        });
        this.rightPanel.add(this.startTest);
        this.stopTest = new HCPGreyButton("STOP TEST");
        this.stopTest.setIcon(this.slikaPrint);
        this.stopTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        try {
                            TestDisplayDialog.this.stopTestingDisplay();
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(TestDisplayDialog.this.mainPane, e1.getMessage(), "ERROR", 0);
                            return;
                        }
                    }
                }.start();
            }
        });
        this.rightPanel.add(this.stopTest);
        this.buttonPane = new JPanel(new BorderLayout());
        this.buttonPane.setBorder(new EmptyBorder(0, 175, 5, 175));
        this.stampaj = new HCPGreyButton("PRINT");
        this.stampaj.setIcon(this.slikaPrint);
        this.stampaj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        try {
                            TestDisplayDialog.this.print();
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(TestDisplayDialog.this.mainPane, e1.getMessage(), "ERROR", 0);
                            return;
                        }
                    }
                }.start();
            }
        });
        this.buttonPane.add(this.stampaj);
        this.textPane = new JPanel(new GridLayout(2, 1, 5, 5));
        this.textPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.row1 = new HCPTextFieldRange(20);
        this.row1.setFont(bigFont);
        this.row1.setBorder(new SoftBevelBorder(0));
        this.row1.setPreferredSize(new Dimension(527, 82));
        InputMap mapIn1 = this.row1.getInputMap(1);
        mapIn1.put(KeyStroke.getKeyStroke(10, 0), "enter");
        ActionMap actMap1 = this.row1.getActionMap();
        actMap1.put("enter", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TestDisplayDialog.this.row2.grabFocus();
            }
        });
        this.row2 = new HCPTextFieldRange(20);
        this.row2.setFont(bigFont);
        this.row2.setBorder(new SoftBevelBorder(0));
        this.row2.setPreferredSize(new Dimension(527, 82));
        InputMap mapIn2 = this.row2.getInputMap(1);
        mapIn2.put(KeyStroke.getKeyStroke(10, 0), "enter");
        ActionMap actMap2 = this.row2.getActionMap();
        actMap2.put("enter", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TestDisplayDialog.this.row1.grabFocus();
                TestDisplayDialog.this.stampaj.doClick();
            }
        });
        this.textPane.add(this.row1);
        this.textPane.add(this.row2);
        this.mainPane.add((Component)this.textPane, "Center");
        this.mainPane.add((Component)this.buttonPane, "South");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPane, "Center");
        contentPane.setPreferredSize(new Dimension(532, 170));
        this.setResizable(false);
        this.pack();
        InputMap mapIn = this.mainPane.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(27, 0), "e");
        ActionMap actMap = this.mainPane.getActionMap();
        actMap.put("e", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TestDisplayDialog.this.setVisible(false);
            }
        });
        this.setLocationRelativeTo(GlavniFrame.getInstance());
    }

    public void print() throws Exception {
        Command instance = Command.bigInstance;
        ProcessingDialog pd = ProcessingDialog.getInstance();
        PortSerial port = PortSerial.getInstance();
        pd.setInstanceVisible(true);
        try {
            instance.reset();
            instance.setCmd(cmd);
            String str = this.row1.getText();
            while (str.length() < 20) {
                str = String.valueOf(str) + ' ';
            }
            str = String.valueOf(str) + this.row2.getText();
            while (str.length() < 40) {
                str = String.valueOf(str) + ' ';
            }
            SysUtil.formatForSend(str, instance);
            port.sendFrame(instance);
            instance = port.receiveFrame();
            int e = instance.getArray()[0] & 0xFF;
            if (cmd != instance.getCmd() && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private void stopTestingDisplay() throws Exception {
        if (this.tester == null && this.tester.status) {
            throw new Exception("Testiranje nije u toku");
        }
        this.tester.status = false;
        this.tester = null;
    }

    private void startTestingDisplay() throws Exception {
        if (this.tester == null) {
            this.tester = new TestingThread();
        }
        if (this.tester.status) {
            throw new Exception("Testiranje je u toku");
        }
        String sss = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)"Enter timeout in miliseconds.");
        if (sss == null || sss.length() <= 0) {
            return;
        }
        int newTime = Integer.parseInt(sss);
        if (newTime <= 0 || newTime > 1000000000) {
            throw new Exception("Wrong input");
        }
        this.tester.time = newTime;
        this.tester.status = true;
    }

    public void setVisible(boolean b) {
        if (!b) {
            try {
                this.stopTestingDisplay();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setVisible(b);
    }

    private class TestingThread
    extends Thread {
        public boolean status = false;
        public int time = 500;

        public TestingThread() throws Exception {
            this.start();
        }

        private synchronized void waitForNotification(int time) {
            try {
                this.wait(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            Command instance = Command.bigInstance;
            PortSerial port = PortSerial.getInstance();
            while (true) {
                try {
                    while (true) {
                        if (!this.status) {
                            this.waitForNotification(100);
                            continue;
                        }
                        this.waitForNotification(this.time);
                        instance.reset();
                        instance.setCmd(cmd);
                        String str = TestDisplayDialog.this.row1.getText();
                        while (str.length() < 20) {
                            str = String.valueOf(str) + ' ';
                        }
                        str = String.valueOf(str.charAt(19)) + str.substring(0, 19);
                        TestDisplayDialog.this.row1.setText(str);
                        SysUtil.formatForSend(str, instance);
                        str = TestDisplayDialog.this.row2.getText();
                        while (str.length() < 20) {
                            str = String.valueOf(str) + ' ';
                        }
                        str = String.valueOf(str.charAt(19)) + str.substring(0, 19);
                        TestDisplayDialog.this.row2.setText(str);
                        SysUtil.formatForSend(str, instance);
                        port.sendFrame(instance);
                        instance = port.receiveFrame();
                        int e = instance.getArray()[0] & 0xFF;
                        if (cmd == instance.getCmd() || e == 0) continue;
                        CommandsErrors.instanceMain.setError(e);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

