/*
 * Decompiled with CFR 0.152.
 */
package gui;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import util.comPort.PortSerial;

public final class StateDialog
extends JDialog {
    private JTextArea text;
    private JPanel mainPane = new JPanel(new BorderLayout());

    public StateDialog() {
        super(GlavniFrame.getInstance(), "BILL STATE", false);
        this.mainPane.getComponents();
        this.mainPane.setBorder(BorderFactory.createTitledBorder("Fiscal data"));
        this.text = new JTextArea();
        this.text.setEditable(false);
        JScrollPane scr = new JScrollPane(this.text, 20, 30);
        scr.setPreferredSize(new Dimension(350, 150));
        this.mainPane.add((Component)scr, "Center");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPane, "Center");
        contentPane.setPreferredSize(new Dimension(390, 220));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        new Thread(){

            public void run() {
                StateDialog.this.text.setText("");
                try {
                    Command instance = Command.instance;
                    PortSerial port = PortSerial.getInstance();
                    instance.reset();
                    instance.setCmd(56);
                    port.sendFrame(instance);
                    port.receiveFrame(instance);
                    int e = instance.getArray()[0] & 0xFF;
                    if (Command.instance.getCmd() != 56 && e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                    StateDialog.this.text.append("bill state: \r\n");
                    long pom = 0L;
                    if (GlavniFrame.PRINTER) {
                        pom = instance.getInt(44);
                        StateDialog.this.text.append("\tbroj racuna: " + pom + "\r\n");
                        pom = instance.getByte(48);
                        if (pom != 255L) {
                            StateDialog.this.text.append("\tkasir: " + pom + "\r\n");
                        }
                        StateDialog.this.text.append("\r\n");
                    }
                    pom = instance.getLong(0);
                    StateDialog.this.text.append("\tto pay:\t " + pom + "\r\n");
                    pom = instance.getLong(8);
                    StateDialog.this.text.append("\tamount:\t " + pom + "\r\n");
                    StateDialog.this.text.append("\r\n");
                    pom = instance.getLong(20);
                    StateDialog.this.text.append("\tcash:\t " + pom + "\r\n");
                    pom = instance.getLong(28);
                    StateDialog.this.text.append("\tcard:\t " + pom + "\r\n");
                    pom = instance.getLong(36);
                    StateDialog.this.text.append("\tbon:\t " + pom + "\r\n");
                    StateDialog.this.text.append("\r\n");
                    pom = instance.getInt(16);
                    StateDialog.this.text.append("\tPLU number:\t " + pom + "\r\n");
                    StateDialog.this.text.append("\r\n");
                    StateDialog.this.text.append("\r\n");
                    int i = 0;
                    while ((long)i < pom) {
                        instance.reset();
                        instance.setCmd(57);
                        instance.addInt(i);
                        port.sendFrame(instance);
                        port.receiveFrame(instance);
                        e = instance.getArray()[0] & 0xFF;
                        if (Command.instance.getCmd() != 57 && e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                        int code = 0;
                        int amount = 0;
                        code = instance.getInt(0);
                        StateDialog.this.text.append("\t\tPLU " + (i + 1) + ":   code: " + code);
                        amount = instance.getInt(4);
                        StateDialog.this.text.append("\tamount: " + amount + "\r\n");
                        ++i;
                    }
                }
                catch (Exception ee) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), ee.getMessage(), "ERROR", 0);
                    StateDialog.this.setVisible(false);
                    return;
                }
            }
        }.start();
        this.setVisible(true);
    }
}

