/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPfileChooser;
import gui.rightPanels.JMerePanel;
import gui.rightPanels.KasiriPanel;
import gui.rightPanels.OdeljenjaPanel;
import gui.rightPanels.PoreskeStopePanel;
import gui.rightPanels.ReklamaPanel;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import journal.Journal;
import objects.Header_Advertisement;
import objects.lang.LanguageStrings;
import objects.wrappers.FiscallObjectsWrapper;
import objects.wrappers.KasiriWrapper;
import objects.wrappers.PLUWrapper;
import objects.wrappers.ReklamaWrapper;
import tables.zagRekTable.ZagRekCellEditor;
import tables.zagRekTable.ZagRekTableModel;
import util.XML.XmlExecuter;

public final class SavePanel
extends JPanel
implements ActionListener {
    private MainThread runner = null;
    private JLabel label;
    public HCPGreyButton jbsaveToCash;
    public HCPGreyButton jbsaveToBase;
    public HCPGreyButton jbreadFromCash;
    public HCPGreyButton jbreadFromBase;
    private String title;
    private static boolean tick = false;

    public SavePanel(String text) {
        this.title = text;
        this.runner = new MainThread();
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 13, 15, 2));
        this.setIgnoreRepaint(true);
        this.setBackground(HCPColors.getColorM2st());
        this.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        ImageIcon slika = new ImageIcon("images/Floppy_Drive_Small.png");
        ImageIcon slikaComp = new ImageIcon("images/ComputerSmall.png");
        ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
        this.label = new JLabel(this.title);
        this.label.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                tick = !tick;
                SavePanel.this.label.setForeground(HCPColors.getColorM1st());
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.label.setBorder(new SoftBevelBorder(1));
        this.label.setIcon(slika);
        this.label.setForeground(HCPColors.getColorM1st());
        this.label.setBackground(HCPColors.getColorM4st());
        this.label.setOpaque(true);
        this.label.setFont(new Font(GlavniFrame.font.getFamily(), 1, 14));
        this.add(this.label);
        this.jbreadFromBase = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("LOAD_FROM_BASE"));
        this.jbreadFromBase.setIcon(slikaComp);
        this.jbreadFromBase.setActionCommand("cib");
        this.jbreadFromBase.addActionListener(this);
        this.jbreadFromBase.setToolTipText(LanguageStrings.getInstance().getStringByName("LOAD_FROM_BASE_TOOLTIP"));
        this.jbreadFromBase.setOpaque(true);
        this.jbreadFromBase.setVisible(true);
        this.add(this.jbreadFromBase);
        this.jbsaveToBase = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("SAVE_TO_BASE"));
        this.jbsaveToBase.setIcon(slikaComp);
        this.jbsaveToBase.setActionCommand("sub");
        this.jbsaveToBase.addActionListener(this);
        this.jbsaveToBase.setToolTipText(LanguageStrings.getInstance().getStringByName("SAVE_TO_BASE_TOOLTIP"));
        this.jbsaveToBase.setOpaque(true);
        this.jbsaveToBase.setVisible(true);
        this.add(this.jbsaveToBase);
        this.jbreadFromCash = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("LOAD_FROM_CASH"));
        this.jbreadFromCash.setIcon(slikaCash);
        this.jbreadFromCash.setActionCommand("cik");
        this.jbreadFromCash.addActionListener(this);
        this.jbreadFromCash.setToolTipText(LanguageStrings.getInstance().getStringByName("LOAD_FROM_CASH_TOOLTIP"));
        this.jbreadFromCash.setOpaque(true);
        this.jbreadFromCash.setVisible(true);
        this.add(this.jbreadFromCash);
        this.jbsaveToCash = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("SAVE_TO_CASH"));
        this.jbsaveToCash.setIcon(slikaCash);
        this.jbsaveToCash.setActionCommand("suk");
        this.jbsaveToCash.addActionListener(this);
        this.jbsaveToCash.setToolTipText(LanguageStrings.getInstance().getStringByName("SAVE_TO_CASH_TOOLTIP"));
        this.jbsaveToCash.setOpaque(true);
        this.jbsaveToCash.setVisible(true);
        this.add(this.jbsaveToCash);
        this.setVisible(true);
        InputMap mapIn = this.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(116, 512), "1");
        mapIn.put(KeyStroke.getKeyStroke(117, 512), "2");
        mapIn.put(KeyStroke.getKeyStroke(118, 512), "3");
        mapIn.put(KeyStroke.getKeyStroke(119, 512), "4");
        ActionMap actMap = this.getActionMap();
        actMap.put("1", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SavePanel.this.jbreadFromBase.doClick();
            }
        });
        actMap.put("2", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SavePanel.this.jbsaveToBase.doClick();
            }
        });
        actMap.put("3", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SavePanel.this.jbreadFromCash.doClick();
            }
        });
        actMap.put("4", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SavePanel.this.jbsaveToCash.doClick();
            }
        });
        new Ticker();
    }

    public void actionPerformed(ActionEvent cmd) {
        String str = cmd.getActionCommand();
        try {
            if (str.equals("cib")) {
                this.runner.setJob(1);
            } else if (str.equals("sub")) {
                this.runner.setJob(2);
            } else if (str.equals("cik")) {
                this.runner.setJob(3);
            } else if (str.equals("suk")) {
                this.runner.setJob(4);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
        }
    }

    private final void citajFile() {
        block43: {
            try {
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ARTICLES_PANEL_LABEL")) >= 0) {
                    PLUWrapper pw = new PLUWrapper();
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        XmlExecuter.getInstance().read(pw, file.getAbsolutePath());
                        break block43;
                    }
                    finally {
                        GlavniFrame.getInstance().articlePanel.ta.revalidate();
                        GlavniFrame.getInstance().articlePanel.ta.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LABEL")) >= 0) {
                    KasiriWrapper kw = new KasiriWrapper();
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        XmlExecuter.getInstance().read(kw, file.getAbsolutePath());
                        break block43;
                    }
                    finally {
                        KasiriPanel.tk.revalidate();
                        KasiriPanel.tk.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_LABEL")) >= 0) {
                    ReklamaWrapper rw = new ReklamaWrapper();
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        XmlExecuter.getInstance().read(rw, file.getAbsolutePath());
                        break block43;
                    }
                    finally {
                        ReklamaPanel.rpt.setRowSelectionInterval(0, 0);
                        ZagRekTableModel.currentRow = 0;
                        ReklamaPanel.t.editCellAt(0, 0);
                        ((ZagRekCellEditor)ReklamaPanel.t.getCellEditor()).ds.setText(Header_Advertisement.getInstance().getStringValue(0, ReklamaPanel.t.getEditingRow()));
                        ReklamaPanel.t.revalidate();
                        ReklamaPanel.t.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("VATS_PANEL_LABEL")) >= 0) {
                    FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        XmlExecuter.getInstance().read(w, file.getAbsolutePath());
                        break block43;
                    }
                    finally {
                        PoreskeStopePanel.tps.revalidate();
                        PoreskeStopePanel.tps.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("MEASURE_PANEL_LABEL")) >= 0) {
                    FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        XmlExecuter.getInstance().read(w, file.getAbsolutePath());
                        break block43;
                    }
                    finally {
                        JMerePanel.tjm.revalidate();
                        JMerePanel.tjm.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("DEPARTMENT_PANEL_LABEL")) >= 0) {
                    FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        XmlExecuter.getInstance().read(w, file.getAbsolutePath());
                        break block43;
                    }
                    finally {
                        OdeljenjaPanel.to.revalidate();
                        OdeljenjaPanel.to.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_LABEL")) >= 0) {
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    XmlExecuter.getInstance().read(GlavniFrame.getInstance().setPane, file.getAbsolutePath());
                } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_LABEL")) >= 0) {
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    XmlExecuter.getInstance().read(Journal.getInstance(), file.getAbsolutePath());
                } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL")) >= 0) {
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    XmlExecuter.getInstance().read(GlavniFrame.getInstance().hcpServerPanel, file.getAbsolutePath());
                } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL")) >= 0) {
                    HCPfileChooser fc = new HCPfileChooser("xml");
                    File file = fc.openFile();
                    if (file == null) {
                        return;
                    }
                    XmlExecuter.getInstance().read(GlavniFrame.getInstance().GPRSPane, file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
            }
        }
    }

    private final void snimiFile() {
        try {
            if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ARTICLES_PANEL_LABEL")) >= 0) {
                PLUWrapper pw = new PLUWrapper();
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(pw, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LABEL")) >= 0) {
                KasiriWrapper kw = new KasiriWrapper();
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(kw, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_LABEL")) >= 0) {
                ReklamaWrapper w = new ReklamaWrapper();
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(w, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("VATS_PANEL_LABEL")) >= 0) {
                FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(w, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("MEASURE_PANEL_LABEL")) >= 0) {
                FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(w, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("DEPARTMENT_PANEL_LABEL")) >= 0) {
                FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(w, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_LABEL")) >= 0) {
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(GlavniFrame.getInstance().setPane, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_LABEL")) >= 0) {
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(Journal.getInstance(), file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL")) >= 0) {
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(GlavniFrame.getInstance().hcpServerPanel, file.getAbsolutePath());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL")) >= 0) {
                HCPfileChooser fc = new HCPfileChooser("xml");
                File file = fc.saveFile();
                if (file == null) {
                    return;
                }
                XmlExecuter.getInstance().write(GlavniFrame.getInstance().GPRSPane, file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), " ERROR", 0);
        }
    }

    private final void citajCR() {
        block33: {
            try {
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ARTICLES_PANEL_LABEL")) >= 0) {
                    PLUWrapper pw = new PLUWrapper();
                    try {
                        pw.readFromPort();
                        break block33;
                    }
                    finally {
                        GlavniFrame.getInstance().articlePanel.ta.revalidate();
                        GlavniFrame.getInstance().articlePanel.ta.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("VATS_PANEL_LABEL")) >= 0) {
                    FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                    try {
                        w.readFromPort();
                        break block33;
                    }
                    finally {
                        PoreskeStopePanel.tps.revalidate();
                        PoreskeStopePanel.tps.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("DEPARTMENT_PANEL_LABEL")) >= 0) {
                    FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                    try {
                        w.readFromPort();
                        break block33;
                    }
                    finally {
                        OdeljenjaPanel.to.revalidate();
                        OdeljenjaPanel.to.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("MEASURE_PANEL_LABEL")) >= 0) {
                    FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                    try {
                        w.readFromPort();
                        break block33;
                    }
                    finally {
                        JMerePanel.tjm.revalidate();
                        JMerePanel.tjm.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LABEL")) >= 0) {
                    KasiriWrapper kw = new KasiriWrapper();
                    try {
                        kw.readFromPort();
                        break block33;
                    }
                    finally {
                        KasiriPanel.tk.revalidate();
                        KasiriPanel.tk.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_LABEL")) >= 0) {
                    ReklamaWrapper w = new ReklamaWrapper();
                    try {
                        w.readFromPort();
                        break block33;
                    }
                    finally {
                        ReklamaPanel.rpt.setRowSelectionInterval(0, 0);
                        ZagRekTableModel.currentRow = 0;
                        ReklamaPanel.t.editCellAt(0, 0);
                        ((ZagRekCellEditor)ReklamaPanel.t.getCellEditor()).ds.setText(Header_Advertisement.getInstance().getStringValue(0, ReklamaPanel.t.getEditingRow()));
                        ReklamaPanel.t.revalidate();
                        ReklamaPanel.t.repaint();
                    }
                }
                if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_LABEL")) >= 0) {
                    GlavniFrame.getInstance().setPane.readFromPort();
                } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_LABEL")) >= 0) {
                    Journal.getInstance().readJournal();
                } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL")) >= 0) {
                    GlavniFrame.getInstance().hcpServerPanel.readFromPort();
                } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL")) >= 0) {
                    GlavniFrame.getInstance().GPRSPane.readFromPort();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), " ERROR", 0);
            }
        }
    }

    private final void snimiCR() {
        try {
            if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ARTICLES_PANEL_LABEL")) >= 0) {
                PLUWrapper pw = new PLUWrapper();
                pw.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("VATS_PANEL_LABEL")) >= 0) {
                FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                w.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("DEPARTMENT_PANEL_LABEL")) >= 0) {
                FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                w.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("MEASURE_PANEL_LABEL")) >= 0) {
                FiscallObjectsWrapper w = new FiscallObjectsWrapper();
                w.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("CASHIERS_PANEL_LABEL")) >= 0) {
                KasiriWrapper kw = new KasiriWrapper();
                kw.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_PANEL_LABEL")) >= 0) {
                ReklamaWrapper w = new ReklamaWrapper();
                w.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("SETTINGS_PANEL_LABEL")) >= 0) {
                GlavniFrame.getInstance().setPane.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("JOURNAL_PANEL_LABEL")) >= 0) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getJournalCanNotBeSavedToCash());
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("HCP_SERVER_PANEL_LABEL")) >= 0) {
                GlavniFrame.getInstance().hcpServerPanel.sendToPort();
            } else if (this.title.indexOf(LanguageStrings.getInstance().getStringByName("GPRS_PANEL_LABEL")) >= 0) {
                GlavniFrame.getInstance().GPRSPane.sendToPort();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), " ERROR", 0);
        }
    }

    private class MainThread
    extends Thread {
        public static final byte READ_FROM_BASE = 1;
        public static final byte WRITE_TO_BASE = 2;
        public static final byte READ_FROM_PORT = 3;
        public static final byte WRITE_TO_PORT = 4;
        private int job = 0;

        public MainThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setJob(int j) throws Exception {
            GlavniFrame glavniFrame = GlavniFrame.getInstance();
            synchronized (glavniFrame) {
                if (this.job != 0) {
                    throw new Exception(LanguageStrings.getProgramIsBusy());
                }
                this.job = j;
                this.notify();
            }
        }

        public synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                switch (this.job) {
                    case 1: {
                        SavePanel.this.citajFile();
                        break;
                    }
                    case 2: {
                        SavePanel.this.snimiFile();
                        break;
                    }
                    case 3: {
                        SavePanel.this.citajCR();
                        break;
                    }
                    case 4: {
                        SavePanel.this.snimiCR();
                    }
                }
                this.job = 0;
            }
        }
    }

    private class Ticker
    extends Thread {
        public Ticker() {
            this.setPriority(1);
            this.start();
        }

        public void run() {
            boolean ppp = true;
            while (true) {
                if (!tick) {
                    this.sacekaj(2000);
                    continue;
                }
                if (ppp) {
                    SavePanel.this.label.setForeground(HCPColors.getColorM1st());
                    this.sacekaj(1000);
                } else {
                    SavePanel.this.label.setForeground(HCPColors.getColorM4st());
                    this.sacekaj(200);
                }
                ppp = !ppp;
            }
        }

        private synchronized void sacekaj(int time) {
            try {
                this.wait(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

