/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.ProcessingDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import objects.DBManager;
import objects.FiscallObjects;
import tables.testTable.PLUtest;
import tables.testTable.RacunTest;

public class RacuniMySQLDialog
extends JDialog
implements ActionListener {
    public JComboBox lista;
    private HCPGreyButton stampaj;
    private JScrollPane scr;
    private JTextArea text;
    private JPanel mainPane;
    private JPanel westPane;
    private boolean[] ps = new boolean[9];
    private long et = 0L;
    private double pt = 0.0;
    private long[] eps = new long[9];
    private static final String decFor = "######0.00";
    private DecimalFormat df = new DecimalFormat("######0.00");
    private static final String decFor0 = "######0.000";
    private DecimalFormat df0 = new DecimalFormat("######0.000");

    public RacuniMySQLDialog() {
        super(GlavniFrame.getInstance(), "MySQL DATABASE GENERATED RECEIPTS", false);
    }

    public void initialize() throws Exception {
        this.mainPane = new JPanel(new BorderLayout(5, 5));
        this.mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.westPane = new JPanel(new GridLayout(12, 1, 5, 5));
        this.stampaj = new HCPGreyButton("PRINT   *");
        this.stampaj.addActionListener(this);
        this.westPane.add(this.stampaj);
        this.westPane.add(new HCPLabel("RECEIPTS"));
        this.lista = new JComboBox();
        DBManager db = DBManager.getInstance();
        ResultSet rs = db.getQueryResultSet("show tables like 'journal_paid';");
        rs = db.getQueryResultSet("SELECT * FROM journal_paid;");
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        int nor = 0;
        try {
            while (rs.next()) {
                if (nor == rs.getInt("number_of_receipt")) continue;
                nor = rs.getInt("number_of_receipt");
                this.lista.addItem("receipt:  " + nor);
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
        this.westPane.add(this.lista);
        this.text = new JTextArea();
        this.text.setFont(GlavniFrame.font);
        this.text.setEditable(false);
        this.scr = new JScrollPane(this.text, 20, 30);
        this.mainPane.add((Component)this.scr, "Center");
        this.mainPane.add((Component)this.westPane, "West");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPane, "Center");
        contentPane.setPreferredSize(new Dimension(350, 400));
        this.setResizable(false);
        this.pack();
        InputMap mapIn = this.mainPane.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(10, 0), "e");
        ActionMap actMap = this.mainPane.getActionMap();
        actMap.put("e", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RacuniMySQLDialog.this.setVisible(false);
            }
        });
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.print();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
        }
    }

    public void print() throws Exception {
        String s = this.lista.getSelectedItem().toString();
        int ppp = Integer.parseInt(s.substring(s.indexOf(32) + 2, s.length()).trim());
        DBManager db = DBManager.getInstance();
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        ResultSet rs = db.getQueryResultSet("SELECT * FROM journal_paid where number_of_receipt = " + ppp + ';');
        RacunTest rc = new RacunTest();
        try {
            while (rs.next()) {
                if (rc.time == 0L) {
                    rc.time = rs.getLong("time");
                }
                switch (rs.getInt("id")) {
                    case 0: {
                        rc.kes += rs.getLong("amount");
                        break;
                    }
                    case 1: {
                        rc.card += rs.getLong("amount");
                        break;
                    }
                    case 2: {
                        rc.bon = rs.getLong("amount");
                    }
                }
            }
            rs = db.getQueryResultSet("SELECT * FROM journal_article where number_of_receipt = " + ppp + ';');
        }
        finally {
            pd.setInstanceVisible(false);
        }
        this.text.setText("");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("\r\n");
        int i = 0;
        while (i < 9) {
            this.ps[i] = false;
            ++i;
        }
        this.et = 0L;
        this.pt = 0.0;
        this.eps = new long[9];
        i = 0;
        while (i < rc.vecPLU.size()) {
            PLUtest plu = (PLUtest)rc.vecPLU.get(i);
            this.text.append("   " + plu.getDesc() + "/" + FiscallObjects.jediniceMere[plu.getJedinicaMere()] + "      \r\n   " + this.df0.format((double)plu.getKolicina() / 1000.0) + "  X" + this.df.format((double)plu.getCena() / 100.0) + " = " + this.df.format((double)plu.getVrednost() / 100.0));
            this.text.append("   " + FiscallObjects.poreskeStope[plu.getPoreskaStopa()].opis);
            this.text.append("\r\n");
            this.et += plu.getVrednost();
            this.ps[plu.getPoreskaStopa()] = true;
            byte by = plu.getPoreskaStopa();
            this.eps[by] = this.eps[by] + plu.getVrednost();
            ++i;
        }
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        i = 0;
        while (i < FiscallObjects.poreskeStope.length) {
            if (this.ps[i]) {
                if (FiscallObjects.poreskeStope[i].vrednost != 65535) {
                    this.text.append("   S" + FiscallObjects.poreskeStope[i].opis + ":   \t" + this.df.format(FiscallObjects.poreskeStope[i].pravaVrednost) + "  %");
                } else {
                    this.text.append("   S" + FiscallObjects.poreskeStope[i].opis + ":   *.**");
                }
                this.text.append("\r\n");
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            String dfs = this.df.format((double)this.eps[i] * FiscallObjects.poreskeStope[i].pravaVrednost / ((100.0 + FiscallObjects.poreskeStope[i].pravaVrednost) * 100.0));
            if (this.ps[i]) {
                this.text.append("   P" + FiscallObjects.poreskeStope[i].opis + ":   \t" + dfs);
                this.text.append("\r\n");
            }
            this.pt += Double.parseDouble(dfs.replace(',', '.'));
            ++i;
        }
        this.text.append("   PT:   \t" + this.df.format(this.pt));
        this.text.append("\r\n");
        i = 0;
        while (i < 9) {
            if (this.ps[i]) {
                this.text.append("   E" + FiscallObjects.poreskeStope[i].opis + ":   \t" + this.df.format((double)this.eps[i] / 100.0));
                this.text.append("\r\n");
            }
            ++i;
        }
        this.text.append("   ET:   \t" + this.df.format((double)this.et / 100.0));
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        long zupom = rc.bon + rc.card + rc.kes;
        this.text.append("   ZA UPLATU:\t" + this.df.format((double)this.et / 100.0));
        this.text.append("\r\n");
        if (rc.card > 0L) {
            this.text.append("   KARTICA:\t" + this.df.format((double)rc.card / 100.0));
            this.text.append("\r\n");
        }
        if (rc.bon > 0L) {
            this.text.append("   CEK:\t" + this.df.format((double)rc.bon / 100.0));
            this.text.append("\r\n");
        }
        if (rc.kes > 0L) {
            this.text.append("   GOTOVINA:\t" + this.df.format((double)rc.kes / 100.0));
            this.text.append("\r\n");
        }
        this.text.append("   UKUPNO:\t" + this.df.format((double)zupom / 100.0));
        this.text.append("\r\n");
        this.text.append("   POVRACAJ:\t" + this.df.format((double)(zupom -= this.et) / 100.0));
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        Date d = new Date(System.currentTimeMillis());
        this.text.append("   " + d.toString());
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.repaint();
    }
}

