/*
 * Decompiled with CFR 0.152.
 */
package gui;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import cashRegister.FiscalCommands;
import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.ProcessingDialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import objects.RemoteBases;
import objects.lang.LanguageStrings;
import util.SysUtil;
import util.comPort.PortSerial;

public class PrinterTestingDialog
extends JDialog
implements ActionListener {
    private JPanel mainPanel;
    private HCPGreyButton okButton;
    private HCPGreyButton cancelButton;
    HCPGreyButton bTestDisplay;
    HCPGreyButton bTestPrinter;
    HCPGreyButton bTestBeeper;
    HCPGreyButton bTestDrower;
    HCPLabel lTestDisplay;
    HCPLabel lTestPrinter;
    HCPLabel lTestBeeper;
    HCPLabel lTestDrower;
    public RemoteBases base = null;
    public boolean success = false;
    private static byte REGULAR = (byte)-1;
    private static byte BOLD = (byte)(REGULAR & 0xFFFFFFEF);

    public PrinterTestingDialog() {
        this.setTitle(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_TITLE"));
        this.mainPanel = new JPanel(new GridLayout(7, 1, 15, 15));
        this.mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.mainPanel);
        this.bTestDisplay = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_TEST_DISPLAY"));
        this.bTestDisplay.addActionListener(this);
        this.mainPanel.add(this.bTestDisplay);
        this.lTestDisplay = new HCPLabel(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_LABEL_WAITHING"), 4);
        this.mainPanel.add(this.lTestDisplay);
        this.bTestPrinter = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_TEST_PRINTER"));
        this.bTestPrinter.addActionListener(this);
        this.mainPanel.add(this.bTestPrinter);
        this.lTestPrinter = new HCPLabel(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_LABEL_WAITHING"), 4);
        this.mainPanel.add(this.lTestPrinter);
        this.bTestBeeper = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_TEST_BEEPER"));
        this.bTestBeeper.addActionListener(this);
        this.mainPanel.add(this.bTestBeeper);
        this.lTestBeeper = new HCPLabel(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_LABEL_WAITHING"), 4);
        this.mainPanel.add(this.lTestBeeper);
        this.bTestDrower = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_TEST_DROWER"));
        this.bTestDrower.addActionListener(this);
        this.mainPanel.add(this.bTestDrower);
        this.lTestDrower = new HCPLabel(LanguageStrings.getInstance().getStringByName("PRINTER_TESTER_DIALOG_LABEL_WAITHING"), 4);
        this.mainPanel.add(this.lTestDrower);
        this.mainPanel.add(new JComponent(){});
        this.mainPanel.add(new JComponent(){});
        this.mainPanel.add(new JComponent(){});
        this.mainPanel.add(new JComponent(){});
        this.okButton = new HCPGreyButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new HCPGreyButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel pp1 = new JPanel(new GridLayout(1, 1, 5, 5));
        pp1.setBorder(new EmptyBorder(0, 50, 0, 0));
        pp1.add(this.okButton);
        JPanel pp2 = new JPanel(new GridLayout(1, 1, 5, 5));
        pp2.setBorder(new EmptyBorder(0, 0, 0, 50));
        pp2.add(this.cancelButton);
        this.mainPanel.add(pp1);
        this.mainPanel.add(pp2);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.success = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
        } else if (e.getSource() == this.bTestDisplay) {
            this.testDisplay();
        } else if (e.getSource() == this.bTestPrinter) {
            this.testPrinter();
        } else if (e.getSource() == this.bTestBeeper) {
            this.testBeeper();
        } else if (e.getSource() == this.bTestDrower) {
            this.testDrower();
        }
    }

    private void testDrower() {
        new Thread(){

            public void run() {
                ProcessingDialog pd = ProcessingDialog.getInstance();
                pd.setInstanceVisible(true);
                try {
                    try {
                        FiscalCommands.execCommand(Command.COMMAND_DRAWER_OPEN);
                    }
                    catch (Exception e1) {
                        pd.setInstanceVisible(false);
                        JOptionPane.showMessageDialog(PrinterTestingDialog.this.mainPanel, e1.getMessage(), "ERROR", 0);
                        PrinterTestingDialog.this.lTestDrower.setText("ERROR");
                        pd.setInstanceVisible(false);
                        return;
                    }
                }
                finally {
                    pd.setInstanceVisible(false);
                }
                PrinterTestingDialog.this.lTestDrower.setText("OK");
            }
        }.start();
    }

    private void testBeeper() {
        new Thread(){

            public void run() {
                ProcessingDialog pd = ProcessingDialog.getInstance();
                pd.setInstanceVisible(true);
                try {
                    try {
                        int i = 0;
                        while (i < 3) {
                            SysUtil.delay(500);
                            FiscalCommands.execCommand(34);
                            ++i;
                        }
                    }
                    catch (Exception e1) {
                        pd.setInstanceVisible(false);
                        JOptionPane.showMessageDialog(PrinterTestingDialog.this.mainPanel, e1.getMessage(), "ERROR", 0);
                        PrinterTestingDialog.this.lTestBeeper.setText("ERROR");
                        pd.setInstanceVisible(false);
                        return;
                    }
                }
                finally {
                    pd.setInstanceVisible(false);
                }
                PrinterTestingDialog.this.lTestBeeper.setText("OK");
            }
        }.start();
    }

    private void testPrinter() {
        new Thread(){

            public void run() {
                ProcessingDialog pd = ProcessingDialog.getInstance();
                pd.setInstanceVisible(true);
                try {
                    try {
                        PrinterTestingDialog.this.print(REGULAR, false);
                        PrinterTestingDialog.this.print(BOLD, true);
                    }
                    catch (Exception e1) {
                        pd.setInstanceVisible(false);
                        JOptionPane.showMessageDialog(PrinterTestingDialog.this.mainPanel, e1.getMessage(), "ERROR", 0);
                        PrinterTestingDialog.this.lTestPrinter.setText("ERROR");
                        pd.setInstanceVisible(false);
                        return;
                    }
                }
                finally {
                    pd.setInstanceVisible(false);
                }
                PrinterTestingDialog.this.lTestPrinter.setText("OK");
            }
        }.start();
    }

    private void testDisplay() {
        new Thread(){

            public void run() {
                ProcessingDialog pd = ProcessingDialog.getInstance();
                pd.setInstanceVisible(true);
                try {
                    try {
                        int i = 0;
                        while (i < 3) {
                            SysUtil.delay(500);
                            PrinterTestingDialog.this.displayTest();
                            SysUtil.delay(500);
                            PrinterTestingDialog.this.displayBlank();
                            ++i;
                        }
                    }
                    catch (Exception e1) {
                        pd.setInstanceVisible(false);
                        JOptionPane.showMessageDialog(PrinterTestingDialog.this.mainPanel, e1.getMessage(), "ERROR", 0);
                        PrinterTestingDialog.this.lTestDisplay.setText("ERROR");
                        pd.setInstanceVisible(false);
                        return;
                    }
                }
                finally {
                    pd.setInstanceVisible(false);
                }
                PrinterTestingDialog.this.lTestDisplay.setText("OK");
            }
        }.start();
    }

    public void displayTest() throws Exception {
        Command instance = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(Command.DISPLAY_PRINT);
        SysUtil.formatForSend("TESTIRANJE DISPLEJA.", instance);
        SysUtil.formatForSend("TESTIRANJE DISPLEJA.", instance);
        port.sendFrame(instance);
        instance = port.receiveFrame();
        int e = instance.getArray()[0] & 0xFF;
        if (Command.DISPLAY_PRINT != instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void displayBlank() throws Exception {
        Command instance = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(Command.DISPLAY_PRINT);
        int i = 0;
        while (i < 40) {
            instance.addByte(32);
            ++i;
        }
        port.sendFrame(instance);
        instance = port.receiveFrame();
        int e = instance.getArray()[0] & 0xFF;
        if (Command.DISPLAY_PRINT != instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void print(int FLAG, boolean cutPaper) throws Exception {
        int PRINTER_SIZE = 22;
        if (GlavniFrame.PRINTER) {
            PRINTER_SIZE = 32;
        }
        String str = "TESTING PRINTER...                 TESTING PRINTER...                 TESTING PRINTER...                 TESTING PRINTER...                 TESTING PRINTER...                  TESTING PRINTER...                  TESTING PRINTER...                  TESTING PRINTER...                  TESTING PRINTER...";
        String out = "";
        StringTokenizer tock = new StringTokenizer(str, "\n", true);
        while (tock.hasMoreTokens()) {
            String pom = tock.nextToken();
            while (pom.equals("\n") && tock.hasMoreTokens()) {
                pom = tock.nextToken();
                if (!pom.equals("\n")) continue;
                int i = 0;
                while (i < PRINTER_SIZE) {
                    out = String.valueOf(out) + ' ';
                    ++i;
                }
            }
            int ll = pom.length() % 22;
            out = String.valueOf(out) + pom;
            while (ll < PRINTER_SIZE) {
                out = String.valueOf(out) + ' ';
                ++ll;
            }
        }
        int len = out.length();
        Command instance = Command.bigInstance;
        int pos = 0;
        while (pos < len) {
            instance.reset();
            instance.setCmd(26);
            instance.addByte(len - pos < 511 && cutPaper ? 1 : 0);
            while (instance.getPos() + PRINTER_SIZE + 1 < 512 && pos < len) {
                int tt = pos + PRINTER_SIZE < len ? PRINTER_SIZE : len - pos;
                instance.addByte(FLAG);
                SysUtil.formatForSend(out.substring(pos, pos + tt), instance);
                pos += tt;
            }
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = instance.getArray()[0] & 0xFF;
            if (26 == instance.getCmd() || e == 0) continue;
            CommandsErrors.instanceMain.setError(e);
        }
    }
}

