/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.rightPanels.FiscalDataPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import objects.FiscallObjects;
import util.SysUtil;

public class PeriodicalDialog
extends JDialog {
    private JScrollPane scr;
    private JTextArea text;
    private JPanel mainPane = new JPanel(new BorderLayout(5, 5));
    private long pt;
    private long et;
    private long[] eps;
    private long[] pps;
    private long[] epsTemp;
    private static DecimalFormat df = new DecimalFormat("######0.00");

    public PeriodicalDialog() {
        super(GlavniFrame.getInstance(), "IZVESTAJ", false);
        this.mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.text = new JTextArea();
        this.text.setFont(GlavniFrame.font);
        this.text.setEditable(false);
        this.scr = new JScrollPane(this.text, 20, 30);
        this.mainPane.add((Component)this.scr, "Center");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPane, "Center");
        contentPane.setPreferredSize(new Dimension(300, 500));
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.setVisible(true);
    }

    public void calculate(String from, String to) {
        Date d;
        this.pt = 0L;
        this.et = 0L;
        this.pps = new long[9];
        this.eps = new long[9];
        this.epsTemp = new long[9];
        this.text.setText("\tPERIODICNI IZVESTAJ\r\n");
        this.text.append(String.valueOf(from) + "\r\n");
        this.text.append(String.valueOf(to) + "\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        int k = 0;
        while (k < FiscalDataPanel.vecReset.size()) {
            FiscalDataPanel.ResetObj rrr = (FiscalDataPanel.ResetObj)FiscalDataPanel.vecReset.elementAt(k);
            d = new Date(rrr.getTime() - 3600000L);
            this.text.append(String.valueOf(d.toString()) + "   type: " + (rrr.getType() == 1 ? (char)'P' : 'C') + "\r\n");
            ++k;
        }
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        int k2 = 0;
        while (k2 < FiscalDataPanel.vecTax.size()) {
            FiscalDataPanel.TaxObj pom = (FiscalDataPanel.TaxObj)FiscalDataPanel.vecTax.elementAt(k2);
            d = new Date(pom.getTime() - 3600000L);
            this.text.append("   " + d.toString() + "\r\n");
            int i = 0;
            while (i < FiscallObjects.poreskeStope.length) {
                if ((double)pom.getTax(4 + i * 2) != 0.0) {
                    this.text.append("   S" + FiscallObjects.poreskeStope[i].opis + ":   \t" + df.format((double)pom.getTax(4 + i * 2) / 100.0) + "  %");
                } else {
                    this.text.append("   S" + FiscallObjects.poreskeStope[i].opis + ":   \t*.**");
                }
                this.text.append("\r\n");
                ++i;
            }
            ++k2;
        }
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("\r\n");
        FiscalDataPanel.TaxObj taxObj = null;
        int k3 = FiscalDataPanel.vecDaily.size();
        while (--k3 >= 0) {
            double x;
            long t;
            long ps;
            FiscalDataPanel.TaxObj tob;
            int j;
            FiscalDataPanel.DailyObj ddd = (FiscalDataPanel.DailyObj)FiscalDataPanel.vecDaily.elementAt(k3);
            long dt = ddd.getTime();
            if (taxObj == null) {
                j = FiscalDataPanel.vecTax.size();
                while (--j >= 0) {
                    tob = (FiscalDataPanel.TaxObj)FiscalDataPanel.vecTax.elementAt(j);
                    if (tob.getTime() >= dt) continue;
                    taxObj = tob;
                    break;
                }
            }
            if (taxObj.getTime() > dt) {
                j = 0;
                while (j < FiscallObjects.poreskeStope.length) {
                    ps = taxObj.getTax(4 + j * 2);
                    t = this.epsTemp[j];
                    x = t;
                    x *= (double)(100L * ps);
                    this.epsTemp[j] = SysUtil.round((long)(x /= (double)(10000L + ps)), 2);
                    int n = j;
                    this.pps[n] = this.pps[n] + this.epsTemp[j];
                    this.epsTemp[j] = 0L;
                    ++j;
                }
                j = FiscalDataPanel.vecTax.size();
                while (--j >= 0) {
                    tob = (FiscalDataPanel.TaxObj)FiscalDataPanel.vecTax.elementAt(j);
                    if (tob.getTime() >= dt) continue;
                    taxObj = tob;
                    break;
                }
            }
            j = 0;
            while (j < FiscallObjects.poreskeStope.length) {
                long pl = ddd.getSold(6 + j * 6);
                int n = j;
                this.eps[n] = this.eps[n] + pl;
                int n2 = j++;
                this.epsTemp[n2] = this.epsTemp[n2] + pl;
            }
            if (k3 != 0) continue;
            j = 0;
            while (j < FiscallObjects.poreskeStope.length) {
                ps = taxObj.getTax(4 + j * 2);
                t = this.epsTemp[j];
                x = t;
                x *= (double)(100L * ps);
                this.epsTemp[j] = SysUtil.round((long)(x /= (double)(10000L + ps)), 2);
                int n = j;
                this.pps[n] = this.pps[n] + this.epsTemp[j];
                this.epsTemp[j] = 0L;
                ++j;
            }
        }
        int i = 0;
        while (i < 9) {
            this.et += this.eps[i];
            this.pt += this.pps[i];
            ++i;
        }
        i = 0;
        while (i < 9) {
            this.text.append("   P" + FiscallObjects.poreskeStope[i].opis + ":   \t" + this.pps[i] / 100L + '.' + SysUtil.putVisibleNumberFormat(this.pps[i] % 100L, 2));
            this.text.append("\r\n");
            ++i;
        }
        this.text.append("   PT:   \t" + this.pt / 100L + '.' + this.pt % 100L);
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("\r\n");
        i = 0;
        while (i < 9) {
            this.text.append("   E" + FiscallObjects.poreskeStope[i].opis + ":   \t" + this.eps[i] / 100L + '.' + SysUtil.putVisibleNumberFormat(this.eps[i] % 100L, 2));
            this.text.append("\r\n");
            ++i;
        }
        this.text.append("   ET:   \t" + this.et / 100L + '.' + this.et % 100L);
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("   " + new Date(System.currentTimeMillis()).toString());
        this.text.append("\r\n");
        if (FiscalDataPanel.vecDaily.size() > 0) {
            this.text.append(" BD  " + ((FiscalDataPanel.DailyObj)FiscalDataPanel.vecDaily.elementAt(0)).getNum() + "   -   " + ((FiscalDataPanel.DailyObj)FiscalDataPanel.vecDaily.elementAt(FiscalDataPanel.vecDaily.size() - 1)).getNum());
        } else {
            this.text.append(" BD  0  -  0");
        }
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.repaint();
    }
}

