/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import objects.FiscallObjects;
import objects.PLU;
import objects.RemoteBases;
import objects.lang.LanguageStrings;
import tables.articlesTable.ArticleTableComboCellModel;
import tables.articlesTable.ArticleTableTxtCellModel;

public class NewArticleDialog
extends JDialog
implements ActionListener {
    private JPanel mainPanel;
    private HCPGreyButton okButton;
    private HCPGreyButton cancelButton;
    private JTextField tfName;
    private JTextField tfCode;
    private JTextField tfBarcode;
    private JTextField tfPrice;
    private JComboBox vat;
    private JComboBox measure;
    private JComboBox department;
    public RemoteBases base = null;

    public NewArticleDialog() {
        this.setTitle("PLU");
        this.mainPanel = new JPanel(new GridLayout(8, 2, 5, 5));
        this.mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.mainPanel);
        this.mainPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_1"), 4));
        this.tfName = new ArticleTableTxtCellModel(1, 34);
        this.mainPanel.add(this.tfName);
        this.mainPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_2"), 4));
        this.tfCode = new ArticleTableTxtCellModel(2, 5);
        this.mainPanel.add(this.tfCode);
        this.mainPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_3"), 4));
        this.tfBarcode = new ArticleTableTxtCellModel(3, 19);
        this.mainPanel.add(this.tfBarcode);
        this.mainPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_4"), 4));
        this.tfPrice = new ArticleTableTxtCellModel(4, 11);
        this.mainPanel.add(this.tfPrice);
        this.mainPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_5"), 4));
        this.vat = new ArticleTableComboCellModel(FiscallObjects.poreskeStope);
        this.mainPanel.add(this.vat);
        this.mainPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_6"), 4));
        this.measure = new ArticleTableComboCellModel(FiscallObjects.jediniceMere);
        this.mainPanel.add(this.measure);
        this.mainPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_COLUMN_7"), 4));
        this.department = new ArticleTableComboCellModel(FiscallObjects.odeljenja);
        this.mainPanel.add(this.department);
        this.mainPanel.setPreferredSize(new Dimension(300, 200));
        this.okButton = new HCPGreyButton("Ok");
        this.okButton.addActionListener(this);
        this.mainPanel.add(this.okButton);
        this.cancelButton = new HCPGreyButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.mainPanel.add(this.cancelButton);
        InputMap mapIn = this.mainPanel.getInputMap(1);
        mapIn.put(KeyStroke.getKeyStroke(27, 0), "e");
        ActionMap actMap = this.mainPanel.getActionMap();
        actMap.put("e", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                NewArticleDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            PLU plu = new PLU();
            String str = this.tfName.getText();
            if (str == null || str.length() <= 0) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ERROR_ARTICLE_DESC_IS_EMPTY"), " ERROR", 0);
                return;
            }
            plu.setDesc(str.trim());
            str = this.tfCode.getText();
            if (str == null || str.length() == 0) {
                plu.setCode(-1);
            } else {
                int pomi = 0;
                try {
                    pomi = Integer.parseInt(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pomi > 32000 || pomi <= 0) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ERROR_ARTICLE_CODE_NOT_VALID"), " ERROR", 0);
                    return;
                }
                plu.setCode(pomi);
            }
            str = this.tfBarcode.getText();
            if (str == null || str.length() == 0) {
                plu.setBarCode(-1L);
            } else {
                long poml = 0L;
                try {
                    poml = Long.parseLong(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (poml <= 0L) {
                    return;
                }
                plu.setBarCode(poml);
            }
            str = this.tfPrice.getText();
            int iop = str.indexOf(46);
            String s1 = "";
            String s2 = "";
            if (iop >= 0) {
                s1 = str.substring(0, iop);
            } else {
                str = String.valueOf(str) + "00";
            }
            s2 = str.substring(iop + 1, str.length());
            str = String.valueOf(s1) + s2;
            int pom = 0;
            try {
                pom = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pom <= 0) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), LanguageStrings.getInstance().getStringByName("ERROR_ARTICLE_PRICE_NOT_VALID"), " ERROR", 0);
                return;
            }
            plu.setCena(pom);
            str = this.vat.getSelectedItem().toString();
            byte pomb = 0;
            int i = 0;
            while (i < 9) {
                if (FiscallObjects.poreskeStope[i].opis.equalsIgnoreCase(str)) {
                    pomb = (byte)(i & 0xF);
                    break;
                }
                ++i;
            }
            plu.setPoreskaStopa(pomb);
            str = this.measure.getSelectedItem().toString();
            pomb = 0;
            i = 0;
            while (i < FiscallObjects.jediniceMere.length) {
                if (FiscallObjects.jediniceMere[i].equalsIgnoreCase(str)) {
                    pomb = (byte)(i & 0xF);
                    break;
                }
                ++i;
            }
            plu.setJedinicaMere(pomb);
            str = this.department.getSelectedItem().toString();
            pomb = 0;
            i = 0;
            while (i < FiscallObjects.odeljenja.length) {
                if (FiscallObjects.odeljenja[i].opis.equalsIgnoreCase(str)) {
                    pomb = (byte)i;
                    break;
                }
                ++i;
            }
            plu.setOdeljenje(pomb);
            PLU.vec.add(plu);
            this.setVisible(false);
        } else {
            this.setVisible(false);
        }
    }
}

