/*
 * Decompiled with CFR 0.152.
 */
package gui;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPTextField;
import gui.ProcessingDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import security.GeneratorKeys;
import security.KeyRSA;
import util.comPort.PortSerial;

public class KeysDialog
extends JDialog
implements ActionListener {
    public static final int JOURNAL_KEYS = 80;
    private static final int TYPE_EXP_PRIVATE = 1;
    private static final int TYPE_EXP_PUBLIC = 2;
    private static final int TYPE_MODULE = 3;
    private static final int TYPE_READ = 0;
    private HCPGreyButton sendButton;
    private HCPGreyButton readButton;
    private HCPTextField expPrivate;
    private HCPTextField expPublic;
    private HCPTextField modulus;
    private static KeysDialog dialog;
    KeyRSA keys = GeneratorKeys.getInstance().getKeys();

    public KeysDialog() {
        this.setTitle("KEYS DIALOG");
        JPanel mainPanel = new JPanel(new BorderLayout(15, 15));
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPanel);
        JPanel fieldPanel = new JPanel(new GridLayout(3, 2, 5, 5));
        fieldPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        fieldPanel.add(new HCPLabel("PUBLIC:", 4));
        this.expPublic = new HCPTextField();
        fieldPanel.add(this.expPublic);
        fieldPanel.add(new HCPLabel("PRIVATE:", 4));
        this.expPrivate = new HCPTextField();
        fieldPanel.add(this.expPrivate);
        fieldPanel.add(new HCPLabel("MODULUS:", 4));
        this.modulus = new HCPTextField();
        fieldPanel.add(this.modulus);
        this.sendButton = new HCPGreyButton("Send");
        this.sendButton.addActionListener(this);
        this.readButton = new HCPGreyButton("Read");
        this.readButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel pp1 = new JPanel(new GridLayout(1, 1, 5, 5));
        pp1.setBorder(new EmptyBorder(0, 150, 0, 0));
        pp1.add(this.sendButton);
        JPanel pp2 = new JPanel(new GridLayout(1, 1, 5, 5));
        pp2.setBorder(new EmptyBorder(0, 0, 0, 150));
        pp2.add(this.readButton);
        buttonPanel.add(pp1);
        buttonPanel.add(pp2);
        mainPanel.add((Component)fieldPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.getRootPane().setDefaultButton(this.sendButton);
        dialog = this;
        this.expPublic.setText(this.keys.getPublicExp().toString(16));
        this.expPrivate.setText(this.keys.getPrivateExp().toString(16));
        this.modulus.setText(this.keys.getModulus().toString(16));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sendButton) {
            this.sendToDevice();
        } else if (e.getSource() == this.readButton) {
            this.readFromDevice();
        }
    }

    private void sendToDevice() {
        new Thread(){

            public void run() {
                ProcessingDialog pd = ProcessingDialog.getInstance();
                pd.setInstanceVisible(true);
                try {
                    try {
                        PortSerial port = PortSerial.getInstance();
                        Command instance = Command.bigInstance;
                        instance.reset();
                        instance.setCmd(80);
                        instance.addByte(2);
                        byte[] array = KeysDialog.this.keys.getExpECR(false);
                        instance.addToArray(array, 0, array.length);
                        port.sendFrame(instance);
                        instance = port.receiveFrame();
                        int e = instance.getArray()[0] & 0xFF;
                        int command = instance.getCmd();
                        if (command != 80 && command != 128 && e != 28 && e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                        instance = Command.bigInstance;
                        instance.reset();
                        instance.setCmd(80);
                        instance.addByte(1);
                        instance.addToArray(KeysDialog.this.keys.getExpECR(true), 0, KeysDialog.this.keys.getExpECR(true).length);
                        port.sendFrame(instance);
                        instance = port.receiveFrame();
                        e = instance.getArray()[0] & 0xFF;
                        command = instance.getCmd();
                        if (command != 80 && command != 128 && e != 28 && e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                        instance = Command.bigInstance;
                        instance.reset();
                        instance.setCmd(80);
                        instance.addByte(3);
                        instance.addToArray(KeysDialog.this.keys.getModulusToSendECR(), 0, KeysDialog.this.keys.getModulusToSendECR().length);
                        port.sendFrame(instance);
                        instance = port.receiveFrame();
                        e = instance.getArray()[0] & 0xFF;
                        command = instance.getCmd();
                        if (command != 80 && command != 128 && e != 28 && e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                        KeysDialog.this.readCheck();
                    }
                    catch (Exception e1) {
                        pd.setInstanceVisible(false);
                        JOptionPane.showMessageDialog(dialog, e1.getMessage(), "ERROR", 0);
                        pd.setInstanceVisible(false);
                        return;
                    }
                }
                finally {
                    pd.setInstanceVisible(false);
                }
            }
        }.start();
    }

    private void readFromDevice() {
        new Thread(){

            public void run() {
                ProcessingDialog pd = ProcessingDialog.getInstance();
                pd.setInstanceVisible(true);
                try {
                    try {
                        PortSerial port = PortSerial.getInstance();
                        Command instance = Command.bigInstance;
                        instance.reset();
                        instance.setCmd(80);
                        instance.addByte(0);
                        instance.addByte(2);
                        port.sendFrame(instance);
                        instance = port.receiveFrame();
                        int e = instance.getArray()[0] & 0xFF;
                        int command = instance.getCmd();
                        if (command != 80 && command != 128 && e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                        byte[] arr = new byte[instance.getLength() - 4];
                        System.arraycopy(instance.getArray(), 3, arr, 0, arr.length);
                        BigInteger bi = new BigInteger(arr);
                        instance = Command.bigInstance;
                        instance.reset();
                        instance.setCmd(80);
                        instance.addByte(0);
                        instance.addByte(1);
                        port.sendFrame(instance);
                        instance = port.receiveFrame();
                        e = instance.getArray()[0] & 0xFF;
                        command = instance.getCmd();
                        if (command != 80 && command != 128 && e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                        arr = new byte[instance.getLength() - 4];
                        System.arraycopy(instance.getArray(), 3, arr, 0, arr.length);
                        BigInteger bi2 = new BigInteger(arr);
                        KeysDialog.this.keys.setExp(bi2, bi);
                        instance = Command.bigInstance;
                        instance.reset();
                        instance.setCmd(80);
                        instance.addByte(0);
                        instance.addByte(3);
                        port.sendFrame(instance);
                        instance = port.receiveFrame();
                        e = instance.getArray()[0] & 0xFF;
                        command = instance.getCmd();
                        if (command != 80 && command != 128 && e != 0) {
                            CommandsErrors.instanceMain.setError(e);
                        }
                        arr = new byte[instance.getLength() - 4];
                        System.arraycopy(instance.getArray(), 3, arr, 0, arr.length);
                        BigInteger bi3 = new BigInteger(arr);
                        KeysDialog.this.keys.setModus(bi3);
                        KeysDialog.this.expPublic.setText(KeysDialog.this.keys.getPublicExp().toString(16));
                        KeysDialog.this.expPrivate.setText(KeysDialog.this.keys.getPrivateExp().toString(16));
                        KeysDialog.this.modulus.setText(KeysDialog.this.keys.getModulus().toString(16));
                    }
                    catch (Exception e1) {
                        pd.setInstanceVisible(false);
                        JOptionPane.showMessageDialog(dialog, e1.getMessage(), "ERROR", 0);
                        pd.setInstanceVisible(false);
                        return;
                    }
                }
                finally {
                    pd.setInstanceVisible(false);
                }
            }
        }.start();
    }

    private void readCheck() throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(80);
        instance.addByte(0);
        instance.addByte(2);
        port.sendFrame(instance);
        instance = port.receiveFrame();
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 80 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        byte[] arr = new byte[instance.getLength() - 4];
        System.arraycopy(instance.getArray(), 3, arr, 0, arr.length);
        BigInteger bi1 = new BigInteger(arr);
        instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(80);
        instance.addByte(0);
        instance.addByte(1);
        port.sendFrame(instance);
        instance = port.receiveFrame();
        e = instance.getArray()[0] & 0xFF;
        command = instance.getCmd();
        if (command != 80 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        arr = new byte[instance.getLength() - 4];
        System.arraycopy(instance.getArray(), 3, arr, 0, arr.length);
        BigInteger bi2 = new BigInteger(arr);
        instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(80);
        instance.addByte(0);
        instance.addByte(3);
        port.sendFrame(instance);
        instance = port.receiveFrame();
        e = instance.getArray()[0] & 0xFF;
        command = instance.getCmd();
        if (command != 80 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        arr = new byte[instance.getLength() - 4];
        System.arraycopy(instance.getArray(), 3, arr, 0, arr.length);
        BigInteger bi3 = new BigInteger(arr);
        if (this.keys.getPublicExp().compareTo(bi1) != 0) {
            throw new Exception("Public key error!");
        }
        if (this.keys.getPrivateExp().compareTo(bi2) != 0) {
            throw new Exception("Public key error!");
        }
        if (this.keys.getModulus().compareTo(bi3) != 0) {
            throw new Exception("Public key error!");
        }
    }
}

