/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import objects.FiscallObjects;
import tables.testTable.PLUtest;
import tables.testTable.RacunTest;

public class IzvestajiDialog
extends JDialog
implements ActionListener {
    private JComboBox lista1;
    private JComboBox lista2;
    private HCPGreyButton stampaj;
    private JScrollPane scr;
    private JTextArea text;
    private JPanel mainPane;
    private JPanel westPane;
    private double pt;
    private long et;
    private long[] eps = new long[FiscallObjects.poreskeStope.length];
    private long kes;
    private long bon;
    private long card;
    private static final String decFor = "######0.00";
    private DecimalFormat df = new DecimalFormat("######0.00");

    public IzvestajiDialog() {
        super(GlavniFrame.getInstance(), "IZVESTAJ", false);
    }

    public void initialize() {
        this.mainPane = new JPanel(new BorderLayout(5, 5));
        this.mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.westPane = new JPanel(new GridLayout(12, 1, 5, 5));
        this.stampaj = new HCPGreyButton("Stampaj   *");
        this.stampaj.addActionListener(this);
        this.westPane.add(this.stampaj);
        this.lista1 = new JComboBox();
        this.lista2 = new JComboBox();
        int i = 0;
        while (i < RacunTest.vec.size()) {
            this.lista1.addItem("Racun:  " + (i + 1));
            this.lista2.addItem("Racun:  " + (i + 1));
            ++i;
        }
        this.westPane.add(new HCPLabel("Od racuna:"));
        this.westPane.add(this.lista1);
        this.westPane.add(new HCPLabel("Do racuna:"));
        this.westPane.add(this.lista2);
        this.lista2.setSelectedIndex(this.lista2.getItemCount() - 1);
        this.text = new JTextArea();
        this.text.setFont(GlavniFrame.font);
        this.text.setEditable(false);
        this.scr = new JScrollPane(this.text, 20, 30);
        this.mainPane.add((Component)this.scr, "Center");
        this.mainPane.add((Component)this.westPane, "West");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPane, "Center");
        contentPane.setPreferredSize(new Dimension(350, 400));
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.text.setText("");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        int i = 0;
        while (i < FiscallObjects.poreskeStope.length) {
            if (FiscallObjects.poreskeStope[i].vrednost != 65535) {
                this.text.append("   S" + FiscallObjects.poreskeStope[i].opis + ":   \t" + this.df.format(FiscallObjects.poreskeStope[i].pravaVrednost) + "  %");
            } else {
                this.text.append("   S" + FiscallObjects.poreskeStope[i].opis + ":   \t*.**");
            }
            this.text.append("\r\n");
            ++i;
        }
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("\r\n");
        if (this.lista1.getSelectedIndex() < 0 || this.lista2.getSelectedIndex() < 0) {
            return;
        }
        this.kes = 0L;
        this.bon = 0L;
        this.card = 0L;
        this.pt = 0.0;
        this.et = 0L;
        this.eps = new long[FiscallObjects.poreskeStope.length];
        int i2 = this.lista1.getSelectedIndex();
        while (i2 < this.lista2.getSelectedIndex() + 1) {
            RacunTest rc = (RacunTest)RacunTest.vec.get(i2);
            this.kes += rc.kes;
            this.bon += rc.bon;
            this.card += rc.card;
            int j = 0;
            while (j < rc.vecPLU.size()) {
                PLUtest plu = (PLUtest)rc.vecPLU.get(j);
                byte by = plu.getPoreskaStopa();
                this.eps[by] = this.eps[by] + plu.getVrednost();
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < FiscallObjects.poreskeStope.length) {
            this.et += this.eps[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < FiscallObjects.poreskeStope.length) {
            String dfs = this.df.format((double)this.eps[i2] * FiscallObjects.poreskeStope[i2].pravaVrednost / ((100.0 + FiscallObjects.poreskeStope[i2].pravaVrednost) * 100.0));
            this.text.append("   P" + FiscallObjects.poreskeStope[i2].opis + ":   \t" + dfs);
            this.text.append("\r\n");
            this.pt += Double.parseDouble(dfs.replace(',', '.'));
            ++i2;
        }
        this.text.append("   PT:   \t" + this.df.format(this.pt));
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("\r\n");
        i2 = 0;
        while (i2 < FiscallObjects.poreskeStope.length) {
            this.text.append("   E" + FiscallObjects.poreskeStope[i2].opis + ":   \t" + this.df.format((double)this.eps[i2] / 100.0));
            this.text.append("\r\n");
            ++i2;
        }
        this.text.append("   ET:   \t" + this.df.format((double)this.et / 100.0));
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("\r\n");
        this.text.append("   KARTICA:\t" + this.df.format((double)this.card / 100.0));
        this.text.append("\r\n");
        this.text.append("   CEK:\t" + this.df.format((double)this.bon / 100.0));
        this.text.append("\r\n");
        this.text.append("   GOTOVINA:\t" + this.df.format((double)(this.et - (this.card + this.bon)) / 100.0));
        this.text.append("\r\n");
        this.text.append("   UKUPNO:\t" + this.df.format((double)(this.card + this.bon + this.kes) / 100.0));
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        Date d = new Date(System.currentTimeMillis());
        this.text.append("   " + d.toString());
        this.text.append("\r\n");
        this.text.append("   BI:  " + (this.lista1.getSelectedIndex() + 1) + "  -  " + (this.lista2.getSelectedIndex() + 1));
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.text.append("\r\n");
        this.text.append("--------------------------------------------------");
        this.repaint();
    }
}

